;;; -*- Mode:Lisp; Package:YY; Syntax:Common-Lisp; Base: 10; -*-
;;;
;;; YY on X Demo Program
;;;
;;; Note:
;;;		$B?7$7$$%&%#%s%I%&$rI=<($7!"4JC1$J?^7A$rIA2h$9$k!#(B
;;; file:	demo1.lisp
;;; date:	20.Aug.90
;;; Author:	Yohta
;;;
;;; change log:
;;;
;;;

(in-package 'yy)			;


;;;
;;; with color
;;;
(defmacro with-color ((window color) &rest body)
  (let ((old-color (gensym)))
    `(let ((,old-color (graphic-color ,window)))
       (setf (graphic-color ,window) ,color)
       ,@body
       (setf (graphic-color ,window) ,old-color)
       nil
       )
    )
  )

;;;
;;; Color definitions
;;;
(defvar *red* (make-color :red 65535 :green 0 :blue 0))
(defvar *blue* (make-color :red 0 :green 0 :blue 65535))
(defvar *green* (make-color :red 0 :green 65535 :blue 0))
(defvar *yellow* (make-color :red 65535 :green 65535 :blue 0))
(defvar *cyan* (make-color :red 0 :green 65535 :blue 65535))
(defvar *magenta* (make-color :red 65535 :green 0 :blue 65535))

(defvar *color-table*
  (make-array 8
	      :initial-contents
	      (list *black-color* *white-color*
		    *red* *magenta* *blue* *cyan* *green* *yellow*)))

;;;
;;; draw circles
;;;
(defun circles (window &key (pitch 1) (x 200) (y 150)
		     (radius 150) (color *black-color*))
  (with-color (window color)
	      (do ((r radius (- r pitch)))
		  ((<= r 0))
		  (draw-circle-xy window x y r))))

;;;
;;; clear screen
;;;
(defun cls (&optional (window *demo-window3*))
  (clear-window-stream window))

;;;
;;; draw regions
;;;
(defun regions (window &key (pitch 1) (x 10) (y 10)
			    (width 200) (height 150) (color *black-color*))
  (let ((p2 (* pitch 2)))
    (with-color (window color)
		(do ((x1 x (+ x1 pitch))
		     (y1 y (+ y1 pitch))
		     (w width (- w p2))
		     (h height (- h p2)))
		    ((or (<= w 0) (<= h 0)))
		    (draw-region-xy window x1 y1 w h)))))


;;;
;;; Tree
;;;
(defun draw-tree (window &key (x 200) (y 0) (theta (/ pi 2)) (length 100)
			 (depth 10) (color *black-color*))
;  (cls window)
  (with-graphic-state ((graphic-color graphic-color))
		      window
    (setf graphic-color color)
    (draw-tree-internal window x y length theta depth)))

(defun draw-tree-internal (window x y length theta depth)
  (unless (zerop depth)
	  (flet ((adjust (th)
			  (cond
			   ((>= th (* 2 pi))
			    (- th (* 2 pi)))
			   ((< th 0)
			    (+ th (* 2 pi)))
			   (t th))))
		 (let ((to-x (+ x (floor (* (cos theta) length))))
		       (to-y (+ y (floor (* (sin theta) length)))))
		   (setf (line-width window) depth)
		   (draw-line-xy window x y to-x to-y)
		   (draw-tree-internal window to-x to-y (* length 0.7)
				       (adjust (- theta (/ pi 3))) (1- depth))
		   (draw-tree-internal window to-x to-y (* length 0.7)
				       (adjust (+ theta (/ pi 3))) (1- depth))
		   )
		 )
	  )
  )

;;;
;;; multi-color tree
;;;
(defun draw-ctree (window &key (x 200) (y 0) (theta (/ pi 2)) (length 100)
			 (depth 10))
;  (cls window)
  (with-graphic-state ((line-edge line-edge))
		      window
    (setf line-edge 2)			;round edge
    (draw-ctree-internal window x y length theta depth)))

(defun draw-ctree-internal (window x y length theta depth)
  (unless (zerop depth)
	  (flet ((adjust (th)
			  (cond
			   ((>= th (* 2 pi))
			    (- th (* 2 pi)))
			   ((< th 0)
			    (+ th (* 2 pi)))
			   (t th))))
		 (let ((to-x (+ x (floor (* (cos theta) length))))
		       (to-y (+ y (floor (* (sin theta) length)))))
		   (setf (line-width window) depth)
		   (setf (graphic-color window)
			 (aref *color-table* (+ (mod depth 6) 2)))
		   ;; debug start
		   ;(format t "~%depth=~s color=~s" depth
		   ;    (aref *color-table* (+ (mod depth 6) 2)))
		   ;; debug end
		   (draw-line-xy window x y to-x to-y)
		   (draw-ctree-internal window to-x to-y (* length 0.7)
				       (adjust (- theta (/ pi 3))) (1- depth))
		   (draw-ctree-internal window to-x to-y (* length 0.7)
				       (adjust (+ theta (/ pi 3))) (1- depth))
		   )
		 )
	  )
  )


;;;
;;; Scrolling
;;;
(defun move-screen (window &key (pitch 10))
  (do ((x pitch (+ x pitch)))
      ((> x (* pitch 20)))
      (scroll window x 0)))


;;;
;;; Matrix
;;;
(defun draw-matrix (window &key (pitch 20) (x 10) (y 10) (width 300)
			   (height 300) (color *black-color*))
  (with-color (window color)
	      (do ((xx x (+ xx pitch)))
		  ((>= xx (+ x width))
		   (draw-line-xy window xx y xx (+ y height)))
		  (draw-line-xy window xx y xx (+ y height)))
	      (do ((yy y (+ yy pitch)))
		  ((>= yy (+ y height))
		   (draw-line-xy window x yy (+ x height) yy))
		  (draw-line-xy window x yy (+ x height) yy))))

(defun  test (&optional (window *demo-window2*))
  (clear-window-stream window)
  (with-graphic-matrix ((theta matrix-theta)
			(x-time matrix-x-time)
			(y-time matrix-y-time))
		       window
     (setf theta 0.0
	   x-time 1.0
	   y-time 0.5)
     (draw-matrix window)
     (cls window)
     (setf theta 0.0
	   x-time 0.5
	   y-time 1.0)
     (draw-matrix window)
     (cls window)
     (setf theta 60.0
	   x-time 1.0
	   y-time 1.0)
     (lisp:format t "~% Matrix -> ~s" (stream-transform-by-matrix window))
     (draw-matrix window)
     ))


;;;
;;; bench mark test
;;;
(defun perf (&optional (window *demo-window3*) &key (time 100))
  (loop
   (lisp:format t "~%;Speed meter of simple drawing. (~d times)" time)
   (lisp:format t "~%;Please select a number of menu.")
   (lisp:format t "~%0 : End~%1 : Line~%2 : Box~%3 : Circle~%4 : write-char")
   (lisp:format t "~%5 : draw-text")
   (format t "~%>>> ")
   (case (read)
	 ((0) (return nil))
	 ((1) (time (dotimes (i time)
			     (draw-line-xy window i i (+ i 50) i))))
	 ((2) (time (dotimes (i time)
			     (draw-region-xy window i i 50 50))))
	 ((3) (time (dotimes (i time)
			     (draw-circle-xy window i i 50))))
	 ((4) (terpri window)
	      (time (dotimes (i time (force-output window))
			 (stream-write-char window #\Y))
		    )
	  )
	 ((5) (terpri window)
	      (let ((str (make-string time :initial-element #\Y)))
		(time (drawing-text window str))))
	 (otherwise
	  (lisp:format t "~%;!!! Lock number !!!"))
	 )
   )
  )


;;;
;;; writing
;;;
;(defvar *f-a24* (load-font :font-name "a24"))
;(defvar *f-neca16* (load-font :font-name "neca16"))
;(defvar *f-maru14* (load-font :font-name "maru14"))
(defmacro with-font ((window font) &rest body)
  (let ((old-font (gensym)))
    `(let ((,old-font (stream-font ,window)))
       (unwind-protect
	 (progn
	   (setf (stream-font ,window) ,font)
	   ,@body)
	 (setf (stream-font ,window) ,old-font)
	 )
       )
    )
  )
#|
(defun test2 (&optional (window *demo-window1*))
  (write-string "ABCDEFG" window)
  (terpri window)
  (force-output window)
  (with-font (window *f-neca16*)
	     (write-string "ABCDEFG" window)
	     (force-output window))
  (with-font (window *f-a24*)
	     (write-string "ABCDEFG" window)
	     (force-output window))
  )
|#

;;;
;;; polygon
;;;
(defun test3 (&optional (window *demo-window3*) &key (color *black-color*))
  (with-graphic-state ((paint-color graphic-color)
		       (fill-type filled-type)
		       (rule filled-rule))
		      window
     (setf fill-type *fillsolid*
	   paint-color color
	   rule *WindingRule*)
     (draw-polygon-xy window 20 0 100 80 80 100 0 20)
     )
  )


;;;
;;; Drawing randam circles
;;;
(defun random-circles (&optional (window *demo-window*1))
  (let* ((region (window-region))
	 (width (region-width region))
	 (height (region-height region))
	 (radius 0) (center-x 0) (center-y 0))
    (do ((stop (lisp::read-char-no-hang)
	       (lisp::read-char-no-hang)))
	(stop)
      (setf center-x (random width)
	    center-y (random height))
      (setf radius (min (max center-x
			     (- width center-x))
			(max center-y
			     (- height center-y))))
      (draw-circle-xy window center-x center-y radius)
      )
    )
  )

;;;
;;; Drawing random regions
;;;
(defun random-regions (&optional (window *lisp-listener*))
  (let* ((region (window-region window))
	 (window-width (region-width region))
	 (window-height (region-height region))
	 (x 0) (y 0) (width 0) (height 0) (colnum 0)
	 (colors (make-array 7
			     :initial-contents
			     (list *red* *blue* *green* *yellow* *cyan*
				   *magenta* *black-color*))))
    (lisp:format t "~%;Drawing regions demo")
    (lisp:format t "~%;If you wish stop, push any key.")
    (with-graphic-state
     ((color graphic-color))
     window
     (do ((stop (lisp::read-char-no-hang)
		(lisp::read-char-no-hang)))
	 (stop)
       (setf x (random window-width)
	     y (random window-height))
       (setf width (random (- window-width x))
	     height (random (- window-height y)))
       (setf colnum (random 7))
       (setf color (aref colors colnum))
       (draw-region-xy window x y width height)
       )
     )
    )
  )


;;;
;;; drawing line
;;;
(defun g-line (window x1 y1 x2 y2 &key (width 1) (color *black-color*)
		                       (dash "") (edge *SQUEAR-LINE-EDGE*))
  (with-graphic-state ((graphic-color graphic-color)
		       (line-width line-width)
		       (line-edge line-edge)
		       (line-dashing line-dashing))
		      window
    (setf graphic-color color
	  line-width width
	  line-edge edge
	  line-dashing dash)
    (draw-line-xy window x1 y1 x2 y2)
    )
  )
				       
		      
	       