;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XACT
;;;                       Module: Catalog
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/xact/catalog.lisp
;;; File Creation Date: 10/08/92 14:13:06
;;; Last Modification Time: 07/12/93 17:26:30
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :xit)

(defun select-gio-catalog ()
  (declare (special *gio-catalog*))
  (unless (and (boundp '*gio-catalog*) *gio-catalog*)
    (setq *gio-catalog* (make-gio-catalog)))
  (totop-window *gio-catalog*))

(defun destroy-gio-catalog ()
  (declare (special *gio-catalog*))
  (destroy-and-make-unbound *gio-catalog*))

(defmethod copy-window-from-catalog ((self interaction-window)
				     (parent composite)
				     x y)
  (let ((copy (copy-window-to-parent self parent x y)))
    (change-reactivity copy :drag-event :none)
    copy))

(defcontact catalog-area (intel)
  ((adjust-size? :initform nil)
   (reactivity
    :initform '((:drop-event
		 (call :sender copy-window-to-parent *self*
		       (first *value*) (second *value*)))))))

(defmethod add-child :after ((self catalog-area)
			     (part interaction-window) &key)
  (change-reactivity part :drag-event
		     '(call :self copy-window-from-catalog *sender*
		       (first *value*) (second *value*))))

(defun make-gio-catalog ()
  (while-busy nil
    (make-gio 
     'paned-window
     :name :catalog
     :adjust-size? nil
     :reactivity-entries '((:select) (:move))
     :parts
     '((:class text-dispel
       :name :title
       :adjust-size? nil
       :text "Catalog"
       :font (:face :bold)
       :background "black"
       :foreground "white"
       :inside-border 2
       :display-position :center)
     
      ;; catalog operation menu
      (:class text-menu
       :name :catalog-operations-menu
       :layouter (distance-layouter :distance 20 :orientation :right)
       :part-font (:size 14 :face :bold)
       :parts
       ((:text "Load"
	 :action (call :eval (load-catalog-entries))
	 :action-docu "Load catalog entries")
	(:text "Save"
	 :action (call :eval (save-catalog-entries))
	 :action-docu "Save catalog entries")
	(:text "Clear"
	 :action
	 (call :eval
	       (broadcast (client-window (part (part-of *self* 2) :work-area))
			  #'destroy))
	 :action-docu "Remove all catalog entries")))

      ;; switch configuration button
      (:class soft-button
       :name :button-switch
       :text-part :none
       :bitmap-part (:bitmap "button-switch")
       :mouse-feedback :border
       :action (call :eval (switch-configuration (layouter (part-of *self*))))
       :action-docu "Refresh Window")

      ;; window operation menu
      (:class bitmap-menu
       :name :window-operations-menu
       :inside-border 0
       :layouter (distance-layouter :distance 3 :orientation :right)
       :action (call :eval (funcall *part-value* (top-window *self*)))
       :parts
       ((:view-of refresh-window
	 :bitmap "button-refresh"
	 :action-docu "Refresh Window")
	(:view-of move-window
	 :bitmap "button-move"
	 :action-docu "Move Window")
	(:view-of resize-window
         :bitmap "button-resize"
	 :action-docu "Resize Window")
	(:view-of totop-window
         :bitmap "button-totop"
	 :action-docu "Put Window on Top")
	(:view-of tobottom-window
	 :bitmap "button-tobottom"
	 :action-docu "Put Window to Bottom")
	(:view-of bury-window
	 :bitmap "button-shrink"
	 :action-docu "Shrink Window")
	(:view-of destroy
	 :bitmap "button-kill"
	 :cursor "pirate"
	 :action-docu "Remove Window")))
     
      (:class margined-window
       :name :work-area
       :adjust-size? nil
       :border-width 0
       :margins
       ((standard-margins-with-scroll-bars-without-label
	  :scroll-bar-options (:locations (:right :bottom))))
       :client-window
       (catalog-area
	:name :catalog-area
	:adjust-size? nil)))

     :layouter
     '(pane-layouter
       :configuration configuration-1
       :configurations
       ((configuration-1
	  ((:title :ask)
	   (empty 3)
	   (menu-strip (:ask :window-operations-menu) :h
		       (empty 3)
		       (:catalog-operations-menu :ask)
		       (empty :rest)
		       (:button-switch :ask)
		       (empty 20)
		       (:window-operations-menu :ask)
		       (empty 3))
	   (empty 3)
	   (:work-area :rest))))
       ))))
	   

(defun load-catalog-entries ()
  )
(defun save-catalog-entries ()
  )