;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT; -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Object Binder
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /nfsmount/diabololocal/lisp/xit/utilities/object-binder.lisp
;;; File Creation Date: 5/19/90 09:48:11
;;; Last Modification Time: 06/30/93 11:04:39
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;_____________________________________________________________________________

(in-package :xit)

(load (system-pathname :xit-utilities "object-binder-window"))

(defparameter *object-binder* nil)

(defun make-object-binder (&optional (toplevel nil toplevel-p))
  (declare (ignore toplevel))
  (setq *object-binder*
      (apply #'make-object-binder-window
	     (when toplevel-p toplevel)))
  (shrink *object-binder*)
  *object-binder*)
      
(if (or *multiple-shells-p* (toplevel-initialized-p))
    (make-object-binder)
  (add-open-toplevel-hook 'make-object-binder))
