;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT -*-
;;;__________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Drag&Drop for Move
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/utilities/drag-for-move.lisp
;;; File Creation Date: 02/26/93 09:18:53
;;; Last Modification Time: 06/30/93 10:55:25
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;__________________________________________________________________________

(in-package :xit)

;____________________________________________________________________________
;;
;; Drag&drop is used instead of move interaction.
;; The default behavior of drag&drop, i.e. when drag&drop actions are
;; applicable, is moving the window (with type :wire).

(defvar *drag-instead-of-move-p* t)

(setq *drag-and-drop-default-type* :move)

(defmethod move-window-interactively :around ((self basic-contact))
  (declare (special *drag-instead-of-move-p*))
  (if *drag-instead-of-move-p*
      (drag-and-drop-window self)
    (call-next-method)))