;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: AUDIO -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: 
;;;                       Module: 
;;;                       Version: 1.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Matthias Ressel
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/systems/pi/audio.lisp
;;; File Creation Date: 04/07/92 14:09:42
;;; Last Modification Time: 04/22/92 13:24:10
;;; Last Modification By: Matthias Ressel
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;
;;;_____________________________________________________________________________

(in-package :audio)

;;------------------------------------------------------------------

(defvar *audio_fd* nil)

(defparameter *default-volume* 60)
(defparameter *volume-factor* 1)

(defun CREATE-PLAY-AUDIO-PROCESS (file volume)
  (declare (ignore quality))  
  #+excl
  (let ((p nil))
    (unwind-protect
      (progn
	(setq *audio_fd* (open_audio))
	(setq p (mp::process-run-function `(:name "Play audio"
					      :initial-bindings
					      nil)
				      #'play-audio-loop
				     *audio_fd* file
				     (min 100 (floor
					       volume
					       *volume-factor*))))
	(mp::process-enable p)
	;(format t "~&~a" mp:*current-process*)
	 p)
      (unless (mp:process-active-p p)
	(close_audio *audio_fd*))
      )))


(defvar *audio-process* nil)

(defun stop_play_audio_&_kill (process)
  (when process
    #+excl (mp::process-disable process)
    #+excl (mp::process-kill process)
    (if (numberp *audio_fd*)
	(progn
	  (flush_audio *audio_fd*)
	  (setq *audio_fd* nil)))))


(defun play-audio-loop (audio_fd file volume)
  (let ((input_fd nil))
    (when (>=  audio_fd 0)
      (unwind-protect
	  (when (>= (set_volume audio_fd volume))
	    (setq input_fd (open_ifile audio_fd file))
	    (when (>= input_fd 0)
	      (do ((eof nil)
		   (cnt nil))
		  (eof )
		(setq cnt (play_audio audio_fd input_fd))
		(setq eof (<= cnt 0)))))
	(when (>= input_fd 0)
	    (close_ifile input_fd))
	(close_audio audio_fd)
	(setq *audio_fd* nil)
	(setq *audio-process* nil)))))

(defun play-audio-file (file &optional (volume *default-volume*)
				       &key wait)
  (unless *audio-process*
    (if wait
	(let ((fd (open_audio)))
	  (play-audio-loop fd file (min 100 (floor volume *volume-factor*))))
      (setq *audio-process*
	  (create-play-audio-process
	   file volume)))))

(defun stop-audio ()
  (stop_play_audio_&_kill *audio-process*)
  (setq *audio-process* nil))
