;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: CLUEI; Base: 10; -*-

;;; 06/15/1993 (Juergen) 
;;;
;;; (setf contact-state) looped when the state was changed interactively 
;;; by means of the window manager.  This has been patched modifying
;;; the :iconic case as described below.
 
(in-package :cluei)

(defmethod (setf contact-state) (new-state (shell wm-shell))
  (check-type new-state (member :withdrawn :iconic :mapped))    
  
  (with-slots (parent display state) shell
    (unless (eq state new-state)
      (let ((old-state state))
	
	(setf state new-state)
	
	(if
	  (realized-p shell)
	  
	  ;; Change state now -- but don't send side-effect requests if inside
	  ;; without-requests wrapper (i.e. eq *contact-notified*) ---
	  ;; that is, if responding to notification of state change from window mgr.
	  (when
	    ;; Was a (un)map request actually sent?
	    (case new-state
	      (:mapped    (shell-mapped shell)
			  (unless (eq *contact-notified* shell)
			    (map-window shell)
			    t))				 ; Request sent
	      
	      (:iconic    (if (eq old-state :withdrawn)
			      
			      (unless (eq *contact-notified* shell)
				(unless (eq :iconic (wm-initial-state shell))
				  (setf (wm-initial-state shell) :iconic))
				(map-window shell)
				nil)			 ; No :map-notify coming, so don't wait!
			      
			    ;; *** used prog1 instead of progn, which was a
			    ;; bug. t now is only returned if not within a 
			    ;; without-requests macro, i.e. *contact-notified*
			    ;; is not set to the shell ***
			    (prog1
				(unless (eq *contact-notified* shell)
				  (send-event parent
					      :client-message
					      #.(make-event-mask :substructure-redirect :substructure-notify)
					      :window shell
					      :type :wm_change_state
					      :format 32
					      :data '(3) ; Crock: this should be an xlib defconstant
					      )
				  t)			 ; Request sent	
				(shell-unmapped shell))))
	      
	      (:withdrawn (prog1
			    (unless (eq *contact-notified* shell)
			      (unmap-window shell)
			      (send-event parent
					  :unmap-notify
					  #.(make-event-mask :substructure-redirect :substructure-notify)
					  :event-window parent
					  :window shell
					  :configure-p nil)
			      t)			 ; Request sent
			    (shell-unmapped shell))))
	    
	    ;; Wait until resulting :(un)map-notify event has been received.
	    (let ((*ignore-map-notify* t))
	      (declare (special *ignore-map-notify*))
	      (with-event-mode (shell '(:map-notify   (throw-action :map-notify))
				      '(:unmap-notify (throw-action :map-notify)))
		(catch :map-notify
		  ;; Don't update-state to avoid infinite recursion during realization.
		  (loop (process-next-event display nil nil))))))
	  
	  ;; Not realized, let UPDATE-STATE do the work
	  (setf (display-update-flag display) t)))))
  new-state)