	title	SYSTEM call
	page	54,130
; This file provides functions not available with NDP-C386
; Written by Tom Almy and placed in public domain
	.386p
	.xlisti
dataseg	segment	'DATA'
commandBlock DD	0			; env string offset
	DW	0			; env string segment
commandTail DD	0			; command tail offset
ctseg	DW	0			; and its segment
savestate DW	0			; saved tty mode
savebrk	DB	0			; saved break flag
dataseg	ends
codeseg	segment	er dword public use32 'CODE'
	assume	cs:codeseg, ds:dataseg

	public	_ssystem
_ssystem	PROC	NEAR
	mov	EAX, 8[ESP]	; argument (command string "tail")
	mov	commandTail,EAX
	mov	ctseg, DS		; arg's segment
	mov	EDX, 4[ESP]		; command
	push	EBX
	push	ESI
	push	EDI
	mov	EBX, OFFSET commandBlock
	mov	EAX, 4b00h		; exec
	int	21h
	jc	SHORT fail		; fail if carry set
	xor	eax, eax		; return zero on success
fail:	pop	EDI
	pop	ESI
	pop	EBX
	ret
_ssystem	endp

	public _xgetc
_xgetc	proc	near
	push	ebx
	mov	AH, 7		; get character
	int	21h
	pop	ebx
	and	eax, 0ffh
	ret
_xgetc	endp

	public	_xputc
_xputc	proc	near
	push	ebx
	mov	edx, 8[esp]
	mov	AH, 6		; put character
	int	21h
	pop	ebx
	ret
_xputc	endp

	public	_xcheck
_xcheck	proc	near
	push	ebx
	mov	ah, 06h
	mov	dl, 0ffh
	int	21h
	pop	ebx
	and	eax, 0ffh	; mask bits
	ret
_xcheck	endp

	public	_setraw
_setraw proc	near
	push	ebx
	mov	ax, 4400h	; Get device status
	mov	bx, 1
	int	21h
	xor	dh,dh
	mov	savestate, dx
	or	dl, 20h		; set raw bit
	mov	ax, 4401h	; set device statu s
	int	21h

	mov	ax, 3300h	; get ctrl-break flag
	int	21h
	mov	savebrk, dl	; save it
	mov	ax, 3301h	; turn of control-break monitoring
	xor	dl,dl
	int	21h

	pop	ebx
	ret
_setraw	endp

	public	_unsetraw
_unsetraw proc near
	push	ebx
	mov	ax, 4401h	; set device status to original
	mov	bx, 1
	mov	dx, savestate
	int	21h
	mov	ax, 3301h	; set ctrl-break monitoring to original
	mov	dl, savebrk
	int	21h
	pop	ebx
	ret
_unsetraw endp

	public	_readline
_readline proc near
	push	ebx
	mov	edx, 8[esp]	; address of buffer
	mov	ax, 0a00h	; read line call
	int	21h
	pop	ebx
	ret
_readline endp

codeseg	ends
	end