/* ndpstuff.c - NDP C specific routines */

#include "xlisp.h"
#include "osdefs.h"
#include <string.h>

#define LBSIZE 200

/* external variables */
extern LVAL s_unbound,s_dosinput,true;
extern FILE *tfp;
extern int errno;

/* local variables */
static char lbuf[LBSIZE];
static int lpos[LBSIZE];
static int lindex;
static int lcount;
static int lposition;
static long rseed = 1L;

/* forward declarations */
void xinfo();
void xflush();
void xputc();
void oscheck();

/* osinit - initialize */
VOID osinit(banner)
  char *banner;
{
    printf("%s\n",banner);
    lposition = 0;
    lindex = 0;
    lcount = 0;
	setraw();
}

/* osfinish - clean up before returning to the operating system */
VOID osfinish()
{
	unsetraw();
}

/* oserror - print an error message */
VOID oserror(msg)
  char *msg;
{
    printf("error: %s\n",msg);
}

/* osrand - return a random number between 0 and n-1 */
int osrand(n)
  int n;
{
    long k1;

    /* make sure we don't get stuck at zero */
    if (rseed == 0L) rseed = 1L;

    /* algorithm taken from Dr. Dobbs Journal, November 1985, page 91 */
    k1 = rseed / 127773L;
    if ((rseed = 16807L * (rseed - k1 * 127773L) - k1 * 2836L) < 0L)
	rseed += 2147483647L;

    /* return a random number between 0 and n-1 */
    return ((int)(rseed % (long)n));
}

/* osaopen - open an ascii file */
FILE *osaopen(name,mode)
  char *name,*mode;
{
    return (fopen(name,mode));
}

/* osbopen - open a binary file */
FILE *osbopen(name,mode)
  char *name,*mode;
{
	FILE *temp;
	extern int _pmode;
	_pmode = 0x8000;
	temp = fopen(name,mode);
	_pmode = 0x4000;
}

/* osclose - close a file */
int osclose(fp)
  FILE *fp;
{
    return (fclose(fp));
}

/* ostgetc - get a character from the terminal */
int ostgetc()
{
    int ch;

    /* check for a buffered character */
    if (lcount--)
	return (lbuf[lindex++]);

    /* get an input line */
	if (getvalue(s_dosinput) != NIL) {
		lindex = 2;
		lbuf[0] = LBSIZE - 2;
		readline(lbuf);
		putchar('\n');
		lcount = lbuf[1];
		lbuf[lcount+2] = '\n';
		if (tfp) fwrite(&lbuf[2],1,lcount+1,tfp);
		return (lbuf[lindex++]);
	}
	else {
    for (lcount = 0; ; )
	switch (ch = xgetc()) {
	case '\r':
		lbuf[lcount++] = '\n';
		xputc('\r'); xputc('\n'); lposition = 0;
		if (tfp) fwrite(lbuf,1,lcount,tfp);
		lindex = 0; lcount--;
		return (lbuf[lindex++]);
	case '\010':
	case '\177':
		if (lcount) {
		    lcount--;
		    while (lposition > lpos[lcount]) {
			xputc('\010'); xputc(' '); xputc('\010');
			lposition--;
		    }
		}
		break;
	case '\032':
		xflush();
		return (EOF);
	default:
		if (ch == '\t' || (ch >= 0x20 && ch < 0x7F)) {
		    lbuf[lcount] = ch;
		    lpos[lcount] = lposition;
		    if (ch == '\t')
			do {
			    xputc(' ');
			} while (++lposition & 7);
		    else {
			xputc(ch); lposition++;
		    }
		    lcount++;
		}
		else {
		    xflush();
		    switch (ch) {
		    case '\003':	xltoplevel();	/* control-c */
		    case '\007':	xlcleanup();	/* control-g */
		    case '\020':	xlcontinue();	/* control-p */
		    case '\032':	return (EOF);	/* control-z */
			case '\024':	xinfo();		/* control-t */
							return ostgetc();
		    default:		return (ch);
		    }
		}
	}
	}
}

/* ostputc - put a character to the terminal */
VOID ostputc(ch)
  int ch;
{
    /* check for control characters */
    oscheck();

    /* output the character */
    if (ch == '\n') {
	xputc('\r'); xputc('\n');
/*	lposition = 0; */
	}
    else {
	xputc(ch);
/*	lposition++; */
   }

   /* output the character to the transcript file */
   if (tfp)
	fputc(ch,tfp);
}

/* osflush - flush the terminal input buffer */
VOID osflush()
{
    lindex = lcount = lposition = 0;
}

/* oscheck - check for control characters during execution */
VOID oscheck()
{
    int ch;
    if ((ch = xcheck()) != 0)
	switch (ch) {
	case '\002':	/* control-b */
	    xflush();
	    xlbreak("BREAK",s_unbound);
	    break;
	case '\003':	/* control-c */
	    xflush();
	    xltoplevel();
	    break;
	case '\023':	/* control-s */
	    xgetc();	/* paused -- get character and toss */
	    break;
	case '\024':	/* control-t */
	    xinfo();
	    break;
	}
}

/* xinfo - show information on control-t */
static VOID xinfo()
{
    extern int nfree,gccalls;
    extern long total;
    char buf[80];
    sprintf(buf,"\n[ Free: %d, GC calls: %d, Total: %ld ]",
	    nfree,gccalls,total);
    errputstr(buf);
}

/* xflush - flush the input line buffer and start a new line */
static VOID xflush()
{
    osflush();
    ostputc('\n');
}

/* xsystem - execute a system command */
LVAL xsystem()
{
	char command[128], commandtail[128],*s;
	int Err;

	if (moreargs()) {
		strcpy(commandtail," /c ");
		s = (char *)getstring(xlgastring());
		strcat(commandtail,s);
		strcat(commandtail,"\r");
		commandtail[0] = strlen(commandtail) - 2;
		xllastarg();
	}
	else
		strcpy(commandtail,"\001 \r");
	
    unsetraw();
	Err = ssystem(getenv("COMSPEC"),commandtail);
	setraw();

	return (Err == 0 ?
		true : cvfixnum((FIXTYPE)Err));
}

/* xgetkey - get a key from the keyboard */
LVAL xgetkey()
{
    xllastarg();
    return (cvfixnum((FIXTYPE)xgetc()));
}

/* ossymbols - enter os specific symbols */
VOID ossymbols()
{
}
