;;;(setq *breakenable* t)
;;;(setq *tracenable* t)

;;;
;;; This variable is the default file to edit
;;;

(defvar *edit-file* "")

(defvar *editor* "eps")

;;;
;;; edit a file using the specified editor
;;; if the file editted was a lisp file (.lsp) load it
;;;

(defun edit (&optional file)
    (read-char)
    (when file (setq *edit-file* (string file)))
    (when (not (member #\.
		       (get-output-stream-list
			  (make-string-input-stream *edit-file*))))
	  (setq *edit-file* (strcat *edit-file* ".lsp")))
    (unless (system (strcat *editor* " " *edit-file*))
          (error (strcat "Unable to execute: " *editor* " " *edit-file*)))
    (let ((len (length *edit-file*)))
      (when (and (> len 4)
		 (string= (string-downcase (subseq *edit-file* (- len 4)))
			  ".lsp"))
	    (load *edit-file*))))
