;; These functions are useful for conversion with strings and arrays
;; Written by Tom Almy

; convert array to list
(defun array-list (array)
	(let ((x nil) (l (length array)))
	     (dotimes (n l)
	     	      (setq x (cons (aref array (- l n 1)) x)))
             x))

; convert list to array
(defun list-array (list)
	(apply #'vector list))

; convert string to list of characters
(defun string-list (string)
	(get-output-stream-list (make-string-input-stream string)))

; convert list of characters to a string
(defun list-string (list)
	(let ((stream (make-string-output-stream)))
	     (dolist (each list (get-output-stream-string stream))
	     	(write-char each stream))))


; do over an array
(defmacro doarray (arglist &rest body)
	(let ((sym (first arglist))
	      (array (second arglist))
	      (returns (cddr arglist))
	      (bind (gensym))
	      (n (gensym)))
	     `(let ((,bind ,array) ,sym)
	       (dotimes (,n  (length ,bind) ,@returns)
	         (setf ,sym (aref ,bind ,n))
	         ,@body))))
