; To play against the computer:
; (meplay #pits-per-side #pebbles-per-pit #search-depth #computer-plays-first)
;
; To have the computer play against itself:
; (play #pits-per-side #pebbles-per-pit #search-depth)


; The playing arena:
; 13    12 11 10 9  8  7
;	0  1  2  3  4  5     6 


(defun makelist (length contents)
	(if	(zerop length)
		'nil
		(cons contents (makelist (1- length) contents))))

(setq *maxvalue* 1000)
(setq *minvalue* (- *maxvalue*))
(defun copy (list) (append list 'nil))
(defun prinb (x) (dotimes (i x) (princ #\space)))

(defun search (startpos depth whoseturn)
   (if (zerop depth)
       (list startpos (evaluate startpos whoseturn))
       (let (bestval nextval bestpos succlist)
	    (setq succlist (successorsfn startpos whoseturn))
	    (when (> depth 1) (setq succlist (reorder succlist whoseturn)))
	    (setq 
	        beta    *maxvalue*
	        bestval *minvalue*
		bestpos (car succlist))
	    (dolist (this succlist)
	    	(when (wincheck this whoseturn)
		    (return-from search (list this *maxvalue*)))
		(setq nextval (- (alphabeta this
					    (- beta)
					    (- bestval)
					    (1- depth)
					    (not whoseturn))))
		(when (> nextval bestval)
		      (setq bestval nextval)
		      (setq bestpos this)))
	    (list bestpos bestval))))	; return value

(defun alphabeta (position alpha beta depth whoseturn)
    (if (zerop depth)
    	(evaluate position whoseturn)
	(let (bestval nextval succlist)
	    (setq succlist (successorsfn position whoseturn))
	    (when (> depth 1) (setq succlist (reorder succlist whoseturn)))
	    (setq bestval alpha)
	    (dolist (this succlist)
	    	(when (wincheck this whoseturn)
		      (return-from alphabeta *maxvalue*))
		(setq nextval (- (alphabeta this
					    (- beta)
					    (- bestval)
					    (1- depth)
					    (not whoseturn))))
		(when (> nextval bestval) (setq bestval nextval))
		(when (<= beta bestval) (return-from alphabeta bestval)))
	    bestval)))

(defun successorsfn (position whoseturn 
			&aux 
			(picuphole (1- (if whoseturn *firstb* *firsta*)))
			succlist 
			succ 
			stones 
			disthole 
			lasthole)
   (dotimes (dummy *enda*)
	    (when (not (zerop (nth (setq picuphole (1+ picuphole)) position)))
		  (setq	succ (copy position))
		  (setq stones (nth picuphole succ)) ; stones in this pit
		  (empty succ picuphole)
		  (setq disthole picuphole)
		  (dotimes (dummy2 stones) ; drop in successive holes except
		  			   ; opponents kalah hole
		  	   (setq disthole (nextdistholefn disthole whoseturn))
			   (dropin succ disthole 1))
		  (setq lasthole disthole)
		  (cond ((allownzerok succ whoseturn) ; all played out
		  	 (opptakesallfn succ whoseturn))
			((eq lasthole (kalaholefn whoseturn)) ; last in kalah
			 (setq succ (successorsfn succ whoseturn)))
			((and (eq (nth lasthole succ) 1) ; last into own empty
			      (> (nth (opposholefn lasthole) succ) 0)
			      (ownsidep lasthole whoseturn))
			 (dropin succ 
			 	 (kalaholefn whoseturn)
				 (1+ (nth (opposholefn lasthole) succ)))
			 (empty succ lasthole)
			 (empty succ (opposholefn lasthole))
			 (when (allownzerok succ whoseturn)
			       (opptakesallfn succ whoseturn))))
		  (setq succlist (nconc (preparelisfn succ) succlist))))
    (if (null succlist)
    	(progn	(setq succ (copy position))
		(opptakesallfn succ whoseturn)
		(list succ))
	succlist))

(defun dropin (position hole number) 
	(rplaca (nthcdr hole position)
		(+ number
		   (nth hole position))))

(defun nextdistholefn (disthole whoseturn)
	(cond	((and whoseturn (eql disthole *lasta*)) *firstb*) ; skip own pile
		((and (not whoseturn) (eql disthole *lastb*)) *firsta*)
		((< disthole *endb*) (1+ disthole))
		(t *firsta*)))

(defun empty (position hole)	; empty out the given hole
	(rplaca (nthcdr hole position) 0))


(defun kalaholefn (whoseturn)   ; the scoring hole for the given player
	(if whoseturn *endb* *enda*))

(defun opposholefn (hole)	; calculate the opposing hole
	 (- *lastb* hole))

(defun ownsidep (hole whoseturn)
	(if whoseturn (> hole *enda*) (< hole *firstb*)))

(defun preparelisfn (x)
	(if (atom (car x))
	    (list x)
	    (unimbedfn x)))

(defun reorder (poslist whoseturn)
	(sortdown poslist (statvalsfn poslist whoseturn)))


(defun sortdown (poslist statvalvec)
	(if (null (cdr poslist))
	    poslist
	    (let ((maxindex (indexfn statvalvec)))
	    	 (cons (nth maxindex poslist)
		       (sortdown (deletel maxindex poslist)
		       		 (deletel maxindex statvalvec))))))

(defun deletel (index list)	; delete the index'th value in list
	(if (zerop index)
	    (cdr list)
	    (prog2
	      (rplacd (nthcdr (1- index) list) (nthcdr (1+ index) list))
	      list)))

(defun indexfn (x) 
       (let ((v (apply #'max x)))
	    (position-if #'(lambda (q) (eql q v)) x)))
       
(defun statvalsfn (poslist whoseturn)
	(if (null poslist)
	    'nil
	    (cons (evaluate (car poslist) whoseturn)
	          (statvalsfn (cdr poslist) whoseturn))))

(defun wincheck (position whoseturn)
	(> (nth (kalaholefn whoseturn) position) *halfall*))

(defun evaluate (position whoseturn) ; assign the value to the position
				     ; could obviously use work
	(let ((ownkala (nth (kalaholefn whoseturn) position))
	      (oppkala (nth (kalaholefn (not whoseturn)) position)))
	     (cond ((> ownkala *halfall*) *maxvalue*)
	     	   ((> oppkala *halfall*) *minvalue*)
		   (t (- ownkala oppkala)))))

(defun printpos (position)
	(let ((minprint (reverse (subseq position 0 *firstb*)))
	      (maxprint (nthcdr *firstb* position)))
	     (terpri)
	     (prin1 (car minprint))
	     (prinb (if (> 10 (car minprint)) 3 2))
	     (setq minprint (cdr minprint))
	     (do ((list minprint (cdr list)))
	         ((null list))
		 (prin1 (car list))
		 (prinb (if (> 10 (car list)) 2 1)))
	     (terpri)
	     (prinb 4)
	     (do ((list maxprint (cdr list)))
	         ((null (cdr list)))
		 (prin1 (car list))
		 (prinb (if (> 10 (car list)) 2 1)))
	     (prinb 2)
	     (prin1 (car (last maxprint)))
	     (terpri)
	     (terpri)))

(defun allownzerok (position whoseturn)
	(zerop (apply #'+ (if whoseturn 
			      (subseq position *firstb* *endb*)
			      (subseq position 0 *enda*)))))


(defun opptakesallfn (position whoseturn)
	(dropin position
		(kalaholefn (not whoseturn))
		(apply #'+ (if whoseturn 
			       (subseq position 0 *enda*)
			       (subseq position *firstb* *endb*))))
	(do	((count *enda* (1- count))
		 (hole (if whoseturn *firstb* *firsta*) (1+ hole)))
		((zerop count))
		(empty position hole)))

(defun nextmove (depth whoseturn)
	(terpri)
	(setq *board* (search (car *board*) depth whoseturn))
	(printpos (car *board*))
	(print (cdr *board*))
	(terpri))

; (defun unimbedfn (poslist)
;	(cond	((null poslist) 'nil)
;		((atom (caar poslist))
;		 (cons (car poslist) (unimbedfn (cdr poslist))))
;		(t (append (unimbedfn (car poslist))
;			   (unimbedfn (cdr poslist))))))

(defun unimbedfn (poslist)
	(do	((list poslist (cdr list))
		 (result nil (if (atom (caar list))
		 		 (cons (car list) result)
				 (append (unimbedfn (car list)) result))))
	        ((null list) result)))

(defun initialize (holes pebbles &aux temp) ; initialize the playing area
	(setq *enda* holes)
	(setq *endb* (+ holes holes 1))
	(setq *firsta* 0)
	(setq *lasta* (1- *enda* ))
	(setq *firstb* (1+ *enda*))
	(setq *lastb* (1- *endb*))
	(setq *halfall* (* holes pebbles))
	(setq temp (makelist holes pebbles))
	(setq *board* (list (append temp
				    (list 0)
				    temp
				    (list 0))
			    0)))

(defun play (holes pebbles depth) ; play the game
	(initialize holes pebbles)
	(do	((whoseturn nil (not whoseturn)))
		((or (eql (cadr *board*) *maxvalue*)
		     (eql (cadr *board*) *minvalue*)))
		(nextmove depth whoseturn)))

(defun meplay (holes pebbles depth computer-first) 
  (prog (picuphole)
	(initialize holes pebbles)
	(when computer-first (setq succ (copy (car *board*)))
	 	 (go y))
n	(setq succ (copy (car *board*)))
	(printpos succ)
	(if (> (nth *enda* succ) *halfall*) (return t))	; win for side a
	(if (> (nth *endb* succ) *halfall*) (return nil)) ; win for side b
x	(princ "Hole? ") (setq picuphole (read))
	(if (or (not (numberp picuphole))
		(> picuphole *firstb*)
		(> 1 picuphole)
		(zerop (setq stones (nth (setq picuphole (1- picuphole)) succ))))
	    (go x))
	(empty succ picuphole)
	(setq disthole picuphole)
	(dotimes (dummy stones)
	         (dropin succ (setq disthole (nextdistholefn disthole nil)) 1))
	(setq lasthole disthole)
	(cond	((allownzerok succ nil)
		 (opptakesallfn succ nil)
		 (setq *board* (list succ 0))
		 (go n))
		((eql lasthole *enda*)
		 (setq *board* (list succ 0))
		 (go n))
		((and (eql (nth lasthole succ) 1)
		      (> (nth (opposholefn lasthole) succ) 0)
		      (> *enda* lasthole))
		 (dropin succ *enda* (1+ (nth (opposholefn lasthole) succ)))
		 (empty succ lasthole)
		 (empty succ (opposholefn lasthole))
		 (when (allownzerok succ nil)
		       (opptakesallfn succ nil)
		       (setq *board* (list succ 0))
		       (go n))))
	(printpos succ)
y	(setq *board* (search succ depth t))
	(go n)))

