;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-

;;; This file is part of Express Windows.

;;; Express Windows is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY.  No author or distributor
;;; accepts responsibility to anyone for the consequences of using it
;;; or for whether it serves any particular purpose or works at all,
;;; unless he says so in writing.  Refer to the Express Windows General Public
;;; License for full details.

;;; Everyone is granted permission to copy, modify and redistribute
;;; Express Windows, but only under the conditions described in the
;;; Express Windows General Public License.   A copy of this license is
;;; supposed to have been given to you along with Express Windows so you
;;; can know your rights and responsibilities.  It should be in a
;;; file named COPYING.  Among other things, the copyright notice
;;; and this notice must be preserved on all copies.  */

;;; ****************************************************************************************
;;; ****************************************************************************************
;;; ********** (c) Copyright 1988, 1989, 1990 Liszt Programming Inc. All Rights Reserved *********
;;; ****************************************************************************************
;;; ****************************************************************************************

;;; ****************************************************************************************
;;; ****************************************************************************************
;;; **************** Written by Dr. Andrew L. Ressler **************************************
;;; ****************************************************************************************
;;; ****************************************************************************************


(in-package 'user)

(defvar *Loaded-Files* (make-hash-table :test 'equal))

(defvar *Binary-File-Type* #+Excl "fasl" #+lucid "lbin" #+symbolics "BIN")

(defun get-pathname-properties (pathname)
  (let ((name (namestring pathname)))
    (gethash name *Loaded-Files*)))

(defun set-pathname-properties (pathname write-date)
  (let ((name (namestring pathname)))
    (setf (gethash name *Loaded-Files*) write-date)))

(defun load-file-maybe (file)
  (setq file (make-pathname :type *Binary-File-Type*
			    :defaults (parse-namestring file)))
  (let ((write-date (and (probe-file file)
			 (file-write-date file))))
    (cond ((numberp write-date)
	   (let ((previous-load (get-pathname-properties file)))
	     (if (numberp previous-load)
		 (when (> write-date previous-load)
		   (load file)
		   (set-pathname-properties file write-date))
		 (progn (load file)
			(set-pathname-properties file write-date)))))
	  (T (format T "~&File ~A does not exist to load.~%" file)))))


(defun compile-file-maybe (file)
  (let ((lisp-version (make-pathname :defaults file :type "lisp"))
	(lbin-version (make-pathname :defaults file
				     :type *Binary-File-Type*)))
    (let ((lisp-date (and (probe-file lisp-version)
			  (file-write-date lisp-version)))
	  (lbin-date (and (probe-file lbin-version)
			  (file-write-date lbin-version))))
      (if (not (numberp lisp-date))
	  (format T "~&File ~A does not exist to compile.~%" file)
	  (when (or (and (numberp lbin-date) (> lisp-date lbin-date))
		    (not (numberp lbin-date)))
	    #+symbolics (format T "~&Compiling File ~A." lisp-version)
	    (compile-file lisp-version #+lucid :messages #+lucid NIL))))))

