;;;-*-Mode: LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp; Patch-File:T -*-

(in-package 'pcl)

;; boot.lisp

(defun load-defmethod
       (class name quals specls ll doc isl-cache-symbol plist fn)
  (let ((method-spec (make-method-spec name quals specls)))
    (record-definition 'method method-spec)
    (setq fn (set-function-name fn method-spec))
    (let ((method
	    (load-defmethod-internal
	      name quals specls ll doc isl-cache-symbol plist fn class)))
      #+symbolics
      (when method (scl:fdefine method-spec fn))
      method-spec)))



(defun load-defmethod-internal
       (gf-spec qualifiers specializers
	lambda-list doc isl-cache-symbol plist fn method-class)
  (when (listp gf-spec) (do-standard-defsetf-1 (cadr gf-spec)))
  (when plist
    (setq plist (copy-list plist))	     ;Do this to keep from affecting
					     ;the plist that is about to be
					     ;dumped when we are compiling.
    (let ((uisl (getf plist :isl))
	  (isl nil))
      (when uisl
	(setq isl (intern-slot-lists uisl))
	(setf (getf plist :isl) isl))
      (when isl-cache-symbol
	(setf (getf plist :isl-cache-symbol) isl-cache-symbol)
	(set isl-cache-symbol isl)))
    
    (setf (method-function-plist fn) plist))
  (let ((method (add-named-method
		  gf-spec qualifiers specializers lambda-list fn
		  :documentation doc)))
    (unless (or (eq method-class 'standard-method)
		(eq (find-class method-class nil) (class-of method)))
      (format *error-output*
	      "At the time the method with qualifiers ~:~S and~%~
               specializers ~:S on the generic function ~S~%~
               was compiled, the method-class for that generic function was~%~
               ~S.  But, the method class is now ~S, this~%~
               may mean that this method was compiled improperly."
	      qualifiers specializers gf-spec
	      method-class (class-name (class-of method))))
    method))




;;3600-low.lisp

(defvar *method-fdefs* (make-hash-table :test #'equal :size 500))
(defvar *method-setf-fdefs* (make-hash-table :test #'equal :size 500))


(defun record-definition (type spec &rest args)
  (declare (ignore args))
  (case type
   (method (if (listp (cadr spec))
        	(si:record-source-file-name spec 'method)
		(si:record-source-file-name spec 'method)))
    (class (si:record-source-file-name spec 'defclass)
	   (si:record-source-file-name spec 'deftype
				       (eq sys:inhibit-fdefine-warnings T)
				       :start-type-definition NIL))))



zwei:
(defun parse-pcl-defmethod-for-zwei (bp-after-defmethod setfp)
  (block parser
    (flet ((barf (&OPTIONAL (error t))
	     (return-from parser
	       (cond ((eq error :flavor)
		      (funcall (get 'flavor:defmethod 'zwei::definition-function-spec-parser)
			       bp-after-defmethod))
		     (T (values nil nil nil error))))))
      (let ((bp-after-generic (forward-sexp bp-after-defmethod))
	    (qualifiers ())
	    (specializers ())
	    (spec nil)
	    (ignore1 nil)
	    (ignore2 nil))
	(when bp-after-generic
	  (multiple-value-bind (generic error-p)
	      (read-fspec-item-from-interval bp-after-defmethod
					     bp-after-generic)
	    (if error-p
		(barf)
		(progn
		  (when (listp generic)
		    (if (and (symbolp (car generic))
			     (string-equal (cl:symbol-name (car generic)) "SETF"))
			(setq generic (second generic)
			      setfp t)
			(barf :flavor)))
		  (let* ((bp1 bp-after-generic)
			 (bp2 (forward-sexp bp1)))
		    (cl:loop
		       (if (null bp2)
			   (barf :more)
			   (multiple-value-bind (item error-p)
			       (read-fspec-item-from-interval bp1 bp2)
			     (cond (error-p (barf))
				   ((listp item)
				    (setq qualifiers (nreverse qualifiers))
				    (cl:multiple-value-setq (ignore1
							      ignore2
							      specializers)
				      (pcl::parse-specialized-lambda-list item))
				    (setq spec (pcl::make-method-spec 
						 (if setfp
						     `(cl:setf ,generic)
						     generic)
						 qualifiers
						 specializers))
				    (return (values spec
						    'defun
						    (string-interval
						      bp-after-defmethod
						      bp2))))
				   (t (push item qualifiers)
				      (setq bp1 bp2
					    bp2 (forward-sexp bp2))))))))))))))))

