;;; -*- Mode:LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;; 
;;; This is the Lucid lisp version of the file portable-low.
;;;
;;; Lucid:               (415)329-8400
;;; 

(in-package 'pcl)


;;; First, import some necessary "internal" or Lucid-specific symbols

(eval-when (eval compile load)

(let ((importer
        #+LCL3.0 #'sys:import-from-lucid-pkg
	#-LCL3.0 (let ((x (find-symbol "IMPORT-FROM-LUCID-PKG" "LUCID")))
		   (if (and x (fboundp x))
		       (symbol-function x)
		       ;; Only the #'(lambda (x) ...) below is really needed, 
		       ;;  but when available, the "internal" function 
		       ;;  'import-from-lucid-pkg' provides better checking.
		       #'(lambda (name)
			   (import (intern name "LUCID")))))))
  ;;
  ;; We need the following "internal", undocumented Lucid goodies:
  (mapc importer '("%POINTER" "DEFSTRUCT-SIMPLE-PREDICATE"
		   #-LCL3.0 "LOGAND&" "%LOGAND&" #+VAX "LOGAND&-VARIABLE"))
  ;;
  ;; We import the following symbols, because in 2.1 Lisps they have to be
  ;;  accessed as SYS:<foo>, whereas in 3.0 lisps, they are homed in the
  ;;  LUCID-COMMON-LISP package.
  (mapc importer '("ARGLIST" "NAMED-LAMBDA" "*PRINT-STRUCTURE*"))
  ;;
  ;; We import the following symbols, because in 2.1 Lisps they have to be
  ;;  accessed as LUCID::<foo>, whereas in 3.0 lisps, they have to be
  ;;  accessed as SYS:<foo>
  (mapc importer '(
		   "NEW-STRUCTURE"   	"STRUCTURE-REF"
		   "PROCEDUREP"     	"PROCEDURE-SYMBOL"
		   "PROCEDURE-REF" 	"SET-PROCEDURE-REF" 
		   ))
  ;;
  ;;  The following is for the "patch" to the general defstruct printer.
  (mapc importer '(
		   "OUTPUT-STRUCTURE" 	  "DEFSTRUCT-INFO"
		   "OUTPUT-TERSE-OBJECT"  "DEFAULT-STRUCTURE-PRINT" 
		   "STRUCTURE-TYPE" 	  "*PRINT-OUTPUT*"
		   ))
  ;;
  ;; The following is for a "patch" affecting compilation of %logand&.
  ;; On APOLLO, Domain/CommonLISP 2.10 does not include %logand& whereas
  ;; Domain/CommonLISP 2.20 does; Domain/CommonLISP 2.20 includes :DOMAIN/OS
  ;; on *FEATURES*, so this conditionalizes correctly for APOLLO.
  #-(or (and APOLLO DOMAIN/OS) LCL3.0 VAX) 
  (mapc importer '("COPY-STRUCTURE"  "GET-FDESC"  "SET-FDESC"))
  
  nil)

;; end of eval-when

)
	

;;;
;;; Patch up for the fact that the PCL package creation in defsys.lisp
;;;  will probably have an explicit :use list ??
;;;
;;;  #+LCL3.0 (use-package *default-make-package-use-list*)




(defmacro %logand (&rest args)
  (reduce-variadic-to-binary #-VAX '%logand&
			     #+VAX 'logand&-variable
			     args
			     0
			     t
			     'fixnum))


;;; Fix for VAX LCL
#+VAX
(defun logand&-variable (x y)
  (logand&-variable x y))

;;; Fix for other LCLs
#-(or LCL3.0 (and APOLLO DOMAIN/OS) VAX)
(progn

(eval-when (compile load eval)

(let* ((logand&-fdesc (get-fdesc 'logand&))
       (%logand&-fdesc (copy-structure logand&-fdesc)))
  (setf (structure-ref %logand&-fdesc 0 t) '%logand&)
  (setf (structure-ref %logand&-fdesc 7 t) nil)
  (setf (structure-ref %logand&-fdesc 8 t) nil)
  (set-fdesc '%logand& %logand&-fdesc))

)

(eval-when (load)
  (defun %logand& (x y) (%logand& x y)))

(eval-when (eval)
  (compile '%logand& '(lambda (x y) (%logand& x y))))

);#-(or LCL3.0 (and APOLLO DOMAIN/OS) VAX)



;;;
;;; Reimplementation of MAKE-MEMORY-BLOCK
;;;
(defmacro make-memory-block (size &optional area)
  (declare (ignore area))
  ;; No need to supply the :initial-element argument -- Lucid Common Lisp will
  ;;  defaultly initialize to nil; also helps the optimizer to recognize this
  ;;  case, if there aren't spurious keyword arguments.
  `(make-array ,size))


;;; The following should override the definitions provided by lucid-low.
;;;
#+(or LCL3.0 (and APOLLO DOMAIN/OS))
(defstruct-simple-predicate  iwmc-class  iwmc-class-p)

;;;
;;;
;;;
;(defmacro symbol-cache-no (symbol mask)
;  `(cache-no ,symbol ,mask))

(defmacro object-cache-no (object mask)
  `(cache-no ,object ,mask))

#-VAX					; nested #+/-: Questionable style?
(defmacro cache-no (pointer mask)
  `(%logand& ,mask ,pointer))

;;; Fix for VAX LCL
#+VAX
(defun logand&-variable (x y)
  (logand&-variable x y))

#+VAX
(defmacro cache-no (pointer mask)
  `(locally (declare (inline logand&-variable))
     (logand&-variable ,mask ,pointer)))


;;; Fix for other LCLs
#-(or (and APOLLO DOMAIN/OS) LCL3.0 VAX)
(eval-when (compile load eval)

(let* ((logand&-fdesc (get-fdesc 'logand&))
       (%logand&-fdesc (copy-structure logand&-fdesc)))
  (setf (structure-ref %logand&-fdesc 0 t) '%logand&)
  (setf (structure-ref %logand&-fdesc 7 t) nil)
  (setf (structure-ref %logand&-fdesc 8 t) nil)
  (set-fdesc '%logand& %logand&-fdesc))

)

(defun set-function-name-1 (fn new-name ignore)
  (declare (ignore ignore))
  (if (not (procedurep fn))
      (error "~S is not a procedure." fn)
      (if (compiled-function-p fn)
	  ;; This is one of:
	  ;;   compiled-function, funcallable-instance, compiled-closure
	  ;;   or a macro.
	  ;; So just go ahead and set its name.
	  (set-procedure-ref fn procedure-symbol new-name)
	  ;; This is an interpreted function.
	  ;; The lambda expression for this interpreted function is stored
	  ;; in the procedure-symbol slot of the procedure.  We side-effect
	  ;; that lambda-expression because that way we get to change the
	  ;; LCODE-CLOSURE which is the actual code the interprted runs.
	  (let ((lambda (procedure-ref fn procedure-symbol)))
	    (cond ((not (listp lambda))
		   (error "Did not find a lambda expression in the name~%~
                           slot of interpreted function ~S."
			  fn))
		  ((eq (car lambda) 'lambda)
		   (setf (car lambda) 'named-lambda
			 (cdr lambda) (cons new-name (cdr lambda))))
		  ((eq (car lambda) 'named-lambda)
		   (setf (cadr lambda) new-name))))))
  fn)

(defun function-arglist (fn)
  (arglist fn))

(sys::defadvice (sys::arglist pcl-arglist-advice) (function)
  (if (if (and (symbolp function)
	       (fboundp function))
	  (setq function (symbol-function function))
	  function)
      (if (and (fboundp 'generic-function-p)
	       (fboundp 'generic-function-pretty-arglist)
	       (generic-function-p function))
	  (generic-function-pretty-arglist function)
	  (sys::advice-continue function))
      (sys::advice-continue function)))

  ;;   
;;;;;; printing-random-thing-internal
  ;;
(defun printing-random-thing-internal (thing stream)
  (format stream "~O" (%pointer thing)))