;;;-*-Mode:LISP; Package:(PCL LISP 1000); Base:10; Syntax:Common-lisp -*-
;;;
;;; *************************************************************************
;;; Copyright (c) 1985, 1986, 1987, 1988 Xerox Corporation.
;;; All rights reserved.
;;;
;;; Use and copying of this software and preparation of derivative works
;;; based upon this software are permitted.  Any distribution of this
;;; software or derivative works must comply with all applicable United
;;; States export control laws.
;;; 
;;; This software is made available AS IS, and Xerox Corporation makes no
;;; warranty about the software, its performance or its conformity to any
;;; specification.
;;; 
;;; Any person obtaining a copy of this software is requested to send their
;;; name and post office or electronic mail address to:
;;;   CommonLoops Coordinator
;;;   Xerox PARC
;;;   3333 Coyote Hill Rd.
;;;   Palo Alto, CA 94304
;;; (or send Arpanet mail to CommonLoops-Coordinator.pa@Xerox.arpa)
;;;
;;; Suggestions, comments and requests for improvements are also welcome.
;;; *************************************************************************
;;;

(in-package 'pcl)

(defvar *defmacro*)

;;;
;;; Install something to process defmacro's lambda list a bit before defmacro
;;; gets to see it.  This allows me to move the &environment to the front of
;;; the list where KCL's defmacro wants it to be.
;;;
;;; This goes to great pains to be sure that it will always indirect through
;;; the function cell of new-defmacro.  That allows me to redefine and have
;;; the new definition take effect.
;;; 
(eval-when (load eval)
  (unless (and (boundp '*defmacro*) *defmacro*)
    (setq *defmacro* (macro-function 'defmacro))
    (setf (macro-function 'defmacro)
	  #'(lambda (form env)
	      (funcall (symbol-function 'new-defmacro) form env)))))

(defun new-defmacro (form env)
  (let ((defmacro (car form))
	(name (cadr form))
	(ll (caddr form))
	(body (cdddr form))
	(&env nil))
    (cond ((not (and (eq defmacro 'defmacro)
		     (symbolp name)
		     (listp ll)))
	   ;; Something is wrong, but we'll pass the whole thing off
	   ;; to the real defmacro and let it detect the error and
	   ;; complain about it in its own way.
	   (funcall *defmacro* form env))
	  ((setq &env (member '&environment ll))
	   ;; If &environment is in the lambda list we have to redo
	   ;; the lamnbda list so that it is at the front.
	   (let ((new-ll ())
		 (old-ll ll))
	     (loop (when (eq old-ll &env)
		     (return (setq ll (append (list '&environment
						    (cadr old-ll))
					      (reverse new-ll)
					      (cddr old-ll)))))
		   (push (pop old-ll) new-ll))
	     (funcall *defmacro*
		      (list* 'defmacro name ll body)
		      env)))
	  (t
	   (funcall *defmacro* form env)))))