(in-package :traps)
;
;	File:		QuickdrawText.p
;
;	Copyright:	 1983-1993 by Apple Computer, Inc.
;				All rights reserved.
;
;	Version:	System 7.1 for ETO #11
;	Created:	Tuesday, March 30, 1993 18:00
;
;       adaptated for MCL 2.0 by Gilles Serasset, GETA-IMAG, France

;$IFC UNDEFINED UsingIncludes
;$SETC UsingIncludes := 0
;$ENDC

;$IFC NOT UsingIncludes
;UNIT QuickdrawText;
;INTERFACE
;$ENDC

;$IFC UNDEFINED UsingQuickdrawText
;$SETC UsingQuickdrawText := 1

;$I+
;$SETC QuickdrawTextIncludes := UsingIncludes
;$SETC UsingIncludes := 1
;$IFC UNDEFINED UsingTypes

(require-interface 'types)               ;$I $$Shell(PInterfaces)Types.p
;$ENDC

;$IFC UNDEFINED UsingIntlResources

(require-interface 'IntlResources)      ;$I $$Shell(PInterfaces)IntlResources.p
;$ENDC

;$SETC UsingIncludes := QuickdrawTextIncludes

; constants

; CharToPixel directions
(defconstant $leftCaret 0)                 ;Place caret for left block
(defconstant $rightCaret -1)               ;Place caret for right block
(defconstant $hilite 1)                    ;Direction is SysDirection

(defconstant $smLeftCaret 0)               ;Place caret for left block, obsolete
(defconstant $smRightCaret -1)             ;Place caret for right block, obsolete 
(defconstant $smHilite 1)                  ;Direction is TESysJust, obsolete

;     Constants for styleRunPosition argument in PortionLine, DrawJustified,
;     MeasureJustified, CharToPixel, and PixelToChar.
(defconstant $onlyStyleRun 0)              ; This is the only style run on the line 
(defconstant $leftStyleRun 1)              ; This is leftmost of multiple style runs on the line 
(defconstant $rightStyleRun 2)             ; This is rightmost of multiple style runs on the line 
(defconstant $middleStyleRun 3)            ; There are multiple style runs on the line and this 
                                           ; is neither the leftmost nor the rightmost. 
(defconstant $smOnlyStyleRun 0)            ; obsolete  
(defconstant $smLeftStyleRun 1)            ; obsolete  
(defconstant $smRightStyleRun 2)           ; obsolete  
(defconstant $smMiddleStyleRun 3)          ; obsolete


; type for styleRunPosition parameter in PixelToChar etc. 
(def-mactype :JustStyleCode (find-mactype :signed-integer))

(defrecord FontInfo
  (ascent :signed-integer)
  (descent :signed-integer)
  (widMax :signed-integer)
  (leading :signed-integer)
  )

(defrecord FormatOrder (array (array :signed-integer 1)))
(def-mactype :FormatOrderPtr (find-mactype :pointer))
(def-mactype :FormatStatus (find-mactype :signed-integer))



(deftrap _Pixel2Char ((textBuf :pointer) (textLen :signed-integer) (slop :signed-integer)
                      (pixelWidth :signed-integer) (leadingEdge (:pointer :boolean)))
  (:stack :signed-integer)
  (:stack-trap #xA8B5 textBuf textLen slop pixelWidth leadingEdge ((+ (ash 33294 16) 20) :signed-longint)))


(deftrap _Char2Pixel ((textBuf :pointer) (textLen :signed-integer) (slop :signed-integer)
                      (offset :signed-integer) (direction :signed-integer))
  (:stack :signed-integer)
  (:stack-trap #xA8B5 textBuf textLen slop pixelWidth leadingEdge ((+ (ash 33292 16) 22) :signed-longint)))


;  New for 7.0  
(deftrap _PixelToChar ((textBuf :pointer) (textLen :signed-long) (slop :fixed)
                       (pixelWidth :fixed) (leadingEdge (:pointer :boolean))
                       (widthRemaining (:pointer :Fixed)) (styleRunPosition :JustStyleCode)
                       (numer :point) (denom :point))
  (:stack :signed-integer)
  (:stack-trap #xA8B5 textBuf textLen slop pixelWidth leadingEdge widthRemaining styleRunPosition 
               numer denom ((+ (ash 33314 16) 46) :signed-longint)))

(deftrap _NPixel2Char ((textBuf :pointer) (textLen :signed-long) (slop :fixed)
                       (pixelWidth :fixed) (leadingEdge (:pointer :boolean))
                       (widthRemaining (:pointer :Fixed)) (styleRunPosition :JustStyleCode)
                       (numer :point) (denom :point))
  (:stack :signed-integer)
  (:stack-trap #xA8B5 textBuf textLen slop pixelWidth leadingEdge widthRemaining styleRunPosition 
               numer denom ((+ (ash 33314 16) 46) :signed-longint)))

(deftrap _CharToPixel ((textBuf :pointer) (textLen :signed-long) (slop :fixed)
                       (offset :signed-long) (direction :signed-integer)
                       (styleRunPosition :JustStyleCode) (numer :point) (denom :point))
  (:stack :signed-integer)
  (:stack-trap #xA8B5 textBuf textLen slop offset direction styleRunPosition 
               numer denom ((+ (ash 33308 16) 48) :signed-longint)))

(deftrap _NChar2Pixel ((textBuf :pointer) (textLen :signed-long) (slop :fixed)
                       (offset :signed-long) (direction :signed-integer)
                       (styleRunPosition :JustStyleCode) (numer :point) (denom :point))
  (:stack :signed-integer)
  (:stack-trap #xA8B5 textBuf textLen slop offset direction styleRunPosition 
               numer denom ((+ (ash 33308 16) 48) :signed-longint)))

(deftrap _DrawJustified ((textPtr :pointer) (textLength :signed-long) (slop :Fixed)
                         (styleRunPosition :JustStyleCode) (numer :Point) (denom :Point))
  nil
  (:stack-trap #xA8B5 textPtr textLength slop styleRunPosition numer denom 
               ((+ (ash 32790 16) 50) :signed-longint)))

(deftrap _NDrawJust ((textPtr :pointer) (textLength :signed-long) (slop :Fixed)
                     (styleRunPosition :JustStyleCode) (numer :Point) (denom :Point))
  nil
  (:stack-trap #xA8B5 textPtr textLength slop styleRunPosition numer denom 
               ((+ (ash 32790 16) 50) :signed-longint)))

(deftrap _MeasureJustified ((textPtr :pointer) (textLength :signed-long) (slop :Fixed)
                            (charLocs :pointer) (styleRunPosition :JustStyleCode) (numer :Point)
                            (denom :Point))
  nil
  (:stack-trap #xA8B5 textPtr textLength slop charLocs styleRunPosition numer denom 
               ((+ (ash 32794 16) 52) :signed-longint)))

(deftrap _NMeasureJust ((textPtr :pointer) (textLength :signed-long) (slop :Fixed)
                            (charLocs :pointer) (styleRunPosition :JustStyleCode) (numer :Point)
                            (denom :Point))
  nil
  (:stack-trap #xA8B5 textPtr textLength slop charLocs styleRunPosition numer denom 
               ((+ (ash 32794 16) 52) :signed-longint)))

(deftrap _NPortionText ((textPtr :pointer) (textLen :signed-long) (styleRunPosition :JustStyleCode)
                        (numer :Point) (denom :Point))
  (:stack :fixed)
  (:stack-trap #xA8B5 textPtr textLen styleRunPosition numer denom 
               ((+ (ash 33810 16) 54) :signed-longint)))

(deftrap _PortionLine ((textPtr :pointer) (textLen :signed-long) (styleRunPosition :JustStyleCode)
                        (numer :Point) (denom :Point))
  (:stack :fixed)
  (:stack-trap #xA8B5 textPtr textLen styleRunPosition numer denom 
               ((+ (ash 33810 16) 54) :signed-longint)))

(deftrap _HiliteText ((textPtr :pointer) (textLength :signed-integer) (firstOffset :signed-integer)
                      (secondOffset :signed-integer) (offsets (:pointer :OffsetTable)))
  nil
  (:stack-trap #xA8B5 textPtr textLength firstOffset secondOffset offsets 
               ((+ (ash 32782 16) 28) :signed-longint)))

(deftrap _DrawJust ((textPtr :pointer) (textLength :signed-integer) (slop :signed-integer))
  nil
  (:stack-trap #xA8B5 textPtr textLength slop ((+ (ash 32776 16) 30) :signed-longint)))

(deftrap _MeasureJust ((textPtr :pointer) (textLength :signed-integer) (slop :signed-integer)
                       (charLocs :pointer))
  nil
  (:stack-trap #xA8B5 textPtr textLength slop ((+ (ash 32780 16) 32) :signed-longint)))



(deftrap _PortionText ((textPtr :pointer) (textLen :signed-long))
  (:stack :fixed)
  (:stack-trap #xA8B5 textPtr textLen ((+ (ash 33800 16) 36) :signed-longint)))

(deftrap _VisibleLength ((textPtr :pointer) (textLen :signed-long))
  (:stack :signed-long)
  (:stack-trap #xA8B5 textPtr textLen ((+ (ash 33800 16) 40) :signed-longint)))

(deftrap _GetFormatOrder ((ordering :FormatOrderPtr) (firstFormat :signed-integer)
                          (lastFormat :signed-integer) (lineRight :boolean) (rlDirProc :pointer)
                          (dirParam :pointer))
  nil
  (:stack-trap #xA8B5 ordering firstFormat lastFormat lineRight rlDirProc dirParam 
               ((+ (ash 32786 16) 65532) :signed-longint)))


(deftrap _TextFont ((font :signed-integer))
  nil
  (:stack-trap #xA887))

(deftrap _TextFace ((face :style))
  nil
  (:stack-trap #xA888))

(deftrap _TextMode ((mode :signed-integer))
  nil
  (:stack-trap #xA889))

(deftrap _TextSize ((size :signed-integer))
  nil
  (:stack-trap #xA88A))

(deftrap _SpaceExtra ((extra :Fixed))
  nil
  (:stack-trap #xA88E))

(deftrap _DrawChar ((ch :character))
  nil
  (:stack-trap #xA883))

(deftrap _DrawString ((s (:string 255)))
  nil
  (:stack-trap #xA884))

(deftrap _DrawText ((textBuf :pointer) (firstByte :signed-integer) (byteCount :signed-integer))
  nil
  (:stack-trap #xA885))

(deftrap _CharWidth ((ch :character))
  (:stack :signed-integer)
  (:stack-trap #xA88D))

(deftrap _StringWidth ((s (:string 255)))
  (:stack :signed-integer)
  (:stack-trap #xA88C))

(deftrap _TextWidth ((textBuf :pointer) (firstByte :signed-integer) (byteCount :signed-integer))
  (:stack :signed-integer)
  (:stack-trap #xA886))

(deftrap _MeasureText ((count :signed-integer) (textAddr :pointer) (charLocs :pointer))
  nil
  (:stack-trap #xA837))
`

(deftrap _GetFontInfo ((info (:pointer :FontInfo)))
  nil
  (:stack-trap #xA88B))


(deftrap _CharExtra ((extra :Fixed))
  nil
  (:stack-trap #xAA23))

(deftrap _StdText ((count :signed-integer) (textAddr :pointer) (numer :point) (denom :point))
  nil
  (:stack-trap #xA882))

(deftrap _StdTxMeas ((byteCount :signed-integer) (textAddr :pointer) (numer (:pointer :point))
                     (denom (:pointer :point)) (info (:pointer :FontInfo)))
  (:stack :signed-integer)
  (:stack-trap #xA8ED))


(export '($leftCaret $rightCaret $hilite $smLeftCaret $smRightCaret $smHilite $onlyStyleRun
          $leftStyleRun $rightStyleRun $middleStyleRun $smOnlyStyleRun $smLeftStyleRun $smRightStyleRun
          $smMiddleStyleRun))

(provide-interface 'quickdrawtext)



