;;; -*- Mode:Common-Lisp; Package:YW-ZWEI; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

(defmacro with-function-trapped ((name) &body body)
"Executes Body with the function named Name trapped so that if it is called
you get mouse confirm to determine whether you want to break of not.
"
 `(let ((old-fun #',name))
       (declare (unspecial old-fun))
       (letf ((#',name #'(lambda (&rest args)
			  (if (tv:mouse-confirm
				(format nil "~A - break?" ',name)
			      )
			      (progn (stop-here)
				     (apply old-fun args)
			      )
			      (apply old-fun args)
			  )
			)
	      )
	     )
	     ,@body
       )
  )
)

(defmacro do-lines
	  ((&key (start-line 'start-line)
		 (stop-line  'stop-line)
	   )
	   &body body
	  )
"Executes Body over the range Start-Line to Stop-Line with Line bound to the
current line.
"
 `(let ((start-line ,start-line)
	(stop-line  ,stop-line)
       )
       (declare (unspecial start-line stop-line))
       (do ((line start-line (line-next line)))
	   ((eq line stop-line))
	 (declare (unspecial line))
	 ,@body
       )
  )
)

(defmacro do-lines-backwards
	  ((&key (start-line 'start-line)
		 (stop-line  'stop-line)
	   )
	   &body body
	  )
"Executes Body over the range Start-Line to Stop-Line with Line bound to the
current line, looping from the stop line back to the start line.
"
 `(let ((start-line ,start-line)
	(stop-line  ,stop-line)
       )
       (declare (unspecial start-line stop-line))
       (do ((line stop-line (line-previous line)))
	   ((eq line start-line))
	 (declare (unspecial line))
	 ,@body
       )
  )
)

(defmacro do-paragraphs
	  ((&optional (start-line 'start-line) (stop-line 'stop-line))
	   &body body
	  )
"Executes Body for each paragraph over the range Start-Line to Stop-Line with
Start-Line and Stop line bound to the beginning and end lines of the paragraph.
"
 `(let ((boundaries (list ,start-line))
	(new-bp1 nil)
	(new-bp2 nil)
       )
       (do-lines (line ,start-line ,stop-line)
	 (if (blank-line-p line) (push line boundaries) nil)
       )
       (loop for (start-line stop-line) on
	     (if (equal (length boundaries) 1)
		 (list ,start-line ,stop-line)
		 (reverse boundaries)
	     )
	     do
	     (if stop-line
		 (multiple-value-bind (one two) (progn ,@body)
		   (if new-bp1
		       (setq new-bp2 two)
		       (progn (setq new-bp1 one)
			      (setq new-bp2 two)
		       )
		   )
		 )
	     )
       )
       (values new-bp1 new-bp2)
  )
)

