;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10 -*-
;;; *-* Last-edit: 02/28/90 13:01:26 by RICE; *-* 

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

;;; This is a Kludge. There's a horrible bug in make system that breaks
;;; this occasionally.
(eval-when (compile load eval)
  (if (loading-yw-p)
      (progn (si:compile-load-if "Yes-Way:Yes-Way;PROFILE-INTERFACE")
	     (si:compile-load-if "Yes-Way:Yes-Way;SITE")
      )
      (progn (si:compile-load-if "New-Yes-Way:Yes-Way;PROFILE-INTERFACE")
	     (si:compile-load-if "New-Yes-Way:Yes-Way;SITE")
      )
  )
)

(defprofile-class :Yw profile:imap-client-customisation-variables*
  "YW" "Variables controlling the Explorer IMAP client mail program."
)

;===============================================================================

(defvar *mail-control-window-width* (min 400 (send tv:default-screen :width))
"The outside width of the YW window.  That's the one with the prompt window
 and the mailbox selector scroll window.
"
)

(defprofile *Mail-Control-Window-Width* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect (reposition-mail-control-windows t)
  :Long-Time-To-Set-P t
)
;-------------------------------------------------------------------------------

(Defvar *mail-control-window-height* (min 240 (send tv:default-screen :height))
"The outside height of the YW window.  That's the one with the prompt window
 and the mailbox selector scroll window.
"
)

(defprofile *Mail-Control-Window-Height* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect (reposition-mail-control-windows t)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-window-width* (min 505 (send tv:default-screen :width))
"The outside width of the windows that show message headers."
)

(defprofile *Message-Window-Width* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect (reposition-summary-windows t)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-window-height* (min 295 (send tv:default-screen :height))
"The outside width of the windows that show message headers."
)

(defprofile *Message-Window-Height* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect (reposition-summary-windows t)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *new-headers-window-x-offset* 0
"The x offset in pixels to use to position new summary windows
to make them walk across the screen.  A good value for this is 20
if you start with your windows on the left of the screen [low values for
(first *Default-Ideal-Message-Display-Pane-Position*)] of -20 if you
start with your headers windows towards the right of the screen.
"
)

(defprofile *new-headers-window-x-offset* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect (reposition-summary-windows)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(Defvar *new-headers-window-y-offset* -10
"The y offset in pixels to use to position new summary windows
to make them walk across the screen.  A good value for this is 20
if you start with your windows at the top of the screen [low values for
(second *Default-Ideal-Message-Display-Pane-Position*)] of -20 if you
start with your headers windows towards the bottom of the screen.
"
)

(defprofile *new-headers-window-y-offset* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect (reposition-summary-windows)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-window-font-map* '(fonts:tvfont fonts:tr8i fonts:tr8b)
"The font map to use in the window that shows message headers.  Everything
will be printed in Font 0 unless you make magic settings for
*message-header-display-specification*.
"
)

(defprofile *message-window-font-map* :Yw :Yw
  :Cvv-Type :Font-List
  :Set-Effect
    (apply-to-summary-windows
      #'(lambda (x)
	  (send x :Set-Font-Map *Message-Window-Font-Map*)
	  (Send x :Refresh)
	)
    )
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *mailbox-selector-default-number-of-lines* 4
"The number of lines in the little scroll window that allows you to select
different message header windows.
"
)

(defprofile *mailbox-selector-default-number-of-lines* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect
    (apply-to-mail-control-windows
       #'(lambda (window)
	   (send window :change-constraints (mail-control-window-constraints))
	 )
    )
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *mailbox-selector-font-map* *Message-Window-Font-Map*
"The font map to use for the mailbox selector window.  Only Font 0 is used at
present.
"
)

(defprofile *mailbox-selector-font-map* :Yw :Yw
  :Cvv-Type :font-list
  :Set-effect
    (apply-to-mail-control-windows
      #'(lambda (window)
	  (send (send window :Mailbox-Selector) :Set-Font-Map
		*mailbox-selector-font-map*
	  )
	  (send window :refresh)
	)
    )
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(Defvar *default-ideal-mail-control-window-position*
 (list (max 0 (- (send tv:default-screen :width ) *mail-control-window-width*))
       (max 0 (- (send tv:default-screen :height) *mail-control-window-height*))
 )
"The screen coordinates that are used when possible to position the mail
control window.  If the screen is too small to be able to put it there then
the window will butt up against the side of the screen.
"
)

(defprofile *default-ideal-mail-control-window-position* :Yw :Yw
  :Cvv-Type :Sexp
  :Set-effect (reposition-mail-control-windows)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *default-ideal-message-display-pane-position*
 (list (max 0 (- (send tv:default-screen :width ) *message-window-width*))
       (max 0 (- (send tv:default-screen :height)
		 *mail-control-window-height*
		 *message-window-height*
	      )
       )
 )
"The screen coordinates that are used when possible to position message sequence
header windows.  If the screen is too small to be able to put it there then
the window will butt up against the side of the screen.
"
)

(defprofile *default-ideal-message-display-pane-position* :Yw :Yw
  :Cvv-Type :Sexp
  :Set-effect (reposition-summary-windows)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *yw-daemon-sleep-interval* 120
"The yw daemon is a process that does things like checking your mailbox for
new mail.  This is the interval in seconds between the times that it wakes up
to do things like this.  Any daemon actions that you specify will also
be separated by this interval.
"
)

(defprofile *yw-daemon-sleep-interval* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defreset-var *daemon-header-read-grain-size* (For-Processor-Type 20 40 30)
"The number of message headers that the yw daemon will fetch preemptively in
one chunk.  The larger this number the more the machine might slow down as
this happens behind your back, but the more rapidly your preemptive commands
will be satisfied.
"
)

(defprofile *daemon-header-read-grain-size* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defreset-var *daemon-body-read-grain-size* (For-Processor-Type 3 10 6)
"The number of message bodies that the yw daemon will fetch preemptively in
one chunk.  The larger this number the more the machine might slow down as
this happens behind your back, but the more rapidly your preemptive commands
will be satisfied.
"
)

(defprofile *daemon-body-read-grain-size* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defvar *Default-Daemon-Actions*
	'((:Get-Headers 100 :Backwards) (:Get-Unseen-Bodies))
"A list of the actions that the yw daemon will perform in the background.
Each element in the list consists of a method name on the flavor yw:yw-daemon
followed by its arguments.  This variable is used by yw:Default-Daemon-Actions
directly to compute the actions to perform.  You can, therefore, change the
background behaviour by changing either of these.
  The currently implemented useful methods are as follows:
    :Get-Headers (most-recent-n, &optional (direction :forwards))
      This will preemptively get the most-recent-n message headers in chunks of
      *daemon-header-read-grain-size*.  If direction is not forwards then
      the headers will be preempted starting with the most recent headers and
      working backwards in time.
    :Get-Recent-Bodies (&optional (most-recent-n nil) (direction :forwards))
      This will preemptively get the most-recent-n recent message bodies
      in chunks of *daemon-body-read-grain-size*.  If direction is not
      forwards then the bodies will be preempted starting with the most recent
      and working backwards in time.
    :Get-All-Bodies (&optional (direction :forwards))
      Will get all of the bodies of th messages in the mailbox working in the
      direction specified.
    :Get-Unseen-Bodies (&optional (most-recent-n nil) (direction :forwards)
                                  (bboards-too nil))
      This will preemptively get the most-recent-n unseen message bodies in
      chunks of *daemon-body-read-grain-size*.  If direction is not forwards
      then the bodies will be preempted starting with the most recent and
      working backwards in time.  If most-recent-n is :all then it will get
      all unseen message bodies.  If BBoards-too is true then this will
      happen for bboard files as well.
    :Get-Flagged-Bodies (&optional (most-recent-n nil) (direction :forwards))
      This will preemptively get the most-recent-n flagged message bodies in
      chunks of *daemon-body-read-grain-size*.  If direction is not forwards
      then the bodies will be preempted starting with the most recent and
      working backwards in time.  If most-recent-n is :all then it will get
      all unseen message bodies.
    :Get-Nearby-Bodies (&optional (next-n *daemon-body-read-grain-size*)
	                          (direction :forwards))
      Gets the bodies of messages that are near to any messages that you are
      already reading.  Gets Next-N messages after the message you're reading
      if direction is :forwards, otherwise message before the message
      you're reading.
    :Get-And-Cache-Directory-For-Completion ()
      Makes sure that your default mailbox directory has been read on for the
      completion cache.
    :Get-Selected-Bodies (&optional (direction :forwards) (bboards-too nil))
      Gets all of the message bodies for the messages that match the sequence
      asked for if the user selects a mailbox with the Get <foo> <filter>
      command.
"
)

(defprofile *Default-Daemon-Actions* :Yw :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar *default-bboard* *site-specific-default-bboard*
"The default bboard to read when you give an argumentless BBoard command."
)

(defprofile *default-bboard* :Yw :Yw
  :Cvv-Type :string
)

;-------------------------------------------------------------------------------

(defvar *default-mailbox-name* "INBOX"
"The default mailbox name."
)

(defprofile *default-mailbox-name* :Yw :Yw
  :Cvv-Type :string
)

;-------------------------------------------------------------------------------

(defvar *canonical-mailbox-names* '(("INBOX" "INBOX" t))
"An AList that maps canonical mailbox names into actual mailbox names.
If there is a third element in the alist entry then this indicates
that the translation does not specify the host."
)

(defprofile *canonical-mailbox-names* :Yw :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar *default-mailbox-file-type* *site-specific-default-mailbox-file-type*
"The default file type of mail files."
)

(defprofile *default-mailbox-file-type* :Yw :Yw
  :Cvv-Type :string
)

;-------------------------------------------------------------------------------

(defvar *default-bboard-file-type* *site-specific-default-mailbox-file-type*
"The default file type of BBoard files."
)

(defprofile *default-bboard-file-type* :Yw :Yw
  :Cvv-Type :string
)

;-------------------------------------------------------------------------------

(defvar *bboard-source-directory* *site-specific-bboard-source-directory*
"The directory in which all of the bboard files reside.  If you change the
*bboard-source-host*, then you'll probably have to change this too.
"
)

(defprofile *bboard-source-directory* :Yw :Yw
  :Cvv-Type :string
)

;-------------------------------------------------------------------------------

(defvar *bboard-source-host* *site-specific-bboard-source-host*
"The default host from which to read BBoards.  If you change this then you'll
probably want to change *bboard-source-directory* as well.
"
)

(defprofile *bboard-source-host* :Yw :Yw
  :Cvv-Type :string
)

;-------------------------------------------------------------------------------

(defvar *bboard-search-list* nil
"The list of bboard names to search through when using the Find and Ignore
 commands.  An example value for it might be:
  '(\"COMMON-LISP\" \"COMMONLOOPS\" \"SU-ETC\")
"
)

(defprofile *bboard-search-list* :Yw :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar *NetNews-search-list* nil
"The list of NetNews newsgroup names to search through when using the Find
 and Ignore commands.  An example value for it might be:
  '(\"net.foo.bar\" \"comp.sci.froz\")
"
)

(defprofile *NetNews-search-list* :Yw :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defreset-var *NetNews-database-Path*
        (make-pathname :Name "NETNEWS"
		       :Type "NETNEWS"
		       :Defaults (fs:user-homedir)
		       :Version :Newest
	)
"The pathname for a database in which to store YW's memory of which
netnews messages you have read.  Note: this file may be a binary file
and so should not have a file type that the file system will
interpret as being a character file type, e.g. LISP or TEXT."
)

(defprofile *netnews-database-path* (:Yw) :Yw
  :Cvv-Type :Pathname-or-nil
)

;-------------------------------------------------------------------------------

(defvar *bboard-filter-alist* nil
"An alist which maps the names of bboards to filters to apply to those bboards.
This is particularly useful in the context of using filters defined by
YW:Deffilter.  An example entry might be:
  '((\"SU-ETC\" uncrispin))
See the documentation on Deffilter or the help text for Message sequences to
get some hints on defining filters.
"
)

(defprofile *bboard-filter-alist* :Yw :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar *from-field-preemptions* 15
"The number of headers to preempt if the mailer decides that it has to get
a message header to read the From field.  For instance, if you say:
Headers From rice
Then the system might have to read the headers for a number of messages.
Preempting *from-field-preemptions* messages at once reduces the number of
separate fetch commands that must be sent.
"
)

(defprofile *from-field-preemptions* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defvar *to-field-preemptions* 15
"The number of headers to preempt if the mailer decides that it has to get
a message header to read the To field.  For instance, if you say:
Headers To rice
Then the system might have to read the headers for a number of messages.
Preempting *to-field-preemptions* messages at once reduces the number of
separate fetch commands that must be sent.
"
)

(defprofile *to-field-preemptions* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defvar *subject-field-preemptions* 15
"The number of headers to preempt if the mailer decides that it has to get
a message header to read the Subject field.  For instance, if you say:
Headers Subject foo
Then the system might have to read the headers for a number of messages.
Preempting *subject-field-preemptions* messages at once reduces the number of
separate fetch commands that must be sent.
"
)

(defprofile *subject-field-preemptions* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defvar *flags-field-preemptions* 15
"The number of headers to preempt if the mailer decides that it has to get
a message header to read the message flags.  For instance, if you say:
Headers UnSeen
Then the system might have to read the headers for a number of messages.
Preempting *flags-field-preemptions* messages at once reduces the number of
separate fetch commands that must be sent.
"
)

(defprofile *flags-field-preemptions* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defvar *text-field-preemptions* 3
"The number of headers to preempt if the mailer decides that it has to get
a message header to read the message body.  For instance, if you say:
Headers Text foo
Then the system might have to read the headers for a number of messages.
Preempting *text-field-preemptions* messages at once reduces the number of
separate fetch commands that must be sent.
"
)

(defprofile *text-field-preemptions* :Yw :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defvar *use-top-level-mouse-clicks-as-prefix-arguments* nil
"When this is true, clicking on a message when you aren't in the middle
of a command results in the message being used as a prefix argument, rather
than invoking the top level mouse click behaviour.  This is like the default
behaviour for mouse-l-2
"
)

(defprofile *use-top-level-mouse-clicks-as-prefix-arguments* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *reply-to-all-by-default* nil
"When true the default state for replying to messages will be to reply to all
recipients.  This default can be overridden by the use the Everyone/Sender
qualifiers to the yw prompt window the using the reply command or by giving
a numeric arg to Zmacs when using the R, or M-x Reply commands.
"
)

(defprofile *reply-to-all-by-default* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *reply-inclusive-by-default* nil
"When true the default state for replying to messages will be to include the message text.  This default can be overridden by the use the Inclusive/Exclusive
qualifiers to the yw prompt window the using the reply command or by
either deleting the included text if unwanted or by using the S-i or
M-x Include Message commands in Zmacs.
"
)

(defprofile *reply-inclusive-by-default* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *right-button-menu-Commands*
  '(("Read" :Value :Read-sequence :Documentation
     "Read the selected message"
    )
    ("Reply" :Value :Reply-to-sequence :Documentation
     "Compose a reply to the selected message"
    )
    ("Forward" :Value :Forward-sequence :Documentation
     "Forward the selected message."
    )
    ("Delete" :Value :Delete-sequence :Documentation
     "Delete the selected message"
    )
    ("Undelete" :Value :Undelete-sequence :Documentation
     "Undelete the selected message"
    )
    ("Flag" :Value :Flag-sequence :Documentation
     "Flag the selected message"
    )
    ("Keyword" :Value :menu-keyword-sequence :Documentation
     "Set/Unset keywords for the selected message"
    )
    ("Unflag" :Value :Unflag-sequence :Documentation
     "Unflag the selected message"
    )
    ("Copy" :Value :Menu-Copy-Sequence :Documentation
     "Copy the selected message to a file to be prompted for."
    )
    ("Move" :Value :Menu-Move-Sequence :Documentation
     "Move the selected message to a file to be prompted for."
    )
    ("Hardcopy" :Value :Hardcopy-Sequence :Documentation
     "Send a copy of selected message to the printer"
    )
    ("Select Headers" :Value :Select-Headers-using-menu :Documentation
 "Pop up a menu of header selection criteria and select the specified headers."
    )
   )
"The Command menu which pops up when a message menu item is right buttoned.
The value to any item is the name of a method on yw:task-server.  For
reasons of performance the right button menu is a constant item menu.  Thus,
if you decide to add new items to this list then you should also do the
following setq:
  (setq yw:*Right-Button-Options-Menu* (yw:make-yw-right-button-menu))
or set this var using the profile feature.
"
)

(defprofile *Right-Button-Menu-Commands* :Yw :Yw
  :Cvv-Type :Sexp
  :Set-effect
    (setq *Right-Button-Options-Menu* (make-yw-right-button-menu))
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *process-messages-even-if-deleted* t
"When true any commands that you chose to use will still
apply to deleted messages.
"
)

(defprofile *process-messages-even-if-deleted* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*queue-zmacs-get-next-message-commands-p* nil
"When true, Zmacs queues a request to the yw task server to move from one
message to the next.  If this is nil, therefore, you loose a certain amount
of asynchronicity in the behaviour of the mailer, but it works in a somewhat
more intuitive seeming manner.
"
)

(defprofile yw:*queue-zmacs-get-next-message-commands-p* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*move-to-next-message-after-delete-in-zmacs* t
"When true, Zmacs will move to the next message in the sequence when you
use the D command.  The value of this can be overridden by the c-d command
in Zmacs.
"
)

(defprofile yw-zwei:*move-to-next-message-after-delete-in-zmacs*
	    (:Zmacs :Yw) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*show-number-of-messages-in-summary-labels-p* t
"When true the number of messages in a sequence are shown in the label of the
message header window.
"
)

(defprofile yw:*show-number-of-messages-in-summary-labels-p* :Yw :Yw
  :Cvv-Type :Boolean
  :Set-effect
  (progn (apply-to-summary-windows
	   #'(lambda (win) (send win :Set-Label (send win :Make-Label)))
	 )
	 (apply-to-mail-control-windows
	   #'(lambda (win)
	       (send (send win :Mailbox-Selector) :Update-All-Labels)
	     )
	 )
  )
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar yw:*address-alias-alist* nil
"An Alist which maps aliases to physical addresses.  It should be a list of
items.  Each item should be of the form:
  (\"jim\" \"rice@sumex\") for a simple address or
  (\"my-list\" (\"jim\" \"Acuff@sumex\")) for a mailing list.
"
)

(defprofile yw:*address-alias-alist* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar yw:*display-ordered-sequences-in-the-order-specified* t
"When true messages sequences that are generated by the use of control structure
type commands like Reverse or Sort will be shown in the order specified by the
sequence, rather than by the numerical order of the messages in the sequence.
"
)

(defprofile yw:*display-ordered-sequences-in-the-order-specified* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*filter-headers* t
"When true the headers of messages read in Zmacs will be filtered."
)

(defprofile yw:*filter-headers* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*basic-header-types-to-filter* nil
"A list of keywords naming the types of basic header entry to remove from the
header fields of messages when displaying them in Zmacs.  For instance
the list could be of the form:
  (:Received :Return-Path :message-id :full-name :Content-Transfer-Encoding)
"
)

(defprofile yw:*basic-header-types-to-filter* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar yw:*address-header-types-to-filter*  nil
"A list of keywords naming the types of address header entry to remove from the
header fields of messages when displaying them in Zmacs.  For instance
the list could be of the form:
  (:bcc :reply-to)
"
)

(defprofile yw:*address-header-types-to-filter*  :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar yw:*notify-of-new-messages* t
"A switch that controls what happens when the mailer determines that new mail has arrived.  This variable can have one of four values:
 nil - doesn't tell you about the new mail
 :notification - gives a tv:notify notification of the presence of new mail.
 :beep - beeps with a beep defined by yw:*new-mail-notify-beep-type*.
 true - prints a message in the mail control window but doesn't notify you.
"
)

(defprofile yw:*notify-of-new-messages* :Yw :Yw
  :Cvv-Type (:Assoc '(("Record" . t)
		      ("Notify" . :Notification)
		      ("Beep" . :Beep)
		      ("Do nothing" . nil)
		     )
	    )
)

;-------------------------------------------------------------------------------

(defvar yw:*new-mail-notify-beep-type* 'zwei:converse-message-received
"The beep type to use when new mail arrives and yw:*notify-of-new-messages*
is set to :beep.
"
)

(defprofile yw:*new-mail-notify-beep-type* :Yw :Yw
  :Cvv-Type :beep-type
)

;-------------------------------------------------------------------------------

(defvar yw:*beep-command-beep-type* 'zwei:converse-message-received
"The beep type to use when the beep command is issued."
)

(defprofile yw:*beep-command-beep-type* :Yw :Yw
  :Cvv-Type :beep-type
)

;-------------------------------------------------------------------------------

(defreset-var *default-mail-server-user-directory*
	      (list "A" (string-upcase fs:user-id))
"The default directory in which to find your .mminit file (your top level
directory on your primary mail server.  This variable must be in canonical,
interchange format to make it work on any server, i.e. (\"A\" \"RICE\") means
/a/rice/ if the server is a unix box.
"
)

(defprofile *default-mail-server-user-directory* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *read-yw-init-file-on-mailer-start-up* nil
"When the mailer starts up, parse the specified mminit file to get aliases."
)

(defprofile *read-yw-init-file-on-mailer-start-up* :Yw :Yw
  :Cvv-Type :Boolean
  :Set-effect (if *read-yw-init-file-on-mailer-start-up*
		  (parse-yw-init-file)
	      )
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defreset-var *Default-Mailbox-Directory* *default-mail-server-user-directory*
"The default directory in which to find your mailbox.  This variable must
be in canonical, interchange format to make it work on any server,
i.e. (\"A\" \"RICE\") means /a/rice/ if the server is a unix box.
"
)

(defprofile *Default-Mailbox-Directory* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defreset-var *Service-Hosts*
	(loop for name
	      in (Append *imap-server-hosts-default-host-first*
			 (list (send si:local-host :Name))
		 )
	      for host-object = (net:parse-host name t)
	      when host-object
	      collect (send host-object :Name)
	)
  "The full Internet names of the hosts that run IMAP servers."
)

(defprofile *Service-Hosts* :Yw :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defreset-var *User-Host* (first *Service-Hosts*)
  "The host name of the user's primary remote mail server."
)

(defprofile *User-Host* :Yw :Yw
  :Cvv-Type :String
)

;-------------------------------------------------------------------------------

(defvar *default-move-to-mailbox-name* "MOVE"
"The default file name for a mailbox to move messages to."
)

(defprofile *default-move-to-mailbox-name* :Yw :Yw
  :Cvv-Type :String
)

;-------------------------------------------------------------------------------

(defvar *default-move-to-mailbox-type* *site-specific-default-mailbox-file-type*
"The default file type for a mailbox to move messages to."
)

(defprofile *default-move-to-mailbox-type* :Yw :Yw
  :Cvv-Type :String
)

;-------------------------------------------------------------------------------

(defvar *default-copy-to-mailbox-name* "COPY"
"The default file name for a mailbox to copy messages to."
)

(defprofile *default-copy-to-mailbox-name* :Yw :Yw
  :Cvv-Type :String
)

;-------------------------------------------------------------------------------

(defvar *default-copy-to-mailbox-type* *site-specific-default-mailbox-file-type*
"The default file type for a mailbox to copy messages to."
)

(defprofile *default-copy-to-mailbox-type* :Yw :Yw
  :Cvv-Type :String
)

;-------------------------------------------------------------------------------

;;; The following variables control the way that headers are displayed.

(defvar *message-header-message-length-field-width* 4
"The default width for the message Length field in the header display."
)

(defprofile *message-header-message-length-field-width* :Yw :Yw
  :Cvv-Type :Number
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *yw-date-print-mode* :Dd-Mmm-Yy
"The default print mode for dates in the maill headers."
)

(defprofile *yw-date-print-mode* :Yw :Yw
  :Cvv-Type :Keyword
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-header-number-format-string* "~vD)"
"The format string used to print out the message number of a message in the
message header display.  See yw:*message-header-display-specification* for more
detail about what can go in this string.
"
)

(defprofile *message-header-number-format-string* :Yw :Yw
  :Cvv-Type :String
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-header-from-format-string* "~vA"
"The format string used to print out the message From field of a message in the
message header display.  See yw:*message-header-display-specification* for more
detail about what can go in this string.
"
)

(defprofile *message-header-from-format-string* :Yw :Yw
  :Cvv-Type :String
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-header-keywords-format-string* "~vA"
"The format string used to print out any keywords for a message in the
message header display.  See yw:*message-header-display-specification* for more
detail about what can go in this string.
"
)

(defprofile *message-header-keywords-format-string* :Yw :Yw
  :Cvv-Type :String
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-header-flags-format-string* "~vA"
"The format string used to print out the Flags of a message in the
message header display.  See yw:*message-header-display-specification* for more
detail about what can go in this string.
"
)

(defprofile *message-header-flags-format-string* :Yw :Yw
  :Cvv-Type :String
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-content-type-format-string* "~vA"
"The format string used to print out the content-type of a message in the
message header display.  See yw:*message-header-display-specification* for more
detail about what can go in this string.
"
)

(defprofile *message-content-type-format-string* :Yw :Yw
  :Cvv-Type :String
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-header-subject-format-string* "~vA"
"The format string used to print out the message Subject field of a message
in the message header display.  See yw:*message-header-display-specification*
for more detail about what can go in this string.
"
)

(defprofile *message-header-subject-format-string* :Yw :Yw
  :Cvv-Type :String
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-header-length-format-string* "(~@vA)"
"The format string used to print out the message Length field of a message
in the message header display.  See yw:*message-header-display-specification*
for more detail about what can go in this string.
"
)

(defprofile *message-header-length-format-string* :Yw :Yw
  :Cvv-Type :String
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *system-flag-display-sequence*
       '((:\\recent special-recent-processor)
	 (:\\seen Special-Seen-Processor special-unseen-processor)
	 (:\\flagged "F" " ")
	 (:\\answered "A" " ")
	 (:\\deleted "D")
	)
"An AList that tells the mailer how you want the system flags to be displayed.
The AList is used by the function yw:Header-Flags-string to do the printing.
For each entry in the Alist the flags for the message are searched for a
match.  If a match is found then  The Second element in the item is used,
if not the Third is used.  If the value is a string then this is printed. 
Otherwise it is funcalled with the flags list and is expected to return a
string or nil.
"
)

(defprofile *system-flag-display-sequence* :Yw :Yw
  :Cvv-Type :Sexp
  :Set-effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *message-header-display-specification*
       '(:Content-Type (0 3)
	 :Space nil
	 :Number 3
         :Space nil
	 :Flags (4 4)
	 :date :brief-date
	 :from (17 17)
	 :length :chars
	 :keywords (0 10)
	 :Space nil
	 :subject 0
	)
"This is a plist rather like (in fact a superset of)
yw-zwei::*mail-summary-template* .  Each entry consists of the name of a header
field component and a specifier value.  The header fields are printed in the
order that they are entered in this list.  If a field is not represented in the
list then it is not printed.  Any values that are legal for
yw-zwei::*mail-summary-template* are legal in this list (though :length :lines
will actually give you the length in chars and a width of
*Message-Header-Message-Length-Field-Width* wil be used).
As well as the original zmacs values you can specify things in a rather more
complex manner.  For instance, simply specifying a number will have the
effect of supplying that number to format strings such as
*message-header-number-format-string* as the ~V parameter.  Thus the string
will be padded with spaces up to that length.  However, if this field ends up
being longer than the space you want to allocate to it then you can specify
a pair, the second element of which will cause the output to truncate to the
specified length.  Thus (4 4) will pad to 4 chars but will also truncate to
a max of 4 chars, and (0 10) will not pad the string but will bound it to be
no more than 10 chars long.
You can control the font in which the item is printed by providing a font
specifier in the list.  Thus (0 4 :font 2) will trim it to a max of four chars
and will display it in font 2 of the font map.  (4 nil :font 1) will pad to four
chars, won't truncate and will display in font 1.
When displaying things in fonts other than a constant width font (usually font
0) you end up with your columns not matching up properly, which is a bit
ugly.  You can fix this by using an absolute tab feature in the format strings.
The format strings, such as *message-header-length-format-string* can be of the
form:
  \"(~@vA)250\"
This will have the effect of printing out the field in the normal way (~VA)
and will then tab over to pixel position 250 if it is still to the left of
this point.  Any number of such tabs can be used in the format string as
long as the (decimal) pixel number is delimited by  characters.  Clearly
this in some way constrains the width that you give your headers windows,
but most people will do this anyway.

The :Space specifier is special.  By default the printer will put a space
between each of the components.  If you want to exclude the space, as happens
in a couple of the default settings for this variable, you should provide a
:space nil specifier.  If you want too force a space in then you should put in
:space t.  :space <number> will print <number> spaces.
"
)

(defprofile *message-header-display-specification* :Yw :Yw
  :Cvv-Type :Sexp
  :Set-Effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *sub-mailbox-header-display-specification* 
	'(:Content-Type (0 3)
	  :date :brief-date
	  :from (0 17)
	  :subject 0
	 )
"Like *message-header-display-specification*, only for mailbox names that are
created from multipart messages."
)

(defprofile *sub-mailbox-header-display-specification* :Yw :Yw
  :Cvv-Type :Sexp
  :Set-Effect (refresh-all-message-displays)
  :Long-Time-To-Set-P t
)

;-------------------------------------------------------------------------------

(defvar *reselect-mail-control-window-on-end-of-sequence* t
"When true the mail control window is reselected when you reach the end of
reading a sequence.  You might want to make this nil if your usage pattern
is to use mouse clicks on the message pane, rather than typed commands to
the mail control window.
"
)

(defprofile *reselect-mail-control-window-on-end-of-sequence* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *deexposed-mailer-mouse-behaviour-enabled* nil
"When true, deexposed mouse docs, moves, boxing and buttons are enabled over
message display panes.
"
)

(defprofile *deexposed-mailer-mouse-behaviour-enabled* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *use-ucl-error-catching-stuff-p* t
"When true causes the normal UCL error catching stuff to apply, putting
up a mouse confirm to see whether you want to be dumped in the debugger.
If you always want to be dumped in the debugger then set this to nil.
"
)

(defprofile *use-ucl-error-catching-stuff-p* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *just-warn-for-warnings* t
"When true, causes warning type messages just to print out a warning
and throw you out to the top level.
"
)

(defprofile *just-warn-for-warnings* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *just-warn-for-errors* t
"When true, causes warning type messages to be printed for errors.  If false
Error handling is controlled by *use-ucl-error-catching-stuff-p*.
"
)

(defprofile *just-warn-for-errors* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *use-caches-for-pathname-completion* '(ip:ftp)
"When true, causes YW to cache pathnames collected in directory lists and to use
these caches for pathname cimpletion operations.  The caches are updated every
time a directory list is actually performed, other than during completion.
There is therefore a chance of the cache not being valid if you delete files.
However, for completing to mail files names this is usually ok.  If this value
is a list then the caching happens for service implementation types specified
in this list, e.g. '(ip:ftp) or '(fs:qfile).
"
)

(defprofile *use-caches-for-pathname-completion* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *always-complete-commands-to-shortest-available* nil
"When true will cause commands typed to the mail control window to complete to
the shortest matching command if you try to complete (hit a space, tab
or return).  This is an alternative to using the command short-form feature.
(see defcommand-short-form).
"
)

(defprofile *always-complete-commands-to-shortest-available* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *scroll-to-most-recent-messages-p* nil
"When true the message displays for your mailboxes will scroll to show only the
headers of recent messages if there are any.
"
)

(defprofile *scroll-to-most-recent-messages-p* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *scroll-to-most-recent-messages-for-bboards-p* t
"When true the message displays for bboard mailboxes will scroll to show
only the headers of recent messages if there are any.
"
)

(defprofile *scroll-to-most-recent-messages-for-bboards-p* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*mail-reply-indent-prefix-strings*
	'(">>  " "->  " "--> " "--->")
"A list of prefices to be used when using message reply indentation.
If the mailer detects any of these prefices already present then the circular
next in the list will be used.  As Zmacs deduces new prefices this list is
modified to contain the new prefices.
"
)

(defprofile yw-zwei:*mail-reply-indent-prefix-strings* (:Yw :Zmacs) :Yw
  :Cvv-Type :sexp
)

(defvar yw-zwei:*selected-prefix* nil
"The first indentation prefix to use."
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*mail-reply-indent-prefix-string-ring*
	(copy-list yw-zwei:*mail-reply-indent-prefix-strings*)
"A list of prefices to be used when using message reply indentation.
If the mailer detects any of these prefices already present then the circular
next in the list will be used.
"
)

(defprofile yw-zwei:*mail-reply-indent-prefix-string-ring* (:Yw :Zmacs) :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*mail-reply-indent-rejustify-right-margin* 70
"The right margin in chars that the mailer uses to determine whether it should
rejustify a paragraph.  It is good to keep this at 80 columns, since most
people still read their mail on 80 column devices.
"
)

(defprofile yw-zwei:*mail-reply-indent-rejustify-right-margin* (:Yw :Zmacs) :Yw
  :Cvv-Type :Number
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*automatic-rejustify-overflowing-replies* nil
"When true it will always go ahead and rejustify any reply text that it thinks
needs to be rejustified, otherwise a mouse confirm is used to ask you if you
want to rejustify it.
"
)

(defprofile yw-zwei:*automatic-rejustify-overflowing-replies* (:Yw :Zmacs) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*try-to-deduce-prefices* t
"When true, Zmacs wil try to deduce which prefices have already been used
in a replied message and will pick a suitable one to use.
"
)

(defprofile yw-zwei:*try-to-deduce-prefices* (:Yw :Zmacs) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*always-use-deduced-prefices* t
"When true will cause zmacs always to use a prefix that it has deduced for
indentation.  For instance, if it chooses to indent the paragraph

+++>Hello
+++>Jim

Then it might deduce that +++> is being used as a prefix and that when the
paragraph is being refilled this prefix should be used again.
"
)

(defprofile yw-zwei:*always-use-deduced-prefices* (:Yw :Zmacs) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*automatically-regrind-lisp-like-code* nil
"When true, it will automatically regrind paragraphs that it things represent
Lisp code if they need to be rejustified to fit into the defined right
margin.
"
)

(defprofile yw-zwei:*automatically-regrind-lisp-like-code* (:Yw :Zmacs) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*split-screen-for-message-replies* nil
"When true will cause YW to split the screen between the
source and reply message when replying.
"
)

(defprofile yw:*split-screen-for-message-replies* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*indent-text-for-message-replies* t
"When the source message it included in a reply and this is true, that reply is
indented.
"
)

(defprofile yw:*indent-text-for-message-replies* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*include-source-header-in-reply* nil
"When true the header of the message that is being replied to is
included in the reply.  Most people don't seem to want this, but some do.
"
)

(defprofile yw:*include-source-header-in-reply* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*include-in-message...-in-reply* nil
"When true a string of the form \"In message ... foo said bar\" above the
text of included replies.
"
)

(defprofile yw:*include-in-message...-in-reply* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*in-message...-components-to-include*
	'(yw-zwei:standard-in-message-text)
"A list of functions of a cache entry that deliver text to include in a reply."
)

(defprofile yw:*in-message...-components-to-include* :Yw :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar yw:*keep-messages-read-by-default* nil
"When true, the buffers that are used to read messages are kept, as opposed to
being killed when you finish reading the message.
"
)

(defprofile yw:*keep-messages-read-by-default* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*dont-kill-reply-buffers* nil
"When true reply buffers aren't killed unless you abort the reply."
)

(defprofile yw:*dont-kill-reply-buffers* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *user-summary-window-inits* nil
"An init plist that is passed to the instantiation of headers windows.  This
is useful if you like to change characteristics of those windows.  For instance,
you might want to give it the value:
  (:scroll-bar-side :right)
If you like to position it up against the right hand side of the window.
"
)

(defprofile *user-summary-window-inits* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *user-prompt-window-inits* nil
"An init plist that is passed to the instantiation of prompt windows.
This is useful if you like to change characteristics of those windows.  
For instance, you might want to give it the value:
  (:more-p t)
If you like to have more-p on.
"
)

(defprofile *user-prompt-window-inits* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *user-mailbox-selector-inits* nil
"An init plist that is passed to the instantiation of mailbox selector windows.
This is useful if you like to change characteristics of those windows.  
For instance, you might want to give it the value:
  (:scroll-bar-side :right)
If you like to position it up against the right hand side of the window.
"
)

(defprofile *user-mailbox-selector-inits* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *user-mail-control-window-inits* nil
"An init plist that is passed to the instantiation of mailbox selector windows.
This is useful if you like to change characteristics of those windows.  
"
)

(defprofile *user-mail-control-window-inits* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *enable-regrinding-lisp-regions-whilst-indenting* nil
"When true will allow zmacs to try to regrind lisp code then refilling
paragraphs for an indent.  You'd be well advised to leave this as nil
until things are well debugged.
"
)

(defprofile *enable-regrinding-lisp-regions-whilst-indenting* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw:*copy/move-to-non-existent-files-ok-p* nil
"When false, if you copy/move to a non-existent file then it queries
to see if you really want to do it.
"
)

(defprofile yw:*copy/move-to-non-existent-files-ok-p* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *mouse-l-hold-drag-selection-enabled* t
"When true drag selection of messages is enabled for holding mouse-l."
)

(defprofile *mouse-l-hold-drag-selection-enabled* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *close-mailbox-when-all-summary-windows-closed* t
"When true and you close all of the summary windows associated with a given
mailstream, the mailstream is closed.
"
)

(defprofile *close-mailbox-when-all-summary-windows-closed* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *kill-buffers-when-mailstream-closed-by-user* t
"When the user closes a mailstream and this is true then any associated
zmacs buffers will be killed.
"
)

(defprofile *kill-buffers-when-mailstream-closed-by-user* :Yw :Yw
  :Cvv-Type :Boolean
)


;-------------------------------------------------------------------------------

(defvar *unsent-message-query-p* zwei:*unsent-message-query-p*
"Query the user to resume previously uncompleted messages when you Send."
)

(defprofile *unsent-message-query-p* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *automatically-start-mailer-on-login* nil
"When true, the mailer will be started up on login."
)

(defprofile *automatically-start-mailer-on-login* :Yw :Yw
  :Cvv-Type :Boolean
  :Set-Effect (start-up-yw)
)

;-------------------------------------------------------------------------------

(defvar *automatically-open-connection-to-default-inbox* nil
"When true, the mailer will automatically try to open a connection to your
default inbox when it is invoked.
"
)

(defprofile *automatically-open-connection-to-default-inbox* :Yw :Yw
  :Cvv-Type :Boolean
  :Set-Effect (start-up-yw)
)

;-------------------------------------------------------------------------------

(defvar *try-to-expose-current-summary-window-on-mailer-expose* nil
"When true, the mailer will try to expose the current summary window when it is
 exposed itself.  This could be dangerous, since in some circumstances
 recursive exposure might result.
"
)

(defprofile *try-to-expose-current-summary-window-on-mailer-expose* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *try-to-expose-all-summary-windows-on-mailer-expose* nil
"When true, the mailer will try to expose the current summary window when it is
 exposed itself.  This could be dangerous, since in some circumstances
 recursive exposure might result.
"
)

(defprofile *try-to-expose-all-summary-windows-on-mailer-expose* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defreset-var *Rule-Base-Path*
        (make-pathname :Name "RULE-BASE"
		       :Type "RULE-BASE"
		       :Defaults (fs:user-homedir)
		       :Version :Newest
	)
"The pathname for a database in which to store rules.  Note: this file is a
binary file and so should not have a file type that the file system will
interpret as being a character file type, e.g. LISP or TEXT."
)

(defprofile *rule-base-path* (:Yw) :Yw
  :Cvv-Type :Pathname-or-nil
)

;-------------------------------------------------------------------------------

(defreset-var yw-zwei:*address-database-path*
	      (make-pathname :Name "ADDRESS-DATABASE"
			     :Type "DATABASE"
			     :Defaults (fs:user-homedir)
			     :Version 1
              )
"The pathname for a database in which to keep addresses.  Note: this file is a
binary file and so should not have a file type that the file system will
interpret as being a character file type, e.g. LISP or TEXT."
)

(defprofile yw-zwei:*address-database-path* (:Yw :Zmacs) :Yw
  :Cvv-Type :Pathname-or-nil
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*keep-cursor-keystrokes-as-normal* t
"If this is true then the mailer will not take over any cursor movement
 keystrokes for its own commands.
"
)

(defprofile yw-zwei:*keep-cursor-keystrokes-as-normal* (:Yw :Zmacs) :Yw
  :Cvv-Type :boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*kill-read-buffer-on-end-key* t
"When you hit the  key in Zmacs this controls whether your current buffer
 gets thrown away or not before you get thrown back to the mailer.
"
)

(defprofile yw-zwei:*kill-read-buffer-on-end-key* (:Yw :Zmacs) :Yw
  :Cvv-Type :boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*try-apropos-completion-if-recognition-completion-fails* t
"If :Recognition () completion fails on an address then try to use apropos
 completion instead.
"
)

(defprofile yw-zwei:*try-apropos-completion-if-recognition-completion-fails*
	    (:Yw :Zmacs) :Yw
  :Cvv-Type :boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*reselect-previous-buffer* :ask
"Controls whether to reuse existing buffers for forward/reply/remail.  For
instance, if you forward a message, send it and then forward it again you
have the option of reusing the previous buffer, if it has not been seleted,
and editing your previous message.
"
)

(defprofile yw-zwei:*reselect-previous-buffer*
	    (:Yw :Zmacs) :Yw
  :Cvv-Type (:assoc '(("Yes" . t) ("Ask" . :Ask) ("No" . nil)))
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*silent-mail-delivery* nil
"Controls whether the Mail sent notification comes out or not.  If this value
is :minibuffer then the Done message will come out in the minibuffer.
This is a good variable to use in conjunction with setting
mail:*use-primary-mail-servers* to :always and
yw-zwei:*address-disposition-notifications-to-suppress*.
"
)

(defprofile yw-zwei:*silent-mail-delivery*
	    (:Yw :Zmacs) :Yw
  :Cvv-Type (:assoc '(("Yes" . t) ("Minibuffer" . :Minibuffer) ("No" . nil)))
)

;-------------------------------------------------------------------------------

(defconstant *acceptable-address-dispositions*
  '(:delivered :rejected :translated :forward-unknown
    :expansion-error :deferred :queued :Smtp-Error
    :expanded
   )
)

(defvar yw-zwei:*address-disposition-notifications-to-suppress* nil
"A list of the address disposition notifications to suppress.  This list
 can contain any of:-
    :delivered :rejected :translated :forward-unknown :expansion-error
    :deferred :queued :smtp-error :expanded :translated.
"
)

(defprofile yw-zwei:*address-disposition-notifications-to-suppress*
	    (:Yw :Zmacs) :Yw
  :Cvv-Type
  (:Multiple-Menu
    `',(mapcar #'(lambda (x)
		   (list (string-capitalize (symbol-name x) :Spaces t)
			 :Value x
		   )
		 )
	         *Acceptable-Address-Dispositions*
       )
  )
)

;-------------------------------------------------------------------------------

(defvar *post-process-header-actions*
	'((:Fonts fontify-buffer) (:X-Fonts fontify-buffer))
"An alist that maps the types of mail header components to functions to apply to
those headers after a message has been read into a zmacs buffer.  The function
takes the header and the buffer as its args.
"
)

(defprofile *post-process-header-actions* (:Yw :Zmacs) :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*put-sequence-after-this-in-mode-line* 'zwei:*zmacs-buffer-name*
"An item from (zwei:mode-line-list) after which to put the
{<n> of <x> messages} text.  If this is nil then no such message is emitted.
"
)

(defprofile yw-zwei:*put-sequence-after-this-in-mode-line* (:Yw :Zmacs) :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *process-status-pane-default-number-of-lines* 1
"The number of lines to use in the process status window."
)

(defprofile *process-status-pane-default-number-of-lines* :Yw :Yw
  :Cvv-Type :Fixnum
)

;-------------------------------------------------------------------------------

(defvar *system-output-pane-default-number-of-lines* 3
"The number of lines to use in the system output window."
)

(defprofile *system-output-pane-default-number-of-lines* :Yw :Yw
  :Cvv-Type :Fixnum
)

;-------------------------------------------------------------------------------

(defvar *user-process-status-window-inits* nil
"Additions to the default init plist for the process status window."
)

(defprofile *user-process-status-window-inits* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *user-system-output-window-inits* nil
"Additions to the default init plist for the system output window."
)

(defprofile *user-system-output-window-inits* :Yw :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *process-status-window-font-map* *message-window-font-map*
"The font map for the process status window."
)

(defprofile *process-status-window-font-map* :Yw :Yw
  :Cvv-Type :Font-List
)

;-------------------------------------------------------------------------------

(defvar *system-output-window-font-map* *message-window-font-map* 
"The font map for the system output window."
)

(defprofile *system-output-window-font-map* :Yw :Yw
  :Cvv-Type :Font-List
)

;-------------------------------------------------------------------------------

(defvar *process-staus-pane-sleep-interval* 1
"The time interval in seconds that the status pane sleeps for between
 attempted updates."
)

(defprofile *process-staus-pane-sleep-interval* :Yw :Yw
  :Cvv-Type :positive-fixnum
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*completion-clean-up-function*
	'yw-zwei:completion-clean-up-function
"The function used to disambiguate addresses in the address completion scheme."
)

(defprofile yw-zwei:*completion-clean-up-function* (:Zmacs :Yw) :Yw
  :Cvv-Type :function
)
 
;-------------------------------------------------------------------------------

(defvar yw-zwei:*address-substrings-that-cause-ignoring-in-completion*
	'("KSL-MAC-" "KSL-EXP-")
"A list of strings such that is the address completion mechanism finds an
address with this string then it filters it out.
"
)

(defprofile yw-zwei:*address-substrings-that-cause-ignoring-in-completion*
	    (:Zmacs :Yw) :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar *summary-windows-to-create-for-mailbox-alist* nil
"An alist that maps the names of mailboxes to a set of filters to apply to that
mailbox when it is opened.  For instance, if you always want to create an
Unseen, a Flagged window and one for the messages From Acuff for your inbox
then you could make the value:
  '((\"INBOX\" ((unseen)) ((flagged)) ((from acuff))))

The mailbox spec in each item in the alist will match for any substring.  I.e.
\".MAIL\" will match to any mailbox you create whose name has the (file type)
\".MAIL\".

Each entry in the list after the mailbox name is of the form
(filter &rest inits).  This allows you to have items of the form:
  ((from acuff) :Font-Map '(cptfont) :Position (:Values (100 300)) ...)

The legal sorts of inits are any methods for which there is a :Foo and a
:Set-Foo method (i.e. the init you perform must be undoable).  If the method
takes more than one arg (as in the case with :Set-Position above) then you
should provide all of the args and denote that :Set-Position is to be lexpr
called and that :Position is to be used with multiple-value-list by use of the
(:Values <init-value>) specifier.

If you use init options to specify the position or size of summary windows then
you should also give it the init options :User-Defined-Position-P t.  This will
tell the system not to use these windows in the computation of the position of
new summary windows that use the standard window walking mechanism.

If you have a null filter specification then this will
provide inits for the inbox, i.e. 

  (nil :Position (:Values (100 100)) :User-Defined-Position-P t)

If you have as the first element in the init spec the value :no-window then no
window will be created.  Thus,

  (nil :no-window)

is the way to prevent the system from creating the default window for a given
mailbox.

"
)

(defprofile *summary-windows-to-create-for-mailbox-alist* (:Yw) :Yw
  :Cvv-Type :sexp
)

;-------------------------------------------------------------------------------

(defvar *kill-buffers-when-messages-expunged* nil
"When true causes any buffers associated with expunged messages to be killed."
)

(defprofile *kill-buffers-when-messages-expunged* (:Zmacs :Yw) :Yw
  :Cvv-Type :boolean
)
 
;-------------------------------------------------------------------------------

(defvar *userp-system-m-key* t
"When true allows YW to bind to the system-M key."
)

(defprofile *userp-system-m-key* (:Yw) :Yw
  :Cvv-Type :boolean
)
 
;-------------------------------------------------------------------------------

(defvar yw-zwei:*print-address-dispositions-in-mailer-window* nil
"When true, causes address dispositions to be printed to the scroll window
of the mailer window.
"
)

(defprofile yw-zwei:*print-address-dispositions-in-mailer-window*
  (:ZMacs :Yw) :Yw
  :Cvv-Type :boolean
)
 
;-------------------------------------------------------------------------------

(defvar *page-break-between-printed-messages* t
"When true causes a page break to be printed between each printed message."
)

(defprofile *page-break-between-printed-messages*
  (:Yw) :Yw
  :Cvv-Type :boolean
)
 
;-------------------------------------------------------------------------------

(defvar *display-expanded-name-of-filters-in-labels-p* nil
"When true causes the full name of filters to be displayed in things like
window labels, e.g. UnCrispin : [Recent] And [Not [From Crispin]]
"
)

(defprofile *display-expanded-name-of-filters-in-labels-p* 
  (:Yw) :Yw
  :Cvv-Type :boolean
)
 
;-------------------------------------------------------------------------------

(defvar *header-field-keys-to-parse-for-address-database* '(:To :From)
"A list of message header keys (e.g. '(:from :cc)) to parse for the purpose
of building the address database.  The contents of this list should be a subset
of mail:*address-header-types*.
"
)

(defprofile *header-field-keys-to-parse-for-address-database*
  (:Yw) :Yw
  :Cvv-Type :sexp
)
 
;-------------------------------------------------------------------------------

(defvar *default-message-sequence* :sequence-unseen
"The default message sequence to go to if new mail arrives or if there is no
current sequence.
"
)

(defprofile *default-message-sequence*
  (:Yw) :Yw
  :Cvv-Type :sexp
)
 
;-------------------------------------------------------------------------------

(defvar *header-digestification-mode* nil
"Way in which headers appear in digestified messages."
)

(defprofile *header-digestification-mode*
  (:Yw) :Yw
  :Cvv-Type :Keyword
)
 
;-------------------------------------------------------------------------------

(defvar yw-zwei:*allow-epsilon-font-shifts-in-incoming-mail-p* t
"When true, any epsilon chars in incoming mail are interpretted as font shifts."
)

(defprofile yw-zwei:*allow-epsilon-font-shifts-in-incoming-mail-p*
  (:Yw :Zmacs) :Yw
  :Cvv-Type :Keyword
)
 
;-------------------------------------------------------------------------------

(defvar yw-zwei:*mail-fonts-attribute-mapping-alist* nil
"An AList that maps fonts specified in source messages into display fonts.
For instance, if you often get mail from symbolics users then you might
want to map a fonts header such as:

  Fonts: CPTFONT, TINY, CPTFONTCB

by using:

  '((FONTS:CPTFONT   FONTS:TVFONT)
    (FONTS:CPTFONTB FONTS:TR8B)
   )

to make the fonts smaller.
"
)

(defprofile yw-zwei:*mail-fonts-attribute-mapping-alist*
  (:Yw :Zmacs) :Yw
  :Cvv-Type :Keyword
)
 
;-------------------------------------------------------------------------------

(defvar yw-zwei:*default-fonts-for-read-buffer* nil
"The font map to use for read buffers if the buffer has no font attribute.
Must be a list of font NAMES, i.e. '(fonts:cptfont)"
)

(defprofile yw-zwei:*default-fonts-for-read-buffer*
  (:Yw :Zmacs) :Yw
  :Cvv-Type :Keyword
)
 
;-------------------------------------------------------------------------------

(defvar *use-comments-as-names-in-non-named-addresses* t
"When true allows the mailer to interpret address comments as the names
of the person if there is no name for the address.
"
)

(defprofile *use-comments-as-names-in-non-named-addresses* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *remove-dates-as-message-names-p* t
"When true, removes those irritating addresses that are of the form:
  21-Jan-1991 1825 <couchli@wr1for.enet.dec.com>
")

(defprofile *remove-dates-as-message-names-p* :Yw :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *default-yw-zmacs-frame* nil
"When bound to a zmacs frame this will be selected as the default frame in
 which to do message editing.
"
)

(defprofile *Default-Yw-Zmacs-Frame* (:Yw :Zmacs) :Yw :Cvv-Type :Sexp)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*query-about-abort-in-send-mail* t
"When true makes zmacs y-or-n-p you if you hit abort when sending mail.
"
)

(defprofile yw-zwei:*query-about-abort-in-send-mail* (:Yw :Zmacs) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *use-fonts-from-messages-when-printing-p* t
"When true uses fonts: and x-fonts: header attributes to compute a set of
fonts for printing.
"
)

(defprofile *use-fonts-from-messages-when-printing-p* (:Yw) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *default-printer-font-list* '(fonts:cptfont fonts:tr12 fonts:hl12)
"When either *use-fonts-from-messages-when-printing-p* is false or there is no
attribute for the message, it uses this font map instead for printing.  These
are Explorer fonrs, not printer fonts.  They are mapped through the font
mapping mechanism for the appropriate printer type.
"
)

(defprofile *default-printer-font-list* (:Yw) :Yw
  :Cvv-Type :Font-List
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*use-zmail-abort-key-binding-p* t
"When true uses the default binding for the abort key in send mail mode.
This is pretty annoying a lot of the time.  If this is nil then the abort
key just throws you out to the top.
"
)

(defprofile yw-zwei:*use-zmail-abort-key-binding-p* (:Yw :Zmacs)
  :Yw :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*use-shortened-from-name-in-forwarded-subject-field-p* nil
"When true makes the subject field of forwarded messages have the name part of
named addresses instead of the whole address.
"
)

(defprofile yw-zwei:*use-shortened-from-name-in-forwarded-subject-field-p*
	    (:Yw :Zmacs)
  :Yw :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *Prefer-Windows-With-Visible-Selected-Messages-When-Exposing-P* nil
"When true exposes windows with selected messages over those without,
rather than using just label visibility as a criterion.
"
)

(defprofile *Prefer-Windows-With-Visible-Selected-Messages-When-Exposing-P*
	    (:Yw) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *wildcard-match-in-searches-if-possible* nil
"When true causes the server to perform wildcard matching in search criteria.
The wildcard characters are * = 0-or-more-chars and % = exactly-1-char.
Thus, if this var is set to true, the command
   Headers From j*s
will match all messages from, for example, James Rice.
"
)

(defprofile *wildcard-match-in-searches-if-possible*
	    (:Yw) :Yw
  :Cvv-Type :Boolean
)

;-------------------------------------------------------------------------------

(defvar *reasons-to-mark-messages-as-seen* nil
"A list of keywords which define cases in which a message will be marked as
seen.  The list can contain any of the following keywords:
  :Delete - marks the message as seen if it is deleted.
  :Copy - marks the message as seen if it is copied.
  :Move - marks the message as seen if it is moved.
"
)

(defprofile *reasons-to-mark-messages-as-seen*
	    (:Yw) :Yw
  :Cvv-Type :Sexp
)

;-------------------------------------------------------------------------------

(defvar *address-database-save-action* t
"Can be one of the following:
  nil - don't save the address database.
  :query - ask the user whether it should be saved.
  true - save the address database if you think it is necessary, but
         if the predicate address-database-save-predicate is defined then
         call this to decide what to do.
"
)

(defprofile *address-database-save-action*
	    (:Yw) :Yw
  :Cvv-Type (:Assoc '(("No" . nil)
		      ("Query" . :Query)
		      ("Yes" . t)
		     )
	    )
)

;-------------------------------------------------------------------------------

(defvar *shrink-summary-windows-with-control-window* nil
  "If non-NIL summary windows will be iconified when their control window
is iconified"
)

(defprofile *shrink-summary-windows-with-control-window*
	    (:Yw) :Yw
  :Cvv-Type :boolean
)


;-------------------------------------------------------------------------------

(defvar *yw-tcp-input-buffer-size* 8192
"The size of TCP stream buffers for YW."
)

(defprofile *yw-tcp-input-buffer-size*
	    (:Yw) :Yw
  :Cvv-Type :fixnum
)

;-------------------------------------------------------------------------------

(defvar *yw-tcp-number-of-input-buffers* 6
"The number of input buffers per stream in YW."
)

(defprofile *yw-tcp-number-of-input-buffers*
	    (:Yw) :Yw
  :Cvv-Type :fixnum
)

;-------------------------------------------------------------------------------

(defvar *show-to-address-if-from-me-p* t
"When true causes the headers display to show \"-> foo\" instead of your own
address when mail is from you.
"
)

(defprofile *show-to-address-if-from-me-p*
	    (:Yw) :Yw
  :Cvv-Type :boolean
)

;-------------------------------------------------------------------------------

(defvar *use-rfc822+-message-format-p* t
"When true causes YW to use RFC822+ format for any messages that it sends,
such as forwards and digests.
"
)

(defprofile *use-rfc822+-message-format-p*
	    (:Yw) :Yw
  :Cvv-Type :boolean
)

;-------------------------------------------------------------------------------

(defvar *show-images-if-you-can-p* t
"When true causes YW display any image message that it knows how to display."
)

;;;Edited by Tom Gruber            5 Feb 92  13:31
(defprofile *show-images-if-you-can-p*
	    (:Yw) :Yw
  :Cvv-Type :boolean
)

;-------------------------------------------------------------------------------

(defvar *reset-windows-on-deallocation* nil
"When true causes YW to undo any set-edges type operations on windows that
you did during allocation."
)

(defprofile *reset-windows-on-deallocation*
	    (:Yw) :Yw
  :Cvv-Type :boolean
)

;-------------------------------------------------------------------------------

(defvar yw-zwei:*prefer-longer-addresses-for-completion-p* t
"When completion happens, prefer any address that is longer than another
otherwise equivalent address."
)

(defprofile yw-zwei:*prefer-longer-addresses-for-completion-p*
	    (:Yw :Zmacs)
  :Yw :Cvv-Type :Boolean
)

;===============================================================================
;-------------------------------------------------------------------------------
(Defvar *default-daemon-mailbox-open-operations* nil "Not used right now.")



;;; !!!!!

(defvar *xloadimage-server-host-name* "HPP") ;;; Move these to vars some time.
(defvar *xloadimage-temp-file-path* "HPP:/a/rice/xloadimage.tmp")
