;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

(defflavor imap-stream-mixin
	   ((mailbox nil)		; Name of the mailbox
	    (imaplock (make-an-imap-lock)) ; Process lock
	    (FlagList nil)		; Flags for this mailbox
	    (keywords nil)		; Keyword list
	    (MessageCnt nil)		; Number of messages
	    (RecentCnt nil)		; Number of recent messages
	    (MessageArray nil)		; The message cache
	    (associated-windows nil)	; Windows interested in this stream
	    (read-only-p nil)		; True if a r/o mailbox
	    (selectedmsgs nil)		; Messages selected by seatch etc.
	    (owning-window nil)		; The mcw that owns the stream
	    (search-cache nil)		; The cached search results
	    (associated-filters nil)	; Filters that point to Self
	    (selected-version '(2 0))	; Currently selected version of IMAP
	    (current-line nil)          ; The current line read from the stream.
	    (line-index 0)		; Index into current line.
	    (selected-features nil)     ; Features enabled on this stream.
	    (supported-versions nil)    ; The features supported by the server.
	    (all-bboards nil)           ; A list of all known bboards.
            (all-mailboxes nil)         ; A list of all known mailboxes.
	    (opened-with-filter-p nil)  ; Opened by the user with a
                                        ; "Get <foo> <sequence>" command.
	   )
	   ()
  (:Documentation "A stream that is used to communicate with the imap server.")
  :Initable-Instance-Variables
  :Settable-Instance-Variables
  :Gettable-Instance-Variables
  :Abstract-Flavor
)

;-------------------------------------------------------------------------------

(defflavor imap-stream
  ()
  (Imap-Stream-Mixin)
  (:Documentation "A simple IMAP stream from which we build net imap streams.")
  :Abstract-Flavor
)

(defflavor ip-imap-stream
	   ()
	   (imap-stream ip:ascii-translating-character-stream)
  (:Documentation "An IMAP stream that communicates over TCP/IP.")
)

(defflavor chaos-imap-stream
	   ()
	   (imap-stream chaos:ascii-translating-character-stream)
  (:Documentation "An IMAP stream that communicates over CHAOS.")
)

;-------------------------------------------------------------------------------

(defflavor fake-stream
	   ((stream nil) ;;; The real stream that this fakes.
	    (messages nil) ;;; A list of messages on this stream.
	    (superior nil)
	   )
	   (imap-stream-mixin)
  :Initable-Instance-Variables
  :Settable-Instance-Variables
  :Gettable-Instance-Variables
  (:Documentation "A flavor of IMAP stream that fakes being an IMAP stream
by pointing to Stream.  Messages is a list of strings denoting the messages
we're going to put in the mailbox.
"
  )
)

;-------------------------------------------------------------------------------


(defflavor ip-nntp-stream
	   ((posting-allowed-p nil)
	    (number-of-articles 0)
	    (first-article-number 0)
	    (last-article-number 0)
	    (name-of-group nil)
	    (readable-map nil)
	    (last-check-time nil)
	   )
	   (ip-imap-stream)
  :Initable-Instance-Variables
  :Settable-Instance-Variables
  :Gettable-Instance-Variables
)


;-------------------------------------------------------------------------------


(defflavor multipart-stream
	   ()
	   (Fake-Stream)
)


(defflavor digest-stream
	   ()
	   (multipart-stream)
)
