;;; -*- Mode:Common-Lisp; Package:TV; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.  Where functionality implemented herein replicates
;;; similarly named functionality on Symbolics machines, this code was
;;; developed solely from the interface specification in the documentation
;;; or through guesswork, never by examination of Symbolics source code.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.
;;; **********************************************************************

;;; This software developed by:
;;;	Rich Acuff
;;; at the Stanford University Knowledge Systems Lab in Mar '87.
;;;
;;; This work was supported in part by:
;;;	NIH Grant 5 P41 RR00785-15

;;;  Support of connecting the pressing of an arbitrary key with calling
;;;  an arbitrary function, and, in particular, with selecting
;;;  applications.

;;;----------------------------------------------------------------------

;;; Most of this uses undocumented features, so be careful...

(export '(add-soft-key remove-soft-key add-soft-select-key remove-soft-select-key))

(defun add-soft-key (key function process-options &rest args)
  "Cause FUNCTION to be called via PROCESS-RUN-FUNCTION.
   PROCESS-OPTIONS is the first argument to PROCESS-RUN-FUNCTION unless
   it is :IN-KEYBOARD-PROCESS, in which case FUNCTION is applied to ARGS
   in the Keyboard Process, which is very dangerous.  FUNCTION should
   take KEY as it's first arg, a window as it's second argument (the
   SELECTED-WINDOW when the key was pressed), and then ARGS."
  (check-arg key 'characterp "a character")
  (push (if (eq process-options :in-keyboard-process)
	    (list* key function (copy-list args))
	    (list* key 'run-soft-key
		   function process-options (copy-list args)
	      )
	    )
	kbd-global-asynchronous-characters)
#|
  ;; Patch up the character table if this is a keypad char
  (let ((idx (getf keypad-chars-to-codes key)))
    (when idx
      (setf (aref si:kbd-ti-table 0 idx) key))
    )
|#
  )

(defun remove-soft-key (key function)
  "Undo effects of ADD-SOFT-KEY.  Function must match the function
   called when KEY is pressed, or T to mean any function."
  (check-arg key 'characterp "a character")
  (let ((entry (assoc key kbd-global-asynchronous-characters :test #'char=)))
    (when (or (eq function t)
	      (equal (second entry) function)
	      (and (equal (second entry) 'run-soft-key)
		   (equal (third entry) function)))
      (setf kbd-global-asynchronous-characters
	    (delete entry kbd-global-asynchronous-characters))
#|
      ;; Put the character table back
      (let ((idx (getf keypad-chars-to-codes key)))
	(when idx
	  (setf (aref si:kbd-ti-table 0 idx)
		(aref si:kbd-ti-table 4 idx)))
	)
|#
      )
    )
  )

(defun run-soft-key (key window function process-options &rest args)
  "Run FUNCTION in it's own process with PROCESS-OPTIONS, passing KEY,
   WINDOW, and ARGS as arguments."
  (apply #'process-run-function process-options function key window args)
  )

;;;----------------------------------------------------------------------

;;;  Support pressing single key to select a particular instantiation of
;;;  an application

(defun add-soft-select-key (key window)
  "Make WINDOW be selected whenever KEY is pressed."
  (check-arg key 'characterp "a character")
  (when (typep window 'sheet)
    (add-soft-key key 'soft-select-asynch-char
		  `(:name ,(string-append "Select " (send window :name))
			  :priority 10.)
		  window)
    )
  )

(defun remove-soft-select-key (key)
  "Make KEY be a normal key again if it was a soft select for some
   window before."
  (check-arg key 'characterp "a character")
  (remove-soft-key key 'soft-select-asynch-char)
  )

(defun soft-select-asynch-char (char ignore-w window)
  "Select WINDOW.  Ignore CHAR and IGNORE-W."
  (declare (ignore char ignore-w))
  (when (typep window 'tv:sheet)
    (send window :mouse-select nil)
    (setf kbd-terminal-time nil)
    )
  )

;;;----------------------------------------------------------------------

;;; <Term> key based interface to Soft Select Keys

(defun term-hack-soft-keys (arg)
  (let (ch)
    (let-globally ((who-line-process current-process))
      (who-line-run-state-update)
      (setq ch (kbd-get-software-char "Soft Key"))
      )
    (if arg
	(remove-soft-select-key ch)
	(add-soft-select-key ch selected-window)
	)
    )
  )

(add-terminal-key #\k #'term-hack-soft-keys
  ''(
  "Make the next key pressed select the currently selected window from now on."
  "   Arg means remove any such association from the next key pressed.")
  :KEYBOARD-PROCESS)

(provide 'soft-keys)
