#-*- Mode:Text; Tab-width:4 -*-
# Makefile for flashcards

# Identifiers needed by the microexp:macsys: defsystem.
maclispm = "hd:microexp:macsys:"
flashcards = "hd:demos:flashcards:"
addin-comm= "{maclispm}addin-comm:"
rpc      = "{maclispm}rpc:"
bsd      = "{maclispm}bsd:"
sock     = "{maclispm}sock:"
utility  = "{maclispm}utility:"
nupi     = "{maclispm}nupi:"
driver   = "{maclispm}driver:"
window	 = "{maclispm}window:"
libs     = "{maclispm}libs:"

# define compiler defaults to be set into ?Options:
CFlags   = '-mc68020 -d MAC -g'
PFlags   = -mc68020
AFlags	 = '-case on'

flashcards-includes = -i {libs} -i {driver} -i {cincludes} -i {nupi} -i {rpc} 
		       -i {utility} -i {bsd} -i {maclispm} -i {sock} -i {bsd}sys:

SysLibs =   "{Libraries}"Interface.o 
			"{PLibraries}"Paslib.o 
			"{CLibraries}"CInterface.o 
			"{CLibraries}"CRuntime.o 
			"{CLibraries}"StdCLib.o 
			"{CLibraries}"CSANELib.o

MacObj =    {bsd}bsd.o   
			{sock}sock.o 
			{rpc}rpc.o   
			{flashcards}flashcards.c.o   
			{nupi}nupi.o 
		    {driver}micronet-accessors.c.o 
			{utility}utility.o

Subsystems = 	bsd  
				sock 
				nupi 
				{flashcards}flashcards.c.o  
				utility  
		        {driver}micronet-accessors.c.o 
				rpc 

flashcards  flashcards.r
	Rez flashcards.r -o flashcards -a
	SetFile -a B flashcards -c PSMP -t APPL		# set the bundle bit

flashcards  {Subsystems}
	Directory {flashcards}
	link {MacObj} {sysLibs} -c PSMP -t APPL -o flashcards -bf #-sg MAIN -ss 128000
	SetFile -a B flashcards

bsd							
 set maclispm	{maclispm}
 set addin-comm {addin-comm}
 set rpc		{rpc}
 set bsd		{bsd}
 set sock		{sock}
 set flashcards	{flashcards}
 set utility	{utility}
 set nupi		{nupi}
 set driver		{driver}
 set window		{window}
 set libs		{libs}
 set CFlags		{CFlags}
 set PFlags		{PFlags}
 set AFlags		{AFlags}
 Export -s maclispm addin-comm rpc bsd sock flashcards utility nupi driver window libs CFlags PFlags AFlags
	Directory {bsd}
	make bsd.o > bsd.makefile
	bsd.makefile
	
nupi						
	Directory {nupi}
	make nupi.o > nupi.makefile
	nupi.makefile

sock						
	Directory {sock}
	make sock.o > sock.makefile
	sock.makefile

rpc							
	Directory {rpc}
	make rpc.o > rpc.makefile
	rpc.makefile

utility						
	Directory {utility}
	make utility.o > utility.makefile
	utility.makefile


{driver}Micronet-Accessors.c.o  {driver}Micronet-Accessors.c {driver}Micronet-Accessors.h
	C {driver}Micronet-Accessors.c {CFlags} -z127 {flashcards-Includes} 

{flashcards}flashcards.c.o  {flashcards}flashcards.c
	c {flashcards}flashcards.c {CFlags} -z127 {flashcards-includes}  


# ***END OF FILE ***
