;;; -*- Mode:Common-Lisp; Package:W; Fonts:(COURIER HL12B HL12BI); Base:10; Patch-file:T -*-

;1;;                           RESTRICTED RIGHTS LEGEND*

;1;;Use, duplication, or disclosure by the Government is subject to*
;1;;restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;;Technical Data and Computer Software clause at 52.227-7013.*
;1;;*
;1;;                     TEXAS INSTRUMENTS INCORPORATED.*
;1;;                              P.O. BOX 2909*
;1;;                           AUSTIN, TEXAS 78769*
;1;;                                 MS 2151*
;1;;*
;1;; Copyright (C) 1986,1987 Texas Instruments Incorporated. All rights reserved.*

;1;; Patch file version of Macintosh scrolling. Can be loaded overtop current tv:scroll-bar-mixin stuff*
;1;; then all windows made subsequently will scroll like the Mac. May destroy scrolling on old windows.*
(unless (find-package "MAC") (defpackage "MAC"))

(unless (and (fboundp 'sys:mx-p) (sys:mx-p))
   
   
   (DEFMACRO mac-window? (window)
     2"Returns t iff the window is a window on the Macintosh."*
     `(WHEN (FBOUNDP 'mac:mac-window-p)
	(mac:mac-window-p ,window)))
   
   ;1;; Recommended Mac configuration*
   (SETF tv:*scroll-bar-default-mode* :maximum)
   (SETF tv:*scroll-bar-shade* tv:25%-gray)
   (SETF tv:*scroll-bar-default-icon-width* 13.)	   ;1Minimum practical is 7. Should be odd. *
   (SETF tv:*scroll-bar-default-icon-height* 13.)	   ;1Minimum practical is 9.*
   (SETF tv:*scroll-bar-default-lines* 1.)
   
   (DEFPARAMETER *scroll-bar-top-icon-documentation*
		 `(:MOUSE-L-1     "Line up,  "
		   :MOUSE-M-1     "25% Page up,  "
		   :MOUSE-R-1     "50% Page up.                "
		   :MOUSE-L-2     ", "
		   :MOUSE-M-2     ", "
		   :MOUSE-R-2     "Top of form."
		   :no-comma      "  "
		   :documentation "                 HOLD: Continuous.")
     "2Who line documentation string used when mouse is in the top icon of scroll region.*")
   
   (DEFPARAMETER *scroll-bar-upper-box-documentation*
		 `(:MOUSE-L-1     "Page up,   "
		   :MOUSE-M-1     "25% page up,    "
		   :MOUSE-R-1     "50% page up;          " 
		   :MOUSE-l-2     ", "
		   :MOUSE-m-2     "To fraction of form.         "
		   :MOUSE-r-2     "Top line to here."
		   :no-comma      "  "
		   :documentation "                 HOLD: Continuous.")
      "2Who line documentation string used when mouse is above the scroll bar but in the scroll box.*")
   
   (DEFPARAMETER *scroll-bar-documentation*
		 `(:MOUSE-L-HOLD  "Drag scroll bar,  "
		   :MOUSE-m-HOLD  "Drag lines,  "
		   :MOUSE-R-HOLD  "Drag lines.            "
   
		   :MOUSE-l-2     ", "
		   :MOUSE-m-2     "To fraction of form.           "
		   :MOUSE-r-2     "Top line to here." 
		   :no-comma      "  ")
      "2Who line documentation string used when mouse is in the scroll bar.*")
   
   (DEFPARAMETER *scroll-bar-lower-box-documentation*
		 `(:MOUSE-L-1     "Page down,   "
		   :MOUSE-M-1     "25% page down,    "
		   :MOUSE-R-1     "50% page down;          " 
		   :MOUSE-l-2     ", "
		   :MOUSE-m-2     "To fraction of form.         "
		   :MOUSE-r-2     "Top line to here."
		   :no-comma      "  "
		   :documentation "                 HOLD: Continuous.")
      "2Who line documentation string used when mouse is below the scroll bar but in the scroll box.*")
   
   (DEFPARAMETER *scroll-bar-bottom-icon-documentation*
		 `(:MOUSE-L-1     "Line down,  "
		   :MOUSE-M-1     "25% Page down,  "
		   :MOUSE-R-1     "50% Page down.                "
		   :MOUSE-L-2     ", "
		   :MOUSE-M-2     ", "
		   :MOUSE-R-2     "Bottom of form."
		   :no-comma      "  "
		   :documentation "                 HOLD: Continuous.")
     "2Who line documentation string used when mouse is in the bottom icon of scroll region.*")
   
   (defmethod (scroll-bar-mixin :around :who-line-documentation-string) (cont mt ignore)
     1"If in the scroll-bar, use scroll-bar documentation, else use default documentation."*
     (if scroll-bar-draw-state
	 (CASE scroll-bar-draw-state
	   (:top-icon *scroll-bar-top-icon-documentation*)
	   (:upper-box *scroll-bar-upper-box-documentation*)
	   (:bar *scroll-bar-documentation*)
	   (:lower-box *scroll-bar-lower-box-documentation*)
	   (:bottom-icon *scroll-bar-bottom-icon-documentation*)
	   (:otherwise (funcall-with-mapping-table cont mt :who-line-documentation-string)))
       (funcall-with-mapping-table cont mt :who-line-documentation-string)))
   
   
   
   (DEFMACRO draw-shaded-rectangle (width height x y alu window pattern-or-nil)
     "2Draws a rectangle shaded with pattern.*"
     `(LET ((right (+ ,x ,width -1.))
	    (bottom (+ ,y ,height -1.)))
	(sys:%draw-shaded-triangle ,x bottom ,x ,y right ,y 
				   ,alu t t t ,pattern-or-nil ,window)
	(sys:%draw-shaded-triangle ,x bottom right ,y right bottom 
				   ,alu t t t ,pattern-or-nil ,window)))
   
   (DEFMACRO draw-hollow-rectangle (width height x y border alu window)
     "2Draws a hollow rectangle with a border of thickness 'border' pixels.*"
     `(LET ((right (+ ,x ,width (- ,border)))
	    (bottom (+ ,y ,height (- ,border))))
	(sys:%draw-rectangle ,border (1- ,height) ,x ,y ,alu ,window)	   ;1left edge*
	(sys:%draw-rectangle (1- ,width) ,border (1+ ,x) ,y ,alu ,window)	   ;1top edge*
	(sys:%draw-rectangle (1- ,width) ,border ,x bottom ,alu ,window)  ;1bottom edge*
	(sys:%draw-rectangle ,border (1- ,height) right (1+ ,y) ,alu ,window)))  ;1right edge*
   
   
   (DEFCONSTANT *scroll-region-border* 1.
     "2The width of the border around the scroll bar region.*")
   
   (DEFUN scroll-bar-area-width (window)
   1"Return the width for the scroll bar*
    1region when scroll-bar-mode, else nil."*
     (LET ((w (SEND window :scroll-bar-icon-width)))
       (IF (AND (> w 0)
		(SEND window :scroll-bar-mode))
	   (+ w *scroll-region-border* *scroll-region-border*)
	   0)))
   
   
   ;;; Don't want this to happen yet- labels haven't been defined!
   (DEFMETHOD (scroll-bar-mixin :around :compute-border-margin-area-margins)
	      (cont mt ignore spec lm tm rm bm)
     "Wrap around this method to allocate space for the scroll-bar 
    between the border and the border margin area."
   #|
     (let ((side (scroll-bar-region-side scroll-bar-region)) ; set up at init
	   (region-width (if (send self :scroll-bar-on?)
			     (scroll-bar-area-width self)
			     0))
	   (left lm)
	   (right (- rm)))
       ; Unfortunately HEIGHT and WIDTH are not available now
       ; so when the region is on the right, LEFT and RIGHT are
       ; negative to indicate that they still need to be subtracted 
       ; from WIDTH.  BOTTOM is always negative.
       (if (eq side :left)
	   (setq lm (+ lm region-width)
		 right (1- lm))
	   (setq rm (+ rm region-width)
		 left (- rm)))
       (setq scroll-bar-region (list side region-width left tm right (- bm)))
   |#
   
      (FUNCALL-WITH-MAPPING-TABLE cont mt
				:compute-border-margin-area-margins
				   spec lm tm rm bm))
   
   (DEFMETHOD (scroll-bar-mixin :compute-margins) (lm tm rm bm)
     (LET ((side (scroll-bar-region-side scroll-bar-region))  ; 1Set up at init*
	   (region-width (if (send self :scroll-bar-on?)
			     (scroll-bar-area-width self)
			     0))
	   (left lm)
	   (right (- rm)))
       ;; Unfortunately HEIGHT and WIDTH are not available now
       ;; so when the region is on the right, LEFT and RIGHT are
       ;; negative to indicate that they still need to be subtracted 
       ;; from WIDTH.  BOTTOM is always negative.
       (IF (ZEROP region-width)
	   (SETF (scroll-bar-region-left scroll-bar-region) left
		 (scroll-bar-region-right scroll-bar-region) right
		 (scroll-bar-region-width scroll-bar-region) region-width) 
	 (IF (EQ side :left)
	     (SETQ lm (+ lm region-width (- (MIN *scroll-region-border* lm)))
		   right lm
		   left (- right region-width))
	   (SETQ rm (+ rm region-width (- (MIN *scroll-region-border* rm)))
		 left (- rm)
		 right (+ left region-width)))
	 (SETF (scroll-bar-region-left scroll-bar-region) left
	       (scroll-bar-region-right scroll-bar-region) right
	       (scroll-bar-region-width scroll-bar-region) region-width))
       (VALUES lm tm rm bm)))
   
   ;1;; The scroll region is the complete area taken up by scrolling. Includes the border, icons, box, and bar.*
   ;1;; The scroll region always extends from the top margin to the bottom margin of the window.*
   ;1;; The scroll bar is the small box representing the current scroll position. The Mac refers to it as the thumb.*
   ;1;; The scroll box is the area the scroll bar travels in. It is divided into an upper and lower box by the scroll bar.*
   
   (DEFSTRUCT (scroll-bar-region (:type :list))
     (side :left :type keyword)		   ;1:left or :right*
     (width 0 :type fixnum)		   ;1width of scroll-bar-region*
     (left 0 :type fixnum)			   ;1left margin including scroll-bar, negative if scroll bar is on the right*
     (top 0 :type fixnum)			   ;1top margin - set same as window top margin*
     (right 0 :type fixnum)		   ;1right margin including scroll-bar, always negative*
     (bottom 0 :type fixnum)		   ;1bottom margin - set same as window margin but negative*
     ;1; Remainder are new variables added for Mac type scrolling. They are included*
     ;1; in the defstruct so that they can be computed once then used by all the drawing*
     ;1; routines rather than recalculated each time. This way is faster and all scroll bar drawers agree*
     ;1; on the scroll region parameters.*
     (valid-p nil :type symbol)		   ;1non-Nil if region parameters have been calculated*
     (height 0 :type fixnum)		   ;1scroll region height*
     (left-edge 0 :type fixnum)		   ;1y position of the left edge of the scroll region with respect to the window*
     (icon-box-height 0 :type fixnum)	   ;1height of box containing the arrow icons*
     (bar-width 0 :type fixnum)		   ;1width of the scroll bar and box*
     (bar-height 0 :type fixnum)		   ;1height of the scroll bar including it's border*
     (bar-left 0 :type fixnum)		   ;1x position of the scroll bar and box relative to the window*
     (bar-top 0 :type fixnum)		   ;1current y position of the scroll bar relative to the window* 
     (box-height 0 :type fixnum)		   ;1height of the scroll box*
     (box-top 0 :type fixnum)		   ;1y position of the scroll box top relative to the window*
     (box-bottom 0 :type fixnum)		   ;1y position of the scroll box bottom relative to the window*
     (bar-range 0 :type fixnum)		   ;1range over which the scroll bar can move (0 to ...)*
     )
   
   (DEFMETHOD (scroll-bar-mixin :before :init) (init-plist)
     (SETF scroll-bar-region (make-scroll-bar-region
			       :side (or (get init-plist :scroll-bar-side)
					 *scroll-bar-default-side*))))
   
   (DEFMETHOD (scroll-bar-mixin :after :change-of-size-or-margins)
	      (&rest ignore)
     (IF scroll-bar-on-off
	 (UNLESS scroll-bar-making-decision
	   (SEND self :decide-if-scrolling-necessary))
       (SETF (scroll-bar-region-valid-p scroll-bar-region) nil)))
   
   (DEFMETHOD (scroll-bar-mixin :decide-if-scrolling-necessary) ()
     1"Turn the scroll-bar regions on or off for scroll-bar-on-off windows.*
    1This method should be called after changing the number of displayable*
    1items, but before doing the redisplay.  This can change the inside size*
    1of the window unless :ADJUSTABLE-SIZE-P has been defined and returns *
    1t.  In that case the outside size should be set before entering this method."*
     (WHEN scroll-bar-on-off
       (bind (LOCATE-IN-INSTANCE self 'scroll-bar-making-decision) t)
       (LET ((iw (sheet-inside-width)) (ih (sheet-inside-height)) (changep nil)
	     scroll-now)
	 ;; When we ask whether everything fits, pretend there are no scroll regions.
	 (LET ()
	   (bind (LOCATE-IN-INSTANCE self 'scroll-bar-on-off) :off)
	   (MULTIPLE-VALUE-BIND (left nil right nil)
	       (SEND self :compute-margins 0 0 0 0)
	     (bind (LOCF left-margin-size) left)
	     (bind (LOCF right-margin-size) right)
	     (SETQ scroll-now (SEND self :enable-scrolling-p))))
	 ;; Now SCROLL-NOW says whether we must now have scrolling.
	 (MULTIPLE-VALUE-BIND (IGNORE n-lines1 * ignore n-screen-lines)
	       (SEND self :scroll-position)	
	 (IF (AND scroll-now (>  n-lines  n-screen-lines))
	     (SETQ scroll-now :on)
	     (SETQ scroll-now :off))
	 (WHEN (NEQ scroll-now scroll-bar-on-off)
	   (SETQ scroll-bar-on-off scroll-now
		 changep t))
	 (SEND self :redefine-margins)
	 (AND changep
	      (SEND self :send-if-handles :adjustable-size-p)
	      (SEND self :set-inside-size iw ih)))))
     (SETF (scroll-bar-region-valid-p scroll-bar-region) nil))
   
   (DEFVAR *scroll-bar-default-height* 16
     "2Default height of the scroll bar*")
   
   (DEFMETHOD (scroll-bar-mixin :compute-region) ()
     ;1; Width and Height are sheet instance variables*
     ;1; Scroll-bar-region-side and scroll-bar-region-width are set at init from global variable defaults.*
     ;1; Scroll-bar-region-left and -right are set by the :compute-margins mixin.*
     ;1; Scroll-bar-region-bar-top is set and maintained by the :scroll-bar-update mixin.*
     (SETF (scroll-bar-region-top scroll-bar-region)
	   (MAX 0 (- (w:sheet-top-margin-size self) *scroll-region-border* 1)))
     (SETF (scroll-bar-region-bottom scroll-bar-region)
	   (- (MAX 0 (- (w:sheet-bottom-margin-size self) *scroll-region-border* 1))))
     (SETF (scroll-bar-region-height scroll-bar-region)
	   (+ height
	      (- (scroll-bar-region-top scroll-bar-region))
	      (scroll-bar-region-bottom scroll-bar-region)))
     (SETF (scroll-bar-region-left-edge scroll-bar-region)
	   (+ (scroll-bar-region-left scroll-bar-region)
	      (IF (EQ :left (scroll-bar-region-side scroll-bar-region)) 0 width)))
     (SETF (scroll-bar-region-icon-box-height scroll-bar-region)
	   (MIN (SEND self :scroll-bar-icon-height)   ;1If not enough room*
		(ASH (- (scroll-bar-region-height scroll-bar-region)
			(* 4 *scroll-region-border*))
		     -2)))
     (SETF (scroll-bar-region-bar-width scroll-bar-region)
	   (- (scroll-bar-region-width scroll-bar-region) (* 2 *scroll-region-border*)))
     (SETF (scroll-bar-region-bar-left scroll-bar-region)
	   (+ (scroll-bar-region-left-edge scroll-bar-region) *scroll-region-border*))
     (SETF (scroll-bar-region-box-height scroll-bar-region)
	   (MAX 0 (- (scroll-bar-region-height scroll-bar-region)
		     (* 2 (scroll-bar-region-icon-box-height scroll-bar-region))
		     (* 4 *scroll-region-border*))))
     (SETF (scroll-bar-region-bar-height scroll-bar-region)
	   (MIN *scroll-bar-default-height*   ;1If enough room for full size bar*
		(ASH (scroll-bar-region-box-height scroll-bar-region) -1)))   ;1If not enough room for full size bar*
     (SETF (scroll-bar-region-box-top scroll-bar-region)
	   (+ (scroll-bar-region-top scroll-bar-region)
	      (scroll-bar-region-icon-box-height scroll-bar-region)
	      (* 2 *scroll-region-border*)))
     (SETF (scroll-bar-region-box-bottom scroll-bar-region)
	   (+ height
	      (scroll-bar-region-bottom scroll-bar-region)
	      (- (scroll-bar-region-icon-box-height scroll-bar-region))
	      (- (* 2 *scroll-region-border*))))
     (SETF (scroll-bar-region-bar-range scroll-bar-region)
	   (- (scroll-bar-region-box-height scroll-bar-region)
	      (scroll-bar-region-bar-height scroll-bar-region)))
     ;1; Okay everything should be set up now*
     (SETF (scroll-bar-region-valid-p scroll-bar-region) t))
   
	 
   (DEFMETHOD (scroll-bar-mixin :scroll-bar-manage-drawing)
	      (&optional refresh)
     1"Draw or undraw as necessary the scroll-bar and icons depending upon *
    1SCOLL-BAR-ACTIVE-STATE, the current display mode, SCROLL-BAR-DRAW-STATE, and REFRESH."*
     (WHEN (AND scroll-bar-mode
		(ZEROP (sheet-output-hold-flag self)))
       (WITHOUT-INTERRUPTS
	 (IF (NOT (sheet-can-get-lock self))
	     ;;There is this funny case where the sheet could be locked by the person waiting
	     ;; for us to back out.  For us to block here would be a disaster, so undraw the
	     ;; scroll bar in another process
	     (PROCESS-RUN-FUNCTION
	       "Draw Scroll Bar"
	       #'(lambda (self refresh)
		   (SEND self :scroll-bar-manage-drawing refresh))
	       self refresh)
	   ;1; else...*
	   (SEND self :scroll-bar-update refresh)))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-bar-update) (&optional refresh)
     "2If the scroll-bar-region-bar-top is different than the new scroll position then this*
   2draws the scroll box and bar at the new scroll position.*"
     (UNLESS (scroll-bar-region-valid-p scroll-bar-region)
       (SEND self :compute-region)
       (SETF refresh t))
     (WHEN refresh
       (SEND self :scroll-bar-draw-region)
       (SEND self :scroll-bar-draw-icon :point-up t :solid nil)
       (SEND self :scroll-bar-draw-icon :point-up nil :solid nil))    
     (MULTIPLE-VALUE-BIND (top-line n-lines ignore n-screen-lines)
	 (SEND self :scroll-position)
       (LET ((current-bar-top (scroll-bar-region-bar-top scroll-bar-region))
	     (new-bar-top (WHEN (OR (PLUSP top-line)
				    (> n-lines n-screen-lines))
			    (+ (scroll-bar-region-box-top scroll-bar-region)
			       (IF (>= (+ top-line n-screen-lines) n-lines)
				   ;1;...THEN special case bottom line visible - force bar to bottom*
				   (scroll-bar-region-bar-range scroll-bar-region)
				 ;1;...ELSE proportionally position the bar*
				 (TRUNCATE (* (scroll-bar-region-bar-range scroll-bar-region)
					      top-line)
					   n-lines))))))
	 (WHEN (OR refresh (NOT (EQL new-bar-top current-bar-top)))
	   (SEND self :scroll-bar-draw-box-and-bar new-bar-top)
	   (SETF (scroll-bar-region-bar-top scroll-bar-region) new-bar-top)))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-bar-draw-box-and-bar)
	      (bar-top)
     "2Draws the scroll box and bar. If bar-top is NIL the scroll box is cleared.*"
     (LET ((box-left (scroll-bar-region-bar-left scroll-bar-region))
	   (box-top (scroll-bar-region-box-top scroll-bar-region))
	   (box-height (scroll-bar-region-box-height scroll-bar-region))
	   (bar-width (scroll-bar-region-bar-width scroll-bar-region))
	   (bar-height (scroll-bar-region-bar-height scroll-bar-region)))
       (PREPARE-SHEET (self)
	 (IF bar-top
	     ;1; THEN...Draw the scroll-bar and box.*
	     ;1; Clear a spot for the scroll bar*
	     (LET* ((mac-adjust (IF (mac-window? self) 1 0))  ;1Why???*
		    (upper-box-height (- bar-top box-top (- mac-adjust)))
		    (bar-bottom (+ bar-top bar-height))
		    (lower-box-height (- box-height
					 (- bar-bottom box-top) (- mac-adjust)))) 
	       (sys:%draw-rectangle bar-width bar-height
				    box-left bar-top
				    alu-setz self)
	       ;1; Draw line around the bar*
	       (draw-hollow-rectangle bar-width bar-height 
				      box-left bar-top
				      1 alu-seta self)
	       ;1; Shade the scroll box*
	       (WHEN (PLUSP upper-box-height)
		 (draw-shaded-rectangle (+ bar-width mac-adjust) upper-box-height
					box-left box-top
					alu-seta self *scroll-bar-shade*))
	       (WHEN (PLUSP lower-box-height)
		 (draw-shaded-rectangle (+ bar-width mac-adjust) lower-box-height
					box-left bar-bottom
					alu-seta self *scroll-bar-shade*)))
	   ;1; ELSE... just clear the scroll-box*
	   (sys:%draw-rectangle bar-width box-height
				box-left box-top
				alu-setz self)))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-bar-draw-region) ()
     "2Draws the scroll bar region and outlines it.*"
     (LET* ((region-width (scroll-bar-region-width scroll-bar-region)) 
	    (region-left (scroll-bar-region-left-edge scroll-bar-region))
	    (region-top (scroll-bar-region-top scroll-bar-region))
	    (region-height (scroll-bar-region-height scroll-bar-region))
	    (icon-box-height (scroll-bar-region-icon-box-height scroll-bar-region))
	    (icon-box-width (scroll-bar-region-bar-width scroll-bar-region))
	    (icon-box-left (scroll-bar-region-bar-left scroll-bar-region))
	    (top-icon-top (+ region-top *scroll-region-border*)) 
	    (top-icon-bottom (+ region-top
				(scroll-bar-region-icon-box-height scroll-bar-region)
				*scroll-region-border*))
	    (bottom-icon-top (scroll-bar-region-box-bottom scroll-bar-region)))
       (PREPARE-SHEET (self)
	 (PROGN
	   (sys:%draw-rectangle icon-box-width icon-box-height	   ;1Clear spot for top icon*
				icon-box-left top-icon-top
				alu-setz self)
	   (sys:%draw-rectangle icon-box-width icon-box-height	   ;1Clear spot for bottom icon*
				icon-box-left (+ bottom-icon-top *scroll-region-border*)
				alu-setz self)
	   (draw-hollow-rectangle region-width region-height  ;1border it*
				  region-left region-top
				  *scroll-region-border*
				  alu-seta self)
	   (sys:%draw-rectangle region-width *scroll-region-border*   ;1top icon box*
				region-left top-icon-bottom
				alu-seta self)
	   (sys:%draw-rectangle region-width *scroll-region-border*   ;1bottom icon box*
				region-left bottom-icon-top
				alu-seta self)))))	   ;1bottom icon box*
   
   
   (DEFCONSTANT *hollow-arrow* (LIST #x00000020 #x00000050 #x00000088 #x00000104
				     #x00000202 #x0000078F #x00000088 #x00000088
				     #x00000088 #x00000088 #x000000F8)
     "2Bit image for an 11x11 hollow up-arrow scroll-bar icon.*")
   
   (DEFCONSTANT *solid-arrow* (LIST #x00000020 #x00000070 #x000000F8 #x000001FC
				    #x000003FE #x000007FF #x000000F8 #x000000F8
				    #x000000F8 #x000000F8 #x000000F8)
     "2Bit map for an 11x11 filled in up-arrow scroll-bar icon.*")
   
   (DEFPARAMETER *scroll-bar-hollow-up-arrow*
		 (MAKE-ARRAY 11 :element-type '(unsigned-byte 32)
			     :initial-contents *hollow-arrow*
			     :leader-length 4.
			     :leader-list '(nil 6. 11. 11.)))	   ;1(nil arrow-point-x-offset arrow-width arrow-height)*
   (DEFPARAMETER *scroll-bar-hollow-down-arrow*
		 (MAKE-ARRAY 11 :element-type '(unsigned-byte 32)
			     :initial-contents (REVERSE *hollow-arrow*)
			     :leader-length 4.
			     :leader-list '(nil 6. 11. 11.)))
   (DEFPARAMETER *scroll-bar-solid-up-arrow*
		 (MAKE-ARRAY 11 :element-type '(unsigned-byte 32)
			     :initial-contents *solid-arrow*
			     :leader-length 4.
			     :leader-list '(nil 6. 11. 11.)))
   (DEFPARAMETER *scroll-bar-solid-down-arrow*
		 (MAKE-ARRAY 11 :element-type '(unsigned-byte 32)
			     :initial-contents (REVERSE *solid-arrow*)
			     :leader-length 4.
			     :leader-list '(nil 6. 11. 11.)))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-bar-draw-icon)
	      (&optional &key (point-up t) (solid nil))
     1"Draw the up or down arrow scroll-bar icon.2 *Almost no error checking is done."*
     (LET* ((region-width (scroll-bar-region-width scroll-bar-region))
	    (icon-height (scroll-bar-region-icon-box-height scroll-bar-region))
	    (icon-box-left (scroll-bar-region-bar-left scroll-bar-region))
	    (icon-box-top (IF point-up
			      (+ (scroll-bar-region-top scroll-bar-region) *scroll-region-border*)
			    (+ height
			       (scroll-bar-region-bottom scroll-bar-region)
			       (- icon-height)
			       (- *scroll-region-border*))))
	    (arrow (IF solid
		       (IF point-up
			   *scroll-bar-solid-up-arrow*
			 *scroll-bar-solid-down-arrow*)
		     (IF point-up
			 *scroll-bar-hollow-up-arrow*
		       *scroll-bar-hollow-down-arrow*)))
	    (arrow-offset (ARRAY-LEADER arrow 1.))
	    (arrow-width (ARRAY-LEADER arrow 2.))
	    (arrow-height (ARRAY-LEADER arrow 3.))
	    (icon (MAKE-ARRAY `(,arrow-height 32.)
			      :element-type 'bit
			      :displaced-to arrow)) 
	    (x-adjust (- (TRUNCATE region-width 2.)
			 arrow-offset))
	    (y-adjust (IF point-up
			  (FLOOR (MAX 0 (- icon-height arrow-height)) 2.)
			(IF (< icon-height arrow-height)
			    (- icon-height arrow-height)	   ;1make it negative*
			  (CEILING (- icon-height arrow-height) 2.))))
	    (window-array (SEND self :screen-array))
	    (wd (MIN (- region-width (* 2 *scroll-region-border*)) 
		     arrow-width
		     (- (ARRAY-DIMENSION window-array 1) icon-box-left 3.)))	   ;1safety*
	    (ht (MIN arrow-height
		     icon-height
		     (- (ARRAY-DIMENSION window-array 0) (+ icon-box-top y-adjust) 1.)))) 
       (COND ((AND (>= x-adjust 0) (>= y-adjust 0))   ;1normal case, icon fits okay*
	      (BITBLT alu-seta
		      wd ht
		      icon
		      0 0
		      window-array
		      (+ icon-box-left x-adjust) (+ icon-box-top y-adjust)))
	     ((AND (MINUSP x-adjust) (>= y-adjust 0)) ;1doesn't fit widthwise*
	      (BITBLT alu-seta
		      wd ht
		      icon
		      (- x-adjust) 0
		      window-array
		      icon-box-left (+ icon-box-top y-adjust)))
	     ((AND (>= x-adjust 0) (MINUSP y-adjust)) ;1doesn't fit heightwise*
	      (BITBLT alu-seta
		      wd ht
		      icon
		      0 (- y-adjust)
		      window-array
		      (+ icon-box-left x-adjust) icon-box-top)) 
	     (t				   ;1doesn't fit either way*
	      (BITBLT alu-seta
		      wd ht
		      icon
		      (- x-adjust) (- y-adjust)
		      window-array 
		      icon-box-left icon-box-top)))))
   
   ;1;; Turn off grabbing the mouse - it's not nice.*
   (defmethod (scroll-bar-mixin :handle-mouse-scroll) ()
     ;1; Mac scrolling does not grap the mouse or support bump scrolling*
     (mouse-default-handler self))		   ;1Dont tell mouse-handler we are :in scroll bar* 
   
   (DEFVAR *scroll-bar-mouse-blinker* (LIST mouse-glyph-north-west-arrow 0 0) 
     "2Variable holding mouse blinker and offset being used while mouse is in the scroll region.*")
   (DEFVAR *scroll-bar-previous-mouse-blinker* (LIST mouse-glyph-north-west-arrow 0 0) 
     "2Variable holding mouse blinker and offset in effect when scroll region was entered.*")
   
   ;1;; Turn off bumping - it's not Macish.*
   (DEFMETHOD (scroll-bar-mixin :around :mouse-moves) (cont mt ignore x y)
     "2Change the mouse cursor when entering or leaving the scroll-bar area.*
    2Also implement bump scrolling at top and bottom of scroll-bar.*"
     (IF (AND (scroll-bar-region-bar-top scroll-bar-region)	   ;1If scrolling necessary*
	      (scroll-bar-region-valid-p scroll-bar-region))
	 ;1;...THEN see if mouse is in scroll region*
	 (IF (IF (EQ (scroll-bar-region-side scroll-bar-region) :left)
		 (< x (+ (scroll-bar-region-bar-left scroll-bar-region)
			 (scroll-bar-region-bar-width scroll-bar-region)))
	       (> x (scroll-bar-region-bar-left scroll-bar-region)))
	     ;;1...THEN mouse is in scroll region.*
	     (PROGN 
	       (IF scroll-bar-draw-state
		   ;1; Then mouse was in scroll region last time*
		   (SETF scroll-bar-draw-state (SEND self :where-is-mouse? y))
		 ;1; Else mouse is entering the scroll region*
		 (WHEN (SETF scroll-bar-draw-state (SEND self :where-is-mouse? y))	
		   (SETF *scroll-bar-previous-mouse-blinker*
			 (CONS (SEND mouse-blinker :character)
			       (MULTIPLE-VALUE-LIST (SEND mouse-blinker :offsets))))))
	       (UNLESS (= (FIRST *scroll-bar-mouse-blinker*)
			  (SEND w:mouse-blinker :character)) 
		 (mouse-set-blinker-definition
		   :character
		   (SECOND *scroll-bar-mouse-blinker*) (THIRD *scroll-bar-mouse-blinker*)
		   :on
		   :set-character (FIRST *scroll-bar-mouse-blinker*))))
	   ;;1...ELSE mouse is not in scroll region.*
	   (IF scroll-bar-draw-state	   ;1 leaving scroll region*
	       (PROGN (mouse-set-blinker-definition
			:character
			(SECOND *scroll-bar-previous-mouse-blinker*)
			(THIRD *scroll-bar-previous-mouse-blinker*)
			:on
			:set-character (CAR *scroll-bar-previous-mouse-blinker*))
		      (SETF scroll-bar-draw-state nil)) 
	     (FUNCALL-WITH-MAPPING-TABLE cont mt :mouse-moves x y)))
       ;1;...ELSE normal mouse tracking*
       (FUNCALL-WITH-MAPPING-TABLE cont mt :mouse-moves x y)))
   
   ;1;; Redefine mouse scrolling button action*
   (defparameter *scroll-bar-default-clicks*
		 '(#\mouse-l :scroll-left-button
		   #\mouse-l-2 :scroll-left-button-2
		   #\mouse-m :scroll-middle-button
		   #\mouse-m-2 :scroll-middle-button-2
		   #\mouse-r :scroll-right-button
		   #\mouse-r-2 :scroll-right-button-2)
     1"The methods to call for mouse-clicks when the scroll-bar is active."*)
   
   (DEFWRAPPER (scroll-bar-mixin :mouse-click) ((button x y) . body)
     1"If in scroll-bar do scroll-bar mouse-click else do default mouse-click."*
     `(if scroll-bar-draw-state
	  (let ((method (getf *scroll-bar-default-clicks* button))) 
	    (if method
		(send self method x y button)
		(beep)))
	 . ,body))
   
   (DEFMETHOD (scroll-bar-mixin :mouse-buttons) (bd x y)
     1"Redefine :mouse-buttons to map mouse-click R2 to the scroll-bar when scroll-bar is active."*
     (let ((buttons (mouse-character-button-encode bd)))
       (if (and (= buttons #\mouse-r-2)
		(not scroll-bar-draw-state))
	   (mouse-call-system-menu)
	   (send self :mouse-click buttons x y))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-left-button) (ignore y &rest ignore)
     "2This dispatches to the appropriate action when the left button is pushed*
   2depending on the position of the mouse within the scroll region.*"
     (LET ((index sys:mouse-buttons-buffer-in-index))
       (multiple-value-bind (ignore ignore ignore lines-per-page)
	   (send self :scroll-position) 
	 (CASE scroll-bar-draw-state 
	   (:top-icon (SEND self :scroll-lines index (- *scroll-bar-default-lines*)))
	   (:upper-box (SEND self :scroll-lines index (- lines-per-page)))
	   (:bar (SEND self :scroll-drag index y))
	   (:lower-box (SEND self :scroll-lines index lines-per-page))
	   (:bottom-icon (SEND self :scroll-lines index *scroll-bar-default-lines*))
	   (:otherwise nil)))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-middle-button) (ignore y &rest ignore)
     "2This dispatches to the appropriate action when the middle button is pushed*
   2depending on the position of the mouse within the scroll region.*"
     (LET ((index sys:mouse-buttons-buffer-in-index))
       (multiple-value-bind (ignore ignore ignore lines-per-page)
	   (send self :scroll-position) 
	 (CASE scroll-bar-draw-state 
	   (:top-icon (SEND self :scroll-lines index (- (TRUNCATE lines-per-page 4))))
	   (:upper-box (SEND self :scroll-lines index (- (TRUNCATE lines-per-page 4))))
	   (:bar (SEND self :scroll-drag index y :continuous t))
	   (:lower-box (SEND self :scroll-lines index (TRUNCATE lines-per-page 4)))
	   (:bottom-icon (SEND self :scroll-lines index (TRUNCATE lines-per-page 4)))
	   (:otherwise nil)))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-right-button) (ignore y &rest ignore)
     "2This dispatches to the appropriate action when the right button is pushed*
   2depending on the position of the mouse within the scroll region.*"
     (LET ((index sys:mouse-buttons-buffer-in-index)) 
       (multiple-value-bind (ignore ignore ignore lines-per-page)
	   (send self :scroll-position) 
	 (CASE scroll-bar-draw-state 
	   (:top-icon (SEND self :scroll-lines index (- (TRUNCATE lines-per-page 2))))
	   (:upper-box (SEND self :scroll-lines index (- (TRUNCATE lines-per-page 2))))
	   (:bar (SEND self :scroll-drag index y :continuous t))
	   (:lower-box (SEND self :scroll-lines index (TRUNCATE lines-per-page 2)))
	   (:bottom-icon (SEND self :scroll-lines index (TRUNCATE lines-per-page 2)))
	   (:otherwise nil)))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-left-button-2) (ignore y &rest ignore)
     "2This dispatches to the appropriate action when the left button is pushed twice*
   2depending on the position of the mouse within the scroll region.*"
     (multiple-value-bind (ignore n-lines ignore ignore)
	 (send self :scroll-position)
       (CASE scroll-bar-draw-state 
	 (:top-icon (SEND self :scroll-to 0. :absolute))
	 (:upper-box (SEND self :scroll-fractional nil y))
	 (:bar (SEND self :scroll-fractional nil y))
	 (:lower-box (SEND self :scroll-fractional nil y))
	 (:bottom-icon (SEND self :scroll-to (1- n-lines) :absolute))
	 (:otherwise nil))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-middle-button-2) (ignore y &rest ignore)
     "2This dispatches to the appropriate action when the middle button is pushed twice*
   2depending on the position of the mouse within the scroll region.*"
     (multiple-value-bind (ignore n-lines ignore ignore)
	 (send self :scroll-position)
       (CASE scroll-bar-draw-state 
	 (:top-icon (SEND self :scroll-to 0. :absolute))
	 (:upper-box (SEND self :scroll-fractional nil y))
	 (:bar (SEND self :scroll-fractional nil y))
	 (:lower-box (SEND self :scroll-fractional nil y))
	 (:bottom-icon (SEND self :scroll-to (1- n-lines) :absolute))
	 (:otherwise nil))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-right-button-2) (ignore y &rest ignore)
     "2This dispatches to the appropriate action when the right button is pushed twice*
   2depending on the position of the mouse within the scroll region.*"
     (multiple-value-bind (ignore n-lines ignore ignore)
	 (send self :scroll-position)     
       (CASE scroll-bar-draw-state 
	 (:top-icon (SEND self :scroll-to 0. :absolute))
	 (:upper-box (SEND self :scroll-top-line-here nil y))
	 (:bar (SEND self :scroll-top-line-here nil y))
	 (:lower-box (SEND self :scroll-top-line-here nil y))
	 (:bottom-icon (SEND self :scroll-to (1- n-lines) :absolute))
	 (:otherwise nil))))
   
   (DEFMETHOD (scroll-bar-mixin :where-is-mouse?) (y)
     "2Returns :top-icon, :upper-box, :bar, :lower-box, or :bottom-icon. Or nil if not in scroll region.*"
     (multiple-value-bind (ignore n-lines ignore n-screen-lines)
	 (send self :scroll-position)
       (WHEN (> n-lines n-screen-lines)
	 (COND ((< y (scroll-bar-region-top scroll-bar-region)) nil)
	       ((<= y (scroll-bar-region-box-top scroll-bar-region)) :top-icon)
	       ((<= y (scroll-bar-region-bar-top scroll-bar-region)) :upper-box)
	       ((<= y (+ (scroll-bar-region-bar-top scroll-bar-region)
			 (scroll-bar-region-bar-height scroll-bar-region))) :bar)
	       ((<= y (scroll-bar-region-box-bottom scroll-bar-region)) :lower-box)
	       ((<= y (+ height (scroll-bar-region-bottom scroll-bar-region))) :bottom-icon) 
	       (t nil)))))
   
   (DEFCONSTANT mouse-glyph-null #x18
     "2Using one of the reserved (blank) mouse glyphs to turn off the mouse cursor.*")
   
   (DEFMETHOD (scroll-bar-mixin :scroll-lines) (mouse-button-index lines)
     "2Scrolls 'lines' at a time until mouse-button-index changes.*
   2If lines is positive to next line. If lines is negative scrolls to previous line.*
   2Also makes the approprate icon solid while scrolling.*"
     (mouse-set-blinker-definition :character
				   0 0
				   :on
				   :set-character mouse-glyph-null)
     (SEND self :scroll-bar-draw-icon :point-up (MINUSP lines) :solid t)
     (multiple-value-bind (top-line n-lines ignore ignore)
	 (send self :scroll-position)
       (send self :scroll-to
		   (MAX 0 (MIN (- n-lines 1) (setf top-line (+ top-line lines))))
		   :absolute)
       (LOOP with delay = (send self :scroll-bar-delay-time)
	     and top = (- n-lines 1)
	     and bottom = 0
	     until (or (> top-line top)
		       (<= top-line bottom)
		       (neq mouse-button-index sys:mouse-buttons-buffer-in-index)
		       (ZEROP (mouse-buttons)))
	     do
	     (when delay (process-sleep delay))
	     (send self :scroll-to
		   (MAX bottom (MIN top (setf top-line (+ top-line lines))))
		   :absolute)))
     (SEND self :scroll-bar-draw-icon :point-up (MINUSP lines) :solid nil)
     (mouse-set-blinker-definition
       :character
       (SECOND *scroll-bar-mouse-blinker*) (THIRD *scroll-bar-mouse-blinker*)
       :on
       :set-character (CAR *scroll-bar-mouse-blinker*)))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-drag)
	      (mouse-button-index y-init &optional &key (continuous nil))
     "2Drags scroll bar up and down then scrolls to final position. If continuous is non-nil*
   2then display is updated in real time.*"
     (WHEN scroll-bar-draw-state
       (mouse-set-blinker-definition :character
				     0 0
				     :on
				     :set-character mouse-glyph-null) 
       (MULTIPLE-VALUE-BIND (ignore n-lines ignore ignore)
	   (SEND self :scroll-position)
	 (prepare-sheet (self)
	   (LOOP with box-top = (scroll-bar-region-box-top scroll-bar-region)
		 with bar-height = (scroll-bar-region-bar-height scroll-bar-region)
		 with bar-width = (scroll-bar-region-bar-width scroll-bar-region) 
		 with bar-range = (scroll-bar-region-bar-range scroll-bar-region)
		 with lower-limit = (+ box-top bar-range)
		 with current-bar-top = (scroll-bar-region-bar-top scroll-bar-region)
		 with bar-left = (scroll-bar-region-bar-left scroll-bar-region)
		 with mouse-y-init = (+ y-init
					(CADR (MULTIPLE-VALUE-LIST
						(sheet-calculate-offsets self mouse-sheet))))
		 with snapshot = (MAKE-ARRAY `(,bar-height ,(* 32. (CEILING bar-width 32.)))
					     :element-type 'bit)
		 with screen = (SEND self :screen-array)
		 for y = (MIN lower-limit
			      (MAX box-top
				   (- mouse-y mouse-y-init (- current-bar-top) -1.)))
		 until (or (neq mouse-button-index sys:mouse-buttons-buffer-in-index)
			   (ZEROP (mouse-buttons)))
		 unless continuous
		 do
		 (BITBLT alu-seta	   ;1Save whats under the moving bar*
			 bar-width bar-height
			 screen bar-left y
			 snapshot 0 0)
		 (draw-hollow-rectangle bar-width bar-height 
					bar-left y
					1. alu-ior self)
		 (PROCESS-WAIT "Mouse"
		   #'(lambda (y)
		       (OR (NEQ y mouse-y) (ZEROP (mouse-buttons))))
		   mouse-y)
		 (BITBLT alu-seta	   ;1Restore what was under the moving bar*
			 bar-width bar-height
			 snapshot 0 0
			 screen bar-left y)
		 when continuous		   
		 do 
		 (SEND self :scroll-to
		       (TRUNCATE (* n-lines
				    (FLOAT (/ (- y box-top) (MAX 1 bar-range)))))
		       :absolute)
		 (PROCESS-WAIT "Mouse"
		   #'(lambda (x y)
		       (OR (NEQ x mouse-x) (NEQ y mouse-y) (ZEROP (mouse-buttons))))
		   mouse-x mouse-y)
		 finally
		 (SEND self :scroll-to
		       (TRUNCATE (* n-lines
				    (FLOAT (/ (- y box-top) (MAX 1 bar-range)))))
		       :absolute))))
       (mouse-set-blinker-definition
	 :character
	 (SECOND *scroll-bar-mouse-blinker*) (THIRD *scroll-bar-mouse-blinker*)
	 :on
	 :set-character (CAR *scroll-bar-mouse-blinker*))))
   
   (DEFMETHOD (scroll-bar-mixin :scroll-fractional) (ignore y &rest ignore)
     "2Scrolls window as percentage of y relative to scroll-bar height.*"
     (MULTIPLE-VALUE-BIND (ignore n-lines ignore ignore)
	 (SEND self :scroll-position)
       (SEND self :scroll-to
	     (MAX 0
		  (MIN (1- n-lines)
		       (TRUNCATE (* n-lines
				    (FLOAT (/ (- y (scroll-bar-region-box-top scroll-bar-region))
					      (MAX 1
						   (scroll-bar-region-bar-range scroll-bar-region))))))))
	     :absolute)))
						       
   (defmethod (scroll-bar-mixin :scroll-top-line-here) (ignore y &rest ignore)
     1"Scroll up this many lines for a single click, or continous scrolling while the mouse button is depressed."*
     (send self :scroll-to (- (truncate (- y (sheet-inside-top)) line-height)) :relative))

)