;;; -*- Mode:Common-Lisp; Package:IMAGEN; Base:10 -*-

;;; This software developed by:
;;;	Rich Acuff
;;; at the Stanford University Knowledge Systems Lab in Mar '86.
;;; Updated in 1988 and 1989.
;;;
;;; This work was supported in part by:
;;;	NIH Grant 5 P41 RR00785-15

;;;----------------------------------------------------------------------
;;; Portions of this code indicated by the comment line:
;;;	;TI Code:
;;; are derived from code licensed from Texas Instruments Inc.
;;; KSL's changes are noted by comment lines beginning with:
;;;	;RDA:
;;;  The following restrictions apply to the TI code:

;;; Your rights to use and copy Explorer System Software must be obtained
;;; directly by license from Texas Instruments Incorporated.  Unauthorized
;;; use is prohibited.

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (b)(3)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1986,1987 Texas Instruments Incorporated. All rights reserved.
;;;----------------------------------------------------------------------

;;;  Code to make the TI Imagen and TCP code work together allowing
;;;  printing to Imagen printers based on ethernets.
;;;  The printer type in the Net-Config must be NET-IMAGEN.

;;;  Set up this mapping for the KSL.  It may work elsewhere, depending
;;;  on what fonts are around.
(setq *lisp-to-imagen-font-mapping*
      '(("BIGFNT"."GA14")	("COURIER"."COUR10")
	("CPTFONT"."COUR10")	("CPTFONTB"."COUR10")
	("MEDFNT"."COUR12")
	("HL10"."HV10")	("HL10B"."HV10B")
	("HL10BI"."HV10BI")	("HL10I"."HV10I")
	("HL12"."HV12")	("HL12B"."HV12B")
	("HL12BI"."HV12BI")	("HL12I"."HV12I")
	("HL6"."HV6")	("HL7"."HV8")
	("TINY"."GA6")
	("TR10"."TR10")	("TR10B"."TR10B")
	("TR10BI"."TR10BI")	("TR10I"."TR10I")
	("TR12"."TR12")	("TR12B"."TR12B")
	("TR12BI"."TR12BI")	("TR12I"."TR12I")
	("TR8"."TR8")	("TR8B"."TR8B")
	("TR8I"."TR8I")	("TVFONT"."GA6")
	)
      )

;;;  Make sure the system knows COUR10 is printer-resident on Imagens.
(setf (imagen::lisp-font-name imagen-fonts:cour10) nil)

;;;----------------------------------------------------------------------

;;;  A canonical type for temp files.
(fs:define-canonical-type :net-imagen-printer "IMAGEN"
  (:unix "imagn")
  (:vms "img"))

;;;
;;; Add IMAGEN-FONT properties to all Lisp fonts that have associated
;;; Imagen fonts...
;;;
(LOOP FOR font-pair IN *lisp-to-imagen-font-mapping* DO
      (PUTPROP (sys:INTERN-LOCAL (CAR font-pair) 'fonts)
	       (sys:INTERN-LOCAL (CDR font-pair) 'imagen-fonts) 'FED:imagen-font)
      (PUTPROP (sys:INTERN-LOCAL (CDR font-pair) 'imagen-fonts)
	       (sys:INTERN-LOCAL (CAR font-pair) 'fonts) 'imagen:lisp-font))


(defflavor printer:net-imagen-printer
	   ()
	   (printer:imagen-printer)		;most behavior from here
  :settable-instance-variables
  :gettable-instance-variables)

(defmethod (printer:net-imagen-printer :finish-imagen-document) ()
  (send printer:printer-stream :tyo 255.)	;RDA: 255 to end.
  (SETQ document-string-already-sent-p nil))

(defmethod (printer:net-imagen-printer :tyo-raw) (char)
  "Shadow :TYO-RAW method that might send bad chars."
  (send printer:printer-stream :tyo char))

(defmethod (printer:net-imagen-printer :start-imagen-document) ()
  "Send the Imagen the strings that define a new document to it."
  (unless document-string-already-sent-p
      (send self :string-out-raw
	    ;;RDA: Change the @Document for network printing
	    (string-append
	      "@Document(Language IMpress, JobHeader "
	      (if print-header-page-p "On" "Off")
	      ", "
	      (format nil "Owner \"~A\"" username)
	      ", "
	      (format nil "Printed-On \"~A\"" printer:current-time)
	      ", "
	      (format nil "Name \"~A\"" filename)
	      (format nil "~@[, Created \"~A\"~])"
		      (IF (typep filename 'fs:pathname)
			  (time:print-universal-time
			    (get (send filename :properties) :creation-date) nil)))))
      (send self :download-glyphs)     		; Download all needed glyphs.
      (setq document-string-already-sent-p t)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; The following are modified system functions.

;;;TI Code:
printer:
;;;Edited by acuff                 6 Jan 89  8:26
(defmethod (basic-print-request :handle-request) ()   ;2.1 fix to support remote-login option
  "Perform print request, see if printer exists and is on a local or remote host"
  (let ((printer-host (parse-host-name (get print-device ':host) T T)))
    (cond (printer-host
	   (if (or (eq si:local-host printer-host)
		   ;;RDA: Do it locally for Imagen printer.
		   (equal (get print-device :type) :net-imagen-printer))
	       (send self ':handle-local-request)   ;2.1 fix to support remote-login option
	       (send self ':handle-remote-request printer-host)))
	  (T
	   (notify-user-at-host
	     (format NIL "~A is not a known host for printer ~A in ~A" 
		     (get print-device ':host) (car print-device) self)
	     sender-host)))))

;;;TI Code:
printer:
;;;Edited by acuff                 6 Jan 89  8:26
(DEFUN GET-PRINTER-STREAM (&REST OPTIONS &KEY &OPTIONAL (BAUD *DEFAULT-BAUD-RATE*) (STOP-BITS *DEFAULT-STOP-BITS*)
			   (STREAM *DEFAULT-STREAM*) (DATA-BITS *DEFAULT-DATA-BITS*) (PARITY *DEFAULT-PARITY*)
			   (ASCII-CHAR NIL)	       ; should always be NIL if print bitmaps
			   (XON-XOFF *DEFAULT-XON-XOFF*) &ALLOW-OTHER-KEYS)
  "Return the serial or parallel stream for a printer."
  (if (equal (getf options :type) :net-imagen-printer)
      ;;RDA: It's a net printer, so open a TCP stream.
      (ip:open-stream (getf options :host) :remote-port 35.
		      :timeout 120. :characters t)
      ;; Must be attached, so do the normal thing.
      (progn
	(UNLESS (MEMBER STREAM '(:PARALLEL :SERIAL :MAC-PRINTER )      ;08-19-88 DAB
			:TEST #'EQ)
	  (SETQ STREAM :SERIAL))
	(IF (EQ PARITY :NONE)
	    (SETQ PARITY ()))
	(CASE STREAM
	  (:SERIAL
	   (SI:MAKE-SERIAL-STREAM :BAUD BAUD :NUMBER-OF-STOP-BITS STOP-BITS :NUMBER-OF-DATA-BITS
				  DATA-BITS :PARITY PARITY :ASCII-CHARACTERS ASCII-CHAR
				  :XON-XOFF-PROTOCOL XON-XOFF))
	  (:PARALLEL (SI::MAKE-PARALLEL-STREAM))
	  (:mac-printer (make-mac-printer-stream)))    ;ab 10-17-88
	)
      )
  )