;;; -*- Mode:Common-Lisp; Package:User; Base:10 -*-

(load-tools '(:36xx-explorer
	      :Development-Tool-Consistency-Enhancements
	      :Grapher
	      :Inspector-Enhancements
	      :Window-Debugger-Enhancements
             )
)

(defsystem general-inspector
  (:name "General Inspector")
  (:output-version :Newest)
  (:Pathname-Default "General-Inspector:General-Inspector;")
  (:module patches (("KSLx:SYS-PATCHES;FLAVOR-INSPECTOR-PATCHES-8")))
  (:Module inspector-changes (("BASIC-INSPECTOR-CHANGES")))
  (:module ti-compat (("TI-ENV-INSPECTOR-INTERFACE")
		      ("TI-ENV-FLAVOR-INSPECTOR-INTERFACE")
		      ("METHOD-COMBINATION")))
  (:module System (("GENERAL-INSPECTOR")
		   ("GENERAL-INSPECT-DEBUGGER")))
  (:Module perspectives (("PERSPECTIVES")))
  (:Module messy (("MESSY-INSPECTOR")))
  #-microExplorer (:Module wrapup (("SUGGESTIONS")))
  (:Compile-Load patches)
  (:Compile-Load inspector-changes)
  (:Compile-Load ti-compat (:Fasload patches inspector-changes))
  (:Compile-Load System (:fasload patches inspector-changes ti-compat))
  (:Compile-Load perspectives
		 (:Fasload patches inspector-changes ti-compat system)
  )
  #-microExplorer
  (:Compile-Load wrapup
	 (:Fasload patches inspector-changes ti-compat system perspectives)
  )
  (:Compile-Load messy
	 (:Fasload patches inspector-changes ti-compat system perspectives)
  )
)