;;; -*- Mode:Common-Lisp; Package:SYSTEM; Base:10; Patch-File: t -*-


(defvar *defeat-bogus-make-system-file-newer-than-file-p-message-p* nil)

(DEFUN FILE-NEWER-THAN-FILE-P (FILE-1 FILE-2 &OPTIONAL (NO-ERROR-P T))
    (COND ((EQ *SAFETY* 'VERSION)
	   ;; The new definition of this function uses versions if the OS supports them.  If not
	   ;; we automatically go and use creation dates.
	   (AND (EQUAL (SEND FILE-1 :NAME) (SEND FILE-2 :NAME))
		(LET ((FILE-1-VERSION (SYSTEM-GET-VERSION-NUM FILE-1))
		      (FILE-2-VERSION (SYSTEM-GET-VERSION-NUM FILE-2 NO-ERROR-P)))
		  (IF (= -2 (MIN FILE-1-VERSION FILE-2-VERSION)) ;version is -2 if versions not supported
		      (LET ((*SAFETY* 'CREATION-DATE))           ;bind *safety* to do dates and try again.
			(FILE-NEWER-THAN-FILE-P FILE-1 FILE-2 NO-ERROR-P))
		      (PROGN
			;;Now that the compiler can output files as :newest or :same version numbers,
			;;Issue a warning if there are versions of the binary greater than the version of the source.
			(IF (AND (< FILE-1-VERSION FILE-2-VERSION)
				 (EQ *OUTPUT-VERSION-BEHAVIOR* :SAME))
			    (FORMAT T "~%WARNING: ~A already has a larger version number than ~A. ~
                                       ~%         You probably need to use (:OUTPUT-VERSION :newest) in the DEFSYSTEM"
				    (SEND FILE-2 :NEW-PATHNAME :VERSION FILE-2-VERSION)
				    (SEND FILE-1 :NEW-PATHNAME :VERSION FILE-1-VERSION)))
			(> FILE-1-VERSION FILE-2-VERSION))))))

	((EQ *SAFETY* 'CREATION-DATE)
	 ;; The original definition of this function used creation dates for the selection criterion.
	 ;; This is now the alternate. 
	 (LET 
	   ((NEWER-DATE-P (> (SYSTEM-GET-FILE-PROPERTY FILE-1 :CREATION-DATE)	;file property 
			   (SYSTEM-GET-FILE-PROPERTY FILE-2 :CREATION-DATE NO-ERROR-P)))       
	    (NEWER-VERSION-P (AND (EQUAL (SEND FILE-1 :NAME) (SEND FILE-2 :NAME))	;not file property	       
				(> (SYSTEM-GET-VERSION-NUM FILE-1)
				   (SYSTEM-GET-VERSION-NUM FILE-2 NO-ERROR-P))))
	    (ZERO-LENGTH-P (EQl 0 (SYSTEM-GET-FILE-PROPERTY FILE-2 :LENGTH-IN-BYTES T))))	;file property
	   (ignore NEWER-VERSION-P)
	   (COND
	     (ZERO-LENGTH-P  T)			;ok if file doesn't exist yet
	     (T ;;;JPR patched here.
	      (when (not *defeat-bogus-make-system-file-newer-than-file-p-message-p* )
		(WHEN (AND NEWER-VERSION-P (NOT NEWER-DATE-P) (NOT *JUST-ACCUMULATING-FILES*))
		  (FORMAT T "~&WARNING: File-newer-than-file-p condition was asked to compare by creation dates, however~
                             ~&         File ~A has a newer version number but not a newer date than file ~A.~&"
			  FILE-1 FILE-2)))
	      NEWER-DATE-P))))
	(T (ERROR (FORMAT nil "Invalid *safety* value of ~a.  Must be either 'SI:VERSION or 'SI:CREATION-DATE" *safety*)))))


(defun sys:always (&rest ignore) t)