;;;   -*- Mode:Common-Lisp; Package:ZWEI; Base:10 -*-


;;; Some fixes to the code dealing with writing diagram lines.
;;;


;;; Originally defined in file SYS:ZMACS;METH.LISP
;;; This method simply did not know how to properly write out diagram lines.
;;; Numerous changes, added lots of comments.
;;;
(DEFMETHOD (INTERVAL-STREAM-WITH-FONTS :READ-CHAR) (&OPTIONAL EOF &AUX CH)
  (COND ((STRINGP *FONT-FLAG*)
	 ;;
	 ;; If font-flag is a string, then we are to take characters out of that string before
	 ;; taking characters out of the buffer again.
	 ;;
	 (SETQ CH (AREF *FONT-FLAG* *INDEX*))
	 (AND (>= (SETQ *INDEX* (1+ *INDEX*)) *STOP-INDEX*)
	      (SETQ *FONT-FLAG* NIL
		    *INDEX* 0
		    *STOP-INDEX* (IF (EQ *LINE* *LAST-LINE*)
				     *LAST-INDEX*
				     (LINE-LENGTH *LINE*))))
	 CH)
	
	((NULL *INDEX*)
	 (AND EOF (FERROR NIL (IF (STRINGP EOF)
				  EOF
				  "Unexpected end-of-file encountered; please check parentheses."))))
	
	((EQ *FONT-FLAG* T)
	 ;;
	 ;; If Font-Flag is T, then we are to return a font-change-number (because the last character
	 ;; we returned was an Epsilon).  **font** holds the code we are to return.
	 ;;
	 (SETQ *FONT-FLAG* NIL)
	 (CODE-CHAR (+ (CHAR-INT #\0) **FONT**)))
	
	((OR (CHARACTERP *FONT-FLAG*) (NUMBERP *FONT-FLAG*))
	 ;;
	 ;; If Font-Flag is a character of number, then we are to return that (and reset Font-Flag).
	 ;; It is the case that when *font-flag* is a character, it is the Epsilon character, or an Asterisk.
	 ;; This is used to implement the "Epsilon Epsilon" quoting, and the "Epsilon Asterisk" pop.
	 ;;
	 (PROG1 (INT-CHAR *FONT-FLAG*)
		(SETQ *FONT-FLAG* NIL)))
	
	((< *INDEX* *STOP-INDEX*)
	 ;;
	 ;; Now we are taking things from the buffer.  If Index is less than Stop-Index, then we can take
	 ;; another character out of this line.  
	 ;;
	 (SETQ CH (AREF *LINE* *INDEX*))
	 (COND ((/= **FONT** (CHAR-FONT CH))
		;;
		;; If the character we get has a different font than the last character we read, then we must
		;; return an Epsilon, and set up **font** and *font-flag* so that an epsilon code will be returned
		;; on the next pass.
		;;
		(COND ((MEMBER (CHAR-FONT CH) (G-L-P *FONT-STACK*) :TEST #'EQ)
		       (SETQ **FONT** (VECTOR-POP *FONT-STACK*))
		       (SETQ *FONT-FLAG* #\*))
		      (T
		       (INTERVAL-WITH-FONTS-IO-PUSH-FONT)
		       (SETQ **FONT** (CHAR-FONT CH))
		       (SETQ *FONT-FLAG* T)))
		#\)
	       (T
		;;
		;; If the fonts of this char and the last char are the same, and the character is not an Epsilon,
		;; then we can just return the char.  If the character is an Epsilon, then we must set font-flag
		;; to be that character as well, so that two epsilons get returned.
		;;
		(SETQ *INDEX* (1+ *INDEX*))
		(AND (CHAR= (SETQ CH (MAKE-CHAR CH)) #\)
		     (SETQ *FONT-FLAG* CH))
		CH)))
	
	((EQ *LINE* *LAST-LINE*)    ; If on the last line, and at the end (prev clause) signal EOF.
	 (SETQ *INDEX* NIL)
	 (AND EOF (FERROR NIL (IF (STRINGP EOF)
				  EOF
				  "Unexpected end-of-file encountered; please check parentheses."))))
	
	((ANTICIPATE-FONT-POP))   ; Some efficiency stuff...

	((setq ch (getf (line-plist *line*) :diagram))
	 ;;
	 ;; If this is the primary diagram line, write it out.
	 ;; We get the string to write it by sending the Diagram the :STRING-FOR-FILE message.
	 ;; In most cases, this returns a multi-line string, which begins with Epsilon-Hash.
	 ;; Before calling this method, we bind *PACKAGE* to NIL to force the printing of any package-prefixes that
	 ;; may be dumped into the string.
	 ;;
	 ;; We append a newline to the end of this string, and put the string on *font-flag* so that subsequent read-chars
	 ;; will come from that string.  We set *index* to 1 instead of 0, so that chars will come from that string starting
	 ;; at position 1 - this is because we return the character at position 0 now!
	 ;;
	 (when (zerop (getf (line-plist *line*) :diagram-line-number 0))    ; default to 0 - jwz, 12 dec 89.
	   (let* ((string (let ((*package* nil))
			    (send ch :string-for-file *line*)))
		  (length (length string)))
	     (AND (PLUSP LENGTH)
		  (SETQ *FONT-FLAG* (string-append STRING #\Newline)
			*INDEX* 1
			*STOP-INDEX* (1+ LENGTH)))))
	 (setq *line* (line-next *line*))
	 ;;
	 ;; Discard the secondary, space-filling diagram lines.
	 ;; In a buffer, one "diagram" object corresponds to several real "lines", since diagrams can be arbitrarilly tall.
	 ;; Each of these lines has a pointer to the diagram, but we only want to write out one diagram object, even if
	 ;; it spans several lines.
	 ;;
	 (do ((diag-number (getf (line-plist *line*) :diagram-line-number)
			   (getf (line-plist *line*) :diagram-line-number)))
	     ((or (null diag-number)
		  (zerop diag-number)
		  (eq (line-next *line*) *last-line*)))
	   (setq *line* (line-next *line*)))
	 ;;
	 ;; Return the first character of the diagram output-string.  Subsequent calls will get the rest.
	 (char *font-flag* 0))
	
	(t
	 (SETQ *line* (line-next *line*)
	       *INDEX* 0
	       *STOP-INDEX* (IF (EQ *LINE* *LAST-LINE*)
				*LAST-INDEX*
				(LINE-LENGTH *LINE*)))
	 #\Newline)))



;;; This method was almost exactly the same as :READ-CHAR...  why duplicate code...
;;;
(DEFMETHOD (INTERVAL-STREAM-WITH-FONTS :TYI) (&OPTIONAL EOF)
  (let ((c (send self :read-char eof)))
    (if (characterp c)
	(char-int c)
	c)))


;;;  Originally defined in SYS:ZMACS;FONT.LISP
;;;  This function was producing an invalid string describing itself.
;;;
(DEFMETHOD (RESTORABLE-LINE-DIAGRAM-MIXIN :STRING-FOR-FILE) (LINE)
  (IF (SEND SELF :FIRST-LINE-P LINE)
      (FORMAT NIL "# ~D ~S~%~A"		; ## Use ~S instead of ~A, so that package prefix prints.
	      (SEND SELF :NUMBER-OF-LINES)	; ## Also, put a space between epsilon-hash and digit. - jwz, 12 apr 89.
	      (TYPE-OF SELF)
	      (SEND SELF :CONTENTS LINE))
      (SEND SELF :CONTENTS LINE)))
