;;; -*- Mode:Common-Lisp; Package:tv; Base:10; Fonts:(TVFONT) -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.  Where functionality implemented herein replicates
;;; similarly named functionality on Symbolics machines, this code was
;;; developed solely from the interface specification in the documentation
;;; or through guesswork, never by examination of Symbolics source code.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.
;;; **********************************************************************

;;;Cribbed from Rice in DTCE

(defun process-interestingness (process)
 "Returns a number that says how interesting a process is.  The more interesting
     the higher the number.  Totally boring processes return 0.
    "
  (let ((idle (send process :idle-time)))
    (if idle
	(if (= idle 0)
	    (let ((use (send process :percent-utilization)))
	      (if (> use 5)
		  (or use 0)
		  0
		  )
	      )
	    0
	    )
	0
	)
    )
  )


(defun find-interesting-process ()
"Finds the most interesting process out of the processes in the system.  Returns
     either the most interesting process or nil if it can't find one.
    "
  (let ((best-process nil)
	(best-use 0)
	)
    (loop for p in all-processes do
	  (let ((int (process-interestingness p)))
	    (if (> int best-use)
		(progn (setq best-use int)
		       (setq best-process p)
		       )
		nil
		)
	    )
	  )
    best-process
    )
  )


(defmethod (si:process :real-idle-time) ()
  "Returns the time that a process has been idle in seconds.  :Idle-time doesn't
     work for the current process.
    "
  (if (null si:last-time-run)
      nil
      (/ (time-difference (time) si:last-time-run) 60.)
      )
  )


;(setq *show-background-processes-in-who-line* t)

(defun run-state-display-function (process)
  (format nil "~A: ~A"
	  (process-whostate process)
	  (the string (send process :name))
	  )
  )
;(process-whostate current-process)
;(run-state-display-function current-process)


(defun run-state-display-function (process)
  (string (send process :name))
  )

(defun who-line-run-state-for-process (p)
  "Return the PROCESS-WHOSTATE for the process P, or the name of a running process if
there is one and P has been idle a while and *SHOW-BACKGROUND-PROCESSES-IN-WHO-LINE* is
non-NIL."
  (let ((interesting-process nil))
    (if (and *show-background-processes-in-who-line*
	     (typep p 'si:process)
	     (let ((idle (send current-process :real-idle-time)))
	       (and (numberp idle)
		    (>= idle *who-line-run-state-toggle-time*)
		    )
	       )
	     (equalp (process-whostate p) "Keyboard")
	     (setq interesting-process (find-interesting-process))
	     (typep interesting-process 'si:process)
	     )
	(run-state-display-function interesting-process)
	(process-whostate p)
	)
    )
  )

(let ((sys:compile-encapsulations-flag t))
  (advise tv:who-line-update :before "Update Run State" nil
    (when (sys:mx-p)
      ;; Can do this on the mX, but would recurse on X.
      (who-line-run-state-update)
      )
    )
  )

;;;TI Code: Cribbed from SYS:WINDOW;WHOLIN.LISP#37
(DEFUN WHO-LINE-RUN-STATE-UPDATE
       (&AUX P)			;1Separate variable since other can be setq'ed*
				;1 asynchronously by other processes.*
  (SETQ LAST-WHO-LINE-PROCESS
	(SETQ P (OR WHO-LINE-PROCESS
		 (PROGN (AND (NULL SELECTED-IO-BUFFER)
			     (NOT (NULL SELECTED-WINDOW))   ;1This can happen.*
			     (SETQ SELECTED-IO-BUFFER
				   (FUNCALL SELECTED-WINDOW :IO-BUFFER)))
		   (AND SELECTED-IO-BUFFER
			(IO-BUFFER-LAST-OUTPUT-PROCESS
			  SELECTED-IO-BUFFER))))))
  (SETQ WHO-LINE-RUN-STATE (COND ((NULL SELECTED-WINDOW)
				  "No selected window")
				 ((NULL P)
				  "No current process")
				 ((ASSOC P ACTIVE-PROCESSES :TEST #'EQ)
				  ;;RDA: Changed from PROCESS-WHOSTATE
				  (who-line-run-state-for-process  P))
				 ((NOT (NULL (SI:PROCESS-ARREST-REASONS P)))
				  "Arrest")
				 (T "Stop")))
  (cond
    (si:*sib-present* (WHO-LINE-UPDATE T))
    (t (copy-array-portion who-line-run-state 0 (LENGTH who-line-run-state)
			   mac-who-string 0 (- si:%MX-Who-State-String-Max 1))))
  )