 ;;;  -*- Mode:LISP; Package:TV; BASE:8; Fonts:MEDFNT,HL12B,HL12BI -*-

#|
These functions are used to make the screen go black.  This is
done to save the phosphors on the screen from going dim before
their time.  To make the screen turn back to white, press ANY
key (yes, ANY key, including the shifting keys) on the keyboard,
or press a mouse button.

Implementation notes:
The video blanking feature of the TV graphics attribute register
is used to turn on/off the video.  This feature was implemented
specifically to save the phosphors on the screen.  The keyboard
is check by looking at the SAVED-FIRST-CHAR variable.  This is a
real hack because it depends upon the keyboard software to set
this variable whenever a key on the keyboard has been pressed.
Since all of this is in Window System code, I guess that isn't
too bad.
|#

; It is unfortunate that this code works, but the machine ilops too frequently.

(DEFUN MAKE-THE-ENTIRE-SCREEN-BLACK (&optional ignore)
  (TURN-VIDEO NIL)
  (WAIT-FOR-HIT)
  (TURN-VIDEO T))

(DEFUN TURN-VIDEO (&OPTIONAL (ON T))
  "Turn on or off the video blanking of the display."
  (WHEN (NUMBERP ON) (SETQ ON (> ON 0)))
  (si:%NUBUS-WRITE-8b
    SIB-SLOT-NUMBER
    (+ TIME:GRAPHICS-AND-BIT-MAP-CONTROL-BASE TIME:GRAPHICS-ATTRIBUTE-REGISTER)
    (DPB (IF ON (- 1 TIME:VIDEO-BLANKING-ON) TIME:VIDEO-BLANKING-ON)
         TIME:VIDEO-BLANKING
         (LDB #o0002
              (si:%NUBUS-READ-8b
                SIB-SLOT-NUMBER
                (+ TIME:GRAPHICS-AND-BIT-MAP-CONTROL-BASE
                   TIME:GRAPHICS-ATTRIBUTE-REGISTER))))))

;;; Provide another way to turn the video back on.
(ADD-TERMINAL-KEY #\X #'MAKE-THE-ENTIRE-SCREEN-BLACK "Turn video off")

(DEFUN WAIT-FOR-HIT ()
  "Wait until either a keyboard character or a mouse button has
been hit."
  (PROCESS-WAIT "Hit me please" #'KEY-OR-MOUSE SI:SAVED-FIRST-CHAR))

(DEFUN KEY-OR-MOUSE (char)
  "Returns T when either a key or a mouse button has been pushed."
  (OR (NOT (EQUAL char SI:SAVED-FIRST-CHAR))
      mouse-wakeup))
