;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:USER -*-

;;; File "WHOIS"
;;; What FINGER should do.
;;; Written and maintained by Jamie Zawinski.
;;;
;;; ChangeLog:
;;;
;;; 13 Oct 88  Jamie Zawinski    Created.
;;;


(defun whois (user-name)
  (setq user-name (string-downcase (string user-name)))
  (let* ((object (name:lookup-object user-name :user :chase-aliases t)))
    (cond (object
	   (setq user-name (string-downcase (string (name:object-name object))))
	   (let* ((name (name:get-attribute-value object :personal-name))
		  (host (name:get-attribute-value object :home-host))
		  (mail (name:get-attribute-value object :mail-address))
		  (work (name:get-attribute-value object :work-phone))
		  (home (name:get-attribute-value object :home-phone))
		  (addr (name:get-attribute-value object :address))
		  (zip  (name:get-attribute-value object :zipcode))
		  (bday (name:get-attribute-value object :birthday)))
	     (format t "~&~A@~A~30t~@50A~%" user-name host name)
	     (let* ((m (format nil "Mail Address: ~A" mail)))
	       (princ m)
	       (when addr
		 (let* ((s (format nil "~A~A" addr (if zip (format nil " (~A)" zip) ""))))
		   (if (>= (+ (length s) (length m)) 79)
		       (format t "~%~A" s)
		       (format t "~vT~A" (max 1 (- 80 (length s))) s)))))
	     (terpri)
	     (format t "Work Phone: ~A~%" (or work "unknown"))
	     (format t "Home Phone: ~A" (or home "unknown"))
	     (if bday
		 (format t "~40t~@40A~%" bday)
		 (terpri))
	     (terpri)))
	  (t
	   (format t "~2&~S unknown.~2%" user-name))))
  (values))
