;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TELNET; Vsp:0; Fonts:(MEDFNT HL12B HL12BI COURIER CPTFONT HL12B HL12); Patch-file:T -*-

;6;; File "3TELNET-NEWLINE-FIX*"*
;6;; If you telnet from a Sun to a TI, you can't terminate a READ-LINE - because you can't get a newline through.*
;6;; You must be sitting at a Sun to see this behavior - if you telnet from a TI to a Sun, and then back to the TI, it doesn't happen.*
;6;;*
;6;; 5ChangeLog:**
;6;;*
;6;;    27 May 89*	6Jamie Zawinski*	6 Created.*
;6;;*

;6;; Originally defined in 3SYS: TELNET; TELNET-SERVER.LISP#>**
;6;;*

(DEFMETHOD (telnet-server-window :net-tyi) (&aux char)
  (SETQ char (DO (ch
		   command)
		 (nil)
	       (SEND network-stream :force-output)
	       (SETQ ch (SEND network-stream :tyi))
	       (COND
		 ;1; nil signals a remote close at this time.*
		 ((EQ () ch)
		  (SEND network-stream :close)
		  (FERROR 'system:network-error "Telnet Server is closing.") nil)
		 
		 ;1; Process Telnet commands *
		 ((EQL ch nvt-iac)
		  (SETQ command (SEND network-stream :tyi))	   ;1 Get the command*
		  (COND
		    ;1; Do Option*
		    ((EQL nvt-do command)
		     (telnet-server-do-option) nil)
		    
		    ;1; Dont Option*
		    ((EQL nvt-dont command)
		     (telnet-server-dont-option) nil)
		    
		    ;1; Will Option*
		    ((EQL nvt-will command)
		     (telnet-server-will-option) nil)
		    
		    ;1; Wont Option*
		    ((EQL nvt-wont command)
		     (telnet-server-wont-option) nil)
		    
		    ;1; Are You There commad  (STATUS)*
		    ((EQL nvt-ayt command)
		     (FORMAT network-stream "~&~A ~A Telnet Server~%" si:local-host network-type) nil)
		    
		    ;1; Erase Line command*
		    ((EQL nvt-el command)
		     (SEND network-stream :tyo 2)
		     (RETURN #.(CHAR-INT #\Clear-input)))
		    
		    ;1; Erase Character command*
		    ((EQL nvt-ec command)
		     (WHEN remote-echo-flag
			   (WRITE-CHAR #\Backspace network-stream) ;1;*	1(SEND NETWORK-STREAM :TYO #\BACKSPACE)*
			   (WRITE-CHAR #\Space network-stream)     ;1;  (SEND NETWORK-STREAM :TYO #\SPACE)*
			   (WRITE-CHAR #\Backspace network-stream) ;1;  (SEND NETWORK-STREAM :TYO #\BACKSPACE)*
			   (SEND network-stream :force-output))
		     (RETURN #.(CHAR-INT #\Rubout)))
		    
		    ;1; Interupt Process command*
		    ((EQL nvt-ip command)
		     (tv:kbd-intercept-abort #\Abort) nil)
		    
		    ;1; Abort Output command*
		    ((EQL nvt-ao command)
		     (tv:kbd-intercept-abort #\Abort) nil)
		    
		    ;1; Go Ahead command*
		    ((EQL nvt-ga command) nil)
		    ;1; IAC character sent as data*
		    ((EQL nvt-iac command)
		     (WHEN remote-echo-flag
			   ;1; All IAC characters sent as data*
			   ;1; must be send as two IAC characters.*
			   ;1; The window will send one IAC.*
			   (SEND network-stream :tyo nvt-iac)
			   (SEND network-stream :force-output))
		     (RETURN nvt-iac))
		    (t nil)))

		 ;1; Hack to get around bogus ASCII conversion...*			1-- Jwz*
		 ((member ch '(13 10 #.(char-int #\Linefeed)) :test #'eql)
		  (return (char-int #\Newline)))
		 
		 ;1; Special character*
		 ((MEMBER ch '(#.(CHAR-INT #\Rubout)
			       #.(CHAR-INT #\Backspace)
			       #.(CHAR-INT #\Newline)
			       #.(CHAR-INT #\Tab)
			       #.(CHAR-INT #\Page)
			       #.(CHAR-INT #\Linefeed)) :test #'EQL)
		  (RETURN ch))
		 
		 ;1; Check for Control character, Meta character or ascii character*
		 (t
		   ;1; Meta keys have bit 7 set.  Control keys are < 40 octal.*
		   (LET ((new-char ch))
		     (IF (LDB-TEST (BYTE 1 7) ch)  ;1meta key *
			 (SETQ new-char (SET-CHAR-BIT (LDB (BYTE 7 0) new-char) :meta t)))
		     
		     (IF (< (LDB (BYTE 7 0) ch) 32)	   ;1control key*
			 (SETQ new-char (SET-CHAR-BIT (+ new-char 64) :control t)))

		     ;
		     ;	1       (IF (OR (MEMQ new-char '(#\RUBOUT #\OVERSTRIKE #\RETURN #\TAB #\FF #\LINE))*
		     ;		1       (AND (NOT (CHAR-BIT new-char :META))*
		     ;			1    (NOT (CHAR-BIT new-char :CONTROL))))*

		     (IF (AND (NOT (CHAR-BIT new-char :meta))
			      (NOT (CHAR-BIT new-char :control)))
			 (RETURN new-char)
			 ;1; SEND back a control-G (beep),*
			 ;1; since it's up to the telnet window to handle rubout handler command*
			 ;1; not the telnet server. *
			 (SEND network-stream :tyo nvt-bell)))))))
  ;1; Clean up the remote screen.*
  (WHEN (AND remote-echo-flag (EQL char #.(CHAR-INT #\Rubout)))	
	(WRITE-CHAR #\Backspace network-stream) ;1;*	1(SEND NETWORK-STREAM :TYO #\BACKSPACE)*
	(WRITE-CHAR #\Space network-stream)     ;1;  (SEND NETWORK-STREAM :TYO #\SPACE)*
	(WRITE-CHAR #\Backspace network-stream) ;1;  (SEND NETWORK-STREAM :TYO #\BACKSPACE)*
	)
  char)
