;;; -*- Mode:Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B TR12BI HL12BI HL12I); Syntax:Common-Lisp -*-

;1;; File "*SCRIBE-MODE1"*
;1;; Implements a minor mode that does fontification for SCRIBE source code; *
;1;; this is to 5.MSS* files what Electric Font Lock Mode is to 5.LISP* files.*
;1;; Written and maintained by Jamie Zawinski.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;; *24 Jan 891  Jamie Zawinski*	1 Created.*
;1;;   5 Apr 89  Jamie Zawinski *	1 Got it working.*
;1;;   6 Apr 89  Jamie Zawinski *	1 Made 5@* have 5list-slash* syntax, so that 5@)* is recognised as a command name, not a close-paren.*
;1;;*				1 Fixed the boldification of closing parens - it was bolding all closing parens, not just the *
;1;;*				1   ones that balanced.*
;1;;   7 Apr 89  Jamie Zawinski *	1 Fontify was messed up with respect to @@, and the hook was having trouble with punctuation commands.*
;1;;*


(defminor com-electric4-scribe*-mode electric-scribe-mode "2Scribe*" 5
	2  "Minor mode to fontify characters as follows:
         Default Font*			2A
         Command and Environment Names*	2B
         Command Arglists*			2C
A positive argument turns the mode on, zero turns it off; no argument toggles."* ()
  ;1;*
  ;1; Set the list syntax for some characters; we don't want semicolons treated as comments, for example.*
  ;1; Also, make brackets, braces, and <> be parens, since Scribe interprets them that way.*
  ;1;*
  (set-char-syntax LIST-OPEN       *mode-list-syntax-table*  #\()
  (set-char-syntax LIST-OPEN       *mode-list-syntax-table*  #\[)
  (set-char-syntax LIST-OPEN       *mode-list-syntax-table*  #\{)
  (set-char-syntax LIST-OPEN       *mode-list-syntax-table*  #\<)
  (set-char-syntax LIST-CLOSE      *mode-list-syntax-table*  #\))
  (set-char-syntax LIST-CLOSE      *mode-list-syntax-table*  #\})
  (set-char-syntax LIST-CLOSE      *mode-list-syntax-table*  #\])
  (set-char-syntax LIST-CLOSE      *mode-list-syntax-table*  #\>)
  (set-char-syntax LIST-DELIMITER  *mode-list-syntax-table*  #\")  ;1 Just a normal delimiter, not a string.*
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\/)  ;1 Scribe doesn't have an escape character*
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\\)  ;1  like slash/backslash.*
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\:)
  (set-char-syntax LIST-DELIMITER  *mode-list-syntax-table*  #\;)  ;1 No comments.*
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\|)
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\#)
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\')  ;1 No Quotes, Commas, or other magic.*
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\`)
  (set-char-syntax LIST-ALPHABETIC *mode-list-syntax-table*  #\,)
  
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\<)
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\>)
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\()
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\))
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\[)
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\])
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\{)
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\})
  
  ;1; In normal text, make At-Sign be a word-delimiter.*
  ;1; For lists, make At-Sign be an escape - this lets the parens in 5@(* and 5@)* not be treated as parens at all.*
  ;1;*
  (set-char-syntax LIST-SLASH      *mode-list-syntax-table*  #\@)
  (set-char-syntax WORD-DELIMITER  *mode-word-syntax-table*  #\@)
  ;1;*
  ;1; Add 5Fontify* to the Extended Commands.*
  ;1;*
  (set-comtab *comtab* () '(("3Fontify Region Or Buffer*" . com-scribe-fontify-region-or-buffer)))
  ;1;*
  ;1; In Scribe, comments are made with the At-Tilde command.*
  ;1;*
  (setq *comment-begin* "3@~*")
  ;1;*
  ;1; Add our command hook, so that we can fiddle the font before the user types.*
  ;1;*
  (command-hook 'scribe-mode-hook *command-hook*))


(set-comtab *zmacs-comtab* () '(("3Electric Scribe Mode*" . com-electric-scribe-mode)))


(defprop 4scribe-mode*-hook 10 COMMAND-HOOK-PRIORITY) ;1 Same priority as (Lisp mode) Electric Font Lock.*




;1;;*
;1;; Taken from the 7SCRIBE Database Administrator's Guide8, April 1985**.*
;1;;*
(defvar *scribe-command-names*
	'("3bar*" "3begin*" "3bibform*" "3bibliography*" "3blankpage*" "3blankspace*" "3case*" "3cite*" "3citemark*" "3commandstring*"
	  "3counter*" "3declare*" "3define*" "3definefont*" "3definehyphenationdictionaries*" "3definehyphenationdictionary*"
	  "3definerawfont*" "3definespectrum*" "3definetypecase*" "3device*" "3disable*" "3end*" "3equate*" "3expand*"
	  "3fontfamily*" "3form*" "3generate*" "3goto*" "3graphic*" "3hinge*" "3hpos*" "3hsp*" "3imbed*" "3include*" "3index*"
	  "3indexentry*" "3itag*" "3label*" "3libraryfile*" "3localstring*" "3make*" "3markbaseline*" "3marker*" "3mathbar*"
	  "3message*" "3modify*" "3newcolumn*" "3newpage*" "3noop*" "3pagefooting*" "3pageheading*" "3pageref*" "3parm*" "3parmquote*"
	  "3parmref*" "3parmset*" "3parmvalue*" "3picture*" "3place*" "3process*" "3quote*" "3rawfontdirectory*" "3rawfontlocation*"
	  "3ref*" "3refstr*" "3rmstr*" "3send*" "3sendend*" "3set*" "3site*" "3space*" "3specialfont*" "3string*" "3style*" "3tabclear*"
	  "3tabdivide*" "3tabset*" "3tag*" "3textform*" "3title*" "3titlepage*" "3unnumbered*" "3use*" "3value*")
  "2The names of all of the Scribe commands, that is, the Scribe directives which are not Environments.
  6Elements of this list must be lower-case*.*")


(defun 4scribe-mode-hook* (char)
  "2The command-hook for twiddling the font in accordance with Electric Scribe Mode.*"
  (unless (eq *interval* (window-interval *mini-buffer-window*))
    (let (in-directive-p
	  directive-name
	  directive-name-start-bp
	  directive-name-end-bp
	  (point (point))
	  (new-font *font*)
	  (paren-p       (position (the character char) "([{<" :test #'char=))
	  (close-paren-p (position (the character char) ")]}>" :test #'char=))
	  
	  (initial-open-paren-about-to-be-typed-p nil)
	  )
      (cond ((char= char #\@)
	     ;1; At-Signs are always bold; even the second in an 5@@* sequence.*
	     (setq directive-name "" in-directive-p t))
	    (t
	     (multiple-value-setq (in-directive-p directive-name directive-name-start-bp directive-name-end-bp)
				  (scribe-bp-syntactic-context point))
	     ;1;*
	     ;1; If point is in the directive name, and the character being typed is an open paren, then we should consider*
	     ;1; point to be in the argument-part of the command; this assumes that the open-paren characters are bound*
	     ;1; to 5self-insert*, a not-so-bad assumption.*
	     ;1;*
	     (when (and in-directive-p paren-p)
	       (setq in-directive-p nil
		     initial-open-paren-about-to-be-typed-p t))))
      
      (let* ((nfonts (length (window-font-alist *window*))))
	(setq new-font
	      (cond ((null directive-name) 0)
		    
		    ;1; If there are no fonts declared, see if fonts should be used anyway.*
		    ((and (null *electric-font-lock-if-no-fonts-declared-p*)
			  (zerop nfonts))
		     0)
		    
		    (in-directive-p (min nfonts 1))
		    
		    (t
		     ;1; If we are in the arguments-part of a directive, then the font is set to font C if the directive is a command,*
		     ;1; and is set to font A if the directive is an environment.*
		     ;1;*
		     ;1; If the character being typed is the first open-paren after the directive-name, then it goes in font B.*
		     ;1; If the character being typed is a close-paren, and it matches the open-paren immediately after the directive-name,*
		     ;1; then it also goes in font B.*
		     ;1;*
		     (let* ((command-p (member (the string directive-name)
					       (the list *scribe-command-names*) :test #'string=)))
		       (cond (command-p  (min nfonts 2))
			     (initial-open-paren-about-to-be-typed-p (min nfonts 1))
			     (close-paren-p
			      (let* ((char-after-directive (bp-char directive-name-end-bp))
				     (which-paren (position (the character char-after-directive) "([{<" :test #'char-equal))
				     (parens-match (eql which-paren close-paren-p))
				     (parens-balance (and parens-match
							  (scribe-syntax-bind
							    (close-paren-would-balance directive-name-end-bp point)))))
				(if parens-balance
				    (min nfonts 1)
				    0)))
			     (t 0)))))))
      
      (unless (= *font* new-font)
	(setq *font* new-font)
	(update-font-name)))))


(defun close-paren-would-balance4 *(start-bp end-bp)
  "2T if a close-paren inserted at END-BP would make the two BPs delimit one and only one list.*"
  (unless (bp-< end-bp start-bp)
    (let* ((*interval* (make-interval start-bp end-bp))
	   (depth 0)
	   bp)
      (loop
	(cond ((setq bp (forward-list start-bp 1 nil -1 t t))
	       (incf depth))
	      ((setq bp (forward-list start-bp 1 nil 0 nil t))
	       (decf depth))
	      ((setq bp (forward-list start-bp 1 nil 1 nil t))
	       (decf depth))
	      (t (return)))
	  (setq start-bp bp))
      (= depth 1))))



;1;;*
;1;; These next two variables might not be necessary.*
;1;; If we make the assumption that things like FORWARD-SCRIBE-ATOM will be called only when the buffer is in Scribe Mode,*
;1;; then we know that the syntax tables are already set up properly.  That assumption would let us remove the duplicated code*
;1;; in the 5defminor*.*

(defvar 4*scribe-atom-word-syntax-table* *(let* ((table (make-sparse-syntax-table *atom-word-syntax-table*)))
					  (set-char-syntax WORD-DELIMITER  table  #\@)
					  (set-char-syntax WORD-DELIMITER  table  #\<)
					  (set-char-syntax WORD-DELIMITER  table  #\>)
					  (set-char-syntax WORD-DELIMITER  table  #\()
					  (set-char-syntax WORD-DELIMITER  table  #\))
					  (set-char-syntax WORD-DELIMITER  table  #\[)
					  (set-char-syntax WORD-DELIMITER  table  #\])
					  (set-char-syntax WORD-DELIMITER  table  #\{)
					  (set-char-syntax WORD-DELIMITER  table  #\})
  					  table)
2   *"2A syntax table for Scribe command names.  This is just like Atom Word Syntax Table, except that At-sign is Word Alphabetic.*")


(defvar 4*scribe-list-syntax-table* *     (let* ((table (make-sparse-syntax-table *list-syntax-table*)))
					  (set-char-syntax LIST-OPEN       table  #\()
					  (set-char-syntax LIST-OPEN       table  #\[)
					  (set-char-syntax LIST-OPEN       table  #\{)
					  (set-char-syntax LIST-OPEN       table  #\<)
					  (set-char-syntax LIST-CLOSE      table  #\))
					  (set-char-syntax LIST-CLOSE      table  #\})
					  (set-char-syntax LIST-CLOSE      table  #\])
					  (set-char-syntax LIST-CLOSE      table  #\>)
					  (set-char-syntax LIST-DELIMITER  table  #\")
					  (set-char-syntax LIST-ALPHABETIC table  #\#)
					  (set-char-syntax LIST-ALPHABETIC table  #\')
					  (set-char-syntax LIST-ALPHABETIC table  #\,)
					  (set-char-syntax LIST-ALPHABETIC table  #\/)
					  (set-char-syntax LIST-ALPHABETIC table  #\:)
					  (set-char-syntax LIST-DELIMITER  table  #\;)
					  (set-char-syntax LIST-SLASH      table  #\@)
					  (set-char-syntax LIST-ALPHABETIC table  #\`)
					  (set-char-syntax LIST-ALPHABETIC table  #\|)
					  table)
  "2A syntax table for Scribe command arglists.  This is just like List Syntax Table, except that the Lisp comment and
  string characters have been turned into List Alphabetic, and the braces and brackets have been made List Open and
 Close characters.*")


(defmacro 4scribe-syntax-bind *(&body body)
  "2Execute body using the Scribe syntax tables.*"
  `(let* ((*mode-word-syntax-table* *scribe-atom-word-syntax-table*)
	  (*mode-list-syntax-table* *scribe-list-syntax-table*))
     ,@body))


(defun 4forward-scribe-atom* (bp &optional (times 1) fixup-P)
  "2Return a bp which is forward across TIMES Scribe-atoms from BP.
TIMES negative means move backwards.
FIXUP-P non-NIL means if go past beginning or end return a bp
 to there; otherwise return NIL in that case.*"
  (scribe-syntax-bind (forward-word bp times fixup-p)))


(defun 4looking-at-scribe-directive-p *(point)
  "2If the word surrounding POINT is a scribe directive, returns a BP to the front of it, else NIL.*"
  (scribe-syntax-bind
    (let* ((bp-back (backward-over '(#\@) point))
	   (n-ats (count-chars bp-back point)))
      (cond ((zerop n-ats)
	     (when (or (char-equal #\@ (bp-char-before point))
		       (= (word-syntax (bp-char-before point)) WORD-ALPHABETIC))
	       (let* ((bp (copy-bp point)))
		 (unless (or (member (bp-char point) *whitespace-chars* :test #'char-equal)
			     (position (bp-char point) "([{<" :test #'char-equal))
		   (move-bp bp (forward-scribe-atom bp 1 t)))
		 (move-bp bp (forward-scribe-atom bp -1 t))	;1 BP is now pointing to the front of the current "word".*
		 (when (and (or (bp-= bp point)
				(bp-< bp point))
			    (char-equal (bp-char-before bp) #\@))   ;1 When the prev char is an atsign, we're in a directive.*
		   (cond ((not (alpha-char-p (bp-char bp)))	    ;1  - unless the first char of the word is not alphabetic;*
			  (when (bp-= point bp)			    ;1    in that case, we are only in the directive if we are before*
			    bp))				    ;1    that character.*
			 (t bp))))))
	     ((evenp n-ats) nil)
	     ((oddp n-ats) point)))))



(defun 4forward-list-with-limit *(bp limit-bp &optional (times 1) fixup-p (level 0) downp no-up-p)
  "2Just like Forward List, but will not go past LIMIT-BP.  
  LIMIT-BP is the forward limit if TIMES is positive, and the backwards limit if TIMES is negative.*"
  (let* ((forward-p (not (minusp times)))
	 (bp-1 (if forward-p
		   (interval-first-bp *interval*)
		   limit-bp))
	 (bp-2 (if forward-p
		   limit-bp
		   (interval-last-bp *interval*)))
	 (*interval* (make-interval bp-1 bp-2)))    ;1 use 5make-interval*, not 5create-interval* - we don't want to copy anything.*
    (forward-list bp times fixup-p level downp no-up-p)))



(defun 4scribe-bp-syntactic-context *(point)
  "2Returns the syntactic context of the point, as seen by Scribe.
   The first value, *IN-DIRECTIVE-P2 is *T2 if the point is within a Scribe directive,
     that is, within the directive word itself.
   If *IN-DIRECTIVE-P2 is NIL, and *DIRECTIVE-NAME2 is non-*NIL2, then that
     means that the point is in a following argument list.
   *DIRECTIVE-NAME2 is the name of the current directive, or *NIL2.

  The next two values are *BP2s pointing to the At-Sign of this directive, and the end
    of the command name;* 2given the first, you can calculate the second with
    *FORWARD-SCRIBE-ATOM2, but we have it handy here, so...*"
  
  (declare (values in-directive-p directive-name
		   directive-start-bp directive-name-end-bp))
  (scribe-syntax-bind
    (let* ((current-directive-start (forward-scribe-directive point -1)) ;1 This is a BP to the first Scribe directive before POINT.*
	   word-end)
      (cond (current-directive-start
	     (let* ((word-start (forward-char current-directive-start 1 t))  ;1 BP to just after the atsign.*
		    (first-char (bp-char word-start))
		    (name nil)
		    (in-directive-p t)
		    (punk-p nil))
	       ;1;*
	       ;1; Compute the name of the directive, and the BP pointing to the end of it.*
	       ;1;*
	       (cond ((alpha-char-p first-char)
		      ;1;*
		      ;1; If the first character after the atsign is alphabetic, then this is a normal directive.*
		      ;1;*
		      (setq punk-p nil
			    word-end (forward-scribe-atom word-start 1 t)
			    name (nstring-downcase (string-interval word-start word-end t t))))
		     (t
		1        *;1; Otherwise, this is a ``punctuation'' directive - the command name is one character long.*
		      ;1;*
		      (setq punk-p t
			    word-end (forward-char word-start 1 t)
			    name (string (make-char first-char)))))   ;1 Strip fonts from name-char.*
	       ;1;*
	       ;1; Determine the relation of POINT to the positions of the directive's name and arguments.*
	       ;1;*
	       (let* ((next-word-start (forward-over *whitespace-chars* word-end))
		      (next-word-args-p (position (bp-char next-word-start) "([{<" :test #'char-equal))
		      (end-of-args (and next-word-args-p
					(forward-list-with-limit next-word-start point 1 nil))))
		 
		 (cond ((and next-word-args-p end-of-args
			     (or (bp-< end-of-args point)
				 (bp-= end-of-args point)))
			;1; There is an args-list, and the point is 5after* it - that is, it is not really in the directive at all.*
			(setq name nil))
		       
		       ((and (not punk-p)
			     (not next-word-args-p)
			     (bp-< next-word-start point))
			;1; There are no arguments, and the point is after the previous directive's name and following whitespace -*
			;1; It is not really in the directive at all.*
			(setq name nil))
		       
		       ((and punk-p (not next-word-args-p))  ;1 A no-argument punctuation directive.*
			(unless (bp-= point word-start)
			  (setq name nil)))
		       
		       ((bp-< word-end point)
			;1; The point is after the directive word, but is in the directive, which means it is in the arguments.*
			(setq in-directive-p nil))
		       
		       (t
			;1; Otherwise it is in the directive's name.*
			(setq in-directive-p t))))
	       (if name
		   (values in-directive-p name current-directive-start word-end)
		   (values nil nil))))
	    (t (values nil nil))))))



(defun 4forward-scribe-directive *(bp &optional (times 1) (skip-arglists t) fixup-p)
  "2Return a bp which is forward across TIMES Scribe directives from BP.
If BP is within a directive, that is included in the count.
TIMES negative means move backwards.
FIXUP-P non-NIL means if go past beginning or end return a bp
 to there; otherwise return NIL in that case.*"
  
  (let* ((forward-p (plusp times))
	 result)
    (setq times (abs times))
    
    (block DONE
      (with-bp (bp bp :normal)
	(dotimes (j times)
	  (when (and (char-equal #\@ (bp-char bp))
		     (char-not-equal #\@ (bp-char-before bp)))
	    (move-bp bp (forward-char bp (if forward-p 1 -1) t)))
	  (when (and skip-arglists forward-p (looking-at-scribe-directive-p (point))
		     (alpha-char-p (bp-char bp)))
	    (unless (position (bp-char bp) "([{<" :test #'char-equal)
	      (move-bp bp (forward-scribe-atom bp 1 t)))
	    (move-bp bp (forward-list bp 1 t 0 nil t))
	    )
	  (move-bp bp (forward-char bp (if forward-p 1 -1) t))
	  (block ONE
	    (do* ((line (bp-line bp))
		  (first-line (bp-line (interval-first-bp *interval*)))
		  (last-line (bp-line (interval-last-bp *interval*)))
		  (last-index (bp-index (interval-last-bp *interval*)))
		  (i (bp-index bp)
		     (if forward-p
			 (1+ i)
			 (1- i))))
		 (())
	      (let ((length (line-length line)))
		(cond ((and (eq line last-line) (>= i last-index))
		       (return-from DONE (if fixup-p
					     (create-bp line last-index)
					     nil)))
		      
		      ((and (eq line first-line) (<= i 0))
		       (return-from DONE (if fixup-p
					     (create-bp first-line 0)
					     nil)))
		      
		      ((>= i length)
		       (setq line (line-next line)
			     i -1))
		      
		      ((minusp i)
		       (setq line (line-previous line)
			     i (1- (length line))))
		      (t
		       (let* ((c (aref line i)))
			 (move-bp bp line i)
			 (cond ((char-equal c #\@)
				;1; When we've found an atsign, count the atsigns before it.*
				;1; The "real" atsign is the one we are on only if there are an odd number of adjascent atsigns.*
				;1; If there are an even number, then the "real" atsign is the character before us.*
				(let* ((bp-back (backward-over '(#\@) bp))
				       (n-ats (1+ (count-chars bp-back bp))))  ;1; cannot be zero.*
				  (setq result (if (oddp n-ats)
						   bp
						   (forward-char bp -1)))
				  (return-from ONE result)
				  ))))))))))))
    result))



(defun 4scribe-directive-end *(point &optional (arglist-too t) fixup-p)
  "2If point is at the beginning of a Scribe directive, return a point at the end of the directive.*"
  (scribe-syntax-bind
    (cond ((and (char-equal #\@ (bp-char-before point))
		(not (alpha-char-p (bp-char point))))
	   (forward-char point))
	  
	  ((and (char-equal #\@ (bp-char point))
		(not (alpha-char-p (bp-char (forward-char point)))))
	   (forward-char point 2))
	  
	  (t
	   (let* ((start-bp (looking-at-scribe-directive-p point)))
	     (when (and (null start-bp) (char-equal #\@ (bp-char point)))
	       (setq start-bp point))
	     (when start-bp
	       (let* ((word-end-bp (forward-scribe-atom start-bp 1 fixup-p)))
		 (if arglist-too
		     (when word-end-bp
		       (if (and (= WORD-DELIMITER (word-syntax (bp-char word-end-bp)))
				(/= LIST-OPEN     (list-syntax (bp-char word-end-bp))))
			   word-end-bp
			   (forward-list word-end-bp 1 fixup-p)))
		     word-end-bp))))))))



(defcom 4com-scribe-fontify-region-or-buffer*
	"2Fontify the region or buffer according to the rules of Electric Scribe Mode.
  This changes the fonts of Scribe directives only; font information in the region which is not 
  within a Scribe directive is untouched.*"
	()
  (let* (bp1 bp2)
    (cond ((window-mark-p *window*)
	   (setq bp1 (point) bp2 (mark))
	   (when (bp-< bp2 bp1) (rotatef bp1 bp2)))
	  (t
	   (setq bp1 (interval-first-bp *interval*)
		 bp2 (interval-last-bp *interval*))))
    (with-undo-save ("3Fontification*" (copy-bp bp1) (copy-bp bp2))
      (let* ((nfonts (length (window-font-alist *window*)))
	     (bp bp1))
	(loop
	  (setq bp (search bp "3@*" nil nil nil bp2))
	  (when (or (null bp) (bp-< bp2 bp)) (return))
	  
	  (multiple-value-bind (ignore name name-start-bp name-end-bp) (scribe-bp-syntactic-context bp)
	    (when (bp-< bp2 name-end-bp) (setq name-end-bp bp2))
	    (let* ((directive-end-bp (scribe-directive-end name-start-bp t))
		   (command-p (member (the string name) (the list *scribe-command-names*) :test #'string=)))
	      (unless directive-end-bp (barf "3Unbalanced parentheses.*"))
	      ;1;*
	      ;1; Change the font of the directive name.*
	      ;1;*
	      (change-font-interval name-start-bp name-end-bp t (min nfonts 1))
	      
	      (cond (command-p
		     ;1; *Change the font of the arglist, if this is a command.
		     ;1;*
		     (when (bp-< bp2 directive-end-bp) (setq directive-end-bp bp2))
		     (change-font-interval name-end-bp directive-end-bp t (min nfonts 2)))
		    
		    ((and (alpha-char-p (bp-char-before name-end-bp))
			  (position (bp-char name-end-bp) "([{<" :test #'char-equal))
		     ;1;*
		     ;1; If this is a short-form environment, and not a punctuation-directive, then fontify the parens as well.*
		     ;1;*
		     (setf (char (bp-line name-end-bp) (bp-index name-end-bp))
			   (make-char (bp-char name-end-bp) 0 (min nfonts 1)))
		     (setf (char (bp-line directive-end-bp) (1- (bp-index directive-end-bp)))
			   (make-char (bp-char-before directive-end-bp) 0 (min nfonts 1)))
		     ))
	      (if command-p
		  (setq bp directive-end-bp)
		  (setq bp name-end-bp))     ;1 not directive-end - we want to move down into the list of an environment.*
	      ))))))
  DIS-TEXT)
