;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:TV; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B HL12I) -*-

;1;; File "*SCREENSAVER-PATCHES1"*
;1;; Some fixes to the screensaver from 3SYS:PUBLIC;SCREEN-SAVER-MIT*, making it work on a color system (and be better all around).*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;   29 Dec 88*	1Jamie Zawinski*	1Created.*
;1;;    6 Feb 89*	1Jamie Zawinski*	1Redefined 5screen-saver* to work with Dual Monitor Mode; moved things that we had been doing*
;1;;*				1 5:before :expose* on the blackout-screen-window to 5screen-saver*.*
;1;;    9 Feb 89*	1Jamie Zawinski*	1Made the 5screen-saver* function tell you how long the console was idle if it is sending a notification*
;1;;*				1 about how many pending notifications there are.*
;1;;   15 Apr 89*	1Jamie Zawinski*	1Cleaned up.*
;1;;   20 Apr 89*	1Jamie Zawinski*	1Made the ScreenSaver not come on every time you warm-boot!*
;1;;  19 May 89*	1Jamie Zawinski*	1Added a 5:user-activity-string* method so that 5finger* still works if the ScreenSaver is on.*
;1;;   27 Jul 89*	1Jamie Zawinski*	1Added 5Rorschach*, based on code from Peter Norvig.*
;1;;  10 Aug 89*	1Jamie Zawinski*	1Made Terminal-Space turn on the screensaver.*
;1;;  24 Aug 89*	1Jamie Zawinski *	1Made the 5:mouse-moves* method only stuff a zero if the mouse has really moved.*
;1;;*				1We were having problems with the screensaver turning off when notifications came in...*
;1;;* 1 14 Sep 89*	1Jamie Zawinski*	1Added Rel*-16 compatibility - the name of 5:screen-descriptor* had changed to 5:screens-who-line-screen**.
;1;;*   13 Oct 89*	1Jamie Zawinski *	1Added a better definition of 5:user-activity-string*.*
;1;;*   12 Dec 89*	1Jamie Zawinski *	1Made the Blackout-Screen-Window be 5:deactivate*d instead of 5:deexpose*d, in case there are no active*
;1;;*				1 windows on screen (as can happen when using the KSL desktop).*
;1;;*				1Made the clock-function-list entry 5schedule-screen-saver* not be added if we have the 5timer-queue* code.*
;1;;*				1Moved 5Rorschach* and 5Spline* to their own files.*
;1;;*  110 Jan 90*	1Jamie Zawinski *	1Made 5Terminal-Space* take arguments.*
;1;;*


(unless (boundp 'tv:*screen-saver-hacks-list*)
  (error "3This file must be loaded *after* the screensaver in SYS:PUBLIC;SCREEN-SAVER-MIT.LISP#>*"))



;1;; A fix to5 BALLS* to work with color.*
;1;;*
;1;; It looks like *SI:%DRAW-SHADED-RASTER-LINE1 doesn't do the same thing on 1 bitplane bitmaps*
;1;; and 8 bitplane bitmaps - looks like it was treating the 8-plane as a 1-plane, and getting skewed.*
;1;;*

(defun 4create-ball* (center-x center-y array &optional (color -1))
  (fill array 0)
  (let ((radius *ball-radius*))
    (do ((y 0)
         (f 0)             ;1 F is just Y squared without any multiplies*
         (x radius)
         (last-x radius))
        (nil)
      (dotimes (i (* 2 x))
	(setf (aref array (- center-y y) (+ center-x i (- x))) color))
      ;1; Draw the middle line only once.*
      (unless (zerop y)
	(dotimes (i (* 2 x))
	  (setf (aref array (+ center-y y) (+ center-x i (- x))) color)))
      ;1; Handle pixel errors by only drawing this upper/lower part once.*
      (when (not (= x last-x))
	(dotimes (i (* 2 y))
	  (setf (aref array (- center-y x) (+ center-x i (- y))) color)
	  (setf (aref array (+ center-y x) (+ center-x i (- y))) color)))
      (setq last-x x)
      (setq f (+ f y y 1)
            y (1+ y))
      (cond ((>= f x) (setq f (- f x x -1)
                            x (- x 1))))
      (cond ((> y x) (return)))
      (cond ((= y x) (return))))))



;1;; A fix to5 TWINKLE* to work with color.*
;1;;*
;1;; It was making the age-old assumption that 0 is the background color.*
;1;;*

(defun 4draw-twinkle* (width height x y alu window)
  (declare (ignore height))
  ;1; Be nice to the window by not writing into its margins.*
  (when (>= (+ x width) (tv:sheet-inside-right window))
    (setq x (- (tv:sheet-inside-right window) width 1)))
  (when (>= (+ y width) (tv:sheet-inside-bottom window))
    (setq y (- (tv:sheet-inside-bottom window) width 1)))
  (when (<= x (tv:sheet-inside-left window))
    (setq x (tv:sheet-inside-left window)))
  (when (<= y (tv:sheet-inside-top window))
    (setq y (tv:sheet-inside-top window)))
  ;1;*
  ;1; hack - when they say *ZERO1, they really mean *BACKGROUND1.*
  ;1;*
  (when (= alu tv:alu-setz) (setq alu (tv:sheet-erase-aluf window)))
  
  ;1; Copy the selected circle to the window.*
  (let* ((array (aref twinkles (truncate width 2))))
    (when array
      (bitblt alu (+ 1 width) (+ 1 width) array 0 0 (w:sheet-screen-array window) x y))))



;1;; A fix to5 GLOBE* to make it work with color, and to not be so silly all around.*


;1;; Modified this function to draw into a 1-bitplane array instead of onto a window.*
;1;;*
(defun globe-line (lat1 long1 lat2 long2)
  (declare (special globe-array))
  (let* ((p1 (globe-point lat1 long1))
	 (p2 (globe-point lat2 long2))
	 (xoff (- xc (floor globe-size 2)))
	 (yoff (- yc (floor globe-size 2))))
    (when (and p1 p2)
      (sys:%draw-line (- (car p1) xoff) (- (cdr p1) yoff) (- (car p2) xoff) (- (cdr p2) yoff) tv:alu-seta t globe-array)
      )))


;1;; Modified this function to not deal with windows at all - instead, it binds a special variable to the array,*
;1;; and *GLOBE-LINE1 draws directly into that.*
;1;; *
(defun build (&optional (lat -1.5) (long 2.0))
  (let* ((array (make-array 10)))
    (SinCosTables)
    (dotimes (delta (length array))
      (let* ((globe-array (make-array (list globe-size globe-size) :element-type 'bit)))
	(declare (special globe-array))
	(set-matrix lat long)
	(globe delta 0)
	(setf (aref array delta) globe-array)))
    (setq globe-pix array)))


;1;; Modified this function to not reference* TV:MAIN-SCREEN1 or* GLOBE-WINDOW, 1but instead to use the window passed in. (imagine that!)*
;1;;*
(defun raw-show (&optional (window *terminal-io*)
		 &aux
		(x 0) (y 0) (spin t) phi
		(dx 1701) (dy 0)
		(grav 11) (scr (send window :screen-array))
		xmax ymax)
  (setq xmax (* 4096 (- (array-dimension scr 1) globe-size)))
  (setq ymax (* 4096 (- (array-dimension scr 0) globe-size)))
  (send window :clear-screen)
  (loop
    (loop for delta from 0 below (length globe-pix) do
	  (tv:prepare-sheet (window)
	    (if spin
		(setq phi delta)
		(setq phi (- (1- (length globe-pix)) delta)))
	    (bitblt TV:ALU-SETA globe-size globe-size (aref globe-pix phi)
		    0 0 scr (truncate x 4096) (truncate y 4096)))
	  
	  (when (>= (setq x (+ x dx)) xmax)
	    (setq x (- x dx dx))
	    (setq spin (>= dy 0))
	    (setq dx (- dx)))
	  (when (< x 0)
	    (setq x (- x dx dx))
	    (setq spin (< dy 0))
	    (setq dx (- dx)))
	  (when (>= (setq y (+ y dy)) ymax)
	    (setq y (- y (* 2 dy)))
	    (setq dy (- dy)))
	  (setq dy (+ dy grav))
	  (when (< y 0)
	    (setq y 0)
	    (setq dy 0)))))



;;; The 5GLOBE, checkered*.


(defvar *checkered-globe-pix* nil)


(defun checker-globe-line (lat1 long1 lat2 long2)
  (declare (special globe-array))
  (let* ((p1 (globe-point lat1 long1))
	 (p2 (globe-point lat2 long2))
	 (p3 (globe-point (+ 10 lat1) long1))
	 (p4 (globe-point (+ 10 lat2) long2))
	 (xoff (- xc (floor globe-size 2)))
	 (yoff (- yc (floor globe-size 2))))
    (cond ((and p1 p2 p3 p4)
	   (sys:%draw-shaded-triangle (- (car p1) xoff) (- (cdr p1) yoff)
				      (- (car p2) xoff) (- (cdr p2) yoff)
				      (- (car p3) xoff) (- (cdr p3) yoff)
				      tv:alu-seta t t t nil globe-array)
	   (sys:%draw-shaded-triangle (- (car p4) xoff) (- (cdr p4) yoff)
				      (- (car p2) xoff) (- (cdr p2) yoff)
				      (- (car p3) xoff) (- (cdr p3) yoff)
				      tv:alu-seta t t t nil globe-array)
	   t)
	  ((and p1 p2)
	   (sys:%draw-line (- (car p1) xoff) (- (cdr p1) yoff) (- (car p2) xoff) (- (cdr p2) yoff)
			   tv:alu-seta t globe-array)
	   nil)
	  ((and p3 p4)
	   (sys:%draw-line (- (car p3) xoff) (- (cdr p3) yoff) (- (car p4) xoff) (- (cdr p4) yoff)
			   tv:alu-seta t globe-array)
	   nil)
	  ((and p1 p3)
	   (sys:%draw-line (- (car p1) xoff) (- (cdr p1) yoff) (- (car p3) xoff) (- (cdr p3) yoff)
			   tv:alu-seta t globe-array)
	   nil)
	  ((and p2 p4)
	   (sys:%draw-line (- (car p2) xoff) (- (cdr p2) yoff) (- (car p4) xoff) (- (cdr p4) yoff)
			   tv:alu-seta t globe-array)
	   nil)
	  (t nil))))


(defun checker-globe (xlat xlong &optional (latstep 10) (longstep 10))
  (dotimes (i (floor 360 latstep))
    (let* ((rlat (* i latstep))
	   (lat (rem (+ xlat rlat) 360)))
      (globe-line lat longstep xlat xlong)))
  (dotimes (i (floor 180 longstep))
    (let* ((rlong (* (1+ i) longstep))
	   (long (rem (+ xlong rlong) 360)))
      (dotimes (j (floor 360 latstep))
	(let* ((rlat (* j latstep))
	       (lat (rem (+ xlat rlat) 360)))
	  (unless (and (or (and (oddp i) (oddp j))
			   (and (evenp i) (evenp j)))
		       (checker-globe-line lat long lat (- long longstep)))
	    (globe-line lat long (+ lat latstep) long)
	    (globe-line lat long lat (- long longstep))
	    )))))
  (dotimes (i (floor 360 latstep))
    (let* ((rlat (* i latstep))
	   (lat (rem (+ xlat rlat) 360)))
      (globe-line lat (- (+ xlong 180) longstep) xlat (+ xlong 180)))))


(defun checkered-build (&optional (lat -1.5) (long 2.0))
  (let* ((array (make-array 20)))
    (SinCosTables)
    (dotimes (delta (length array))
      (let* ((globe-array (make-array (list globe-size globe-size) :element-type 'bit)))
	(declare (special globe-array))
	(set-matrix lat long)
	(checker-globe delta 0)
	(setf (aref array delta) globe-array)))
    (setq *checkered-globe-pix* array)))



(defun rotate-checkered-sphere (&optional (window *terminal-io*) (lat -1.0) (long 2.5))
  (when (null *checkered-globe-pix*)
    (checkered-build lat long)
    (send window :clear-screen))
  (let* ((colors '#,(list W:50%-GRAY-COLOR W:PINK W:CYAN W:MAGENTA W:YELLOW W:GREEN W:ORANGE W:LIGHT-BROWN W:RED-PURPLE))
	 (color (nth (random (length colors)) colors)))
    (tv:prepare-color (window color)
      (let* ((globe-pix *checkered-globe-pix*))
	(declare (special globe-pix))
	(raw-show window)))))


(pushnew 'rotate-checkered-sphere *screen-saver-hacks-list*)



;1;; Making5 ATTRACTION* work with color.*
;1;; Again, it was using *SETA1 and* SETZ1 instead of* TRANSP1 and* BACK1.*
;1;;*
;1;; Made the balls be color.*
;1;;*


(defvar 4*orb-balls-colors** (list W:WHITE W:RED W:GREEN W:BLUE W:YELLOW W:BLUE-GREEN W:PINK W:PURPLE W:PINK W:MAGENTA)
  "2The colors that the ATTRACTION balls will be rendered in if using a color monitor.*")


;1;; This used to be done with a* MACROLET1, can you imagine that??  And the representation of balls was as* LIST1s.*
;1;; Changing it to a defstruct5 not only* makes it easier to understand, it also speeds it up!*
;1;;*
(defstruct 4(attraction-ball *(:conc-name orb-))
  (x-acc 0.0s0 :type short-float)
  (y-acc 0.0s0 :type short-float)
  (x-vel 0.0s0 :type short-float)
  (y-vel 0.0s0 :type short-float)
  (x-pos 0.0s0 :type short-float)
  (y-pos 0.0s0 :type short-float)
  (mass  0.0s0 :type short-float)
  (size  0     :type fixnum)
  (char  99    :type fixnum)
  )
  

(defun 4attraction* (&optional (window *terminal-io*) (length default-orb-length) (times nil)
		   (max-size 16))
  "2Non-consing ATTRACTION.*"

  (macrolet ((orb-x-pix (orb xlim) `(min ,xlim (max 0 (floor (+ (/ ,xlim 2.0s0) (orb-x-pos ,orb))))))
	     (orb-y-pix (orb ylim) `(min ,ylim (max 0 (floor (+ (/ ,ylim 2.0s0) (orb-y-pos ,orb)))))))
    
  (multiple-value-bind (xlim ylim) (send window :inside-size)
    
    (let* ((xlim/2 (ash xlim -1))
	   (ylim/2 (ash ylim -1))
	   (-xlim/2 (* -1.0s0 xlim/2))
	   (-ylim/2 (* -1.0s0 ylim/2))
	   (2pi (* 2.0s0 (float pi 1.0s0))))
      
      (let* ((diameter (- (min xlim/2 ylim/2) 50))
	     (erase-alu (send window :erase-aluf))
	     list)
	(unless (and orb-list (= length orb-list-length))
	  (setq orb-list-length length
		orb-list (make-list orb-list-length))
	  (dotimes (n length)
	    (setf (nth n orb-list) (make-attraction-ball))))
	(setq list orb-list)
	(dotimes (n length)
	  (let ((new-size (min max-size (+ 8 (random (- max-size 9)))))
		(orb (nth n orb-list)))
	    (setf (orb-x-acc orb) 0.0s0
		  (orb-y-acc orb) 0.0s0
		  (orb-x-vel orb) (/ (- 6.0s0 (random 11)) 8.0s0)
		  (orb-y-vel orb) (/ (- 6.0s0 (random 11)) 8.0s0)
		  (orb-x-pos orb) (* diameter (cos (* n (/ 2pi length))))
		  (orb-y-pos orb) (* diameter (sin (* n (/ 2pi length))))
		  (orb-mass orb) (* new-size new-size 10.0s0)
		  (orb-size orb) new-size
		  (orb-char orb) 99  ;1  *(or (nth (- new-size 8) '(98 100 101 102 26 99 37)) 37)
		  )))
	
	(send window :clear-screen)

	(loop UNTIL (if times (= (setf times (1- times)) 0) nil)
	      DO
	      (dotimes (l length)
		;1; calculate attraction of this orb to the other orbs, this will set the x-acc and y-acc.*
		(let ((new-x-acc 0.0s0) (new-y-acc 0.0s0)
		      (orb (nth l list)))
		  (dotimes (ll length)
		    (let ((other-orb (nth ll list)))
		      (if (not (eq orb other-orb))	;1 don't do it to yourself !!!*
			  (let* ((x-dist (- (orb-x-pos other-orb) (orb-x-pos orb)))
				 (y-dist (- (orb-y-pos other-orb) (orb-y-pos orb)))
				 (dist^2 (+ (* x-dist x-dist)
					    (* y-dist y-dist)))
				 (dist (sqrt dist^2))
				 (new-acc 0.0s0)
				 (new-acc/dist 0.0s0))
			    (cond ((> dist 0.1s0)
				   (setq new-acc (* (/ (orb-mass other-orb) dist^2)
						    (cond ((< dist 100.0s0) -1.0s0)
							1 *;1 *((< dist 3.0s0)   -10.0s0)
							1 *;1 *((< dist 1.0s0)   -100.0s0)
							  (t 1.0s0))))
				   (setq new-acc/dist (/ new-acc dist))
				   (incf new-x-acc (* new-acc/dist x-dist))
				   (incf new-y-acc (* new-acc/dist y-dist)))
				  (t
				   (incf new-x-acc (- 5.0s0 (random 10.0s0)))
				   (incf new-y-acc (- 5.0s0 (random 10.0s0)))))))))
		  (setf (orb-x-acc orb) new-x-acc)
		  (setf (orb-y-acc orb) new-y-acc)))
	      
	      (dotimes (l length)
		(let* ((orb (nth l list))
		       (old-x-pix (orb-x-pix orb xlim))
		       (old-y-pix (orb-y-pix orb ylim))
		       (new-x-pix 0)
		       (new-y-pix 0)
		       (orb-size (orb-size orb)))
		  
		  ;1; set the new velocities*
		  (incf (orb-x-vel orb) (orb-x-acc orb))
		  (incf (orb-y-vel orb) (orb-y-acc orb))
		  
		  ;1; make sure that if things get too fast, they slow down!*
		  (when (< 10.0s0 (abs (orb-x-vel orb)))
		    (setf (orb-x-vel orb) (* (orb-x-vel orb) 0.9s0))
		    (setf (orb-x-acc orb) 0.0s0))
		  (when (< 10.0s0 (abs (orb-y-vel orb)))
		    (setf (orb-y-vel orb) (* (orb-y-vel orb) 0.9s0))
		    (setf (orb-y-acc orb) 0.0s0))
		  
		  ;1; set the new positions*
		  (incf (orb-x-pos orb) (orb-x-vel orb))
		  (incf (orb-y-pos orb) (orb-y-vel orb))
		  
		  ;1; check for maximum position in x direction*
		  (cond ((<= (- xlim/2 max-size 4) (orb-x-pos orb))
			 (setf (orb-x-pos orb) (- xlim/2 max-size 5))
			 (setf (orb-x-vel orb) (- (max 0.1s0 (abs (orb-x-vel orb))))))
			((>= (+ -xlim/2 1) (orb-x-pos orb))
			 (setf (orb-x-pos orb) (+ -xlim/2 2))
			 (setf (orb-x-vel orb) (max 0.1s0 (abs (orb-x-vel orb))))))
		  
		  ;1; check for maximum position in y direction*
		  (cond ((<= (- ylim/2 max-size 4) (orb-y-pos orb))
			 (setf (orb-y-pos orb) (- ylim/2 max-size 5))
			 (setf (orb-y-vel orb) (- (max 0.1s0 (abs (orb-y-vel orb))))))
			((>= (+ -ylim/2 1) (orb-y-pos orb))
			 (setf (orb-y-pos orb) (+ -ylim/2 2))
			 (setf (orb-y-vel orb) (max 0.1s0 (abs (orb-y-vel orb))))))
		  
		  ;1; calculate the new pixel position*
		  (setq new-x-pix (orb-x-pix orb xlim))
		  (setq new-y-pix (orb-y-pix orb ylim))

		  (let* ((colors *orb-balls-colors*)
			 (color (when (and colors (w:color-system-p window))
				  (nth (mod l (length colors)) colors)))
			 (char (orb-char orb)))
		    (tv:prepare-color (window color)
		      (tv:prepare-sheet (window)
			(sys:%draw-character orb-font char (+ 4 orb-size) old-x-pix old-y-pix erase-alu window)
			(sys:%draw-character orb-font char (+ 4 orb-size) new-x-pix new-y-pix TV:ALU-TRANSP window)
			)))))))))))



;1;;; Making5 QIX* be pretty in color.*


(defun qix (&optional (length 100) (stream *terminal-io*) (times NIL) (bottom-color 32) (top-color 126))
  "2Non-consing QIX.
  If on a color monitor, the color of the lines will oscillate between *BOTTOM-COLOR2 and* TOP-COLOR2.
  The default values were chosen because, in the standard color map, there are several color ramps there.*"
  
  (let* ((list (if (and qix-list (<= (1+ length) qix-list-length))
		    qix-list
		    (progn
		      (setq qix-list-length length
			    qix-list (make-list (1+ qix-list-length)))
		      ;; Make history a circular list.
		      (si:%p-store-cdr-code (cdr (nthcdr (1- length) qix-list)) cdr-error)
		      (si:%p-store-cdr-code (nthcdr (1- length) qix-list) cdr-normal)
		      (rplacd (nthcdr (1- length) qix-list) qix-list)
		      (loop repeat length
			    for h = (nthcdr (1- length) qix-list) then (cdr h)
			    do (setf (car h) (make-list 4)))
		      qix-list)))
	  (history (nthcdr (1- length) list))
	  (draw-aluf TV:ALU-SETA)
	  (erase-aluf (send stream :erase-aluf))
	  (color-p (tv:color-system-p stream))
	  (color-going-up t)
	  (color bottom-color))
    
     (send stream :clear-screen)
     (multiple-value-bind (xlim ylim) (send stream :inside-size)
       
       (loop with x1 = (random xlim)
	     and y1 = (random ylim)
	     and x2 = (random xlim)
	     and y2 = (random ylim)
	     and dx1 = 5
	     and dy1 = 12
	     and dx2 = 12
	     and dy2 = 5
	     with tem
	     until (if times (= (setf times (1- times)) 0) NIL)
	     when (caar history)
	     do (prepare-sheet (stream)
		  (sys:%draw-line
		    (first (car history)) (second (car history))
		    (third (car history)) (fourth (car history))
		    erase-aluf t stream))
	     do
	     (setf (first (car history)) x1)
	     (setf (second (car history)) y1)
	     (setf (third (car history)) x2)
	     (setf (fourth (car history)) y2)
	     (setf history (cdr history))

	     ;1;; let *COLOR1 oscillate between *BOTTOM-COLOR1 and* TOP-COLOR1 if we are on a color system.*
	     (when color-p
	       (if color-going-up
		   (if (>= color top-color)
		       (setq color-going-up nil)
		       (incf color))
		   (if (<= color bottom-color)
		       (setq color-going-up t)
		       (decf color))))

	     (tv:prepare-color (stream color)
	       (tv:prepare-sheet (stream)
		 (sys:%draw-line x1 y1 x2 y2 draw-aluf t stream)))
	     
	     (setf dx1 (1- (+ dx1 (random 3)))
		   dy1 (1- (+ dy1 (random 3)))
		   dx2 (1- (+ dx2 (random 3)))
		   dy2 (1- (+ dy2 (random 3))))
	     (cond ((> dx1 12) (setf dx1 12))
		   ((< dx1 -12) (setf dx1 -12)))
	     (cond ((> dy1 12) (setf dy1 12))
		   ((< dy1 -12) (setf dy1 -12)))
	     (cond ((> dx2 12) (setf dx2 12))	
		   ((< dx2 -12) (setf dx2 -12)))
	     (cond ((> dy2 12) (setf dy2 12))
		   ((< dy2 -12) (setf dy2 -12)))
	     (when (or (>= (setf tem (+ x1 dx1)) xlim) (minusp tem))
	       (setf dx1 (- dx1)))
	     (when (or (>= (setf tem (+ x2 dx2)) xlim) (minusp tem))
	       (setf dx2 (- dx2)))
	     (when (or (>= (setf tem (+ y1 dy1)) ylim) (minusp tem))
	       (setf dy1 (- dy1)))
	     (when (or (>= (setf tem (+ y2 dy2)) ylim) (minusp tem))
	       (setf dy2 (- dy2)))
	     (setf x1 (+ x1 dx1)
		   y1 (+ y1 dy1)
		   x2 (+ x2 dx2)
		   y2 (+ y2 dy2))
	     finally (loop repeat length
			   when (caar history)
			   do (prepare-sheet (stream)
				(sys:%draw-line
				  (first (car history)) (second (car history))
				  (third (car history)) (fourth (car history))
				  erase-aluf t stream))
			   do (setf history (cdr history))))))
  )


;1;;; Changes to the higher-up screensaver code for color.*


;1;; Rel4 and earlier had a different name for this method.*
;1;;*
(eval-when (load eval)
  (unless (send tv:default-screen :operation-handled-p :screens-who-line-screen)
    (fdefine '(:method tv:screen :screens-who-line-screen)
	     #'(:method tv:screen :screen-descriptor)
	     t nil))
  )

;1;; This is the function that controls the screen saving activity*
;1;;*
;1;;    1)  blank the screen [expose the blackout window]*
;1;;    2)  deexpose the who line*
;1;;    3)  kick off the activity process*
;1;;    4)  wait for user interaction*
;1;;    5)  kill off the activity process*
;1;;    6)  deexpose the blackout window*
;1;;    7)  notify user if notifications are pending.*
;1;;*
;1;; If we are using a color system interface board, and there is a color screen around, then:*
;1;;*
;1;;    0.5)  Expose the color screen, and make the blackout window's superior be that screen.*
;1;;    0.6)  Turn off the video signal to the monochrome monitor (if we're in dual-monitor mode).*
;1;;    6.5)  Turn monochrome video back on.*
;1;;    6.6)  Expose the previously exposed screen.*
;1;;*

(defvar *debugging-screen-saver* nil "2If this is non-NIL, then the screensaver won't tra*p2 the System key.*")

(defun screen-saver (&aux bow-mode screen-saver-hack-process)
  "2Black out the screen until a character is typed.*"
  (unless blackout-screen-window
    (setq blackout-screen-window (MAKE-INSTANCE 'blackout-screen-window)))

  ;1;; If you want the screen black, it's a good idea for the window to have a black background.*
  (send blackout-screen-window :set-foreground-color W:WHITE)
  (send blackout-screen-window :set-background-color W:BLACK)

  ;1; Disable the abort, system and other such keys*
  (let ((save-kbd-intercepted-characters kbd-intercepted-characters)
	(save-kbd-global-asynchronous-characters kbd-global-asynchronous-characters)
	(previously-exposed-screen tv:default-screen)
	(last-ut (get-universal-time))
	)
    (unwind-protect
	(progn
	  (setq inhibit-who-line t)
	  (set-fake-run-light)		   ;1; Lie to the scheduler about where the run-bar is*
	  (setq *the-screen-is-black* t)
	  (setq *screen-saver-time-delay-saved* nil)	;1 Don't need to remember this any more.*
	  (unless *debugging-screen-saver*
	    (setq kbd-intercepted-characters nil)
	    (setq kbd-global-asynchronous-characters nil))
	  (setq bow-mode *current-screen-color*)
	  ;1;*
	  ;1; Do things slightly differently if we're running with a CSIB.*
	  ;1; The blackout screen window always appears on the color screen.  (graphics hacks want color!!)*
	  ;1; The Video signal on the Monochrome monitor (that is, the one on the fiber-optic line) is turned off.  (totally unused.)*
	  ;1;*
	  (when (and TV:SIB-IS-CSIB w:*control-register*)
	    ;1;*
	    ;1; If the parent of the Blackout window is not color, then reparent the window.*
	    ;1;*
	    (unless (w:color-system-p blackout-screen-window)
	      (let* ((color-screen (find-if #'(lambda (w) (w:color-system-p w)) w:all-the-screens)))
		(when color-screen
		  (send blackout-screen-window :set-superior color-screen)
		  )))
	    (unless (tv:sheet-exposed-p (tv:sheet-get-screen blackout-screen-window))
	      (send (tv:sheet-get-screen blackout-screen-window) :expose))
	    ;1;*
	    ;1; Turn off the video on the monochrome monitor, if we're using the color screen.*
	    ;1; If there is a CSIB, but there are no color screens, then leave the monochrome video on, and run the ScreenSaver there.*
	    ;1;*
	    (when (w:color-system-p blackout-screen-window)
	      (send w:*control-register* :set-monochrome-blanking :off))
	    )
	  
	  (send blackout-screen-window :select)
	  (SEND blackout-screen-window :clear-input)
	  
	  (unless (send blackout-screen-window :lock)

	    (let* ((this-who-line-screen (send (tv:sheet-get-screen blackout-screen-window) :screens-who-line-screen)))
	1        *;1;*
	      ;1; Make the background of the wholine screen be black.*
	1        *;1; It's ok to not undo this, because the background color of the who line screen is totally irrelevant.*
	1        *;1; Since the screen is completely covered by subwindows, it is the color of the subwindows that is drawn during normal*
	1        *;1; operation - but when a* :CLEAR-SCREEN1 message is sent to the who line screen itself (which happens only in the*
	1        *;1; screen-saver), we want to erase it to black.*
	1        *;1;*
	      (send this-who-line-screen :set-background-color tv:black)
	      (send this-who-line-screen :clear-screen))
	    
	    (setf screen-saver-hack-process
		(process-run-function  '(:name "Screen-Saver-Hack" :priority -200 :quantum 10)
				      #'(lambda (w &aux (*terminal-io* w))
					  (send w :select)
					  (white-on-black)
					  (mouse-set-blinker-definition
					    :character 0 0 :off
					    :set-character mouse-glyph-small-dot)
					  (if *screen-saver-hacks*
					      (funcall (if (eq t *screen-saver-hacks*)
							   #'screen-saver-hacks
							    *screen-saver-hacks*)
						       w)
					      (process-wait "Blackout" #'(lambda () *screen-saver-hacks*))))
				      blackout-screen-window))
	    (sleep 1)
	    (send blackout-screen-window :clear-input)	;1 Do it here; sometimes the mouse-process is late sending *:MOUSE-MOVES1.*
	    (process-wait "Screen-Saver"
			  #'(lambda (w p)
			      (erase-real-run-bar) ;1;keep erasing the run bar: someone is writing it!*
			      (or (send w :mouse-or-kbd-tyi-no-hang)	;1 Char typed or mouse clicked/moved.*
				  (not *screen-saver-time-delay*)	;1 Screen Saver turned off.*
				  (not (send p :runnable-p))		;1 Process arrested, or has a ``More'' exception.*
				  ))
			  blackout-screen-window screen-saver-hack-process))
	  )
      ;1;*
      ;1; Do this first!  If these variables don't come back, we are hosed.*
      ;1;*
      (setq kbd-intercepted-characters save-kbd-intercepted-characters
	    kbd-global-asynchronous-characters save-kbd-global-asynchronous-characters
	    tv:kbd-last-activity-time (time:time)
	    inhibit-who-line nil)
      ;1;*
      ;1; Turn the monochrome video back on.*
      (when (and TV:SIB-IS-CSIB w:*control-register*)
	(send w:*control-register* :set-monochrome-blanking :on))
      ;1;*
      ;1; Refresh the wholine corresponding to the screen that the blackout window is under.*
      (let* ((this-who-line-screen (send (tv:sheet-get-screen blackout-screen-window) :screens-who-line-screen)))
	(send this-who-line-screen :refresh))
      
      (when screen-saver-hack-process
	(when bow-mode (black-on-white))
	(unless (send screen-saver-hack-process :arrest-reasons)
	  (send screen-saver-hack-process :arrest-reason :output-hold))	;1 Pause the process.*
	(send blackout-screen-window :deselect)
	(send screen-saver-hack-process :kill)
	(send screen-saver-hack-process :set-priority 1)		;1 Give it high priority so it can clean up after the* :kill1.*
	(send screen-saver-hack-process :revoke-arrest-reason :output-hold)	;1 Let it clean up now.*
	)
      (setq mouse-reconsider t)
      (send blackout-screen-window :deactivate)
      ;1;*
      ;1; If we've switched screens, make sure the old one is back.*
      (unless (tv:sheet-exposed-p previously-exposed-screen)
	(send previously-exposed-screen :expose))
      
      (SETQ *the-screen-is-black* nil)
      (setq sys:really-run-light real-run-bar-location)
      (when (and pending-notifications selected-window)
	(let* ((now (get-universal-time)))
	  (tv:notify nil
		3     *"3There ~[are~;is~:;are~] ~:*~d notification~:p pending.  Console was idle ~A (since ~A).~%~
                    Press TERM N to see notifications.*"
		      (length pending-notifications)
		      (time:print-interval-or-never (- now last-ut) nil)
		      (time:print-brief-universal-time last-ut nil)
		      )))
      )))


(let* ((old-mouse-x 0)
       (old-mouse-y 0))
  
  (defmethod 4(blackout-screen-window :mouse-moves)* (x y &rest ignore)
    "2If the new mouse position is not the same as the last mouse position, stuff a 0 on our input buffer.*"
    (unless (and (= x old-mouse-x) (= y old-mouse-y))
      (setq old-mouse-x x old-mouse-y y)
      (send self :force-kbd-input 0)))
  )


;1;; Information for FINGER.*
;1;;*
;1;;  It used to be that if you fingered a host whose screensaver was on, you got the 5"??User-Activity??" *status report.*
;1;;  This makes it tell you that the screensaver is on, and also give you the info about the obscured window.*
;1;;*

(defmethod 4(blackout-screen-window *:user-activity-string4)* ()
  (let* ((previously-selected-window (aref tv:previously-selected-windows 0)))
    (string-append "3[ScreenSaver] *"
		   (if (eq self previously-selected-window) ;1 This would be very bad.*
		       "3???*"
		       (let* ((tv:selected-window previously-selected-window))
			 (net:user-activity-string))))))



;1;; Making the ScreenSaver not automatically come on at warm-boot.*
;1;;*
;1;; Previously, the function *MAYBE-START-SCREENSAVER1 was called from an *:AFTER :UPDATE1 method of *WHO-LINE-FILE-SHEET1.*
;1;; The intention was that this function would be called regularly, (say every few seconds), without taking up the overhead of a process.*
;1;; *
;1;; The Scheduler updates the wholine once a second; but the wholine is also updated as a result of many window and file actions.*
;1;;*
;1;; When one warm- or cold-boots, for the duration of the bootup, the current time is incorrect.  This almost always means that the conditions*
;1;; necessary for the screen-saver to wake up are true.  The screen-saver is prevented from coming on during a cold-boot via initializations;*
;1;; it is disabled before a disk-save, and reenabled on cold-boot.  But, there is no way (that I can find) to determine that a warm-boot is in*
;1;; progress, and that the screensaver should not come on.*
;1;;*
;1;; What was happening is, the function *LISP-REINITIALIZE1, upon exposing the wholine screen, generated an *:UPDATE1 event.  This was*
;1;; happening very early on in the boot process.  And it seems to me to be very bad form to alter such a fundamental function to*
;1;; accomodate something so trivial as a screensaver...*
;1;;*
;1;; This problem is circumvented by the following: *MAYBE-START-SCREENSAVER1 is no longer called as a result of arbitrary updates of the*
;1;; wholine screen; it is only called from within the Scheduler.  Since the Scheduler is not actually running until the System Initialization List is*
;1;; run (at which point the time is correct), there will be no attempts to turn on the screensaver during a warm-boot.*
;1;;*
;1;; A function, *SCHEDULE-SCREEN-SAVER1, is added to the Clock Function List.  This function keeps a tick of the last time it was called in a*
;1;; private variable, and based on this, invokes *MAYBE-START-SCREEN-SAVER1 every three seconds.  Since things on the Clock Function List*
;1;; are called from within the Scheduler stack group, there is no more overhead than before.*
;1;;*
;1;; Of course, this is a non-issue if the timer-queue code is loaded.*
;1;;*


;1 Undefmethod-ing this caused problems - removing a method while the code is running...*
;(when (fdefinedp '(:method who-line-file-sheet :after :update))
;  (undefmethod (who-line-file-sheet :after :update)))		  ;1 Remove the hook that 3SCREEN-SAVER-MIT* added for update.*

(defmethod (who-line-file-sheet :after :update) ())		  ; Remove the hook that 3SCREEN-SAVER-MIT1 added for update.**


(let ((total-elapsed 0))
  (declare (fixnum total-elapsed))
  
  (defun schedule-screen-saver4 *(elapsed)
    "2  This is called from the Scheduler via the *CLOCK-FUNCTION-LIST2.
  *ELAPSED2 is the elapsed time in 60ths since the last time the *CLOCK-FUNCTION-LIST2 was run.
  Via a private variable, this function calls *MAYBE-START-SCREENSAVER2 every three seconds (or longer).*"
    (declare (fixnum elapsed))
    (unless *the-screen-is-black*
      (incf total-elapsed elapsed)
1        *(when (> total-elapsed 180) ;1 3 seconds.*
	(setq total-elapsed 0)
	(maybe-start-screen-saver)))
    nil)
  
  )

(unless (fboundp 'si:add-timer-queue-entry)
  (pushnew 'SCHEDULE-SCREEN-SAVER sys:clock-function-list)
  )


;1;; A better version of *RANDOM-SCREEN-SAVE-HACK1 - this one cycles the demos, instead of picking one and using that for n hours...*


(defvar 4*screen-saver-cycle-length** 10 "2Number of minutes that a given screensaver demo can run.*")

(defvar 4*last-hack-run** nil "2This is useful for debugging...*")

(defun 4random-screen-save-hack* (window)
  "2Selects a screen saver hack at random from the list of available ones.*"
  (loop
    ;1; Clear the wholine screen in case it has come back on somehow.*
    (send (send (tv:sheet-get-screen window) :screens-who-line-screen) :clear-screen)
    (with-timeout ((round (* 60 60 *screen-saver-cycle-length*)))
      (funcall (setq *last-hack-run* (nth (random (length *screen-saver-hacks-list*))
					  *screen-saver-hacks-list*))
	       window))))


(defun 4demo-screenhacks *()
  "2Demo each of the screenhacks in order.*"
  (dolist (hack *screen-saver-hacks-list* (values))
    (format t "3~&~A*" hack)
    (sleep 1)
    (let-globally ((*screen-saver-hacks-list* (list hack)))
      (screen-saver))))


;1;; A terminal key binding to turn the screensaver on.*

(defun 4screensaver-terminal-key *(numeric-argument)
  "2Turn on the screensaver now.
  With a numeric arg of 0, don't run any graphics demos from now on.
  With a numeric arg of 1, run random graphics demos from now on.*"
  (case numeric-argument
    (0 (setf tv:*screen-saver-hacks* nil))
    (1 (setf tv:*screen-saver-hacks* 'tv:random-screen-save-hack))
    (t nil))
  (process-run-function "3idler*"
    #'(lambda ()
	(cond ((null tv:*screen-saver-time-delay*)
	       (beep))
	      (t (sleep 1)
		 (setq tv:*the-screen-is-black* nil) ;1 In case something freaked.*
		 (process-wait "3keys up*" #'every #'zerop sys:kbd-key-state-array)
		 (setq tv:kbd-last-activity-time (- (time:time) (* 3600 tv:*screen-saver-time-delay*)))
		 (maybe-start-screen-saver)))
	nil)))


(w:add-terminal-key #\Space 'screensaver-terminal-key
  "2Make the system think the keyboard has been idle for long enough to turn on the ScreenSaver.
  Numeric arg = 0 means no graphics demos from now on; Numeric arg = 1 re-enables them.*")

;1;; Yeah, this doesn't belong here, so what.*
(w:add-system-key #\System '(aref tv:previously-selected-windows 0)
  "2Toggle between two most recently selected windows.*" nil nil "2Previous*")
