;;; -*- Mode:Common-Lisp; Package:SYSTEM; Base:10 -*-

;;; Defines the REBOOT function.

(export 'ticl::reboot 'ticl)

(defun ticl::reboot (&optional no-query)
  (cond ((or no-query
	     (yes-or-no-p "Shut down the system and reboot on the current band? "))
	 (system-shutdown :type :user :reason-string "Reboot" :return t)
	 (multiple-value-bind (name name-hi-16-bits name-lo-16-bits)
	     (disk-restore-decode *loaded-band*)
	   (format t "~&~%Booting on ~S (~S)..." name (partition-comment name *default-disk-unit*))
	   (%disk-restore name-hi-16-bits name-lo-16-bits (get-real-unit *default-disk-unit*))))
	(t
	 (format t "~&Well then eat me!~%")
	 (values))))
