;;; -*- Mode:Lisp; Package:TV; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B); Vsp:0; Syntax:Common-Lisp -*-

;1;; File "RAINBOW"*
;1;; Drawing rainbows.*
;1;; Written and maintained by Jamie Zawinski.*
;1;;*
;1;; ChangeLog:*
;1;;*
;1;;  4 Jan 89  Jamie Zawinski    Created.*
;1;;  6 Feb 89  Jamie Zawinski    Made it work in dual-monitor mode, though not in the cleanest way....  I don't understand cmaps well enough...*
;1;;*	1       *		1      *
;1;;*


(defun 4hsv-to-rgb* (hue saturation value)
  "2Convert HSV to RGB.
    H = [0,360]  S,V = [0.0,1.0]
    R,G,B = [0,255]*"

  (declare (values r g b))
  (let* (rred ggreen bblue)
    (if (= saturation 0)
	(setf rred value
	      ggreen value
	      bblue value) 
	(let* ((h (mod (/ hue 60) 6))
	       (h-integer (floor h))
	       (fract (- h h-integer))
	       (p (* (- 1.0 saturation) value))
	       (q (* (- 1.0 (* saturation fract)) value))
	       (tt (* (- 1.0 (* saturation (- 1.0 fract))) value)))
	  (multiple-value-setq (rred ggreen bblue)
	    (case h-integer
	      (0 (values value tt p))
	      (1 (values q value p))
	      (2 (values p value tt))
	      (3 (values p q value))
	      (4 (values tt p value))
	      (5 (values value p q))))))
    (values (round (* 255 rred))
	    (round (* 255 ggreen))
	    (round (* 255 bblue)))))


(defun 4rgb-to-hsv* (rr gg bb)  
  "2Convert RGB to HSV.
    R,G,B = [0,255]
    H = [0,360]  S,V = [0.0,1.0]*"

  (declare (values h s v))
  (let* ((rred (/ rr 255))
	 (ggreen (/ gg 255))
	 (bblue (/ bb 255))
	 (max-rgb (max rred ggreen bblue))
	 (min-rgb (min rred ggreen bblue))
	 (delta (- max-rgb min-rgb))
	 (value max-rgb)
	 (saturation (if (zerop max-rgb) 0 (/ delta max-rgb)))
	 (hue 360))
    (unless (= saturation 0)
      (let* ((rc (/ (- max-rgb rred) delta ))
	     (gc (/ (- max-rgb ggreen) delta ))
	     (bc (/ (- max-rgb bblue) delta )))
	(setq hue
	      (mod (* 60
		      (cond ((= max-rgb rred) (- bc gc))
			    ((= max-rgb ggreen) (- (+ 2 rc) bc))
			    ((= max-rgb bblue) (- (+ 4 gc) rc))
			    (t (error "max-rgb not equal to red, green or blue"))))
		   360))))
    (values (round hue) saturation value)))
 

;1;; Ok, it looks like setting the 5N*th and 5N(mod 128)*th slots of color maps are* EQ1 - setting 0 sets 127 and vice versa!!*
;1;; If this is the case, then WHY are there advertised to be 255 slots?*
;1;;*
(defun 4make-spectrum-colormap* (&optional cmap (saturation 0.7) (value 0.8) (ncolors 255))
  "2Fills a color map with a ramp through all colors with the given saturation and value.
  If CMAP is NIL, one is created and returned.*"
  (unless cmap (setq cmap (tv:make-color-map :name "Spectrum")))
  (let* ((scale (float (/ 360 ncolors))))
    (dotimes (i (1+ ncolors))
      (let* ((h (float (* i scale)))
	     (s saturation)
	     (v value)
	     )
	(multiple-value-bind (r g b) (hsv-to-rgb h s v)
	  (tv:write-color-map cmap i r g b))))
    cmap))


(defun 4fill-rasters* (window &optional (thickness 1) (offset 0) (ncolors 255))
  "2Draw solid horizontal lines on WINDOW, each successive line of an incremented color.
  OFFSET is the color to start with.  Returns the last color drawn.*"
  (let* ((w (tv:sheet-width window))
	 (h (tv:sheet-height window))
	 (ofg (tv:sheet-foreground-color window)))
    (unwind-protect
	(do* ((j 0 (+ j thickness))
	      (i offset (1+ i)))
	     ((>= j h)
	      (1- i))
	  (setf (tv:sheet-foreground-color window) (mod i (1+ ncolors)))
	  (tv:prepare-sheet (window)
	    (dotimes (k thickness)
	      (sys:%draw-shaded-raster-line 0 w (+ j k) tv:alu-seta nil nil window))))
      (setf (tv:sheet-foreground-color window) ofg))))


(defun 4roll-colormap* (cmap &optional forwards (ncolors 255))
  "2Roll the contents of the colormap forwards or backwards one cell.*"
  (multiple-value-bind (r0 g0 b0) (tv:read-color-map cmap (if forwards ncolors 0))
    (dotimes (i ncolors)
      (let* ((j (if forwards (- ncolors i) i)))
	(multiple-value-bind (r g b) (tv:read-color-map cmap (if forwards (1- j) (1+ j)))
	  (tv:write-color-map cmap j r g b))))
    (tv:write-color-map cmap (if forwards 0 ncolors) r0 g0 b0))
  cmap)


(defvar 4*spectrum-cmap* *nil "2A color map filled in and reused by RAINBOW and RAINBOW-SCREEN.*")

(defun 4rainbow* (&optional (sheet tv:selected-window) (forwards t) (thickness 1))
  (unwind-protect
      (let* ((cmap (or *spectrum-cmap* (setq *spectrum-cmap* (tv:make-color-map))))
	     (ncolors (if tv:*dual-monitors* 127 255))
	     )
	(make-spectrum-colormap cmap 0.7 0.8 ncolors)
	(send sheet :clear-screen)
	(tv:download-color-lut-buffer cmap)
	(fill-rasters sheet thickness 0 ncolors)
	(loop
	  (roll-colormap cmap forwards ncolors)
	  (tv:download-color-lut-buffer cmap)))
    (tv:download-color-lut-buffer (send tv:selected-window :color-map))
    (send sheet :refresh)))


(defun 4rainbow-screen* (&optional (forwards t) (thickness 1) (s 1.0) (v 0.7) norefresh iterations)
  (let* ((opm (send tv:default-screen :plane-mask))
	 (owpm (send tv:who-line-screen :plane-mask)))
    (unwind-protect
	(let* ((cmap (or *spectrum-cmap* (setq *spectrum-cmap* (tv:make-color-map))))
	       (ncolors 255); (if tv:*dual-monitors* 127 255))
	       )
	  (send tv:default-screen :set-plane-mask 255)
	  (send tv:who-line-screen :set-plane-mask 255)
	  (make-spectrum-colormap cmap s v ncolors)
	  (tv:download-color-lut-buffer cmap)
	  (let* ((offset (1+ (fill-rasters tv:default-screen thickness 0 ncolors))))
	    (fill-rasters tv:who-line-screen thickness offset ncolors))
	  (do* ((i 0))
	       ((and iterations (> (incf i) iterations)))
	    (roll-colormap cmap forwards ncolors)
	    (tv:download-color-lut-buffer cmap)
	    ))
      (send tv:default-screen :set-plane-mask opm)
      (send tv:who-line-screen :set-plane-mask owpm)
      (and tv:selected-window (tv:download-color-lut-buffer (send tv:selected-window :color-map)))
      (unless norefresh
	(when (and tv:*dual-monitors* (neq tv:main-screen tv:default-screen))
	  (send tv:main-screen :refresh))
	(send tv:who-line-screen :refresh)
	(send tv:default-screen :refresh)
	))))


(defun 4rainbow-screenhack* (&optional ignore)
  (unwind-protect
      (let* ((oddp nil))
	(loop
	  (rainbow-screen (setq oddp (not oddp))
			  (1+ (random 7))
			  (+ 0.5 (random 0.5))
			  (+ 0.5 (random 0.5))
			  t
			  2048
			  )))
    (send tv:who-line-screen :clear-screen)
    (when (and tv:*dual-monitors* (neq tv:main-screen tv:default-screen))
      (send tv:main-screen :refresh))
    ))


(when (and TV:SIB-IS-CSIB (boundp 'tv:*screen-saver-hacks-list*))
  (pushnew 'rainbow-screenhack tv:*screen-saver-hacks-list*))



;1;; colorwheel*


(defvar 4*find-color-scratch** (let* ((a (make-array 256 :element-type 'cons)))
			       (dotimes (i 256)
				 (setf (aref a i) (cons nil nil)))
			       a))

(defun 4find-color-in-map* (cmap r g b)
  (block EXACT
    (dotimes (i 256)
      (multiple-value-bind (rr gg bb) (tv:read-color-map cmap i)
	(let* ((delta (+ (abs (- r rr))
			 (abs (- g gg))
			 (abs (- b bb)))))
	  (cond ((zerop delta)
		 (return-from EXACT (values i 0)))
		(t
		 (setf (car (aref *find-color-scratch* i)) delta)
		 (setf (cdr (aref *find-color-scratch* i)) i))))))
    (sort *find-color-scratch* #'< :key #'car)
    (values (cdr (aref *find-color-scratch* 0))
	    (car (aref *find-color-scratch* 0)))))



(defun 4draw-colorwheel* (center-x center-y radius &optional (window tv:selected-window)
			(colormap (make-spectrum-colormap)))
  (send window :clear-screen)
  (tv:download-color-lut-buffer colormap)
  (let* ((vv 0.5)
;	1 (screen-array (tv:sheet-screen-array window))*
;	1 (max-x (array-dimension screen-array 1))*
;	1 (max-y (array-dimension screen-array 0))*
	 (color 0)
	 )
    (unwind-protect
	(dotimes (ss radius)
	  (let* ((x (- radius ss))
		 (y 0.0)
		 (npoints (* W:TWO-PI x))
		 (delta-angle (quotient W:TWO-PI 360))
		 (cos-delta   (cos delta-angle))
		 (sin-delta   (sin delta-angle))
		 )
	    (do ((i 0 (1+ i)))
		((>= i npoints))
	      (psetq x (- (* x cos-delta) (* y sin-delta))
		     y (+ (* x sin-delta) (* y cos-delta)))
	      (multiple-value-bind (r g b) (hsv-to-rgb i (float (/ (- ss radius) radius)) vv)
;		1(format t "~&~s ~s ~s  ~s ~s ~s" r g b i (float (/ (- ss radius) radius)) vv)*
		(setq color (find-color-in-map colormap r g b)))
	      (send window :draw-point (round (+ x center-x)) (round (+ y center-y)) tv:alu-seta color))
	    ))
      (tv:download-color-lut-buffer colormap)
      )))
