;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:USER; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "3PHONEGEN*"*
;1;; Generating mnemonics for phone numbers, and vice versa.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    20 Jun 89*	1Jamie Zawinski*	1 Created.*
;1;;*


(defconstant 4KEYPAD-LETTERS*
	     #(nil	;1 0*
	       nil	;1 1*
	       "3abc*"	;1 2*
	       "3def*"	;1 3*
	       "3ghi*"	;1 4*
	       "3jkl*"	;1 5*
	       "3mno*"	;1 6*
	       "3prs*"	;1 7*
	       "3tuv*"	;1 8*
	       "3wxy*"	;1 9*
	       ))


(defun 4genphone *(string)
  "2Given a string, returns a string of the phone number which corresponds to it.
  Characters in the string which are non-alphabetic are passed through; the letters Q and Z are not allowed.*"
  (setq string (copy-seq (string string)))
  (dotimes (i (length string))
    (let* ((c (char string i)))
      (when (alpha-char-p c)
	(setf (char string i)
	      (or (dotimes (j 10 nil)
		    (when (position c (aref KEYPAD-LETTERS j) :test #'char-equal)
		      (return (digit-char j))))
		  (error "3Invalid letter - ~S*" c))))))
  string)


(defun 4phonegen *(number)
  "2Given a phone number, returns a list of strings, which is every possible keypad mnemonic.*"
  (if (numberp number)
      (setq number (princ-to-string number))
      (setq number (copy-seq number)))	;1 *PHONEGEN-11 temporarily modifies the string passed to it - so copy it first, to be safe.*
  (let* ((results '()))
    (declare (special results))
    (phonegen-1 number 0)
    (nreverse results)))

(defun 4phonegen-1 *(string index)
  (declare (special results)
	   (simple-string string)
	   (fixnum index)
	   (optimize (speed 3) (safety 0) (space 0))
	   )
  (if (= index (length string))
      (push (copy-seq string) results)
      (let* ((char (char string index))
	     (char-n (digit-char-p char))
	     (mappings (and char-n (aref (the vector KEYPAD-LETTERS) char-n))))
	(declare (string-char char))
	(if mappings
	    (dotimes (j (length mappings))
	      (setf (aref string index) (char (the simple-string mappings) j))
	      (phonegen-1 string (1+ index)))
	    (phonegen-1 string (1+ index)))
	(setf (aref string index) char))))


(defun 4phonegen-real *(number &optional (print t))
  "2 Given a phone number, returns a list of strings, which is every possible keypad mnemonic which
 is a real word (according to the spell-checker dictionary).  If PRINT is T, then nothing is returned;
 rather, they are printed as they are generated.*"
  (let* ((list (phonegen number))
	 (result '()))
    (dolist (string list)
      (declare (string string) (optimize speed))
      (when (and (or (speller:vowel-p string 0)		;1 CHECK-WORD is an expensive operation, so we don't do it unless*
		     (speller:vowel-p string 1)		;1 one of the first three letters, and one of the last three letters of the*
		     (speller:vowel-p string 2))	;1  word is a vowel - it can't be a real word unless this is true.*
		 
		 (or (speller:vowel-p string 3)
		     (speller:vowel-p string 4)
		     (speller:vowel-p string 5)
		     (speller:vowel-p string 6))
		 
		 (speller:check-word-p string))
	(if print
	    (format t "3~&~A~10t~A~%*" number string)
	    (push string result))))
    (if print
	(values)
	result)))


(defun 4phonegen-all *(prefix)
  "2Given a phone number prefix, print out every possible real-word keypad mnemonic for all ten thousand numbers in that exchange.*"
  (dotimes (i 10000)
    (declare (fixnum i)
	     (optimize (speed 3) (safety 0)))
    (let* ((n (if prefix
		  (format nil "3~3,'0D~4,'0D*" prefix i)
		  (format nil "3~4,'0D*" i))))
      (declare (simple-string n))
      (when (notany #'(lambda (x)
			(declare (string-char x))
			(or (char= x #\0) (char= x #\1)))
		    n)
	(phonegen-real n))))
  (values))


(defun 4phonegen-north-berkeley *()
  "2Print out every possible real-word keypad mnemonic for every possible phone number in North Berkeley, CA.  This will take a day or so.*"
  (dolist (n '(265 486 524 525 526 527 528 529 540 548 549 644 649 841 843 845 848 849 860))
    (print n)
    (terpri)
    (phonegen-all n)))
