;;; -*- Mode:Common-Lisp; Package:MAIL; Base:10; Fonts:(COURIER TR12I TR12BI TR12 MEDFNTB); Patch-file:T -*-

;1 File name: MAILER.LISP*
;1 Redefines the function that looks for mail domains to look at ALL the domains.*
;1 Started 5-2-1989 by Eric Karlson, UC-Berkeley under Robert Wilensky*
;1 Phone: (415) 642-9076, E-mail Address: karlson@ucbarpa.berkeley.edu*

(defun 4parse-mail-domain* (domain &optional namespace-ok)
"2Takes a domain name and returns the host that it specifies (or NIL
if there is no such host)3.**"
  (declare (function parse-mail-domain (T &optional T) T)
	   (values HOST-OR-NAMESPACE-OR-NIL))
  (let (host)
    (declare (T host))
    (unless (null domain)
      (cond ((stringp domain)
	     (setq host (or (si:parse-host domain T)
			    (and namespace-ok (name:find-known-namespace domain))))
	     (unless host
	       (catch 'Done
		 (dolist (ns (name:list-namespace-search-rules))
		   (declare (STRING ns))
		   (dolist (ns-site (name:lookup-objects-from-attributes :namespace ns :class :site))
		     (declare (type name:OBJECT ns-site))
		     (loop with substring
			   for local-domain in (name:get-attribute-value ns-site :Local-Mail-Domains)
			   for index = (search local-domain domain :from-end t :test #'equalp)
			   when (and index
				     (> index 1)
				     (eql (char domain (1- index)) #\.))
			   do (setq substring (xsubstring domain 0 (1- index))
				    host (or (si:parse-host substring T)
					     (and namespace-ok (name:find-known-namespace substring))))
			      (deallocate-xstring substring)
			      (if (and host
				       (or (typep host 'name:TI-REMOTE-NAMESPACE)
					   (equal (name:object-name ns-site) (send host :site))))
				  (throw 'Done nil)
				  (setq host nil))))))))
	    ((typep domain 'si:BASIC-HOST)
	     (setq host domain))))
    host))