;;; -*- Mode:Common-Lisp; Package:ZWEI; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B); Patch-file:T; Base:10 -*-

;1;; File "3MAIL-FONT-PATCH*"*
;1;; Makes the TI mailer and mail reader use fonts!*
;1;; Written and maintained by Jamie Zawinski.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;  15 Feb 89*	1Jamie Zawinski*	1Created.*
;1;; * 117 Feb 89*	1Jamie Zawinski*	1Made the new font code not superfluously mark the buffer as being modified.*
;1;;  24 Feb 89*	1Jamie Zawinski*	1Made message headers have two fonts instead of just one.*
;1;;* 1 31 Mar 89*	1Jamie Zawinski*	1Fixed the bug where saying 5Meta-X Set Fonts* caused the line following the 5Fonts:* field to be zapped.*
;1;;   7 Apr 89*	1Jamie Zawinski*	1Modified 5cleanup-fonted-interval* to not try to modify nodes it doesn't need to; this will stop it from*
;1;;*				1  getting superfluous Read-Only barfs.*
;1;; * 113 Apr 89*	1Jamie Zawinski*	1Redefined 5deformat-message-headers* to use the new read-only suppression macro, since I got*
;1;;*				1  yet another read-only barf...*
;1;;* 1 14 Apr 89*	1Jamie Zawinski*	1There was this bug... if someone who wasn't using the font-mailer sent you a message with*
;1;;*				1  Epsilons in it, the thing would try to interpret those anyway.  Very bad - sometimes errored.*
;1;;*				1I changed things so that it remembers which messages have fonts and which do not, and only uses*
;1;;*				1  font-hacking interval-streams on the messages with fonts (uses normal interval-streams on others).*
;1;;* 1 25 Apr 89*	1Jamie Zawinski*	1Fixed a bug in 5font-names-to-font-alist* - if it had to go to disk for the font, it was returning*
;1;;*				1  a pathname instead of the loaded font!*
;1;;* 1 17 Aug 89*	1Jamie Zawinski*	1Made the 5View Message* command work, for losers who read mail in one-window mode.*
;1;;*				1Gave the send-mail hook 5font-hacking-hook* property, for correct interaction with bold-lock mode.*
;1;;  28 Aug 89*	1Jamie Zawinski *	1Made 5send-mail-headers-font-lock-hook* only have a true 5font-hacking-hook* property when the*
;1;;*				1 point is in the headers of a send-mail buffer; for it only hacks fonts when in the header, and we*
;1;;*				1 only want bold-lock mode to maximize fonts then.*
;1;;   1 Sep 89*	1Jamie Zawinski *	1Redefined5 print-message-list* to print messages in the correct fonts.*
;1;;*				1Added 5*printed-message-delimiter** so that you don't have to have every message on a new *
;1;;*				1 page (very wasteful...)*
;1;;    6 Sep 89*	1Jamie Zawinski *	1Fixed the trivial bug where 5Reply to All*, etc, were leaving the 5To:* and 5CC:* fields unfontified.*
;1;;* 1 24 Oct 89*	1Jamie Zawinski *	1Made this mailer use the 5Content-Type* field as defined in RFC 1049.*
;1;;*				1Improved handling of messages using unknown fonts.*
;1;; * 125 Oct 89*	1Jamie Zawinski *	1More tweaking to above.*
;1;;* 1 26 Oct 89*	1Jamie Zawinski *	1Commas between fonts in the 5X-Fonts:* field are allowed.*
;1;;*				1Added parameter 5*read-mail-allow-old-font-style**.*
;1;;*

(defvar 4*read-mail-default-font* *'FONTS:HL12 "2The font in which messages which did not specify fonts will be displayed.*")
(defvar 4*read-mail-default-headers-field-font* *'FONTS:COURIER "2The font in which the headers of all messages will be displayed.*")
(defvar 4*read-mail-default-headers-body-font* *'FONTS:HL12I "2The font in which the headers of all messages will be displayed.*")
(defvar 4*send-mail-default-fonts* *'(FONTS:HL12 FONTS:HL12B FONTS:CPTFONT) "2The default fonts for outgoing messages.*")

(defvar 4*print-message-header-page-font* *'FONTS:COURIER
  "2The font in which to print the title page which comes with every batch of hardcopied messages.*")


(defvar 4*read-mail-allow-old-font-style* *t "2If T, accept the old headers format; this could be dangerous.*")

(defvar 4*read-mail-gag-font-style-warnings* *t
  "2Set this to non-NIL if you don't want to see warnings about the old-style font specification.
  Set this to :QUIET if you don't want to see any warnings about fonts at all.*")


(defvar 4*printed-message-delimiter* *#\Clear-Screen "2What to print between hardcopied messages.  May be a character or a string.*")


(defmacro 4writing-read-only-interval *((interval &optional preserve-modification-flag)
				      &body body)
  "2The macro 3WITH-READ-ONLY-SUPPRESSED* is inadequate - you cannot suppress read-only on two intervals (say an interval and its parent).
  This macro actually binds the 3READ-ONLY-P* slot of the interval.
  If 3PRESERVE-MODIFICATION-FLAG* is true, then the modification flag is unaffected by any modifications to the buffer during BODY.*"
  (let* ((old-ro (gensym))
	 (old-tick (gensym))
	 (i (gensym)))
    `(let* ((,i ,interval)
	    (,old-ro (and ,i (send ,i :read-only-p)))
	    (,old-tick (and ,i (send ,i :tick))))
       (unwind-protect
	   (progn
	     (and ,i (send ,i :set-read-only-p nil))
	     ,@body)
	 (when ,i
	   (send ,i :set-read-only-p ,old-ro)
	   (when ,preserve-modification-flag
	     (setf (send ,i :tick) ,old-tick))
	   )))))



;1;; Changed to zap fonts at front of buffer, and to open a font-hacking stream to the buffer.*
;1;;*
(defcom COM-SEND-MAIL
	"Send mail and exit mail mode."
	()
  
  (erase-header-fonts *interval*)    ;1 5 jwz**
  (let (subject)
    (multiple-value-bind (sent error-list queued-list all-addresses header-list)
	(mail:submit-mail (interval-stream (interval-first-bp *interval*)
					   (interval-last-bp *interval*)
					   nil t))    ;1 5 jwz**
      (when sent
	(loop
	  with fcc-paths
	  for header in header-list
	  do
	  (case (send header :type)
	    (:fcc
	     (push-end (send header :body) fcc-paths))
	    (:subject
	     (setq subject (send header :body))))
	  finally
	  (when fcc-paths
	    ;; Constuct a message object from the template and insert the actual headers used while sending
	    (let ((msg (read-message (interval-stream *interval*))))
	      (with-message-read-only-suppressed (msg)
		(delete-interval (interval-first-bp msg) (message-headers-end-bp msg))
		(dolist (header header-list)
		  (insert-moving (message-headers-end-bp msg) (send header :string-for-message))
		  (insert-moving (message-headers-end-bp msg) #\Newline)))
	      (dolist (path fcc-paths)
		(fcc-message-to-mail-file msg path)))))
	
	;; Append subject to name of template buffer
	(when (and subject (not (zerop (length subject))))
	  (let ((name (buffer-name *interval*)))
	    (when (and (char= #\* (char name 0))
		       (char= #\* (char name (1- (length name)))))
	      (send *interval* :rename (format nil "~A  ~S" name subject)))))
	
	;; Save status of delivery
	(push-end (list all-addresses error-list queued-list)  (get *interval* :mail-delivery-status))
	
	(let* ((template-type (get *interval* :mail-template-type))
	       (template *interval*)
	       (mail-buffer (get *interval* :buffer-of-mail-command))
	       (msg (or (get template :message-object-list) (get template :message-object))))
	  ;; If :mail-template-type is :reply, set the answered attribute of the message(es)
	  (when (eq template-type :reply)
	    (cond ((consp msg)
		   (dolist (m msg)
		     (add-message-attribute :answered m)))
		  (t
		   (add-message-attribute :answered msg))))
	  (format t "~2%Done.")
	  (check-for-typeout-window-typeout t)
	  (send *window* :prepare-for-redisplay)
	  (when (null error-list)
	    (not-modified *interval*)
	    (if (or (null mail-buffer)
		    (get mail-buffer :killed))
		;; Not invoked from a mail buffer, just select previous buffer
		;; SPR#5421:  ensure that there is some other buffer to select   \/\/
		(when (previous-buffer *interval*)
		  (send (previous-buffer *interval*) :select))
	      ;; Reselect the mail buffer, the message, and bury this template
	      (make-mail-buffer-current mail-buffer
					(get template :saved-window-configuration)
					nil)
	      (when (messagep msg)
		(select-message msg mail-buffer)
		(delete-message-attribute :unseen msg)))
	    (hide-mail-buffer template)
	    (format *query-io* "~&Press ~A to reselect the mail template buffer."
		    (key-for-command 'com-list-mail-buffers *zmacs-comtab* nil nil #\C-X))
	    ;; If invoked from another window, return to it.
	    (let ((window (get template :return-to-window-after-send)))
	      (when (and window (send window :active-p))
		(send window :select))))
	  (push template *sent-message-list*)
	  (setq *unsent-message-list* (deleq template *unsent-message-list*))))))
  dis-text)



;1;; One thing that this method does is record some of the headers of the message (without doing a full parse).*
;1;; This is so a summary can be generated for the message without fully parsing it.*
;1;;  ##  Modified this to also record whether the message has an3 X-FONTS:* field, so that *:READ-MESSAGE-BODY
;1;;  ##  knows what kind of stream to make when copying the message to the buffer.*
;1;;*
(defmethod (message-node :READ-MESSAGE-HEADERS) (file-format stream)
  "Default method to Read and process one message header."
  (declare (special *mail-prev-line*))
  
  (let ((line (or *mail-prev-line* (read-line-with-leader stream nil))))
    (setq *mail-prev-line* nil)
    
    (loop
      (when (or (null line)
		(send self :end-of-message-p file-format line stream))
	;; premature end (either EOF or end of message before reaching end of header)
	;; add one blank line
	(let ((new-line (create-line 'art-string 0 self)))
	  (add-line-to-message new-line self)
	  (setq headers-end-bp (create-bp new-line 0)))
	(setq *mail-prev-line* line)
	;; Don't signal EOF yet even if hit... other methods may need to initialize this message.
	(return))
      
      ;; Tuck away enough info so that a summary can be generated without parsing message.
      (add-line-to-message line self)
      (cond ((string-equal "Subject" line :end2 7)
	     (let ((start-index (mail:header-line-body-index line)))
	       (setq name (subseq line start-index
				  (min (line-length line)
				       (+ start-index *max-message-name-length*))))
	       (setf (get self :summary-subject) (nsubstring line start-index))))
	    ((string-equal "From" line :end2 4)
	     (setf (get self :summary-from) (nsubstring line (mail:header-line-body-index line))))
	    ((string-equal "Date" line :end2 4)
	     (setf (get self :summary-date-string) (nsubstring line (mail:header-line-body-index line))))
	    ((and (eq file-format :unix)
		  (not *reading-inbox-p*)
		  (string-equal "Status" line :end2 6))
	     (unless (position #\R line :start 7)
 	       (add-message-attribute :unseen self)))
	    ;1;*
	    ;1; The font-related fields.*
	    ;1; A previous version of this code required only the presence of a 5Fonts:* field to signal that Explorer font change codes*
	    ;1; should be used; I was young and naiive then.  To be in compliance with RFCs 822 and 1049, we instead use two fields,*
	    ;1; 5Content-Type:* and 5X-Fonts:*.  5Content-Type* is standardized in RFC 1049, and 5X-Fonts* is private to this format (as *
	    ;1; denoted by the leading 5X-*).  We can still accept the old style of one 5Fonts:* field, for compatibility.*
	    ;1; *
	    ((string-equal "3Content-Type*" line :end2 12)
	     (setf (get self :content-type) (nsubstring line (mail:header-line-body-index line))))
	    ((string-equal "3X-Fonts*" line :end2 7)
	     (setf (get self :summary-fonts) (nsubstring line (mail:header-line-body-index line))))
	    ((and 4*read-mail-allow-old-font-style**
		  (string-equal "3Fonts*" line :end2 5))
	     (setf (get self :obsolete-font-style) t)
	     (setf (get self :summary-fonts) (nsubstring line (mail:header-line-body-index line))))
	    
	    (t
	     (when (send self :end-of-header-p file-format line stream)
	       (setq headers-end-bp (create-bp line 0))
	       (return))))
      (setq line (read-line-with-leader stream nil))))
  
  (resolve-content-type self)  ;1 More font-fields hacking. - jwz.*
  (setq summary-parsed-p t)
  nil)

(defconstant 4MAIL-FONT-FORMAT-NAME *"3X-Explorer-Fonts*"
  "2The magic code which says that this message uses Epsilon characters to denote a font change.*")
(defconstant 4MAIL-FONT-FORMAT-VERSION *2
  "2The version number of the mail-font hacks.  
 Version 1 was when we used only a Fonts: field; 
 version 2 is where we use a Content-Type: and an X-Fonts: field.*")

(defun 4parse-content-type-field *(string)
  "2Parses an RFC 1049 Content-Type field, and returns three values: Type-name, Version-Name, and Resource-Ref.
  Type-Name will be a string; the others will be strings or NIL.*"
  ;1 3Content-Type:= type [";" ver-num [";" 1#resource-ref]] [comment]**
  (declare (string string))
  (flet ((white-p (char)
	   (declare (character char))
	   (or (char-equal char #\Space) (char-equal char #\Tab))))
    (let* ((name-end   (position #\; string :test #'char-equal))
	   (vers-start (and name-end   (position-if-not #'white-p string :start (1+ name-end))))
	   (vers-end   (and vers-start (position #\; string :test #'char-equal :start (1+ vers-start))))
	   (rsrc-start (and vers-end   (position-if-not #'white-p string :start (1+ vers-end))))
	   (rsrc-end   (and rsrc-start (position-if #'white-p string :start rsrc-start))))
      (values
	(subseq string 0 name-end)
	(and vers-start (subseq string vers-start vers-end))
	(and rsrc-start (subseq string rsrc-start rsrc-end))))))


(defun 4resolve-content-type *(message)
  "2If the Content-Type field of this message is inappropriate, pretend we didn't see a Fonts or X-Fonts field.*"
  (let* ((ct (get message :content-type))
	 (fonts (get message :summary-fonts))
	 (old-style-p (get message :obsolete-font-style)))
    
    (cond ((and fonts (not ct))
	   (if (and old-style-p 4*read-mail-allow-old-font-style**)
	       ;1; There is a 5Fonts:* field but no 5Content-Type:* field - accept it for now.*
	       (unless 4*read-mail-gag-font-style-warnings**
		 (warn "2Message has old style of Explorer-Font specification.*"))
	       ;1; There is a 5X-Fonts:* field but no 5Content-Type:* field - silently reject this.  Probably not intended for us at all.*
	       ;1; Or, there is a 5Fonts:* field, but we are not allowing the old (non-RFC-822-compliant) style.*
	       (remprop self :summary-fonts)))
	  
	  (ct
	   ;1; There is both a 5Content-Type* and an 5X-Fonts* (or maybe a 5Fonts*) field.*
	   ;1; If the 5Content-Type* field is inappropriate, then silently discard the fonts - they're not our format.*
	   ;1; If the 5Content-Type* field is appropriate, but there are no fonts, issue a warning.*
	   (multiple-value-bind (name version resource) (parse-content-type-field ct)
	     (declare (ignore resource))
	     (cond ((string-equal name 4MAIL-FONT-FORMAT-NAME*)
		    (cond ((not (equal 4MAIL-FONT-FORMAT-*VERSION (parse-integer version :junk-allowed t :radix 10.)))
			   (unless (eq 4*read-mail-gag-font-style-warnings** :quiet)
			     (warn #.(string-append "2Message is written with version ~S of Explorer Mail Fonts; *"
						    "2we are running version ~D.  Presenting unformatted.*")
				   version 4MAIL-FONT-FORMAT-*VERSION))
			   (remprop self :summary-fonts))
			  
			  ((null fonts)
			   (unless (eq 4*read-mail-gag-font-style-warnings** :quiet)
			     (warn "2Message is ~A version ~A, but has no fonts!*" 4MAIL-FONT-FORMAT-NAME* 4MAIL-FONT-FORMAT-*VERSION)))
			  (t
			   (when old-style-p
			     (unless (eq 4*read-mail-gag-font-style-warnings** :quiet)
			       (warn "2Message has mixed old- and new-style of Explorer-Font specification!*"))))))
		   (t (remprop self :summary-fonts)))))
	  (t nil))))

(defun 4build-content-type-string *()
  "2Creates and returns an appropriate content-type string for this version of the mail-fonts code.*"
  (format nil "3~A; ~A*" 4MAIL-FONT-FORMAT-NAME* 4MAIL-FONT-FORMAT-*VERSION))


;1;; Changed this to write the message to the buffer using an interval-stream, rather than (more efficient) making a line and*
;1;; splicing it in.  This is necessary for the Epsilon font-change parser to get a hold of things.*
;1;;*
(defmethod (message-node :READ-MESSAGE-BODY) (file-format stream)
  "Default method to read the body (text) of one message."
  (declare (special *mail-prev-line*))
  
  (let ((line (or *mail-prev-line* (read-line-with-leader stream nil)))
	(message-has-fonts-p (not (null (get self :summary-fonts)))))
    
    (setq *mail-prev-line* nil)
    (writing-read-only-interval (self t)
      (with-open-stream (s (interval-stream (interval-last-bp self) (interval-last-bp self)
					    nil message-has-fonts-p))
	(loop
	  (cond ((null line)
		 (return))
		((send self :end-of-message-p file-format line stream)
		 (setq *mail-prev-line* line)
		 (return))
		(t
		 (write-line line s)
		 (setq line (read-line-with-leader stream nil)))))))
    (if (null line) :EOF nil)))


;1;; Changed this to read from the message using a font-hacking interval-stream 2only if* the message has an 5X-Fonts: *field.*
;1;; The version from TI always hacked fonts (even though fonts never occurred in the standard TI mail buffers!)*
;1;;*
(defmethod (message-node :WRITE-MESSAGE-BODY) (file-format out-stream)
  (declare (ignore file-format))
  (let* ((stop-line (interval-last-non-blank-line self))
	 (stop-bp (create-bp stop-line (line-length stop-line)))
	 (message-has-fonts-p (not (null (get self :summary-fonts)))))
    (stream-copy-until-eof (interval-stream headers-end-bp stop-bp nil message-has-fonts-p) out-stream))
  (terpri out-stream)
  (delete-message-attribute :recent self)
  nil)



(defun 4font-names-to-font-alist *(names &optional nobarf)
  "2Given a list of font names, return an alist of the font symbols and the font objects.
  If NOBARF is true, then an undefined font will be silently replaced with some default.*"
  (mapcar #'(lambda (name)
	      (let* ((symbol (intern (string-upcase (string name)) "3FONTS*"))
		     (value (if (boundp symbol)
				(tv:font-evaluate symbol)
				(if (load (format nil "3SYS:FONTS;~A*" name) :package "3FONTS*" :if-does-not-exist nil)
				    (or (tv:font-evaluate symbol)
					(error "3SYS:FONTS;~A* did not contain the font ~A." name name))
				    (cond (nobarf
					   (unless (eq 4*read-mail-gag-font-style-warnings** :quiet)
					     (warn "2Message wanted unknown font ~A; using ~A instead.*"
						   symbol ucl:*default-font*))
					   (setq symbol (tv:font-name (tv:font-evaluate ucl:*default-font*)))
					   (tv:font-evaluate ucl:*default-font*))
					  (t (barf "3~A is not a font.*" symbol)))))))
		(cons symbol value)))
	  names))



(defun 4fonts-of-message *(message)
  "2Returns a list of symbols - the things specified in the FONTS field of the message.*"
  (assure-message-parsed message)
  (let* ((interval (or (get-message-header message :X-FONTS :interval)
		       (and 4*read-mail-allow-old-font-style**
			    (get-message-header message :FONTS :interval)))))
    (when interval
      (let* ((string (string-interval interval))
	     (symbols '())
	     (eof (gensym))
	     symbol (end 0))
	(string-subst-char #\Space #\, string nil)  ;1 Commas between font names are kosher.*
	(loop
	  (ignore-errors
	    (let* ((*package* *keyword-package*))
	      (multiple-value-setq (symbol end) (read-from-string string nil eof :start end)))
	    (when (eq symbol eof) (return))
	    (push symbol symbols)))
	(nreverse symbols)))))



(defun 4erase-header-fonts *(bp1 &optional bp2 in-order-p)
  "2Make the interval have no font change information between the start of the interval, and the first blank line (or the end of the interval).*"
  (get-interval bp1 bp2 in-order-p)			;1 Normalize the BPs.*
  (let* ((blank-line (zwei:search bp1 #.(make-string 2 :initial-element #\Newline) nil t nil bp2))
	 (*batch-undo-save* t))		;1 Don't try to save undo info for this font change.*
    (change-font-interval bp1 blank-line nil 0)))



(pushnew '("3X-Fonts*" . :X-FONTS) *valid-header-list* :test #'equal)
(pushnew '("3Content-Type*" . :CONTENT-TYPE) *valid-header-list* :test #'equal)

(pushnew :X-FONTS *reformat-headers-include-list*)
(pushnew :CONTENT-TYPE *reformat-headers-include-list*)

(pushnew '("3Fonts*" . :FONTS) *valid-header-list* :test #'equal) 	;1 For compatibility.*
(pushnew :FONTS *reformat-headers-include-list*)			;1 For compatibility.*


(defmacro 4normalize-font *(source font-name-var font-var)
  "2SOURCE is a variable which holds a font or a font name.  
  FONT-NAME-VAR is a variable intowhich will be stored the name of the font in SOURCE.
  FONT-VAR is a variable intowhich will be stored the actual font object from SOURCE.*"
  `(if (symbolp ,source)
       (setf ,font-name-var ,source
	     ,font-var (tv:font-evaluate ,font-name-var))
       (setf ,font-var (tv:font-evaluate ,source)
	     ,font-name-var (tv:font-name ,font-var))))


(defun 4update-message-fonts *(message window)
  "2Make the fonts of the message be appropriate - header in the header font, and body in the fonts specified in the header.*"
  (let* ((fix-interval-p nil)
	 (fonts (or (send message :get-attribute :fonts)
		    (progn
		      (setq fix-interval-p t)
		      (fonts-of-message message))))
	 (font-alist (or (get message :parsed-fonts-alist)
			 (progn
			   (setq fix-interval-p t)
			   (font-names-to-font-alist fonts t)))))
    (let* (headers-font-a headers-font-name-a
	   headers-font-b headers-font-name-b)
      (normalize-font 4*read-mail-default-headers-*field-4font** headers-font-name-a headers-font-a)
      (normalize-font 4*read-mail-default-headers-*body-4font**  headers-font-name-b headers-font-b)

      (when (and (null fonts) 4*read-mail-default-font**)
	(setq fonts (list (tv:font-name (tv:font-evaluate 4*read-mail-default-font**))))
	(setq font-alist (list (cons (tv:font-name (tv:font-evaluate 4*read-mail-default-font**))
				     4*read-mail-default-font**))))
      (when headers-font-a
	(unless (member headers-font-name-a fonts :test #'string-equal)
	  (setq fonts (append fonts (list headers-font-name-a)))
	  (setq font-alist (append font-alist (list (cons headers-font-name-a headers-font-a))))))
      (when headers-font-b
	(unless (member headers-font-name-b fonts :test #'string-equal)
	  (setq fonts (append fonts (list headers-font-name-b)))
	  (setq font-alist (append font-alist (list (cons headers-font-name-b headers-font-b))))))

      ;1; The fonts in 5font-alist* are guarenteed to be valid; ones in 5fonts* are not.  5fonts* comes directly from the message as the*
      ;1; sender typed it, so it may reference undefined fonts.  5font-alist* has mapped unknown fonts to 5ucl:*default-font**, so let's*
      ;1; hang on to that list instead of the original one (which will remain only in the text of the message).*
      (setq fonts (mapcar #'car font-alist))
      (set-buffer-fonts message fonts)
      (when fix-interval-p
	(send message :set-attribute :fonts fonts nil)
	(setf (get message :parsed-fonts-alist) font-alist))
      (when window
	(redefine-fonts window font-alist (send message :get-attribute :VSP) nil))
      (writing-read-only-interval (message t)
	(writing-read-only-interval ((send message :superior) t)
	  (fontify-message-headers message headers-font-name-a headers-font-name-b fonts)
	  )))
    fonts))


(defun 4fontify-message-headers *(message &optional
				(font-name-a *read-mail-default-headers-field-font*)
				(font-name-b *read-mail-default-headers-body-font*)
				(fonts (send message :get-attribute :fonts)))
  "2Given a message-node (or any interval), grind the fonts of the headers portion of that interval.
  Headers fields before the colon go in font A, and headers fields after the colon (or without a colon) go in font B.
  FONTS is the font list of the interval.*"
  (unless (symbolp font-name-a) (setq font-name-a (tv:font-name font-name-a)))
  (unless (symbolp font-name-b) (setq font-name-b (tv:font-name font-name-b)))
  (let* ((font-a-number (position font-name-a fonts :test #'string-equal))
	 (font-b-number (position font-name-b fonts :test #'string-equal))
	 (*batch-undo-save* t))		;1 Don't try to save undo info for this font change.*
    (when (and font-a-number font-b-number)
      (let* ((bp (interval-first-bp message))
	     (end-bp (if (typep message 'MESSAGE-NODE)
			 (send message :headers-end-bp)
			 (zwei:search (interval-first-bp message) #.(string-append #\Newline #\Newline)))))
	(do* ()
	     ((or (null bp)
		  (bp-= bp end-bp)))
	  (let* ((start bp)
		 (end (end-line bp))
		 (colon (zwei:search start "3:*" nil nil nil end))
		 (starts-with-whitespace-p (member (bp-char start) (the list *whitespace-chars*) :test #'char-equal))
		 )
	    (when colon (setq colon (forward-over '(#\Space #\Tab) colon end)))
	    (cond ((or starts-with-whitespace-p (null colon))
		   (change-font-interval start end nil font-b-number))
		  (t
		   (change-font-interval start colon nil font-a-number)
		   (change-font-interval colon end nil font-b-number))))
	  (setq bp (beg-line bp 1 nil))
	  ))))
  nil)


;1;; This function was originally defined in 3SYS:ZMACS;FONT.LISP**
;1;; Its purpose is to remove references to fonts that are no longer in the font map.*
;1;; It iterates a region, and if it finds a bad font, it changes it.*
;1;; The problem is, it was marking the region as modified 5even if it didn't change anything!**
;1;; It should be legal to call this on a read-only interval if the interval does not need to be fixed, right?*
;1;;*
;1;; What was happening is, sometimes (not always) this was called on a message-node of the read-mail buffer; those nodes*
;1;; are always read-only, so this was trying to mark them as modified them, and barfing.*
;1;; This happened most often when coming out of the Reply command; I really don't understand why it only happened sometimes.*
;1;; It seems to me that it should have happend all the time...  *
;1;;*
(DEFUN 4CLEANUP-FONTED-INTERVAL* (FONT-ALIST-LENGTH FROM-BP &OPTIONAL TO-BP IN-ORDER-P)
  "2For each character in specified interval, if it's in a font that's outside
the range of fonts in the font alist, unfont the character.*"
  (GET-INTERVAL FROM-BP TO-BP IN-ORDER-P)
  (WITH-UNDO-SAVE ("3FONT CHANGE*" FROM-BP TO-BP T)
    (let ((interval-munged-p nil))
      (DO ((LINE (BP-LINE FROM-BP) (LINE-NEXT LINE))
	   (LIMIT-LINE (BP-LINE TO-BP))
	   (START-INDEX (BP-INDEX FROM-BP) 0)
	   (LAST-LINE-P)
	   (line-munged-p nil nil))
	  (NIL)
	(SETQ LAST-LINE-P (EQ LINE LIMIT-LINE))
	(DO ((INDEX START-INDEX (1+ INDEX))
	     (LIMIT-INDEX (IF LAST-LINE-P
			      (BP-INDEX TO-BP)
			      (LINE-LENGTH LINE))))
	    ((>= INDEX LIMIT-INDEX))
	  (WHEN (>= (CHAR-FONT (AREF LINE INDEX)) FONT-ALIST-LENGTH)
	    ;1; At this point we 5know* we must modify the interval.  Mark as modified only as much of it as we touch. *
	    ;1;*
	    (unless interval-munged-p		;1 Mung the interval if we haven't done so already.*
	      (mung-bp-interval from-bp)
	      (setq interval-munged-p t))
	    (unless line-munged-p		;1 and mung the line if we haven't done so already.*
	      (mung-line line)
	      (setq line-munged-p t))
	    
	    (SETF (AREF LINE INDEX) (MAKE-CHAR (AREF LINE INDEX)
					       (CHAR-BITS (AREF LINE INDEX))))))
	(AND LAST-LINE-P
	     (RETURN ()))))))



;1;; Added a call to *UPDATE-MESSAGE-FONTS1.*
;1;;*
(defun MUST-REDISPLAY-MAIL-BUFFER (buffer sequence-degree &optional summary-degree window)
  "Update window displaying the current message sequence as well as any windows
showing its summary."
  (unless (message-sequence-p buffer)
    (must-redisplay-buffer buffer sequence-degree)
    (return-from must-redisplay-mail-buffer))
  (unless sequence-degree (setq sequence-degree dis-text))
  (unless summary-degree (setq summary-degree dis-text))
  
  (let ((message (current-message buffer)))
    (when (messagep message)
      (make-message-current nil buffer)
      (setq *msg* message)
      
      ;; Much of the following code is taken from (:method zmacs-window :set-interval-internal)
      (let ((first-bp (interval-first-bp message)))
	(unless window
	  (setq window (mail-buffer-window buffer)))
	(cond (window
	       ;; Make sure that point and start-bp of window are within the same message.
	       (unless (eq (bp-message (window-point window))
			   (bp-message (window-start-bp window)))
		 (move-bp (window-start-bp window) (interval-first-bp (bp-message (window-point window)))))
	       
	       (cond ((eq (bp-message (window-point window)) message)
		      ;; Window is at correct message, just do specified redisplay
		      (must-redisplay window sequence-degree))
		     (t
		      ;; Switching to new message... update unseen attibute.
		      (let ((old-msg (bp-node (window-point window))))
			(and (messagep old-msg) (delete-message-attribute :unseen old-msg)))
		      ;; Change window pointers 
		      (move-bp (window-point window) first-bp)
		      (move-bp (window-mark window) first-bp)
		      (move-bp (window-start-bp window) first-bp)
		      ;; Lose the region, if any.
		      (setf (window-mark-p window) nil)
		      ;; If this is the current selected window, update global vars.
		      ;;(when (eq window *window*)	
		      ;;(setq *point* (window-point window)
		      ;;*mark* (window-mark window)))
		      (must-redisplay window (max dis-text sequence-degree))))
	       
	       (update-message-fonts message window)	;5  jwz*
	       )
	      (t
	       (must-redisplay-buffer buffer sequence-degree))))
      
      ;; Update the summary buffer and any windows it is in.
      (let* ((summary-buffer (mail-summary-of buffer)))
	(when summary-buffer 
	  (let ((window (mail-buffer-window summary-buffer))
		(new-bp (and summary-buffer (summary-make-message-current message summary-buffer buffer))))
	    (cond ((and window new-bp)
		   (if (bp-= new-bp (window-point window))
		       (must-redisplay window summary-degree)
		     ;; Point moved, ensure degree is not less than dis-bps
		     (move-bp (window-point window) new-bp)
		     (must-redisplay window (max dis-bps summary-degree))))
		  (t
		   (must-redisplay-buffer summary-buffer summary-degree)))))))))


;1;;*
;1;; 5Hacked* this function to work with fonts.*
;1;;*
(defcom 4COM-VIEW-MESSAGE*
	"2View message in separate window.*"
	()
  (in-mail-context (:require-message t)
    ;1; In 2 window mode, just allow current message to *
    ;1; become the selected one, which requires no action here.*
    (cond ((two-mail-reader-windows-p *mail-buffer*)
	   (values dis-text dis-none))
	  (t
	   ;1;*
	   ;1; For 5view-stream* to work with fonts properly, we must have a standard -*- line at the front of the stream.*
	   ;1; So, we make a new interval which includes the one we want to view.  This new interval has one line tacked on to the*
	   ;1; front of it, which has a normal properties line.*
	   ;1;*
	   (let* ((fonts (update-message-fonts *msg* nil))
		  (fake-line (create-line 'ART-STRING 0 nil))			;1 Make a new line.*
		  (fake-interval (make-interval					;1 Make a new interval which points at the new*
				   (make-bp :bp-line fake-line :bp-index 0)	;1 line...*
				   (interval-last-bp *msg*))))
	     (format fake-line "3-*- Fonts:~A -*-*" fonts)			;1 Write a standard -*- into the new line.*
	     (nstring-downcase fake-line)
	     (setf (line-next fake-line) (bp-line (interval-first-bp *msg*))	;1 Point the tail of the new line at the head of *
		   (line-node fake-line) (bp-node (interval-first-bp *msg*)))	;1 the interval we want to view...*
	     (with-open-stream (stream (interval-stream fake-interval))		;1 And view the new interval (which encapsulates*
	       (view-stream stream)))						;1 the old one).*
	   (delete-message-attribute :unseen *msg*)
	   (values dis-none dis-none)))))



;1;; Originally defined in 3MAIL-READER;MESSAGE.LISP* - this was getting "read only" barfs, so I made it use the new read-only macro.*
;1;;*
(defmethod (message-node :REFORMAT-HEADERS) (&optional from-original)
  
  (with-message-read-only-suppressed (self)
    (writing-read-only-interval (self t)
      (writing-read-only-interval ((send self :superior) t)
	(cond ((and (get self :saved-reformatted-headers)
		    (null from-original))
	       (delete-interval first-bp headers-end-bp)
	       (insert-interval first-bp (get self :saved-reformatted-headers)))
	      (t
	       (cond ((null original-headers)
		      (setq original-headers (copy-interval first-bp headers-end-bp)))
		     (from-original
		      (unless (get self :saved-reformatted-headers)
			(setf (get self :saved-reformatted-headers) (copy-interval first-bp headers-end-bp)))
		      (deformat-message-headers self)))
	       (let ((keep-list (select-and-order-headers-interval
				  *reformat-headers-include-list* *reformat-headers-exclude-list*
				  first-bp headers-end-bp)))
		 (delete-interval first-bp headers-end-bp)
		 (mung-message self)
		 (dolist (header keep-list)
		   (reformat-one-header header)
		   (dolist (line header)
		     (splice-line-into-interval line (bp-line headers-end-bp))))
		 (setq status nil)
		 (setq parsed-p nil)
		 (setq reformatted-p t))))))))


;1;; Originally defined in 3MAIL-READER;MESSAGE.LISP* - this was getting "read only" barfs, so I made it use the new read-only macro.*
;1;;*
(defun DEFORMAT-MESSAGE-HEADERS (msg)
  (when (typep (message-original-headers msg) 'interval)
    (writing-read-only-interval (msg t)
     (writing-read-only-interval ((send msg :superior) t)
      (unless (get msg :saved-reformatted-headers)
	(setf (get msg :saved-reformatted-headers)
	      (copy-interval (interval-first-bp msg) (message-headers-end-bp msg))))
      (delete-interval (interval-first-bp msg) (message-headers-end-bp msg) t)
      (insert-interval (interval-first-bp msg) (message-original-headers msg) nil t)
      (mung-message msg)
      (setf (message-reformatted-p msg) nil)
      (setf (message-status msg) nil)
      (setf (message-parsed-p msg) nil)))))




(defmethod (message-node4 :before* :write-message-headers) (file-format out-stream)
  "2Lose the fonts in the headers.*"
  (declare (ignore file-format out-stream))
  (writing-read-only-interval (self t)
    (writing-read-only-interval ((send self :superior) t)
      (erase-header-fonts self))))


(defwhopper (mail-file-buffer :read-mail-file) (file-format stream)
  (writing-read-only-interval (self t)
    (continue-whopper file-format stream)))



;1;; Making send-mail buffers be a different flavor.*
;1;; This is so we can have their attribute line NOT be a -*- at the front of the buffer - rather, the file properties each get a header field.*
;1;;*

(defflavor 4send-mail-buffer*
	   ()
	   (zmacs-buffer)
  :gettable-instance-variables
  :settable-instance-variables
  :initable-instance-variables)

(defmethod 4(send-mail-buffer :after :select)* (&rest ignore)
  "2After the buffer is selected, make sure the message headers are in the right fonts - purely for aesthetic reasons...*"
  ;1;*
  ;1; We do this here because the alternative is to modify each and every sendmail template, or to modify 5define-mail-template* and then*
  ;1; recompile each and every sendmail template...  This fontifies the headers if you switch buffers and then switch back, but that's not*
  ;1; such a big deal, since any user-supplied font changes in the headers part are destroyed before the mail is shipped anyway.*
  ;1;*
  (fontify-message-headers self))


(defun MAKE-MAIL-TEMPLATE-BUFFER (buffer-name template-type &optional (selectp t))
  (fs:force-user-to-login)
  (let* ((name (string-subst-char #\- #\Space buffer-name t))
	 (buffer (make-instance 'SEND-MAIL-BUFFER :name
			       (loop 
				 for bufnam = (format nil "*~A-~D*" name (incf *mail-template-counter*))
				 unless (find-buffer-named bufnam)
				 return bufnam))))
    (push buffer *unsent-message-list*)
    (send buffer :set-major-mode 'text-mode)
    (setf (get buffer :mail-template-type) template-type)
    (when (or (eq template-type :reply)
	      (eq template-type :forward))
      (setf (get buffer :message-object) *msg*))
    (when selectp
      (send buffer :select)
      (turn-on-mode 'mail-mode)
      (when *mail-mode-hook*
	(funcall *mail-mode-hook*)))
    buffer))


;1;; Originally defined in 3SYS:MAIL-READER;SEND-MAIL.LISP* - *
;1;; altered to add 5Content-Type:* and 5X-Fonts:* fields, and to insert headers in the header-font.*
;1;;*
(defun INSERT-DEFAULT-HEADER-FIELDS (bp &rest not-these-fields)
  "Inserts defaults for From, Reply-To, FCC, and BCC fields unless the
field in question is a member of NOT-THESE-FIELDS."

  (declare (list not-these-fields))
  ;1;*
  ;1; Adds the x-fonts: field, initializes the fonts of the buffer.*
  ;1;*
  (let* (header-font-a header-font-name-a header-font-number-a
	 header-font-b header-font-name-b header-font-number-b
	 ignore)
    (normalize-font 4*read-mail-default-headers*-field4-font** header-font-name-a header-font-a)
    (normalize-font 4*read-mail-default-headers*-body4-font**  header-font-name-b header-font-b)
    (setq header-font-number-a (position header-font-name-a (send *interval* :get-attribute :fonts) :test #'string-equal))
    (setq header-font-number-b (position header-font-name-b (send *interval* :get-attribute :fonts) :test #'string-equal))
    
    (let* ((fonts *send-mail-default-fonts*)
	   (content-type-string (build-content-type-string)))
      (unless (or (null header-font-name-a) (member header-font-name-a fonts :test #'string-equal))
	(setq fonts (append fonts (list header-font-name-a))))
      (unless (or (null header-font-name-b) (member header-font-name-b fonts :test #'string-equal))
	(setq fonts (append fonts (list header-font-name-b))))
      
      (send *interval* :set-attribute :fonts fonts nil)		;1 Add the property but not the text.*
      (unless (member :X-FONTS not-these-fields :test #'eq)
	(insert-header-field bp :X-FONTS)			;1 Add the field-name text (now that the fonts are initialized right).*
	(send *interval* :set-attribute :FONTS fonts t))	;1 Add the field-body text.*
      (send *interval* :set-attribute :content-type content-type-string t)	;1 No more magic necessary.*
      (redefine-fonts *window* (font-names-to-font-alist fonts) (send *interval* :get-attribute :VSP)
			nil)))
  ;1;*
  ;1; Just like before - insert the fields.*
  ;1;*
  (when (and (stringp *default-fcc-string*)
	     (not (member :fcc not-these-fields :test #'eq)))
    (insert-header-field bp :fcc *default-fcc-string*))
  (when (and (stringp *default-reply-to-string*)
	     (not (member :reply-to not-these-fields :test #'eq)))
    (insert-header-field bp :reply-to *default-reply-to-string*))
  (when (and (stringp *default-bcc-string*)
	     (not (member :bcc not-these-fields :test #'eq)))
    (insert-header-field bp :bcc *default-bcc-string*))
  (when (not (member :from not-these-fields :test #'eq))
    (insert-header-field bp :from (send (mail:default-from-address) :string-for-message))))


;1;; Changed to use the header fonts.*
;1;;*
(defun INSERT-HEADER-FIELD (bp header-type &optional contents (trailing-cr-p t))
  (let* (header-font-a header-font-name-a header-font-number-a
	 header-font-b header-font-name-b header-font-number-b
	 ignore)
    (normalize-font 4*read-mail-default-headers*-field4-font** header-font-name-a header-font-a)
    (normalize-font 4*read-mail-default-headers*-body4-font**  header-font-name-b header-font-b)
    (setq header-font-number-a (position header-font-name-a (send *interval* :get-attribute :FONTS) :test #'string-equal))
    (setq header-font-number-b (position header-font-name-b (send *interval* :get-attribute :FONTS) :test #'string-equal))
    
    (let* ((*font* (or header-font-number-a *font*)))
      (insert-moving bp (in-current-font (nstring-capitalize (format nil "~A:~VT" header-type
								     *mail-template-header-body-goal-column*)))))
    (when contents
      (let* ((*font* (or header-font-number-b *font*)))
	(move-bp bp (insert-thing bp (in-current-font contents)))))
    (when trailing-cr-p
      (insert-moving bp #\Newline))))



;1;; Originally defined in 3MAIL-READER;SEND-MAIL.LISP* - altered to add a command-hook.*
;1;;*
(defminor COM-MAIL-MODE mail-mode "Mail" 1
	  "Minor mode which can send buffer as a mail message."
	  ()
	  (set-comtab *mode-comtab* '(#\End  com-send-mail
				      #\Abort com-mail-mode-exit
				      #\Help com-mail-mode-documentation
				      #\C-M-Y com-yank-message
				      #\mouse-r-1 com-mail-mode-general-mouse-menu 
				      )
		      '(("Send Mail" . com-send-mail)
			("Quit" . com-mail-mode-exit)
			("Delivery Status" . com-delivery-status)
			("Yank Message" . com-yank-message)
			("Yank Current Message" . com-yank-current-message)
			))
	  (set-mode-line-list (append (mode-line-list) '("  (END to mail -- ABORT to exit)")))
	  (command-hook '4SEND-MAIL-HEADERS-FONT-*LOCK-HOOK *command-hook*)
	  )


;1;; This hook hacks fonts.  We give it a property saying so in case there are other font-hacking-hooks around that want to*
;1;; behave differently (like bold-lock-mode, for example).*
;1;;*
(defprop 4send-mail-headers-font-*lock-hook4 *t font-hacking-hook)

(defprop 4send-mail-headers-font-*lock-hook 10 command-hook-priority)


(defun 4send-mail-headers-font-*lock-hook4 *(char)
  "2If in the header of the message, and within a field name, make the current font be the header-field-font.
  If in the header of the message, and within a field body, make the current font be the header-body-font.
  If not in the header, but just was in the header, make the current font be what it was before entering the header.*"
  (declare (ignore char))
  (let* ((header-start (interval-first-bp *interval*))
	 (header-end (zwei:search header-start #.(make-string 2 :initial-element #\Newline)
				  nil t))
	 (in-header-p (bp-< (point) header-end))
	 (was-in-header-p (get *interval* :in-header-p))
	 (saved-bodyfont (get *interval* :saved-bodyfont)))
    ;1;*
    ;1; We are only a font-hacking hook while in the header of a buffer.*
    ;1; If this property is true, then bold-lock mode will not switch the font to a ``less fonted'' one, i.e., won't go from TR12i to TR12.*
    ;1; This is what we want in the header, but not in the body.*
    (setf (get '4SEND-MAIL-HEADERS-FONT-*LOCK-HOOK 'FONT-HACKING-HOOK) in-header-p)
    
    (cond ((and (not in-header-p) was-in-header-p)
	   ;1; Not in header now, but just was.*
	   (setq *font* (or saved-bodyfont 0))
	   (update-font-name))
	  
	  (in-header-p
	   ;1; In header now.*
	   (unless was-in-header-p
	     (setf (get *interval* :saved-bodyfont) *font*))
	   (let* (header-font-a header-font-name-a header-font-number-a
		  header-font-b header-font-name-b header-font-number-b)
	     (normalize-font 4*read-mail-default-headers-*field-4font** header-font-name-a header-font-a)
	     (normalize-font 4*read-mail-default-headers-*body-4font**  header-font-name-b header-font-b)
	     (setq header-font-number-a (position header-font-name-a (send *interval* :get-attribute :fonts)
						  :test #'string-equal))
	     (setq header-font-number-b (position header-font-name-b (send *interval* :get-attribute :fonts)
						  :test #'string-equal))
	     (when (and header-font-number-a header-font-number-b)
	       (let* ((start (beg-line (point)))
		      (end (end-line (point)))
		      (starts-with-whitespace-p (member (bp-char start) (the list *whitespace-chars*) :test #'char=))
		      (field-bp (zwei:search start "3:*" nil nil nil end)))
		 (when field-bp (setq field-bp (forward-over '(#\Space #\Tab) field-bp end)))
		 (let* ((in-field-p (or (bp-= start end)
					(and (not starts-with-whitespace-p)
					     (or (null field-bp)
						 (bp-< (point) field-bp))))))
		   (setq *font* (if in-field-p header-font-number-a header-font-number-b)))
		 (update-font-name)))))
	  
	  (t ;1; Not in header now.*
	   (setf (get *interval* :saved-bodyfont) *font*)))
    (setf (get *interval* :in-header-p) in-header-p)
    ))



;1;; Originally from 3ZMACS;METH.LISP**
;1;; redefined to use the* :STORE-ATTRIBUTE-LIST1 method instead of the* STORE-ATTRIBUTE-LIST1 function.*
;1;; This is so that send-mail buffers can do it differently.*
;1;;*
(DEFMETHOD 4(FILE-BUFFER :AFTER :SET-ATTRIBUTE*) (ATTRIBUTE VALUE &OPTIONAL SET-TEXT-TOO)
  (UNLESS (GETF SI:PROPERTY-LIST :SPECIAL-TYPE)	;1 Don't do special buffers.*
    (LET ((ATTRIBUTES (FS:EXTRACT-ATTRIBUTE-LIST (INTERVAL-STREAM SELF))))
      (AND (NOT (EQUAL VALUE (GETF ATTRIBUTES ATTRIBUTE)))
	   ;1; Ok, the new value doesn't match what's in the text.*
	   (OR (EQ SET-TEXT-TOO T)
	       (AND (EQ SET-TEXT-TOO :QUERY)
		    (FQUERY NIL "3Change the -*- line of the text as well? *")))
	   (PROGN
	     ;1; Put the new value in with what we got from the text;*
	     ;1; if the new value is the default, delete it instead.*
	     (IF (AND (NOT (MEMBER ATTRIBUTE '(:BASE :MODE :PACKAGE) :TEST #'EQ))
		      (EQUAL VALUE (EVAL (GET ATTRIBUTE 'DEFAULT-ATTRIBUTE-VALUE))))
		 (PROGN
		   (REMPROP (LOCF ATTRIBUTES) ATTRIBUTE)
		   ;1; Cause Update Attribute List to forget this one too.*
		   (REMPROP (LOCF (GET (LOCF SI:PROPERTY-LIST) 'FS::LAST-FILE-PLIST))
			    ATTRIBUTE))
		 (SETF (GETF ATTRIBUTES ATTRIBUTE) VALUE))
	     ;1; Now we have an attribute list to store in the file.*
	     (send self :store-attribute-list attributes)	;1 5 JWZ**
	     (MUST-REDISPLAY-BUFFER SELF DIS-TEXT))))))

(defmethod 4(file-buffer :store-attribute-list) (attributes)*
  "2Store the attribute list in a -*- line at the top of the buffer.*"
  (store-attribute-list self attributes))



(defmethod 4(send-mail-buffer :store-attribute-list)* (list)
  "2Store the attributes in the list each in their own message header field.*"
  (let* ((header-start (interval-first-bp self))
	 (header-end (zwei:search header-start #.(make-string 2 :initial-element #\Newline)
				  nil t nil (interval-last-bp self))))
    (do* ((rest list (cddr rest)))
	 ((null rest))
      (let* ((key (car rest))
	     (val (cadr rest))
	     (val-string (if (consp val)
			     (format nil "3~{~A ~}*" val)
			     (princ-to-string val)))
	     (field-start (zwei:search header-start (string-append (string key) #\:) nil nil nil header-end)))
	(when (eq key :fonts) (setq key :x-fonts)) ;1 mild hack...*
	(cond (field-start
	       (with-bp (bp (beg-line field-start) :moves)
		 (insert-header-field bp key val-string)		;1 Insert the new field, and a newline.*
		 (zwei:delete-interval bp (beg-line bp 1 t))		;1 Then delete the next line (the old field).*
		 ))
	      (t
	       (with-bp (bp header-start :moves)
		 (insert-header-field bp key val-string))))
	))))


;1;; Making mail hardcopy work with fonts.*
;1;;*

(defun 4PRINT-MESSAGE-LIST* (msg-list &optional mail-buffer)
  "2Print the given messages on a prompted-for printer.  Fonts will print correctly.*"
  (let* ((*mini-buffer-default-string* (or *default-print-message-printer* (get-default-printer)))
	 (*mini-buffer-dont-record* t)
	 (printer (completing-read-from-mini-buffer
		    (format nil "3Printer name: (Default is ~A)*" *mini-buffer-default-string*)
		    (list-printers))))
    (if (stringp printer)			;1 Will be element of alist or an empty string.*
	(setq printer *mini-buffer-default-string*)
	(setq printer (first printer))		;1 Name from alist element.*
	(setq *default-print-message-printer* printer))

    (let* ((intervals (loop for msg in msg-list
			    collect (create-interval 4*printed-message-delimiter**)
			    collect msg))
	   (header-page-stream (make-index-page msg-list mail-buffer))
	   (header-page-interval (create-interval nil nil)))
      (stream-copy-until-eof header-page-stream (interval-stream header-page-interval))
      (setf (get header-page-interval :fonts) (list 4*print-message-header-page-font**))
      (let* ((appended-interval (apply #'concatenate-fonted-intervals header-page-interval intervals)))
	(with-open-stream (stream (interval-stream appended-interval nil nil t))
	  (print-stream stream :printer-name printer :font-list (get appended-interval :fonts)))
	))))



;1;; Concatenating multiple intervals with different font maps.*
;1;;*
(defun 4concatenate-fonted-intervals *(&rest sources)
  "2Returns a new interval which is a concatenated copy of the given intervals.
  The passed-in intervals may have different font maps; the returned interval will have a superset font map, with
  all of the characters mapping to the same font, if not font number.
  The font map of this new interval is on it's property list, under 3:FONTS*.*"
  (let* ((font-superset '()))
    ;1;*
    ;1; First, iterate over all of the passed-in intervals and build the superset font map.  (What happens if this is too big?)*
    ;1;*
    (dolist (interval sources)
      (dolist (font (get interval :fonts))
	(cond ((symbolp font) (setq font (intern (string font) "3FONTS*")))
	      ((stringp font) (setq font (intern font "3FONTS*")))
	      (t (setq font (tv:font-name font))))
	(pushnew font font-superset :test #'eq)))
    (setq font-superset (nreverse font-superset))
    ;1;*
    ;1; Next, iterate over the intervals, copy them, remap them, and append them together.*
    ;1;*
    (let* ((head nil)			;1 This will hold the first appended copy.*
	   (previous-interval nil))	;1 This is the last one we have done, each time thru the loop.*
      (dolist (interval sources)
	(let* ((old (coerce (get interval :fonts) 'vector))
	       (new-mapping (make-array (length old))))
	  ;1; Build a mapping vector; the 2N*th element of 5new-mapping* holds the new mapping for font number 2N*.*
	  (dotimes (i (length old))
	    (setf (aref new-mapping i) (position (aref old i) font-superset :test #'string-equal)))
	  ;1;*
	  ;1; Copy the interval, and then destructively remap the copy.*
	  ;1; But don't bother remapping the copy if it has no fonts, or if the font mapping is the same as in the superset map.*
	  ;1;*
	  (setq interval (copy-interval interval))
	  (unless (or (zerop (length new-mapping))
		      (dotimes (i (length new-mapping) t)
			(unless (= (aref new-mapping i) i)
			  (return nil))))
	    (charmap ((interval-first-bp interval)
		      (interval-last-bp interval))
	      (let* ((c (charmap-char)))
		(unless (member c '(#\Newline #\Tab) :test #'char-equal)
		  (charmap-set-char (make-char (charmap-char) (char-bits c) (aref new-mapping (char-font c))))))))
	  (unless head (setq head interval))
	  ;1;*
	  ;1; Point the last line of the previous interval at the first line of this interval.  We destructively append them this way.*
	  (when previous-interval
	    (setf (line-next (bp-line (interval-last-bp previous-interval)))
		  (bp-line (interval-first-bp interval))))
	  (setq previous-interval interval)))
      ;1;*
      ;1; Point the head interval at the last line in its chain, store the font map, and return.*
      ;1;*
      (setf (interval-last-bp head) (interval-last-bp previous-interval))
      (setf (get head :fonts) font-superset)
      head)))
