;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "3MAIL-ABBREVS*"*
;1;; Making abbrev mode be on in certain headers of a send-mail buffer, and generating mail-mode abbrevs from the namespace.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;    21 Apr 89*	1Jamie Zawinski*	1 Created.*
;1;;    27 Jul 89*	1Jamie Zawinski *	1 Commented.*
;1;;*

;1;; When the point is certain fields of the "header" area of a send-mail buffer, abbrev mode is automatically on, and when the*
;1;; point is not in one of these fields, it is off.  The names of these fields are determined by 4*ABBREV-EXPANSION-HEADERS**, *
;1;; which defaults to TO and CC.*
;1;;*
;1;; The function3 ADD-MAIL-ABBREV* defines a send-mail-mode word abbrev, which is useful for abbreviating long addresses.  *
;1;; Because of the abbrev-mode thing, these abbrevs will only expand in the header.   3ADD-MAIL-ABBREV* is undoable by the*
;1;;3 LOGIN-FORMS* macro.*
;1;;*
;1;; The function 3GENERATE-MAIL-ABBREVS* will call 3ADD-MAIL-ABBREV* with arguments derived from the 5User* class of the default*
;1;; namespace; so if a user is defined in the namespace, you will get an abbrev for them.*
;1;;*
;1;; 5Warning:* this code uses **MAIL-MODE-HOOK*1, so if you use that as well, you must call *SETUP-MAIL-ABBREV-HOOK1 at the end of*
;1;; your hook function.*
;1;;*


(defun 4add-mail-abbrev* (string abbrev)
  "2Define a Mode-Word-Abbrev ABBREV to expand to STRING when in Send-Mail mode.
This abbrev will ONLY expand while one is typing in the header of the letter; not the body.*"
  (check-type string simple-string)
  (check-type abbrev simple-string)
  (setf (get (intern (string-upcase abbrev) *utility-package*)
	     (get-abbrev-mode-name "3Text*"))
	(string-append string))
  (setq *word-abbrev-tick* (tick))
  dis-none)

(defun 4add-mail-abbrev-undo* (undo)
  "2This function, given a form which defines a mail abbrev, returns a form which will undo that mail abbrev definition.
The form which undoes the definition is evaluated at Logout.*"
  (let* ((abbrev (caddr undo))
	 (old-str (get abbrev (get-abbrev-mode-name "3Text*"))))
    (if old-str
	`(define-mail-abbrev ,old-str ,abbrev)
	`(remprop ',(intern (string-upcase abbrev) *utility-package*) (get-abbrev-mode-name "3Text*")))))

(setf (get 'add-mail-abbrev :undo-function) #'add-mail-abbrev-undo)





;1;; Automatically generating them.*

(defun 4generate-mail-abbrevs *(&optional (undo-at-logout t))
  "2Generate a send-mail abbrev for each entry in the USER class of the namespace.*"
  (let* ((aliases '())
	 (defines '()))
    (dolist (user (name:list-objects-from-attributes :class :USER))
      (let* ((user-id (car user))
	     (plist (third user))
	     (real-name (getf plist :personal-name))
	     (addr (getf plist :mail-address))
	     (alias-of (getf plist :*alias-of*)))
	(if alias-of
	    (let* ((cons (or (assoc alias-of aliases :test #'string=)
			     (car (push (list alias-of) aliases)))))
	      (push user-id (cdr cons)))
	    (push (cons user-id (format nil "3~&~A <~A>*" real-name addr)) defines))))
    (macrolet ((add (string abbrev)
		 `(progn
		    (add-mail-abbrev ,string ,abbrev)
		    (when undo-at-logout
		      (push (add-mail-abbrev-undo (list 'add-mail-abbrev ,string ,abbrev))
			    logout-list)))))
      (dolist (cons defines)
	(add (cdr cons) (car cons)))
      (dolist (cons aliases)
	(dolist (alias (cdr cons))
	  (let* ((value (cdr (assoc (car cons) defines :test #'string=))))
	    (when value
	      (add value alias))))))
    nil))



;1;; Abbrev mode in send-mail headers.*


(defun 4turn-on-abbrev-mode* ()
  "2Make sure Abbrev Mode is turned on and Fill Mode is turned off.*"
  (unless (member 'WORD-ABBREV-MODE (the list zwei:*mode-name-list*) :test #'eq)
    (let* ((*numeric-arg-p* t)
	   (*numeric-arg* 1))
      (com-word-abbrev-mode)
      (let* ((*numeric-arg* 0))
	(com-auto-fill-mode)))))

(defun 4turn-off-abbrev-mode* ()
  "2Make sure Abbrev Mode is turned off and Fill Mode is turned on.*"
  (when (member 'WORD-ABBREV-MODE (the list zwei:*mode-name-list*) :test #'eq)
    (let* ((*numeric-arg-p* t)
	   (*numeric-arg* 0))
      (com-word-abbrev-mode)
      (let* ((*numeric-arg* 1))
	(com-auto-fill-mode)))))


(defun 4current-header-name *(point)
  "2Returns a string which is the name of the mail header field before poinr.*"
  (let* ((line (bp-line point)))
    (loop
      (if (or (zerop (length line)) (not (member (char line 0) '(#\Space #\Tab) :test #'char-equal)))
	  (return)
	  (setq point (forward-line point -1)
		line (and point (bp-line point)))))
    (nsubstring line 0 (position #\: line :test #'char-equal))))


(setf (get 'smail-abbrev-toggle-hook 'zwei:command-hook-priority) 8)

(defvar 4*abbrev-expansion-headers* *'(:TO :CC)
  "2The send-mail headers in which word-abbrev mode is to be turned on.  NIL means none; T means all.*")

(defun 4smail-abbrev-toggle-hook* (ignore)
  "2Turns Abbrev mode on if in the Header-section of the buffer, off otherwise.*"
  (when (get *interval* :mail-template-type)
    ;1; if the current point is before the first blank line in the buffer...*
    (let* ((in-header-p (bp-< (point) (zwei::search (interval-first-bp *interval*) #.(format nil "3~%~%*") nil t)))
	   (in-abbrev-field-p (and in-header-p
				   (or (eq 'T 4*abbrev-expansion-headers**)
				       (member (current-header-name (point)) 4*abbrev-expansion-headers**
					       :test #'string-equal)))))
      (if in-abbrev-field-p
	  (turn-on-abbrev-mode)
	  (turn-off-abbrev-mode)))))


(defun 4setup-mail-abbrev-hook* ()
  (command-hook 'smail-abbrev-toggle-hook '*post-command-hook*)
  (auto-fill-if-appropriate)
  nil)

(setq *mail-mode-hook* 'setup-mail-abbrev-hook)

