;;; -*- Mode:Common-Lisp; Package:W; Base:10 -*-

; Adds Mouse-Left and Mouse-Right commands to the lisp listener to allow
; for simple drawing and erasing.

(defconstant *mouse-left-mask* 1)
(defconstant *mouse-middle-mask* 2)
(defconstant *mouse-right-mask* 1)

(defvar *lisp-listener-pen-width* 3)
(defvar *lisp-listener-eraser-width* 16)

(defmethod (lisp-listener :mouse-click) (mouse-char x y)
  (case mouse-char
    (#\mouse-l
     (let ((new-x x)
	   (new-y y))
       (loop while (plusp (logand (mouse-buttons) *mouse-left-mask*))
	     do
	     (setq new-x (- si:mouse-x x-offset)
		   new-y (- si:mouse-y y-offset))
	     (when (and (or (/= new-x x) (/= new-y y))
			(< 0 new-x width) (< 0 new-y height))
	       (send self :draw-line x y new-x new-y *lisp-listener-pen-width*)
	       (setq x new-x y new-y))
	     (process-sleep 2))
       t))
    (#\mouse-m
     (let ((new-x 0)
	   (new-y 0))
       (loop while (plusp (logand (mouse-buttons) *mouse-middle-mask*))
	     do
	     (setq new-x (- si:mouse-x x-offset)
		   new-y (- si:mouse-y y-offset))
	     (when (and (or (/= new-x x) (/= new-y y))
			(< 0 new-x width) (< 0 new-y height))
	       (let ((width2 (lsh *lisp-listener-eraser-width* -1)))
		 (let ((x1 (- new-x width2))
		       (x2 (+ new-x width2))
		       (y1 (- new-y width2))
		       (y2 (+ new-y width2)))
		   (send self :draw-rectangle (min x1 x2) (min y1 y2)
			 (abs (- x2 x1)) (abs (- y2 y1)))
		   (process-sleep 1)
		   (send self :draw-line x y new-x new-y *lisp-listener-eraser-width* white)
		   (send self :draw-filled-rectangle (min x1 x2) (min y1 y2)
			 (abs (- x2 x1)) (abs (- y2 y1)) white)
		   (setq x new-x y new-y)))))
       t))))

(defmethod (lisp-listener :who-line-documentation-string) ()
  '(:mouse-l-hold "Scribble  " :mouse-m-hold "Erase  " :mouse-r-2 "System Menu"
		  :no-comma nil))
