;;; -*- Mode:Common-Lisp; Package:TV; Base:10 -*-

;;; ChangeLog:
;;;
;;; 16 May 88  Jamie Zawinski  Created from 'xlock.c' by Patrick J. Naughton.
;;; 29 Dec 88  Jamie Zawinski  Colorized.
;;; 15 Apr 89  Jamie Zawinski  Moved the definition of HOPALONG-SCREENHACK here from NEW-SCREENHACKS.LISP.
;;;

;;; Call the function HOP.  This will draw fractals on the root window.
;;; Control-Abort to stop it, then refresh the screen.
;;;

(defun inithop (range sheet)
  #+LISPM (declare (values a b c maxiter))
  (send sheet :clear-screen)
  (let* ((scale (* range 100))
	 (a (float (/ (* (random scale) (if (zerop (random 2)) -1 1)) 100) 1.s0))
	 (b (float (/ (* (random scale) (if (zerop (random 2)) -1 1)) 100) 1.s0))
	 (c (float (/ (* (random scale) (if (zerop (random 2)) -1 1)) 100) 1.s0)))
    (when (zerop (random 3)) (setq a (/ a 10.s0)))
    (when (zerop (random 2)) (setq b (/ b 100.s0)))
    (let* ((maxiter (+ (random 50000) 20000)))
      (values a b c maxiter))))




(defvar *hopalong-colors* (list W:WHITE W:RED W:BLUE W:YELLOW W:CYAN W:MAGENTA W:GREEN W:RED-PURPLE)
  "A list of colors that HOPALONG draws with (if we are on a color machine, of course).")


(defun innerhop (sheet)
  (let* ((w (tv:sheet-inside-width sheet))
	 (h (tv:sheet-inside-height sheet))
	 (cx (round w 2))
	 (cy (round h 2))
	 (range (isqrt (round (+ (* cx cx) (* cy cy)) 2)))
	 (i 0) (j 0) (oldj 0)
	 (color-p (tv:color-system-p sheet))
	 (colors *hopalong-colors*)
	 (color-inc 0)
	 )
    (declare (fixnum w h cx cy range i j oldj color-inc))
    (multiple-value-bind (a b c maxiter) (inithop range sheet)
      (declare (fixnum maxiter)
	       (short-float a b c))
      (setq color-inc (floor maxiter (length colors)))
      ;;
      ;; This next loop is the tight part - this had better fly.
      ;;
      (do* ((iter 0 (1+ iter))
	    (ccount 0 (1+ ccount))
	    (color (if color-p (pop colors) -1)))
	   ((> iter maxiter))
	(declare (fixnum iter color)
		 (optimize (speed 3) (safety 0)))
	(when (and color-p (> ccount color-inc))
	  (setq color (or (pop colors) color)
		ccount 0))
	(setq oldj j)
	(setq j (- a i))
	(setq i (+ oldj
		   (if (< i 0)
		       (sqrt    (abs (- (* b i) c)))
		       (- (sqrt (abs (- (* b i) c))))
		       )))
	(send tv:selected-window :draw-point (round (+ cx (+ i j))) (round (- cy (- i j))) TV:ALU-TRANSP color)
	(incf iter))
      )))


;;; The interface to the ScreenSaver.

(defun hopalong-screenhack (window &optional delay)
  (loop
    (innerhop window)
    (sleep (or delay 3))))

(when (boundp 'tv:*screen-saver-hacks-list*)
  (pushnew 'HOPALONG-SCREENHACK tv:*screen-saver-hacks-list*))
