;;; -*- Mode: Common-Lisp; Package: DOMAIN-NAME-SYSTEM; Base: 10.; Patch-File: T -*-
;;; Written 07-Dec-88 17:29:15 by Victor,
;;; Reason: Handle CNAMEs as namespace :ALIASES and :*ALIAS-OF*, respectively.
;;; while running on George Ballantine from band LOD2
;;; With SYSTEM 4.61, VIRTUAL-MEMORY 4.4, EH 4.5, MAKE-SYSTEM 4.5, MICRONET 4.5, LOCAL-FILE 4.1,
;;;  BASIC-PATHNAME 4.12, NETWORK-SUPPORT-COLD 4.1, NAMESPACE 4.22, NETWORK-NAMESPACE 4.2,
;;;  DISK-IO 4.13, DISK-LABEL 4.0, BASIC-FILE 4.7, MAC-PATHNAME 4.5, NETWORK-PATHNAME 4.1,
;;;  COMPILER 4.13, TV 4.85, DATALINK 4.14, CHAOSNET 4.18, GC 4.3, MEMORY-AUX 4.0,
;;;  NVRAM 4.6, SYSLOG 4.0, STREAMER-TAPE 4.4, UCL 4.1, INPUT-EDITOR 4.0, METER 4.3,
;;;  ZWEI 4.18, DEBUG-TOOLS 4.2, NETWORK-SUPPORT 4.5, NETWORK-SERVICE 4.0, DATALINK-DISPLAYS 4.0,
;;;  FONT-EDITOR 4.0, SERIAL 4.0, PRINTER 4.8, PRINTER-TYPES 4.2, IMAGEN 4.0, SUGGESTIONS 4.0,
;;;  MAIL-DAEMON 4.7, MAIL-READER 4.6, TELNET 4.1, VT100 4.6, NAMESPACE-EDITOR 4.5,
;;;  PROFILE 4.4, VISIDOC 4.5, IP 3.19, RPC 4.14, NFS 3.2, Experimental NFS-PATCHES 2.2,
;;;  TI-PROLOG 2.11, GRAPHICS-WINDOW 4.1, GED 4.1, TREE 4.0, VISIDOC-SERVER 4.0, Experimental SYSTEM-PATCHES 3.117,
;;;  Experimental ICU-DOCS 11.4, Experimental SYSTEM-ENHANCEMENTS 18.27, Experimental TCP-IMAGEN 9.5,
;;;  Experimental NAME-DRAGON 3.2, Experimental TEXINFO 5.5, Experimental ICU-LIBRARY 13.10,
;;;  Experimental DOMAIN 5.0, Experimental STUB-RESOLVER 1.4,  microcode 534, Band Name: 4.61 w DNS&Prolog,
;;;  881122/Vic

#!C
; From file STUB-RESOLVER.LISP#> ICU.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-RESOLVER.#"


(defun stub-send-dns-packet (server message msg-len medium n-retries)
  (ecase medium
    (:datagram
     (let* ((port (ticl:send ip:*udp-handler* :get-port))
	    (pkt
	      (unwind-protect
		  (let ((reply-block (make-array 512 :element-type '(unsigned-byte 8)))
			(server-address (net:parse-network-address server :ip)))
		    (dotimes (i n-retries nil)
		      (ticl:send port :transmit-data :data message :length msg-len
				 :destination-host server-address :destination-port 53.)
		      (multiple-value-bind (nbytes port rhost not-timed-out)
			  (ticl:send port :receive-data reply-block *stub-resolver-individual-timeout*)
			(declare (ignore port))
			(if (and not-timed-out (/= rhost server-address))
			    (incf i)
			    (when not-timed-out
			      (return (values reply-block nbytes)))))))
		(ticl:send ip:*udp-handler* :return-port port))))
       pkt))
    (:virtual-circuit
     (with-open-stream (s (ip:open-stream server :remote-port 53.))
       (write-byte (ldb (byte 8 8) msg-len) s)
       (write-byte (ldb (byte 8 0) msg-len) s) 
       (write-string message s :end msg-len)
       (force-output s)
       ;;**** This does not hack zone transfers (see pp 28,29 in RFC1034), it only hacks single messages.
       (let ((in-length (dpb (read-byte s) (byte 8 8) (read-byte s))))
	 (let ((reply (make-array (* 64 20) :element-type '(unsigned-byte 8) :fill-pointer 0)))
	   (dotimes (n in-length reply)
	     (vector-push-extend (read-byte s) reply))))))))
))

#!C
; From file STUB-RESOLVER.LISP#> ICU.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-RESOLVER.#"


(defun stub-send-dns-query (ques server &key (n-retries *stub-resolver-n-retries*) (recursion-desired t)
			    (medium :datagram) (switch-mediums-on-truncation t))
  (check-type ques message-question "a DNS question")
  (let* ((hdr (make-message-header))
	 (msg (make-message :header hdr :questions (if (listp ques) ques (list ques))))
	 (id (random #.(expt 2 16))))
    (setf (message-header-response-p hdr) nil
	  (message-header-opcode hdr) dns:*opcode-query*
	  (message-header-recursion-desired hdr) recursion-desired
	  (message-header-question-count hdr) 1
	  (message-header-id hdr) id
	  )
    (multiple-value-bind (message msg-len) (parse-message msg)
      (let ((pkt (stub-send-dns-packet server message msg-len medium n-retries)))
	(when pkt
	  (let ((msg (get-message-packet pkt)))
	    (cond ((not (eql id (message-header-id (message-header msg))))
		   (stub-send-dns-query ques server :n-retries (1- n-retries) :recursion-desired recursion-desired
					:medium medium :switch-mediums-on-truncation switch-mediums-on-truncation))
		  ((/= *response-no-error* (message-header-response-code (message-header msg)))
		   (error "Error from Domain server ~a: ~s"
			  server
			  (response-code-string (message-header-response-code (message-header msg)))))
		  ((and (not (null (message-header-truncated-p (message-header msg))))
			(not (null switch-mediums-on-truncation))
			(eq medium :datagram))
		   ;; Change to virtual circuit
		   (stub-send-dns-query ques server :n-retries (1- n-retries) :recursion-desired recursion-desired
					:medium :virtual-circuit :switch-mediums-on-truncation nil))
		  ((zerop (message-header-answer-count (message-header msg)))
		   (if (message-header-authoritative-p (message-header msg))
		       :no-answer
		       :dont-know))
		  ((and (= *type-canonical-name* (message-resource-record-type (first (message-answers msg))))
			(/= *type-canonical-name* (message-question-type ques))
;;; Maybe not compatible with use.
;			(/= *type-wild-request* (message-question-type ques))
			)
		   (stub-send-dns-query
		     (make-message-question :name (message-resource-record-data (first (message-answers msg)))
					    :type (message-question-type ques)
					    :class (message-question-class ques))
		     server :n-retries n-retries :recursion-desired recursion-desired))
		  (t
		   (message-answers msg)))))))))

))

#!C
; From file STUB-RESOLVER.LISP#> ICU.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-RESOLVER.#"


(defun stub-get-canonical-name-of-name (name &optional (servers *stub-servers*))
  (let ((question (make-message-question :name name :type *type-canonical-name* :class *class-internet*)))
    (dolist (server servers)
      (let ((answers (stub-send-dns-query question server)))
	(when (and answers (not (keywordp answers)))
	  (return
	    (values (mapcar #'message-resource-record-data
			    answers)
		    (message-resource-record-name (first answers)))))))))

))

#!C
; From file STUB-NAMESPACE.LISP#> ICU.NETWORK.DNS; JJ:
#10R NAME#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "NAME"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-NAMESPACE.#"



(defmethod (dns-stub-namespace :very-internal-find-object) (name class)
  (declare (values internal-object))
  (when (eq class :host)
    (let ((object (dns-stub-make-host-object name safety-belt-servers)))
      (when object
	(send self :mark-object-updated object)
	(send self :put-object object)
	;; Make alias objects
	(let ((aliases (get-attribute-value object :aliases)))
	  (when aliases
	    (dolist (alias aliases)
	      (let ((obj (build-object alias :host (list *alias-of* (object-name object)))))
		(send self :mark-object-updated obj)
		(send self :put-object obj)))))
	)
      object)))

))

#!C
; From file STUB-NAMESPACE.LISP#> ICU.NETWORK.DNS; JJ:
#10R NAME#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "NAME"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-NAMESPACE.#"



(defmethod (dns-stub-namespace :around :extract-objects-from-properties) (continuation mapping-table op-arglist
									  &optional name-pattern class first-only
									  property-list test format)
  "Return a subset of the objects in the namespace.  NAME-PATTERN can be the actual name of
   an object or a string containing wildcard characters.  CLASS restricts to objects of that class.
   FIRST-ONLY says return only the first object matching the criteria.  
   PROPERTY-LIST is a list of attributes and values required. 
   FORMAT is :BRIEF :LIST :READ-ONLY or :COPY.
   TEST can be a function which takes a candiate object, NAME-PATTERN, CLASS, and PROPERTY-LIST and
   returns T or NIL. " 
  (declare (ignore format first-only))

  ;;If this is a typical call from NET:GET-HOST-FROM-ADDRESS
  (if (and (eq test 'net:ns-get-host-from-address) (eq class :host)
	   (null name-pattern)
	   (= 4 (length property-list))
	   (and (eq (getf property-list :network) :ip)
		(not (null (getf property-list :address)))))
      (or
	;; first try the basic method
	(lexpr-funcall-with-mapping-table continuation mapping-table op-arglist)
	;; else look up the host from the address, and add it
	(let ((object (dns-stub-lookup-host-object-from-address (getf property-list :address))))
	  (when object
	    (send self :mark-object-updated object)
	    (send self :put-object object)
	    ;; Make alias objects
	    (let ((aliases (get-attribute-value object :aliases)))
	      (when aliases
		(dolist (alias aliases)
		  (let ((obj (build-object alias :host (list *alias-of* (object-name object)))))
		    (send self :mark-object-updated obj)
		    (send self :put-object obj)))))
	    ;; and use the basic method to find it again...
	    (lexpr-funcall-with-mapping-table continuation mapping-table op-arglist))))
      ;; not our special case, call basic method.
      (lexpr-funcall-with-mapping-table continuation mapping-table op-arglist)))

))

#!C
; From file STUB-NAMESPACE.LISP#> ICU.NETWORK.DNS; JJ:
#10R NAME#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "NAME"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-NAMESPACE.#"


(defun dns-stub-make-host-object (host servers)
  (flet ((find-cname-and-addresses (spec)
	   (dbg:when-debug (format *trace-output* "~&Trying ~s..." spec))
	   (condition-case (cond)
	       (values-list (append (multiple-value-list (dns:stub-canonicalize-case spec servers)) (list spec)))
	     (error nil))))
    (multiple-value-bind (cname addresses spec)
	(cond ((char= #\. (char host (1- (length host))))
	       (find-cname-and-addresses host))
	      ((find #\. host :test #'char=)
	       (find-cname-and-addresses (string-append host ".")))
	      (t
	       (loop with cname and addresses
		     for search in *dns-stub-domain-search-list*
		     as spec = (string-append host "." search ".")
		     do
		     (multiple-value-setq (cname addresses)
		       (find-cname-and-addresses spec))
		     when (and (not (null cname)) (not (null addresses)))
		     do (return (values cname addresses))
		     ;;Don't try top level - there are no top level hosts.
;		     finally
;		     (return
;		       (find-cname-and-addresses (string-append host ".")))
		     )))
      (when (or (null cname) (null addresses))
	(return-from dns-stub-make-host-object nil))
      (let* ((name (format nil "~{~a~^.~}" cname))
	     (short-name (first cname))		;**** Might want this only on local domain(s)? (in search-list?)
	     (any (dns:stub-get-any-info-of-name cname servers))
	     (alias (nth-value 1 (dns:stub-get-canonical-name-of-name spec servers)))
	     (alias-name (and alias (format nil "~{~a~^.~}" alias)))
	     (hinfo nil) (wks nil))
	(if (and (assoc :hinfo any)
		 (assoc :wks any))
	    (setq hinfo (canonicalize-hinfo (first (cdr (assoc :hinfo any))))
		  wks (make-services-from-ip-wks-records (cdr (assoc :wks any))))
	    (setq hinfo (canonicalize-hinfo (dns:stub-get-host-info-of-name cname servers))
		  wks (make-services-from-ip-wks-records (dns:stub-get-wks-of-name cname servers))))
	(build-object name :host `(:short-name ,short-name
				   :aliases ,(when alias (list alias-name))
				   :system-type ,(second hinfo)
				   :machine-type ,(first hinfo)
				   :services ((:status :tcp :ip-status)
					      ,@(or wks
						    (get :ip :default-network-services)))
				   (:addresses :group)
				   ,(loop for addr in addresses
					  collect (list :ip (ethernet:dotted-format-ip-address addr)))))))))

))
