;;; -*- Mode: Common-Lisp; Package: NAME; Base: 10.; Patch-File: T -*-
;;; Written 05-Dec-88 22:01:51 by Victor,
;;; Reason: Patch to put DNS namespace second last on search list when rebuilding the search list.
;;; while running on George Ballantine from band LOD2
;;; With SYSTEM 4.61, VIRTUAL-MEMORY 4.4, EH 4.5, MAKE-SYSTEM 4.5, MICRONET 4.5, LOCAL-FILE 4.1,
;;;  BASIC-PATHNAME 4.12, NETWORK-SUPPORT-COLD 4.1, NAMESPACE 4.22, NETWORK-NAMESPACE 4.2,
;;;  DISK-IO 4.13, DISK-LABEL 4.0, BASIC-FILE 4.7, MAC-PATHNAME 4.5, NETWORK-PATHNAME 4.1,
;;;  COMPILER 4.13, TV 4.85, DATALINK 4.14, CHAOSNET 4.18, GC 4.3, MEMORY-AUX 4.0,
;;;  NVRAM 4.6, SYSLOG 4.0, STREAMER-TAPE 4.4, UCL 4.1, INPUT-EDITOR 4.0, METER 4.3,
;;;  ZWEI 4.18, DEBUG-TOOLS 4.2, NETWORK-SUPPORT 4.5, NETWORK-SERVICE 4.0, DATALINK-DISPLAYS 4.0,
;;;  FONT-EDITOR 4.0, SERIAL 4.0, PRINTER 4.8, PRINTER-TYPES 4.2, IMAGEN 4.0, SUGGESTIONS 4.0,
;;;  MAIL-DAEMON 4.7, MAIL-READER 4.6, TELNET 4.1, VT100 4.6, NAMESPACE-EDITOR 4.5,
;;;  PROFILE 4.4, VISIDOC 4.5, IP 3.19, RPC 4.14, NFS 3.2, Experimental NFS-PATCHES 2.2,
;;;  TI-PROLOG 2.11, GRAPHICS-WINDOW 4.1, GED 4.1, TREE 4.0, VISIDOC-SERVER 4.0, Experimental SYSTEM-PATCHES 3.115,
;;;  Experimental ICU-DOCS 11.4, Experimental SYSTEM-ENHANCEMENTS 18.27, Experimental TCP-IMAGEN 9.5,
;;;  Experimental NAME-DRAGON 3.2, Experimental TEXINFO 5.5, Experimental ICU-LIBRARY 13.10,
;;;  Experimental DOMAIN 5.0, Experimental STUB-RESOLVER 1.1,  microcode 534, Band Name: 4.61 w DNS&Prolog,
;;;  881122/Vic

#!C
; From file STUB-NAME-MANAGER.LISP#> ICU.NETWORK.DNS; JJ:
#10R NAME#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "NAME"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-NAME-MANAGER.#"


(DEFUN BUILD-NS-SEARCH-LIST (&OPTIONAL SEARCH-LIST (BOOT-NEW-SERVERS T))
  
  (UNLESS SEARCH-LIST
    (let ((boot-ns (send net:local-host :domain)))
      (SETF SEARCH-LIST (if (typep (find-namespace boot-ns) 'symbolics-remote-namespace)
			    (or (GET-SITE-OPTION :NAMESPACE-SEARCH-LIST)
				(name:lookup-attribute-value boot-ns :namespace :search-rules)) ;this may return a string
			    (GET-SITE-OPTION :NAMESPACE-SEARCH-LIST)))
      (unless (consp search-list) (setf  search-list (list  search-list))) ;results must be a list 12-11-87 DAB
      ))
    
  (WHEN SEARCH-LIST
    (LET (NEW-SEARCH-LIST)
      (LOOP
	FOR NAMESPACE-NAME IN SEARCH-LIST
	WITH NS
	WITH ERROR-STRING 
	DO
	(SETQ NS NIL)				;on each loop iteration
	
        ;; Assume any of the namespaces on the new search list may already be known
        (CONDITION-CASE (COND)
	    (SETF NS (FIND-NAMESPACE NAMESPACE-NAME))
	  (ERROR (SETQ ERROR-STRING (SEND COND :REPORT-STRING))
		 (SETF NS NIL)))
	
        (IF NS 
	    (PUSH NS NEW-SEARCH-LIST)
	    ;; ELSE
	    (NOTIFY "Unable to place namespace ~A on new search list because: ~A" NAMESPACE-NAME ERROR-STRING)))
      
      ;; Make sure the network and distribution namespaces are there
      (LET ((NETWORK-NAMESPACE (ON-SEARCH-LIST *NET-DOMAIN*)))
	(WHEN (AND NETWORK-NAMESPACE (NOT (ON-SEARCH-LIST *NET-DOMAIN* NEW-SEARCH-LIST)))
	  (PUSH NETWORK-NAMESPACE NEW-SEARCH-LIST))
	;;[Victor]**** Make sure DNS namespace is there too!
	(when (and *dns-stub-namespace* (not (on-search-list *dns-stub-namespace-name* new-search-list)))
	  (push *dns-stub-namespace* new-search-list))
	(WHEN (AND *DISTRIBUTION-NAMESPACE* (NOT (ON-SEARCH-LIST *DISTRIBUTION-NAME* NEW-SEARCH-LIST)))
	  (PUSH *DISTRIBUTION-NAMESPACE* NEW-SEARCH-LIST))
	)
      
      (SETQ *NAMESPACE-SEARCH-LIST* (NREVERSE NEW-SEARCH-LIST))

      ;; If we are supposed to be a local server and don't know it, bootstrap us
      (LOOP
	FOR NS IN *NAMESPACE-SEARCH-LIST* 
   	WITH SERVERS 
	WITH NAMESPACE-NAME DO
         (CONDITION-CASE (COND)
	    (WHEN (AND  BOOT-NEW-SERVERS
		       *NAME-SUPERVISOR*
		       (NOT (FIND-SERVER (SETF NAMESPACE-NAME (SEND NS :DOMAIN-NAME))))
		       (SEND NS :SEND-IF-HANDLES :SERVER-QUERY (RELATIVE-MACHINE-NAME))
		       (SETF SERVERS (LOOKUP-ATTRIBUTE-VALUE NAMESPACE-NAME :NAMESPACE :SERVERS :NAMESPACE NS)))
	      (SEND *NAME-SUPERVISOR* :BACKGROUND :ADD-SERVER NAMESPACE-NAME SERVERS :BEGINNING :CLIENT-EXISTS))
	  (ERROR
	   (NOTIFY "Placing namespace ~A on new search list, but can't tell if local machine is a server because ~A"
		   NAMESPACE-NAME (SEND COND :REPORT-STRING)))))
      
      *NAMESPACE-SEARCH-LIST*)))
))
