;;; -*- Mode:Common-Lisp; Package:SYSTEM; Base:10 -*-


(export 'describe-defstruct-diff)

(defun describe-defstruct-diff (x y)
  (let ((description (get (if (consp x) (car x) (named-structure-p x)) 'defstruct-description))
	(*print-structure* nil))
    (if (null (and (typep x (type-of y))
		   (typep y (type-of x))))
	(progn
	   (format t "~%Cannot describe differences due to type mismatch.  Describing normally:~%")
	   (describe-defstruct x))
	(progn
	   (format t "~%~S (type ~S) and~%~s differ thus:~%" x (defstruct-description-name) y)
	   (do ((l (defstruct-description-slot-alist) (cdr l))
		(x-val :error :error)
		(y-val nil nil)
		(no-diffs t))
	       ((null l)
		(if no-diffs (format t "   No differences found.~%")))
	     (catch-error
		(let ((macro (defstruct-slot-description-ref-macro-name (cdar l))))
		  (setf x-val (eval1 `(,macro ',x))
			y-val (eval1 `(,macro ',y))))
		nil)
	     (unless (eql x-val y-val)
	       (setf no-diffs nil)
	       (format t "   ~30A~S~%" (concatenate 'string (string (caar l)) ":") x-val)))))
    x))