;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: mcl-ffi.lisp
;;;  Author: Heeger & Chichilnisky
;;;  Description: collect all the foreign function interface into one place
;;;  Creation Date: 12/93, modified from lucid-ffi
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'obvius)

;;; array-ops.lisp
(deffcfun-obv (memcpy "memcpy")
    (array array fixnum) :long)
(deffcfun-obv (memset "memset")
    (array fixnum fixnum))
(deffcfun-obv (internal-scalar-multiple "internal_scalar_multiple")
    (array array float fixnum float) :long)
(deffcfun-obv (internal-sc-almost-equal "internal_sc_almost_equal")
    (array float fixnum float) :long)
(deffcfun-obv (internal-almost-equal "internal_almost_equal")
    (array array fixnum float) :long)

;;; arrayio-c.lisp
;; **** Screwed up: return type is actually a file pointer!
(deffcfun-obv (fopen "fopen")
  (string string) 
  :long)	
(deffcfun-obv (fclose "fclose")
  (fixnum))
(deffcfun-obv (fread "fread")
  (array fixnum fixnum fixnum)
  :long)
(deffcfun-obv (fwrite "fwrite")
  (array fixnum fixnum fixnum)
  :long)
(deffcfun-obv (fprintf "fprintf")
    (fixnum string))
(deffcfun-obv (byteswap "byteswap")
    (array fixnum))
(deffcfun-obv (swapcopy "swapcopy")
    (array array fixnum))


;;; color.lisp
(deffcfun-obv (internal-cieluv "internal_cieluv")
    (array array array))
(deffcfun-obv (internal-cieluv-rows "internal_cieluv_rows")
    (array array array fixnum))
(deffcfun-obv (internal-cielab "internal_cielab")
    (array array array))
(deffcfun-obv (internal-cielab-rows "internal_cielab_rows")
    (array array array fixnum))

#|
;;; ***
;;; image-sequence.lisp
#+Sun (deffcfun-obv usleep
	  (usecs :unsigned-32bit))
|#

;;; fft.lisp
(deffcfun-obv (internal-fft "internal_fft")
    (array array array fixnum fixnum))
(deffcfun-obv (internal-realft "internal_realft")
    (array array array fixnum fixnum))


;;; hardcopy.lisp
(deffcfun-obv (internal-chartohex "internal_chartohex")
    (string array fixnum fixnum array))


;;; gray.lisp
(deffcfun-obv (internal-dither-into-8bit-lut "internal_dither_into_8bit_lut")
    (array fixnum fixnum array fixnum float float fixnum fixnum array fixnum))


;;; bitmap.lisp
(deffcfun-obv (internal-dither-to-1bit "internal_dither_to_1bit")
    (array fixnum fixnum array fixnum fixnum float float))
(deffcfun-obv (internal-dither-into-1bit "internal_dither_into_1bit")
    (array fixnum fixnum array fixnum float float fixnum fixnum))

#|
;;; ***
;;; flipbook.lisp
(deffcfun-obv (select-fds #-Irix (:name "_select") #+Irix (:name "select"))
    (numfds :fixnum) ins outs errs sleep-time)
|#


;;; surface-plot.lisp:
(deffcfun-obv (internal-perspective-projection "internal_perspective_projection")
    (array fixnum fixnum array array fixnum fixnum array))
(deffcfun-obv (internal-perspective-projection-int "internal_perspective_projection_int")
    (array fixnum fixnum array array fixnum fixnum array))
(deffcfun-obv (internal-orthographic-projection "internal_orthographic_projection")
    (array fixnum fixnum array array fixnum fixnum array))
(deffcfun-obv (internal-orthographic-projection-int "internal_orthographic_projection_int")
    (array fixnum fixnum array array fixnum fixnum array))
(deffcfun-obv (internal-compute-surface "internal_compute_surface")
    (array array fixnum fixnum array array fixnum array array array array fixnum)
  :long)


;;; mcl-blt.lisp
(deffcfun-obv (internal-replicate-8bit "internal_replicate_8bit")
    (array fixnum fixnum fixnum fixnum array fixnum
	   fixnum fixnum fixnum fixnum fixnum))
(deffcfun-obv (internal-subsample-8bit "internal_subsample_8bit")
    (array fixnum fixnum array fixnum fixnum))
(deffcfun-obv (internal-paste-8bit-region "internal_paste_8bit_region")
    (array fixnum fixnum fixnum fixnum array fixnum fixnum fixnum fixnum fixnum))
(deffcfun-obv (internal-subsample-8bit-region "internal_subsample_8bit_region")
    (array fixnum fixnum fixnum fixnum array fixnum
	   fixnum fixnum fixnum fixnum fixnum))
(deffcfun-obv (internal-replicate-1bit "internal_replicate_1bit")
    (array fixnum fixnum array fixnum fixnum))
(deffcfun-obv (internal-subsample-1bit "internal_subsample_1bit")
    (array fixnum fixnum array fixnum fixnum))

;;; filter.lisp
(deffcfun-obv (internal-wrap-filter "internal_wrap_filter")
    (array fixnum fixnum array fixnum fixnum fixnum fixnum fixnum fixnum
           array fixnum))
(deffcfun-obv (internal-wrap-expand "internal_wrap_expand")
    (array array fixnum fixnum fixnum fixnum fixnum fixnum array
	   fixnum fixnum fixnum))
(deffcfun-obv (internal-filter "internal_filter")
    (array fixnum fixnum array array fixnum fixnum fixnum
	    fixnum fixnum fixnum array string))
(deffcfun-obv (internal-expand "internal_expand")
    (array array array fixnum fixnum fixnum fixnum fixnum
	   fixnum array fixnum fixnum string))
(deffcfun-obv (internal-hex-filter "internal_hex_filter")
    (array fixnum fixnum array array fixnum fixnum fixnum
	   fixnum fixnum fixnum array string fixnum))
(deffcfun-obv (internal-hex-expand "internal_hex_expand")
    (array array array fixnum fixnum fixnum fixnum fixnum
	   fixnum array fixnum fixnum string fixnum))


;;; param-filter.lisp
(deffcfun-obv (internal-p-filter "internal_p_filter")
    (array fixnum fixnum array array fixnum array array fixnum fixnum
	    fixnum fixnum fixnum fixnum array string fixnum))
(deffcfun-obv (internal-p-expand "internal_p_expand")
    (array array array fixnum array array fixnum fixnum fixnum fixnum
	    fixnum fixnum array fixnum fixnum string fixnum))


;;; imops.lisp
(deffcfun-obv (internal-logistic "internal_logistic")
    (array array fixnum)
  :long)
(deffcfun-obv (internal-sgn "internal_sgn")
    (array array float fixnum)
  :long)
(deffcfun-obv (internal-16bit-to-float "internal_16bit_to_float")
    (array array fixnum)
  :long)
(deffcfun-obv (internal-8bit-to-float "internal_8bit_to_float")
    (array array fixnum)
  :long)
(deffcfun-obv (internal-add "internal_add")
    (array array array fixnum))
(deffcfun-obv (internal-sc-add "internal_sc_add")
    (array array fixnum float))
(deffcfun-obv (internal-sub "internal_sub")
    (array array array fixnum))
(deffcfun-obv (internal-sc-sub "internal_sc_sub")
    (array array fixnum float))
(deffcfun-obv (internal-mul "internal_mul")
    (array array array fixnum))
(deffcfun-obv (internal-sc-mul "internal_sc_mul")
    (array array fixnum float))
(deffcfun-obv (internal-div "internal_div")
    (array array array fixnum float)
  :long)
(deffcfun-obv (internal-sc-div "internal_sc_div")
    (array array fixnum float float)
  :long)
(deffcfun-obv (internal-linear-xform "internal_linear_xform")
    (array array fixnum float float))
(deffcfun-obv (internal-negate "internal_negate")
    (array array fixnum))
(deffcfun-obv (internal-square "internal_square")
    (array array fixnum))
(deffcfun-obv (internal-sqrt "internal_sqrt")
    (array array fixnum))
(deffcfun-obv (internal-abs "internal_abs")
    (array array fixnum))
(deffcfun-obv (internal-pow-sc "internal_pow_sc")
    (array array fixnum float))
(deffcfun-obv (internal-sc-pow "internal_sc_pow")
    (array array fixnum float))
(deffcfun-obv (internal-pow "internal_pow")
    (array array array fixnum))
(deffcfun-obv (internal-ln "internal_ln")
    (array array fixnum float)
  :long)
(deffcfun-obv (internal-exp "internal_exp")
    (array array fixnum))
(deffcfun-obv (internal-pointop "internal_pointop")
    (array array fixnum array fixnum float float))
(deffcfun-obv (internal-periodic-pointop "internal_periodic_pointop")
    (array array fixnum array fixnum float))
(deffcfun-obv (internal-circular-shift "internal_circular_shift")
    (array array fixnum fixnum fixnum fixnum fixnum fixnum))
(deffcfun-obv (internal-flip-x "internal_flip_x")
    (array array fixnum fixnum))
(deffcfun-obv (internal-flip-y "internal_flip_y")
    (array array fixnum fixnum))
(deffcfun-obv (internal-flip-xy "internal_flip_xy")
    (array array fixnum fixnum))
(deffcfun-obv (internal-clip "internal_clip")
    (array array fixnum float float))
(deffcfun-obv (internal-im-thresh "internal_im_thresh")
    (array array array fixnum))
(deffcfun-obv (internal-thresh "internal_thresh")
    (array array fixnum float))
(deffcfun-obv (internal-round "internal_round")
    (array array fixnum float))
(deffcfun-obv (internal-truncate "internal_truncate")
    (array array fixnum float))
(deffcfun-obv (internal-floor "internal_floor")
    (array array fixnum float))
(deffcfun-obv (internal-quantize "internal_quantize")
    (array array fixnum float float))
(deffcfun-obv (internal-const "internal_const")
    (array float fixnum))
(deffcfun-obv (internal-make-ramp "internal_make_ramp")
    (array fixnum fixnum float float float))
(deffcfun-obv (internal-random "internal_random")
    (array fixnum fixnum))
(deffcfun-obv (internal-copy-array "internal_copy_array")
    (array array fixnum))
(deffcfun-obv (internal32-copy-array "internal32_copy_array")
    (array array fixnum))
(deffcfun-obv (internal-transpose "internal_transpose")
    (array array fixnum fixnum))
(deffcfun-obv (internal-paste "internal_paste")
    (array fixnum fixnum fixnum fixnum fixnum array fixnum fixnum fixnum))
(deffcfun-obv (internal-sq-err "internal_sq_err")
    (array array array fixnum))
(deffcfun-obv (internal-abs-err "internal_abs_err")
    (array array array fixnum))
(deffcfun-obv (internal-sum-of-squares "internal_sum_of_squares")
    (array array array fixnum))
(deffcfun-obv (internal-sqrt-sum-of-squares "internal_sqrt_sum_of_squares")
    (array array array fixnum))
(deffcfun-obv (internal-phase "internal_phase")
    (array array array fixnum))
(deffcfun-obv (internal-im-min "internal_im_min")
    (array array array fixnum))
(deffcfun-obv (internal-sc-im-min "internal_sc_im_min")
    (array array fixnum float))
(deffcfun-obv (internal-im-max "internal_im_max")
    (array array array fixnum))
(deffcfun-obv (internal-sc-im-max "internal_sc_im_max")
    (array array fixnum float))
(deffcfun-obv (internal-min "internal_min")
    (array fixnum)
  :float)
(deffcfun-obv (internal-max "internal_max")
    (array fixnum)
  :float)
(deffcfun-obv (internal-min-of "internal_min_of")
    (array fixnum array))
(deffcfun-obv (internal-max-of "internal_max_of")
    (array fixnum array))
(deffcfun-obv (internal32-min-of "internal32_min_of")
    (array fixnum array))
(deffcfun-obv (internal32-max-of "internal32_max_of")
    (array fixnum array))
(deffcfun-obv (internal-range "internal_range")
    (array fixnum array))
(deffcfun-obv (internal-sum-of "internal_sum_of")
    (array fixnum)
  :float)
(deffcfun-obv (internal-product-of "internal_product_of")
    (array fixnum)
  :float)
(deffcfun-obv (internal-mean "internal_mean")
    (array fixnum fixnum)
  :float)
(deffcfun-obv (internal-variance "internal_variance")
    (array fixnum fixnum)
  :float)
(deffcfun-obv (internal-third-moment "internal_third_moment")
    (array fixnum float)
  :float)
(deffcfun-obv (internal-fourth-moment "internal_fourth_moment")
    (array fixnum float)
  :float)
;;(deffcfun-obv (internal-entropy "internal_entropy")
;;    (array fixnum fixnum fixnum fixnum)
;;  :float)
(deffcfun-obv (internal-histogram "internal_histogram")
    (array fixnum array fixnum float float))
(deffcfun-obv (internal-mean-sq-err "internal_mean_sq_err")
    (array array fixnum)
  :float)
(deffcfun-obv (internal-mean-abs-err "internal_mean_abs_err")
    (array array fixnum)
  :float)
(deffcfun-obv (internal-8bit-to-f "internal_8bit_to_f")
    (array array fixnum))
(deffcfun-obv (internal-32bit-to-f "internal_32bit_to_f")
    (array array fixnum))
(deffcfun-obv (internal-f-to-32bit "internal_f_to_32bit")
    (array array fixnum float float))
(deffcfun-obv (internal-f-to-8bit "internal_f_to_8bit")
    (array array fixnum float float fixnum fixnum))
(deffcfun-obv (internal-f-into-8bit "internal_f_into_8bit")
    (array fixnum fixnum array fixnum float float))
(deffcfun-obv (internal-f-into-8bit-lut "internal_f_into_8bit_lut")
    (array fixnum fixnum array fixnum float float fixnum fixnum array fixnum))


;;; matrix.lisp
(deffcfun-obv (internal-matrix-mul "internal_matrix_mul")
    (array fixnum fixnum array fixnum fixnum array fixnum fixnum))
(deffcfun-obv (internal-matrix-mul-transpose "internal_matrix_mul_transpose")
    (array fixnum fixnum array fixnum fixnum array fixnum fixnum))
(deffcfun-obv (internal-matrix-transpose-mul "internal_matrix_transpose_mul")
    (array fixnum fixnum array fixnum fixnum array fixnum fixnum))
(deffcfun-obv (internal-matrix-transpose "internal_matrix_transpose")
    (array fixnum fixnum array))
(deffcfun-obv (internal-dot-product "internal_dot_product")
    (array array fixnum) :float)
(deffcfun-obv (internal-qf-row-arr "internal_qf_row_arr")
    (array array fixnum fixnum) :float)

(deffcfun-obv (internal-svd "internal_svd")
  (array fixnum fixnum array array array array array) :long)
#|
;;; stepit.lisp
(deffcfun-obv (stepit_fit (language c)  (return-type float))
    (error-function pointer)
  (parameters (array single-float))
  (lower-bounds (array single-float))
  (upper-bounds (array single-float))
  (smallest-steps (array single-float))
  (initial-steps (array single-float))
  (err (array single-float))
  (dx (array single-float))
  (xs (array single-float))
  (dlx (array single-float))
  (xosc (array single-float))
  (salvo (array single-float))
  (fstor (array single-float))
  (vec (array single-float))
  (fosc (array single-float))
  (masks (array fixnum))
  (jflat (array fixnum))
  (num-parameters fixnum)
  (max-function-calls fixnum)
  (ntrac fixnum)
  (mosq fixnum))

(LCLdef-foreign-callable (stepit-foreign-error-function (return-type float)) ()
  (stepit-error-function))

;;; numerical-recipes.lisp
;;; Interfaces to NR library functions
(deffcfun-obv (gammp "gammp")
    (float float) :float)
(deffcfun-obv (gammq "gammq")
    (float float) :float)
(deffcfun-obv (gammln "gammln")
    (float) float)
(deffcfun-obv (betai "betai")
    (float float float) :float)
(deffcfun-obv (factrl "factrl")
    (fixnum) :float)
(deffcfun-obv (factln "factln")
    (fixnum) :float)
(deffcfun-obv (bico "bico")
    (fixnum fixnum) :float)
|#

#|
(defun load-numerical-recipes-library (path)
  (let ((foreign-function-names (list "_gammp" "_gammq" "_gammln" "_betai"
				      "_factrl" "_factln" "_bico")))
    (LCLload-foreign-libraries foreign-function-names (list path))))
(defun load-tiff-library (path)
  (LCLload-foreign-libraries nil (list path)))

;; The nrerror() routine must be defined here,
;; since the NR version calls exit(), which kills the Lisp process.
(LCLdef-foreign-callable (nrerror (return-type signed-32bit))
    ((string simple-string))
  (warn (concatenate 'string "Numerical Recipes error - " string))
  0)
|#


;;; warper.lisp
(deffcfun-obv (bilinear-warp "bilinear_warp")
    (array array array array fixnum fixnum))
(deffcfun-obv (bicubic-warp "bicubic_warp")
    (array array array array fixnum fixnum))
(deffcfun-obv (wrap-warp "wrap_warp")
    (array array array array fixnum fixnum))
(deffcfun-obv (clip-warp "clip_warp")
    (array array fixnum fixnum array array fixnum fixnum))

;;; row-ops.lisp
(deffcfun-obv (internal-add-arr-row "internal_add_arr_row")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-sub-arr-row "internal_sub_arr_row")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-sub-row-arr "internal_sub_row_arr")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-mul-arr-row "internal_mul_arr_row")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-div-arr-row "internal_div_arr_row")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-div-row-arr "internal_div_row_arr")
    (array array array fixnum fixnum) :long)

(deffcfun-obv (internal-add-arr-col "internal_add_arr_col")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-sub-arr-col "internal_sub_arr_col")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-sub-col-arr "internal_sub_col_arr")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-mul-arr-col "internal_mul_arr_col")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-div-arr-col "internal_div_arr_col")
    (array array array fixnum fixnum) :long)
(deffcfun-obv (internal-div-col-arr "internal_div_col_arr")
    (array array array fixnum fixnum) :long)

(deffcfun-obv (internal-row-sum-of-square "internal_row_sum_of_square")
    (array array fixnum fixnum) :long)
(deffcfun-obv (internal-row-sum "internal_row_sum")
    (array array fixnum fixnum) :long)
(deffcfun-obv (internal-col-sum "internal_col_sum")
    (array array fixnum fixnum) :long)
(deffcfun-obv (internal-row-swap "internal_row_swap")
    (array fixnum fixnum fixnum) :long)

