;;; -*- Package: OBVIUS; Syntax: Common-lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: convolve-lisp.lisp
;;;  Author: Eero Simoncelli
;;;  Description: Circular convolution in LISP.
;;;  Creation Date: June, 1988
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'obvius)
(export '())

;;; IMPORTANT NOTE: All changes to this file should be accompanied by parallel 
;;; changes to the file ext/wrap.c.

;;; this needs to be written
;;; for now, simply calls internal-wrap-filter
(defun internal-filter (image x-dim y-dim filt temp x-fdim y-fdim
			xgrid-start xgrid-step ygrid-start ygrid-step
			result edges stag)
  (internal-wrap-filter image x-dim y-dim filt x-fdim y-fdim 
			xgrid-start xgrid-step ygrid-start ygrid-step 
			result stag))

;;; this needs to be written
;;; for now, simply calls internal-wrap-expand
(defun internal-expand (image filt temp x-fdim y-fdim xgrid-start xgrid-step 
			ygrid-start ygrid-step result x-dim y-dim edges stag)
  (internal-wrap-expand image filt x-fdim y-fdim xgrid-start xgrid-step 
			ygrid-start ygrid-step result x-dim y-dim stag))

;;; This function has a nasty arglist because it is a replacement for the C
;;; version in obvius/ext/wrap.c.  The raw arrays are passed, not the objects.
(defun internal-wrap-filter (image x-dim y-dim filt x-fdim y-fdim 
				   xgrid-start xgrid-step ygrid-start 
				   ygrid-step result stag)
  (declare (type (array single-float (* *)) image result)
	   (type fixnum x-dim y-dim x-fdim y-fdim xgrid-start xgrid-step 
			 ygrid-start ygrid-step stag))
  (let* ((x-fmid (floor x-fdim 2))
	 (y-fmid (floor y-fdim 2))
	 (x-stop (- x-dim x-fmid))
	 (y-stop (- y-dim y-fmid))
	 (filter (make-array (list y-fdim x-fdim) :element-type 'single-float
			     :displaced-to filt)))
    (do ((y-pos (- ygrid-start y-fmid) (+ y-pos ygrid-step))
	 (y-res 0 (1+ y-res)))
	((>= y-pos y-stop) result)
      (do ((x-pos (- xgrid-start x-fmid) (+ x-pos xgrid-step))
	   (x-res 0 (1+ x-res))
	   (sum 0.0 0.0))
	  ((>= x-pos x-stop))
	(do ((y-filt 0 (1+ y-filt))
	     (y-im y-pos (1+ y-im)))
	    ((>= y-filt y-fdim))
	  (do ((x-filt 0 (1+ x-filt))
	       (x-im x-pos (1+ x-im)))
	      ((>= x-filt x-fdim))
	    (incf sum (* (aref image (mod y-im y-dim) (mod x-im x-dim))
			 (aref filter  y-filt x-filt)))))
	;;(format t "SUM ~A ~A: ~A~%" y-res x-res sum) 
	(setf (aref result y-res x-res) sum))
      (when (/= stag 0) (setq xgrid-start (mod (+ xgrid-start (floor xgrid-step 2))
					       xgrid-step))))))
			       
;;; Again, the raw data arrays are passed to this routines, not the objects.
;;; WARNING: this routine  adds the expanded image into the result image, so the
;;; user is reponsible for zeroing the result.
(defun internal-wrap-expand (image filt x-fdim y-fdim 
				   xgrid-start xgrid-step ygrid-start ygrid-step 
				   result x-dim y-dim stag)
  (declare (type (array single-float (* *)) image filt result)
	   (type fixnum x-dim y-dim x-fdim y-fdim xgrid-start xgrid-step 
			 ygrid-start ygrid-step stag))
  (let* ((x-fmid (floor x-fdim 2))
	 (y-fmid (floor y-fdim 2))
	 (x-stop (- x-dim x-fmid))
	 (y-stop (- y-dim y-fmid))
	 (filter (make-array (list y-fdim x-fdim) :element-type 'single-float
			     :displaced-to filt)))
    (do ((y-pos (- ygrid-start y-fmid) (+ y-pos ygrid-step))
	 (y-im 0 (1+ y-im)))
	((>= y-pos y-stop) result)
      (do ((x-pos (- xgrid-start x-fmid) (+ x-pos xgrid-step))
	   (x-im 0 (1+ x-im))
	   (val 0.0))
	  ((>= x-pos x-stop))
	(setq val (aref image y-im x-im))
	(do ((y-filt 0 (1+ y-filt)) 	  
	     (y-res y-pos (1+ y-res)))
	    ((>= y-filt y-fdim))
	  (do ((x-filt 0 (1+ x-filt))
	       (x-res x-pos (1+ x-res)))
	      ((>= x-filt x-fdim))
	    (incf (aref result (mod y-res y-dim) (mod x-res x-dim))
		  (* val (aref filter y-filt x-filt))))))
      (when (/= stag 0) (setq xgrid-start (mod (+ xgrid-start (floor xgrid-step 2))
					       xgrid-step))))))


#| ;;; TESTING
(in-package 'obvius)
(progn (make-image '(256 128) :-> 'c-result)
       (make-image '(256 128) :-> 'lisp-result)
       (load-image "/usr/local/images/einstein"))
(setq *filt* (make-array '(3) :element-type 'single-float 
			 :initial-contents '(1.0 2.0 1.0 )))
;;; C VERSION
(progn (fmakunbound 'internal-wrap-filter)
       (load "/usr/local/obvius/convolve-c.lisp"))
(progn (internal-wrap-filter (data einstein) 256 256 *filt* 3 1 
			     0 2 0 1  (data c-result) 0) 
       (set-not-current c-result)
       c-result)

;;; LISP VERSION
(progn (fmakunbound 'internal-wrap-filter)
       (unintern-foreign-symbol "-internal-wrap-filter")
       (load "/usr/local/obvius/convolve-lisp"))	;load this file
(progn (internal-wrap-filter (data einstein) 256 256 *filt* 3 1 
			     0 2 0 1  (data lisp-result) 0)
       (set-not-current lisp-result)
       lisp-result)
(mean-square-error c-result lisp-result) ;should be 0.0!!  
|#


;;; Local Variables:
;;; buffer-read-only: t 
;;; End:
