(in-package 'lispview)
(export '())

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;; These two functions from Hmullers bug fix message: Thu, 7 Mar 91
;;;; 14:30:16 PST.

(defun xview-install-initial-interests (canvas xvo id)
  (let ((input-mask 0))
    (dolist (interest (interests canvas))
      (setf input-mask 
	    (logior input-mask (xview-insert-interest xvo interest :at 0 canvas))))
    (XV:xv-set id :win-consume-x-event-mask input-mask
	          :win-ignore-x-event-mask
		  (if (/= 0 (logand input-mask X11:KeyReleaseMask))
		      0
		    X11:KeyReleaseMask))))

(defmethod dd-insert-interest ((p XView) interest relation relative canvas)
  (when (eq (status canvas) :realized)
    (XV:with-xview-lock 
     (let* ((xvo (device canvas))
	    (dsp (xview-object-dsp xvo))
	    (id (xview-object-id xvo)))
       (when id
	 (XV:xv-set id 
	   :win-consume-x-event-mask 
	     (xview-insert-interest xvo interest relation relative canvas)
	   :win-ignore-x-event-mask 
	     (if (svref (xview-canvas-interest-table xvo) X11:KeyRelease)
		 0
	       X11:KeyReleaseMask))
	 (defeat-xview-passive-grab dsp (xview-object-xid xvo))
	 (xview-maybe-XFlush (xview-object-xvd xvo) dsp))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Patch from wilbur@constitution.ucr.edu

(defun init-xview-window (x xvo al &rest initargs)
  (declare (ignore x initargs))
  (let ((bw (or (xview-window-border-width xvo) 0))) ;used to return NIL and crash (WB)
    (unless (or (= bw 0) (= bw 1))
      (error "XView only supports windows with :border-width = 0 or 1"))
    (when (= bw 1)
      (push-xview-attrs al WIN_BORDER 1))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Patch from Teo:
;;;
;;; I was trying to run Obvius remotely over my slip line tonight
;;; (since my hard drive die on me) and found a bug in lispview.  It
;;; doesn't parse the DISPLAY environment variable when the host is
;;; specified as an IP address as you would when you are running over
;;; slip.  Here's a patch to it...

(defun lv::x11-parse-display-name (display)
  (let* ((host-ndx (position #\: display))
	 (hostname (subseq display 0 host-ndx))
	 (length (length display))
	 (screen-ndx (or (position #\. display :start host-ndx)
			 length))
	 (display-num (parse-integer (subseq display (1+ host-ndx) screen-ndx)))
	 (screen-num (if (>= screen-ndx length) 0
		       (parse-integer (subseq display (1+ screen-ndx) length)))))
    (values hostname display-num screen-num)))


