(in-package 'obvius)

;; Add -> argument, maintain name argument for back-compatibility
;; Also, add methods on arrays and lists.
(defmethod make-histogram ((im image) 
			   &key
			   (range (list (minimum im) (maximum im)))
			   (binsize nil binsize-specified-p)
			   (bincenter (mean im))
			   (size (get-default (find-class 'discrete-function) :size)
				 size-specified-p)
			   (name (format nil "Histogram of ~A" (name im)))
			   (-> name))
  (let ((interval (- (apply '- range)))
	data origin)
    (cond ((and binsize-specified-p size-specified-p)
	   (error "Can't specify both binsize and size of histogram"))
	  (binsize-specified-p
	   (setq size (+ (/-0 interval binsize) 2)))
	  (t (setq binsize (if (zerop interval) 1.0 (/ interval (- size 2))))))
    ;; Origin is bincenter minus a multiple of binsize such that
    ;; origin is <= minimum of image.
    (setq origin (- bincenter (* binsize (round (- bincenter (car range)) binsize))))
    (setq data (compute-histogram im origin binsize (floor size)))
    (make-instance 'histogram 
		   :data data
		   :size (total-size data)
		   :origin origin 
		   :increment binsize
		   :image im
		   :name ->)))

(defmethod make-histogram ((list list) &rest args)
  (with-local-viewables ((im (make-image (make-matrix list))))
    (apply 'make-histogram im args)))

(defmethod make-histogram ((arr array) &rest args)
  (with-local-viewables ((im (make-image arr)))
    (apply 'make-histogram im args)))
