;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: patches.lisp
;;;  Author: Simoncelli
;;;  Description: Patches to be loaded at run-time
;;;  Creation Date:
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'obvius)
(export '())

;;;; Sites may want to put additional patches in here.

;;; Load files from the patches directory with names of the form
;;; patch-<num>.lisp in numerical order (according to <num>), starting
;;; with the one designated by the variable *starting-patch-file*.
(let* ((dir (pathname (concatenate 'string *obvius-directory-path* "patches/")))
       (prefix "patch-")
       (len (length prefix))
       (patch-files (directory (merge-pathnames dir *source-file-suffix*))))
  ;; delete filenames that are not of the form "patch-<num>.lisp", where
  ;; <num> is greater than *starting-patch-file*.
  (setq patch-files
	(delete-if-not
	 #'(lambda (name &aux num)
	     (and (string= name prefix :end1 len)
		  (setq num (parse-integer name :start len :junk-allowed t))
		  (integerp num)
		  (>= num *starting-patch-file*)))
	 patch-files
	 :key #'pathname-name))
  ;; sort files according to <num>:
  (setq patch-files
	(sort patch-files #'<
	      :key #'(lambda (p)
		       (parse-integer (pathname-name p) :start len :junk-allowed t))))
  ;; Compile and load the patch files:
  (dolist (file patch-files t) (obv-compile-load file)))


;;; Local Variables:
;;; buffer-read-only: t 
;;; End:
