;;;; The code in this file should attempt to figure out which window
;;;; system to use, and load code for that window system.  This file
;;;; is loaded at startup by the function obvius-init, which is
;;;; defined in lucid-defsys.lisp.

(in-package 'obvius)

(cond ((and (environment-variable "DISPLAY") (find :lispview *features*))
       ;; If DISPLAY environment variable is set, and LispView is present, make
       ;; sure X code is loaded.
       (setq *auto-display-viewables* t)

       (setq lispview::*default-colormap-allocation* 0.8) ;allow lispview to use lots of colors

#|
       (setq lispview::*default-colormap-allocation* 0.13)
       (set-default '8bit-x-screen :gray-shades 24)
       (set-default '8bit-x-screen :rgb-bits '(1 1 1))
|#

       (setq lispview::*default-colormap-allocation* 0.8) ;allow lispview to use lots of colors

       (obv-require :x-windows :initialize nil)
       (obv-require :x-control-panel :initialize nil)
       )
      (;; Otherwise, run obvius without display stuff.
       t				
       (warn "Unknown window system.  Setting *auto-display-viewables* to nil.")
       (setq *auto-display-viewables* nil)))
