/* stepit.c
AUTHOR:
   J.P.Chandler
DATE:
   June, 1975
PURPOSE:
ALGORITHM:
HISTORY:
   2.28.92 - EJC
   Modified some stuff to make the Lisp interface faster.
   Namely, I made the first entry in the data structure a pointer
   rather than an array, and I wrote the function steptp_
   which takes as its second argument an array (which stepit uses subsequently).
   To go back to the old usage, simply make the first entry in the structure
   an array like many other entries (same size and type)
   and then call stept_ rather than steptp_.


   stepit.f -- translated by f2c (version of 3 February 1990  3:36:42).
   You must link the resulting object file with the libraries:
	-lF77 -lI77 -lm -lc   (in that order)

BUGS:
COPYRIGHT:
  The following is the fortran notice:

C  STEPIT 7.4        A.N.S.I. STANDARD FORTRAN        JUNE 1975         STEPIT 3
C  COPYRIGHT (C) 1965, 1975 J. P. CHANDLER                              STEPIT 4
C       (PRESENT ADDRESS ....  COMPUTER SCIENCE DEPT.,                  STEPIT 5
C              OKLAHOMA STATE UNIVERSITY, STILLWATER, OKLAHOMA 74074)   STEPIT 6
C                                                                       STEPIT 7
C  STEPIT FINDS LOCAL MINIMA OF A SMOOTH FUNCTION OF SEVERAL PARAMETERS.STEPIT 8
C                                                                       STEPIT 9
C  -STEPIT IS A PHLEGMATIC METHOD OF SOLVING A PROBLEM.-                STEPIT10
C            --  J. H. BURRILL, JR.,  360 STEPIT - A USER-S MANUAL      STEPIT11
C                                                                       STEPIT12
C  THIS SOURCE DECK AND A WRITE-UP ARE AVAILABLE FROM THE               STEPIT13
C       QUANTUM CHEMISTRY PROGRAM EXCHANGE                              STEPIT14
C       DEPT. OF CHEMISTRY, INDIANA UNIVERSITY                          STEPIT15
C       BLOOMINGTON, INDIANA 47401                                      STEPIT16
C                                                                       STEPIT17
*/

#include "math.h"
#include "f2c.h"


#define MAX_STEPIT_NVAR        128
#define MAX_STEPIT_NVAR_PLUS1  129

/* Common Block Declarations */

struct stepit {
  float *X,
  XMAX[MAX_STEPIT_NVAR], XMIN[MAX_STEPIT_NVAR], DELTX[MAX_STEPIT_NVAR], 
  DELMN[MAX_STEPIT_NVAR], ERR[MAX_STEPIT_NVAR*MAX_STEPIT_NVAR_PLUS1], FOBJ;

  int NV, NTRAC, MATRX, MASK[MAX_STEPIT_NVAR], NFMAX,
  NFLAT, JVARY, NXTRA, KFLAG, NOREP, KERFL, KW;
};


struct stepit stepit_global_data_structure;
#define cstep_1 stepit_global_data_structure

struct {
    real dx[MAX_STEPIT_NVAR], 
    xs[MAX_STEPIT_NVAR], 
    dlx[MAX_STEPIT_NVAR];
    integer nactv, nssw, nf;
} stork_;

#define stork_1 stork_

struct {
    doublereal dstak[2500];
} cstak_;

#define cstak_1 cstak_

/* Table of constant values */

static integer c__1 = 1;
static integer c__4 = 4;

/* Subroutine */ int datsw_(nssw, jump)
integer *nssw;
integer *jump;
{
/*                                                                      
DUMMYSW2*/
/* DUMMY VERSION OF SUBROUTINE DATSW (ALL SWITCHES PERMANENTLY OFF).    
DUMMYSW3*/
/*                                                                      
DUMMYSW4*/
    *jump = 2;
    return 0;
} /* datsw_ */

#include <stdio.h>
int steptp_(funk,arr)
int (*funk) ();
float *arr;
{
  int i;
  stepit_global_data_structure.X = arr;
  return(stept_(funk));
}

/* ---------------------------------------------------------------------- */
/*  FUNCTION:  I1MACH */
/*  THIS ROUTINE IS FROM THE PORT MATHEMATICAL SUBROUTINE LIBRARY */
/*  IT IS DESCRIBED IN THE BELL LABORATORIES COMPUTING SCIENCE */
/*  TECHNICAL REPORT #47 BY P.A. FOX, A.D. HALL AND N.L. SCHRYER */
/* --------------------------------------------------------------------- */

integer i1mach_(i)
integer *i;
{
    /* Initialized data */

    static struct {
	integer e_1[16];
	} equiv_0 = { 5, 6, 5, 6, 32, 4, 2, 31, 2147483647, 2, 24, -127, 127, 
		56, -127, 127 };


    /* Format strings */
    static char fmt_9000[] = "(\0021ERROR    1 IN I1MACH - I OUT OF BOUND\
S\002)";

    /* System generated locals */
    integer ret_val;

    /* Builtin functions */
    integer s_wsfe(), e_wsfe();
    /* Subroutine */ int s_stop();

    /* Local variables */
#define imach ((integer *)&equiv_0)
#define output ((integer *)&equiv_0 + 3)

    /* Fortran I/O blocks */
    static cilist io__3 = { 0, 0, 0, fmt_9000, 0 };



/*  I/O UNIT NUMBERS. */

/*    I1MACH( 1) = THE STANDARD INPUT UNIT. */

/*    I1MACH( 2) = THE STANDARD OUTPUT UNIT. */

/*    I1MACH( 3) = THE STANDARD PUNCH UNIT. */

/*    I1MACH( 4) = THE STANDARD ERROR MESSAGE UNIT. */

/*  WORDS. */

/*    I1MACH( 5) = THE NUMBER OF BITS PER INTEGER STORAGE UNIT. */

/*    I1MACH( 6) = THE NUMBER OF CHARACTERS PER INTEGER STORAGE UNIT. */

/*  INTEGERS. */

/*    ASSUME INTEGERS ARE REPRESENTED IN THE S-DIGIT, BASE-A FORM */

/*               SIGN ( X(S-1)*A**(S-1) + ... + X(1)*A + X(0) ) */

/*               WHERE 0 .LE. X(I) .LT. A FOR I=0,...,S-1. */

/*    I1MACH( 7) = A, THE BASE. */

/*    I1MACH( 8) = S, THE NUMBER OF BASE-A DIGITS. */

/*    I1MACH( 9) = A**S - 1, THE LARGEST MAGNITUDE. */

/*  FLOATING-POINT NUMBERS. */

/*    ASSUME FLOATING-POINT NUMBERS ARE REPRESENTED IN THE T-DIGIT, */
/*    BASE-B FORM */

/*               SIGN (B**E)*( (X(1)/B) + ... + (X(T)/B**T) ) */

/*               WHERE 0 .LE. X(I) .LT. B FOR I=1,...,T, */
/*               0 .LT. X(1), AND EMIN .LE. E .LE. EMAX. */

/*    I1MACH(10) = B, THE BASE. */

/*  SINGLE-PRECISION */

/*    I1MACH(11) = T, THE NUMBER OF BASE-B DIGITS. */

/*    I1MACH(12) = EMIN, THE SMALLEST EXPONENT E. */

/*    I1MACH(13) = EMAX, THE LARGEST EXPONENT E. */

/*  DOUBLE-PRECISION */

/*    I1MACH(14) = T, THE NUMBER OF BASE-B DIGITS. */

/*    I1MACH(15) = EMIN, THE SMALLEST EXPONENT E. */

/*    I1MACH(16) = EMAX, THE LARGEST EXPONENT E. */

/*  TO ALTER THIS FUNCTION FOR A PARTICULAR ENVIRONMENT, */
/*  THE DESIRED SET OF DATA STATEMENTS SHOULD BE ACTIVATED BY */
/*  REMOVING THE C FROM COLUMN 1.  ALSO, THE VALUES OF */
/*  I1MACH(1) - I1MACH(4) SHOULD BE CHECKED FOR CONSISTENCY */
/*  WITH THE LOCAL OPERATING SYSTEM. */



/*     MACHINE CONSTANTS FOR THE BURROUGHS 1700 SYSTEM. */

/*     DATA IMACH( 1) /    7 / */
/*     DATA IMACH( 2) /    2 / */
/*     DATA IMACH( 3) /    2 / */
/*     DATA IMACH( 4) /    2 / */
/*     DATA IMACH( 5) /   36 / */
/*     DATA IMACH( 6) /    4 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   33 / */
/*     DATA IMACH( 9) / Z1FFFFFFFF / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   24 / */
/*     DATA IMACH(12) / -256 / */
/*     DATA IMACH(13) /  255 / */
/*     DATA IMACH(14) /   60 / */
/*     DATA IMACH(15) / -256 / */
/*     DATA IMACH(16) /  255 / */

/*     MACHINE CONSTANTS FOR THE BURROUGHS 5700 SYSTEM. */

/*     DATA IMACH( 1) /   5 / */
/*     DATA IMACH( 2) /   6 / */
/*     DATA IMACH( 3) /   7 / */
/*     DATA IMACH( 4) /   6 / */
/*     DATA IMACH( 5) /  48 / */
/*     DATA IMACH( 6) /   6 / */
/*     DATA IMACH( 7) /   2 / */
/*     DATA IMACH( 8) /  39 / */
/*     DATA IMACH( 9) / O0007777777777777 / */
/*     DATA IMACH(10) /   8 / */
/*     DATA IMACH(11) /  13 / */
/*     DATA IMACH(12) / -50 / */
/*     DATA IMACH(13) /  76 / */
/*     DATA IMACH(14) /  26 / */
/*     DATA IMACH(15) / -50 / */
/*     DATA IMACH(16) /  76 / */

/*     MACHINE CONSTANTS FOR THE BURROUGHS 6700/7700 SYSTEMS. */

/*     DATA IMACH( 1) /   5 / */
/*     DATA IMACH( 2) /   6 / */
/*     DATA IMACH( 3) /   7 / */
/*     DATA IMACH( 4) /   6 / */
/*     DATA IMACH( 5) /  48 / */
/*     DATA IMACH( 6) /   6 / */
/*     DATA IMACH( 7) /   2 / */
/*     DATA IMACH( 8) /  39 / */
/*     DATA IMACH( 9) / O0007777777777777 / */
/*     DATA IMACH(10) /   8 / */
/*     DATA IMACH(11) /  13 / */
/*     DATA IMACH(12) / -50 / */
/*     DATA IMACH(13) /  76 / */
/*     DATA IMACH(14) /  26 / */
/*     DATA IMACH(15) / -32754 / */
/*     DATA IMACH(16) /  32780 / */

/*     MACHINE CONSTANTS FOR THE CDC 6000/7000 SERIES. */

/*     DATA IMACH( 1) /    5 / */
/*     DATA IMACH( 2) /    6 / */
/*     DATA IMACH( 3) /    7 / */
/*     DATA IMACH( 4) /    6 / */
/*     DATA IMACH( 5) /   60 / */
/*     DATA IMACH( 6) /   10 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   48 / */
/*     DATA IMACH( 9) / 00007777777777777777B / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   48 / */
/*     DATA IMACH(12) / -974 / */
/*     DATA IMACH(13) / 1070 / */
/*     DATA IMACH(14) /   96 / */
/*     DATA IMACH(15) / -927 / */
/*     DATA IMACH(16) / 1070 / */

/*     MACHINE CONSTANTS FOR THE CRAY 1 */

/*     DATA IMACH( 1) /   100 / */
/*     DATA IMACH( 2) /   101 / */
/*     DATA IMACH( 3) /   102 / */
/*     DATA IMACH( 4) /   101 / */
/*     DATA IMACH( 5) /    64 / */
/*     DATA IMACH( 6) /     8 / */
/*     DATA IMACH( 7) /     2 / */
/*     DATA IMACH( 8) /    63 / */
/*     DATA IMACH( 9) /  777777777777777777777B / */
/*     DATA IMACH(10) /     2 / */
/*     DATA IMACH(11) /    47 / */
/*     DATA IMACH(12) / -8192 / */
/*     DATA IMACH(13) /  8190 / */
/*     DATA IMACH(14) /    95 / */
/*     DATA IMACH(15) / -8192 / */
/*     DATA IMACH(16) /  8190 / */

/*     MACHINE CONSTANTS FOR THE DATA GENERAL ECLIPSE S/200 */

/*     DATA IMACH( 1) /   11 / */
/*     DATA IMACH( 2) /   12 / */
/*     DATA IMACH( 3) /    8 / */
/*     DATA IMACH( 4) /   10 / */
/*     DATA IMACH( 5) /   16 / */
/*     DATA IMACH( 6) /    2 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   15 / */
/*     DATA IMACH( 9) /32767 / */
/*     DATA IMACH(10) /   16 / */
/*     DATA IMACH(11) /    6 / */
/*     DATA IMACH(12) /  -64 / */
/*     DATA IMACH(13) /   63 / */
/*     DATA IMACH(14) /   14 / */
/*     DATA IMACH(15) /  -64 / */
/*     DATA IMACH(16) /   63 / */

/*     MACHINE CONSTANTS FOR THE HARRIS SLASH 6 AND SLASH 7 */

/*     DATA IMACH( 1) /       5 / */
/*     DATA IMACH( 2) /       6 / */
/*     DATA IMACH( 3) /       0 / */
/*     DATA IMACH( 4) /       6 / */
/*     DATA IMACH( 5) /      24 / */
/*     DATA IMACH( 6) /       3 / */
/*     DATA IMACH( 7) /       2 / */
/*     DATA IMACH( 8) /      23 / */
/*     DATA IMACH( 9) / 8388607 / */
/*     DATA IMACH(10) /       2 / */
/*     DATA IMACH(11) /      23 / */
/*     DATA IMACH(12) /    -127 / */
/*     DATA IMACH(13) /     127 / */
/*     DATA IMACH(14) /      38 / */
/*     DATA IMACH(15) /    -127 / */
/*     DATA IMACH(16) /     127 / */

/*     MACHINE CONSTANTS FOR THE HONEYWELL 600/6000 SERIES. */

/*     DATA IMACH( 1) /    5 / */
/*     DATA IMACH( 2) /    6 / */
/*     DATA IMACH( 3) /   43 / */
/*     DATA IMACH( 4) /    6 / */
/*     DATA IMACH( 5) /   36 / */
/*     DATA IMACH( 6) /    6 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   35 / */
/*     DATA IMACH( 9) / O377777777777 / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   27 / */
/*     DATA IMACH(12) / -127 / */
/*     DATA IMACH(13) /  127 / */
/*     DATA IMACH(14) /   63 / */
/*     DATA IMACH(15) / -127 / */
/*     DATA IMACH(16) /  127 / */

/*     MACHINE CONSTANTS FOR THE IBM 360/370 SERIES, */
/*     THE XEROX SIGMA 5/7/9 AND THE SEL SYSTEMS 85/86. */

/*     DATA IMACH( 1) /   5 / */
/*     DATA IMACH( 2) /   6 / */
/*     DATA IMACH( 3) /   7 / */
/*     DATA IMACH( 4) /   6 / */
/*     DATA IMACH( 5) /  32 / */
/*     DATA IMACH( 6) /   4 / */
/*     DATA IMACH( 7) /   2 / */
/*     DATA IMACH( 8) /  31 / */
/*     DATA IMACH( 9) / Z7FFFFFFF / */
/*     DATA IMACH(10) /  16 / */
/*     DATA IMACH(11) /   6 / */
/*     DATA IMACH(12) / -64 / */
/*     DATA IMACH(13) /  63 / */
/*     DATA IMACH(14) /  14 / */
/*     DATA IMACH(15) / -64 / */
/*     DATA IMACH(16) /  63 / */

/*     MACHINE CONSTANTS FOR THE PDP-10 (KA PROCESSOR). */

/*     DATA IMACH( 1) /    5 / */
/*     DATA IMACH( 2) /    6 / */
/*     DATA IMACH( 3) /    5 / */
/*     DATA IMACH( 4) /    6 / */
/*     DATA IMACH( 5) /   36 / */
/*     DATA IMACH( 6) /    5 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   35 / */
/*     DATA IMACH( 9) / "377777777777 / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   27 / */
/*     DATA IMACH(12) / -128 / */
/*     DATA IMACH(13) /  127 / */
/*     DATA IMACH(14) /   54 / */
/*     DATA IMACH(15) / -101 / */
/*     DATA IMACH(16) /  127 / */

/*     MACHINE CONSTANTS FOR THE PDP-10 (KI PROCESSOR). */

/*     DATA IMACH( 1) /    5 / */
/*     DATA IMACH( 2) /    6 / */
/*     DATA IMACH( 3) /    5 / */
/*     DATA IMACH( 4) /    6 / */
/*     DATA IMACH( 5) /   36 / */
/*     DATA IMACH( 6) /    5 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   35 / */
/*     DATA IMACH( 9) / "377777777777 / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   27 / */
/*     DATA IMACH(12) / -128 / */
/*     DATA IMACH(13) /  127 / */
/*     DATA IMACH(14) /   62 / */
/*     DATA IMACH(15) / -128 / */
/*     DATA IMACH(16) /  127 / */

/*     MACHINE CONSTANTS FOR PDP-11 FORTRAN SUPPORTING */
/*     32-BIT INTEGER ARITHMETIC. */

/*     DATA IMACH( 1) /    5 / */
/*     DATA IMACH( 2) /    6 / */
/*     DATA IMACH( 3) /    5 / */
/*     DATA IMACH( 4) /    6 / */
/*     DATA IMACH( 5) /   32 / */
/*     DATA IMACH( 6) /    4 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   31 / */
/*     DATA IMACH( 9) / 2147483647 / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   24 / */
/*     DATA IMACH(12) / -127 / */
/*     DATA IMACH(13) /  127 / */
/*     DATA IMACH(14) /   56 / */
/*     DATA IMACH(15) / -127 / */
/*     DATA IMACH(16) /  127 / */

/*     MACHINE CONSTANTS FOR PDP-11 FORTRAN SUPPORTING */
/*     16-BIT INTEGER ARITHMETIC. */

/*     DATA IMACH( 1) /    5 / */
/*     DATA IMACH( 2) /    6 / */
/*     DATA IMACH( 3) /    5 / */
/*     DATA IMACH( 4) /    6 / */
/*     DATA IMACH( 5) /   16 / */
/*     DATA IMACH( 6) /    2 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   15 / */
/*     DATA IMACH( 9) / 32767 / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   24 / */
/*     DATA IMACH(12) / -127 / */
/*     DATA IMACH(13) /  127 / */
/*     DATA IMACH(14) /   56 / */
/*     DATA IMACH(15) / -127 / */
/*     DATA IMACH(16) /  127 / */

/*     MACHINE CONSTANTS FOR THE UNIVAC 1100 SERIES. */

/*     NOTE THAT THE PUNCH UNIT, I1MACH(3), HAS BEEN SET TO 7 */
/*     WHICH IS APPROPRIATE FOR THE UNIVAC-FOR SYSTEM. */
/*     IF YOU HAVE THE UNIVAC-FTN SYSTEM, SET IT TO 1. */

/*     DATA IMACH( 1) /    5 / */
/*     DATA IMACH( 2) /    6 / */
/*     DATA IMACH( 3) /    7 / */
/*     DATA IMACH( 4) /    6 / */
/*     DATA IMACH( 5) /   36 / */
/*     DATA IMACH( 6) /    6 / */
/*     DATA IMACH( 7) /    2 / */
/*     DATA IMACH( 8) /   35 / */
/*     DATA IMACH( 9) / O377777777777 / */
/*     DATA IMACH(10) /    2 / */
/*     DATA IMACH(11) /   27 / */
/*     DATA IMACH(12) / -128 / */
/*     DATA IMACH(13) /  127 / */
/*     DATA IMACH(14) /   60 / */
/*     DATA IMACH(15) /-1024 / */
/*     DATA IMACH(16) / 1023 / */

/*     MACHINE CONSTANTS FOR THE VAX-11 WITH */
/*     FORTRAN IV-PLUS COMPILER */


    if (*i < 1 || *i > 16) {
	goto L10;
    }

    ret_val = imach[*i - 1];
    return ret_val;

L10:
    io__3.ciunit = *output;
    s_wsfe(&io__3);
    e_wsfe();

    s_stop("", 0L);

} /* i1mach_ */

#undef output
#undef imach


/* Subroutine */ int stbeg_(funk)
/* Subroutine */ int (*funk) ();
{
    /* Format strings */
    static char fmt_1020[] = 
	    "(/\002 TURN OFF SENSE SWITCH \002i2//\002 \002)";
    static char fmt_1280[] = "(\0021SUBROUTINE STEPIT.  COPYRIGHT (C) 1965 J\
. P. CHANDLER\002,//\002 INITIAL VALUES....\002/\002 \002)";
    static char fmt_1290[] = "(/\002 MASK   = \002i7,7i13/(4x8i13))";
    static char fmt_1300[] = "(/\002 X      = \0028e13.5/(10x8e13.5))";
    static char fmt_1310[] = "(/\002 XMAX   = \0028e13.5/(10x8e13.5))";
    static char fmt_1320[] = "(/\002 XMIN   = \0028e13.5/(10x8e13.5))";
    static char fmt_1330[] = "(/\002 DELTX  = \0028e13.5/(10x8e13.5))";
    static char fmt_1340[] = "(/\002 DELMN  = \0028e13.5/(10x8e13.5))";
    static char fmt_1370[] = "(////\002 WARNING....  FOBJ IS NOT A REPRODUCI\
BLE\002,\002 FUNCTION OF X(J).\0027x,\002 NF = \002i5//5x3e23.15)";
    static char fmt_1400[] = "(//1xi3,\002 VARIABLES,\002i3,\002 ACTIVE.\002\
9x,\002 MATRX =\002,i4,9x,\002 NFMAX =\002,i8,9x,\002 NFLAT =\002,i2,9x,\002\
 RELAC =\002,e11.4///,\002 FOBJ =\002e18.10///\002 BEGIN MINIMIZATION....\
\002///,\002 \002)";

    /* System generated locals */
    integer i_1;
    real r_1;

    /* Builtin functions */
    integer s_wsfe(), do_fio(), e_wsfe();

    /* Local variables */
    static real huge, rten;
    static integer jump, j;
    static real deldf, relac, fsave;
    extern /* Subroutine */ int datsw_();
    static integer nvmax, ktype;
    static real rzero, runit, unitr, xplus;

    /* Fortran I/O blocks */
    static cilist io__13 = { 0, 0, 0, fmt_1020, 0 };
    static cilist io__17 = { 0, 0, 0, fmt_1280, 0 };
    static cilist io__18 = { 0, 0, 0, fmt_1290, 0 };
    static cilist io__19 = { 0, 0, 0, fmt_1300, 0 };
    static cilist io__20 = { 0, 0, 0, fmt_1310, 0 };
    static cilist io__21 = { 0, 0, 0, fmt_1320, 0 };
    static cilist io__22 = { 0, 0, 0, fmt_1330, 0 };
    static cilist io__23 = { 0, 0, 0, fmt_1340, 0 };
    static cilist io__25 = { 0, 0, 0, fmt_1370, 0 };
    static cilist io__26 = { 0, 0, 0, fmt_1400, 0 };


/*                                                                      
STBEG  2*/
/* STBEG 1.2        A.N.S.I. STANDARD FORTRAN        JUNE 1975          
STBEG  3*/
/* COPYRIGHT (C) 1965, 1975 J. P. CHANDLER                              
STBEG  4*/
/*                                                                      
STBEG  5*/
/* STBEG SETS DEFAULT VALUES AND PRINTS INITIAL OUTPUT FOR STEPIT.      
STBEG  6*/
/* THE CALL TO STBEG IS THE FIRST EXECUTABLE STATEMENT IN STEPIT, TO    
STBEG  7*/
/* FACILITATE OVERLAYING IF NECESSARY.                                  
STBEG  8*/
/*                                                                      
STBEG  9*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STBEG 10*/
/*                                                                      
STBEG 11*/
/* INPUT QUANTITIES.....  FUNK,X,XMAX,XMIN,DELTX,DELMN,NV,NTRAC,        
STBEG 12*/
/*                             MATRX,MASK,NFMAX,NFLAT,KW                
STBEG 13*/
/* OUTPUT QUANTITIES....  NSSW,NACTV,NF,KFLAG,NOREP,                    
STBEG 14*/
/*                             AND SOMETIMES X,XMAX,XMIN,DELTX,DELMN    
STBEG 15*/
/*                                                                      
STBEG 16*/
/*    DOUBLE PRECISION X,XMAX,XMIN,DELTX,DELMN,ERR,FOBJ,DX,XS,DLX       
STBEG 17*/
/*    DOUBLE PRECISION HUGE,DELDF,RZERO,RUNIT,RTEN,RELAC,XPLUS,FSAVE,   
STBEG 18*/
/*   *     UNITR                                                        
STBEG 19*/
/*                                                                      
STBEG 20*/
/* USER COMMON.....                                                     
STBEG 21*/
/*                                                                      
STBEG 25*/
/* INTERNAL STEPIT COMMON.....                                          
STBEG 26*/
/*                                                                      
STBEG 28*/
/* THE REAL FORMAT SPECIFICATIONS USED ARE E13.5, E23.15, E11.4, 
E18.10.STBEG 29*/
/*                                                                      
STBEG 30*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STBEG 31*/
/*                                                                      
STBEG 32*/
/* SET FIXED QUANTITIES ....                                            
STBEG 33*/
/*                                                                      
STBEG 34*/
/*                           KTYPE ...  CONSOLE TYPEWRITER UNIT NUMBER  
STBEG 35*/
/*                                (IRRELEVANT IF A DUMMY DATSW IS USED) 
STBEG 36*/
    ktype = 1;
/*                           NSSW ...  TERMINATION SENSE SWITCH NUMBER  
STBEG 38*/
/*                                (IRRELEVANT IF A DUMMY DATSW IS USED) 
STBEG 39*/
    stork_1.nssw = 6;
/*                           HUGE ...  A VERY LARGE REAL NUMBER         
STBEG 41*/
/*                                (DEFAULT VALUE FOR XMAX AND -XMIN)    
STBEG 42*/
    huge = (float)1e35;
/*                           NVMAX ...  MAXIMUM VALUE OF NV             
STBEG 44*/
    nvmax = MAX_STEPIT_NVAR;
/*                           DELDF ...  DEFAULT VALUE FOR DELTX(J)      
STBEG 46*/
    deldf = (float).01;
/*                                                                      
STBEG 48*/
    rzero = (float)0.;
    runit = (float)1.;
    unitr = (float)1.;
    rten = (float)10.;
/*                                                                      
STBEG 53*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STBEG 54*/
/*                                                                      
STBEG 55*/
/* NO REAL CONSTANTS ARE USED BEYOND THIS POINT.                        
STBEG 56*/
/* CHECK SOME INPUT QUANTITIES, AND SET THEM TO DEFAULT VALUES IF       
STBEG 57*/
/* DESIRED.                                                             
STBEG 58*/
/*                                                                      
STBEG 59*/
    cstep_1.KFLAG = 0;
    cstep_1.NOREP = 0;
/*                           MAKE SURE THE SENSE SWITCH IS OFF.         
STBEG 62*/
    jump = 2;
    datsw_(&stork_1.nssw, &jump);
    if (jump - 1 <= 0) {
	goto L1010;
    } else {
	goto L1040;
    }
/*                                                                      
STBEG 66*/
/*                           ONLY USAGE OF THE CONSOLE TYPEWRITER....   
STBEG 67*/
L1010:
    io__13.ciunit = ktype;
    s_wsfe(&io__13);
    do_fio(&c__1, (char *)&stork_1.nssw, (ftnlen)sizeof(integer));
    e_wsfe();
L1030:
    datsw_(&stork_1.nssw, &jump);
    if (jump - 1 <= 0) {
	goto L1030;
    } else {
	goto L1040;
    }
/*                                                                      
STBEG 73*/
/* COMPUTE RELAC, THE RELATIVE PRECISION OF THE MACHINE AND ARITHMETIC  
STBEG 74*/
/* BEING USED.  RELAC IS USED IN SETTING DELMN(J) TO A DEFAULT VALUE.   
STBEG 75*/
/*                                                                      
STBEG 76*/
L1040:
    relac = runit;
L1050:
    relac /= rten;
    xplus = runit + relac;
    if (xplus - unitr <= (float)0.) {
	goto L1060;
    } else {
	goto L1050;
    }
/*                                                                      
STBEG 81*/
/*                           NACTV ...  NUMBER OF ACTIVE X(J)           
STBEG 82*/
L1060:
    stork_1.nactv = 0;
    cstep_1.FOBJ = rzero;
    if (cstep_1.NV <= 0) {
	goto L1250;
    } else {
	goto L1070;
    }
L1070:
    if (cstep_1.NV - nvmax <= 0) {
	goto L1080;
    } else {
	goto L1250;
    }
L1080:
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	if (cstep_1.MASK[j - 1] != 0) {
	    goto L1240;
	} else {
	    goto L1090;
	}
/*                                                                    
  STBEG 89*/
/*                           CHECK THAT DELTX(J) IS NOT NEGLIGIBLE.   
  STBEG 90*/
L1090:
	if (cstep_1.DELTX[j - 1] != (float)0.) {
	    goto L1100;
	} else {
	    goto L1120;
	}
L1100:
	xplus = cstep_1.X[j - 1] + cstep_1.DELTX[j - 1];
	if (xplus - cstep_1.X[j - 1] != (float)0.) {
	    goto L1110;
	} else {
	    goto L1120;
	}
L1110:
	xplus = cstep_1.X[j - 1] - cstep_1.DELTX[j - 1];
	if (xplus - cstep_1.X[j - 1] != (float)0.) {
	    goto L1150;
	} else {
	    goto L1120;
	}
L1120:
	if (cstep_1.X[j - 1] != (float)0.) {
	    goto L1130;
	} else {
	    goto L1140;
	}
L1130:
	cstep_1.DELTX[j - 1] = deldf * cstep_1.X[j - 1];
	goto L1150;
L1140:
	cstep_1.DELTX[j - 1] = deldf;
L1150:
	if ((r_1 = cstep_1.DELMN[j - 1]) < (float)0.) {
	    goto L1170;
	} else if (r_1 == 0) {
	    goto L1160;
	} else {
	    goto L1180;
	}
L1160:
	cstep_1.DELMN[j - 1] = cstep_1.DELTX[j - 1] * relac;
	if (cstep_1.DELMN[j - 1] >= (float)0.) {
	    goto L1180;
	} else {
	    goto L1170;
	}
L1170:
	cstep_1.DELMN[j - 1] = -(doublereal)cstep_1.DELMN[j - 1];
L1180:
	if (cstep_1.XMAX[j - 1] - cstep_1.XMIN[j - 1] <= (float)0.) {
	    goto L1190;
	} else {
	    goto L1200;
	}
L1190:
	cstep_1.XMAX[j - 1] = huge;
	cstep_1.XMIN[j - 1] = -(doublereal)huge;
L1200:
	++stork_1.nactv;
/*                           X(J)=AMAX1(XMIN(J),AMIN1(XMAX(J),X(J)))  
  STBEG108*/
	if (cstep_1.X[j - 1] - cstep_1.XMAX[j - 1] <= (float)0.) {
	    goto L1220;
	} else {
	    goto L1210;
	}
L1210:
	cstep_1.X[j - 1] = cstep_1.XMAX[j - 1];
L1220:
	if (cstep_1.X[j - 1] - cstep_1.XMIN[j - 1] >= (float)0.) {
	    goto L1240;
	} else {
	    goto L1230;
	}
L1230:
	cstep_1.X[j - 1] = cstep_1.XMIN[j - 1];
L1240:
    ;}
/*                                                                      
STBEG114*/
    if (stork_1.nactv <= 0) {
	goto L1250;
    } else {
	goto L1260;
    }
L1250:
    cstep_1.KFLAG = -1;
    goto L1390;
/*                                                                      
STBEG118*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STBEG119*/
/*                                                                      
STBEG120*/
L1260:
    if (cstep_1.NTRAC >= 0) {
	goto L1270;
    } else {
	goto L1350;
    }
L1270:
    io__17.ciunit = cstep_1.KW;
    s_wsfe(&io__17);
    e_wsfe();
    io__18.ciunit = cstep_1.KW;
    s_wsfe(&io__18);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.MASK[j - 1], (ftnlen)sizeof(integer));
    }
    e_wsfe();
    io__19.ciunit = cstep_1.KW;
    s_wsfe(&io__19);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io__20.ciunit = cstep_1.KW;
    s_wsfe(&io__20);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.XMAX[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io__21.ciunit = cstep_1.KW;
    s_wsfe(&io__21);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.XMIN[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io__22.ciunit = cstep_1.KW;
    s_wsfe(&io__22);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.DELTX[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io__23.ciunit = cstep_1.KW;
    s_wsfe(&io__23);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.DELMN[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
/*                                                                      
STBEG138*/
L1350:
    cstep_1.JVARY = 0;
    (*funk)();
    fsave = cstep_1.FOBJ;
    (*funk)();
/*                           NF ...  NUMBER OF CALLS TO FUNK            
STBEG143*/
    stork_1.nf = 2;
    if (cstep_1.FOBJ - fsave != (float)0.) {
	goto L1360;
    } else {
	goto L1380;
    }
L1360:
    cstep_1.NOREP = 1;
    io__25.ciunit = cstep_1.KW;
    s_wsfe(&io__25);
    do_fio(&c__1, (char *)&stork_1.nf, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&fsave, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&cstep_1.FOBJ, (ftnlen)sizeof(real));
    e_wsfe();
/*                                                                      
STBEG150*/
L1380:
    if (cstep_1.NTRAC >= 0) {
	goto L1390;
    } else {
	goto L1440;
    }
L1390:
    io__26.ciunit = cstep_1.KW;
    s_wsfe(&io__26);
    do_fio(&c__1, (char *)&cstep_1.NV, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&stork_1.nactv, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&cstep_1.MATRX, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&cstep_1.NFMAX, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&cstep_1.NFLAT, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&relac, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&cstep_1.FOBJ, (ftnlen)sizeof(real));
    e_wsfe();
/*                                                                      
STBEG158*/
L1440:
    return 0;
/* END STBEG.                                                           
STBEG160*/
} /* stbeg_ */

/*       STEPT PACKAGE WITH STEPIT AND SIMPLEX */
/* Subroutine */ int stept_(funk)
/* Subroutine */ int (*funk) ();
{
    /* Format strings */
    static char fmt_2550[] = "(/\002 STEP SIZE\002i3,\002 INCREASED TO \002e\
13.5)";
    static char fmt_2780[] = "(/\002 ********\0024x\002 GIGANTIC STEP WITH P\
ERIOD\002,i2,\002 BEING ATTEMPTED.   COXCM, COSIN = \0022e13.5)";
    static char fmt_2930[] = "(/\002 NO. OF STEPS = \0029e11.3/(16x9e11.3))";
    static char fmt_2940[] = "(/\002 FOBJ =\002e16.8,7x,\002 NF = \002,i7,15\
x,\002 X(J)....\002/,(1x7e16.8))";
    static char fmt_3080[] = "(//\002 FOBJ =\002,e16.8,\002  AFTER\002,i3\
,\002 GIANT STEP(S).\002,10x,\002 X(J)....\002//(1x7e16.8))";
    static char fmt_3140[] = "(//\002 FOBJ =\002,e16.8,\002  AFTER\002,e11.3\
,\002 GIANT STEPS.\0024x,\002 X(J)....\002//(1x7e16.8))";
    static char fmt_3260[] = "(\002 \002)";
    static char fmt_3400[] = "(///\002 TERMINATED WHEN THE STEP SIZES\002\
,\002 BECAME AS SMALL AS THE DELMN(J).\002)";
    static char fmt_3480[] = "(///\002 TERMINATED WHEN THE FUNCTION VALUE\
S\002,\002 AT ALL TRIAL POINTS WERE IDENTICAL.\002)";
    static char fmt_3490[] = "(///\002 CURRENT STEP SIZES....\002//(1x9e13.5\
))";
    static char fmt_3520[] = "(//60(\002 *\002)//\002 STEP SIZES REDUCED TO.\
...\002//(1x9e13.5))";
    static char fmt_3540[] = "(///\002 ABNORMAL TERMINATION....   MORE THAN \
NFMAX = \002i7,\002 CALLS TO THE FOBJ SUBROUTINE.\002)";
    static char fmt_3560[] = "(///\002 ABNORMAL TERMINATION....  TERMINATED \
BY\002,\002 OPERATOR VIA SENSE SWITCH \002i2)";
    static char fmt_3610[] = "(////\002 WARNING....  FOBJ IS NOT A REPRODUCI\
BLE\002,\002 FUNCTION OF X(J).\0027x,\002 NF = \002i5//5x3e23.15)";
    static char fmt_3640[] = "(/////1xi6,\002 FUNCTION COMPUTATIONS \002,///\
,\002 FINAL VALUE OF FOBJ = \002,e23.15,///,9x,\002 FINAL VALUES OF X(J)...\
.\002//(1x5e23.15))";

    /* System generated locals */
    integer i_1, i_2, i_3;
    real r_1, r_2;

    /* Builtin functions */
    integer s_wsfe(), do_fio(), e_wsfe();
    double sqrt(), pow_ri();

    /* Local variables */
    static integer nack;
    static real avec;
    static integer matd, jock;
    static real fosc[5];
    static integer nosc;
    static real rten, xosc[MAX_STEPIT_NVAR * 5]	/* was [20][5] */;
    static integer jump, mosq, kwit, nzip, nstp;
    static real sumv;
    static integer j, k, nflag, ngian;
    static real facup;
    static integer jflat[MAX_STEPIT_NVAR], ncirc;
    static real denom;
    extern /* Subroutine */ int stbeg_();
    static real fsave, fbest, coxcm, cosin;
    static integer nfsav;
    static real cindr;
    static integer mnosc, ngate;
    static real fprev, salvo[MAX_STEPIT_NVAR];
    extern /* Subroutine */ int datsw_();
    static real xsave;
    static integer jflmn, nretr;
    static real fstor[MAX_STEPIT_NVAR], steps, rzero, stcut;
    extern /* Subroutine */ int sterr_();
    static integer nonzr, mxstp;
    static real xplus;
    static integer kl, jx, nt;
    static real fac, ack, del;
    static integer nah;
    static real adx, vec[MAX_STEPIT_NVAR], dfu, dfz, dxu, dxz;

    /* Fortran I/O blocks */
    static cilist io__61 = { 0, 0, 0, fmt_2550, 0 };
    static cilist io__73 = { 0, 0, 0, fmt_2780, 0 };
    static cilist io__78 = { 0, 0, 0, fmt_2930, 0 };
    static cilist io__79 = { 0, 0, 0, fmt_2940, 0 };
    static cilist io__80 = { 0, 0, 0, fmt_2940, 0 };
    static cilist io__82 = { 0, 0, 0, fmt_3080, 0 };
    static cilist io__84 = { 0, 0, 0, fmt_3140, 0 };
    static cilist io__85 = { 0, 0, 0, fmt_2930, 0 };
    static cilist io__86 = { 0, 0, 0, fmt_2940, 0 };
    static cilist io__87 = { 0, 0, 0, fmt_3260, 0 };
    static cilist io__88 = { 0, 0, 0, fmt_2930, 0 };
    static cilist io__89 = { 0, 0, 0, fmt_2940, 0 };
    static cilist io__91 = { 0, 0, 0, fmt_3400, 0 };
    static cilist io__93 = { 0, 0, 0, fmt_3480, 0 };
    static cilist io__94 = { 0, 0, 0, fmt_3490, 0 };
    static cilist io__95 = { 0, 0, 0, fmt_3520, 0 };
    static cilist io__96 = { 0, 0, 0, fmt_3540, 0 };
    static cilist io__97 = { 0, 0, 0, fmt_3560, 0 };
    static cilist io__98 = { 0, 0, 0, fmt_3490, 0 };
    static cilist io__99 = { 0, 0, 0, fmt_3610, 0 };
    static cilist io__100 = { 0, 0, 0, fmt_3640, 0 };


/*                                                                      
STEPIT 2*/
/*    NOREP      --  RETURNED .GT. ZERO IF THE FUNCTION WAS NOT         
STEPIT53*/
/*                        REPRODUCIBLE                                  
STEPIT54*/
/*    KERFL      --  RETURNED .LT. ZERO IF SUBROUTINE STERR             
STEPIT55*/
/*                        TERMINATED ABNORMALLY                         
STEPIT56*/
/*    KW         --  THE LOGICAL UNIT NUMBER OF THE PRINTER             
STEPIT57*/
/*                                                                      
STEPIT58*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STEPIT59*/
/*                                                                      
STEPIT60*/
/*                                                                      
STEPIT62*/
/* THE FOLLOWING STATEMENTS CONVERT STEPIT TO DOUBLE PRECISION.         
STEPIT63*/
/* STEPIT CONTAINS NO MIXED MODE STATEMENTS, NO MATTER WHETHER THE      
STEPIT64*/
/* VARIABLES BEGINNING WITH A-H AND O-Z ARE ALL TYPE REAL OR ARE        
STEPIT65*/
/* ALL TYPE DOUBLE PRECISION.                                           
STEPIT66*/
/*                                                                      
STEPIT67*/
/*    DOUBLE PRECISION X,XMAX,XMIN,DELTX,DELMN,ERR,FOBJ,                
STEPIT68*/
/*   X   VEC,DLX,XS,FSTOR,DX,SALVO,XOSC,FOSC,Q,STCUT,ACK,FACUP          
STEPIT69*/
/*    DOUBLE PRECISION RZERO,RTEN,DELX,XPLUS,                           
STEPIT70*/
/*   X   FSAVE,FBEST,XSAVE,ADX,FPREV,DENOM,DEL,DXZ,DXU,DFZ,DFU,         
STEPIT71*/
/*   X   AVEC,SUMV,CINDR,COXCM,COSIN,STEPS,FAC,QSQRT,DSQRT              
STEPIT72*/
/*                                                                      
STEPIT73*/
/* THE DIMENSIONS OF ALL VECTORS AND MATRICES (AS OPPOSED TO ARRAYS)    
STEPIT74*/
/* ARE NV, EXCEPT FOR ....                                              
STEPIT75*/
/*      ERR(NV,MOSQ),XOSC(NV,MOSQ),FOSC(MOSQ).                          
STEPIT76*/
/* IF ERRORS ARE TO BE CALCULATED BY SUBROUTINE STERR, HOWEVER, THEN    
STEPIT77*/
/* ERR MUST BE DIMENSIONED AT LEAST     ERR(NV,MAX(NV,MOSQ)) .          
STEPIT78*/
/*                                                                      
STEPIT79*/
/*                                                                      
STEPIT82*/
/* IF UNLABELLED COMMON AND SINGLE PRECISION ARE USED AND THE EXTERNAL  
STEPIT83*/
/* FACILITY IS NOT USED, STEPIT IS THEN WRITTEN ENTIRELY IN             
STEPIT84*/
/* A.N.S.I. STANDARD BASIC FORTRAN.                                     
STEPIT85*/
/*                                                                      
STEPIT86*/
/* USER COMMON.....                                                     
STEPIT87*/
/*                                                                      
STEPIT91*/
/* INTERNAL STEPIT COMMON.....                                          
STEPIT92*/
/*                                                                      
STEPIT94*/
/* SET THE LIBRARY FUNCTION FOR SINGLE PRECISION (SQRT) OR FOR          
STEPIT95*/
/* DOUBLE PRECISION (DSQRT).  NO OTHER FUNCTIONS ARE USED, EITHER       
STEPIT96*/
/* EXTERNAL OR INTRINSIC, EXCEPT THE ROUTINE INVOKED BY REAL**INTEGER.  
STEPIT97*/
/* THE ONLY SUBROUTINES CALLED ARE FUNK, STBEG, STERR, AND DATSW.       
STEPIT98*/
/* STEPIT TERMINATES IF SENSE SWITCH NUMBER -NSSW- IS ON.               
STEPIT99*/
/* THE STATEMENT    CALL DATSW(NSSW,JUMP)    RETURNS JUMP=1 IF          
STEPI100*/
/* SENSE SWITCH NUMBER -NSSW- IS ON, AND JUMP=2 IF IT IS OFF.           
STEPI101*/
/* IF NO SENSE SWITCH IS TO BE USED, SUPPLY A DUMMY ROUTINE FOR DATSW.  
STEPI102*/
/*                                                                      
STEPI103*/
/*    QSQRT(Q)=DSQRT(Q)                                                 
STEPI105*/
/*                                                                      
STEPI106*/
/* THE REAL FORMAT SPECIFICATIONS USED ARE E13.5, E16.8, E11.3, E23.15. 
STEPI107*/
/*                                                                      
STEPI108*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STEPI109*/
/*                                                                      
STEPI110*/
/* CALL STBEG TO SET DEFAULT VALUES AND PRINT INITIAL OUTPUT.           
STEPI111*/
/*                                                                      
STEPI112*/
    stbeg_(funk);
    if (cstep_1.KFLAG >= 0) {
	goto L2010;
    } else {
	goto L3710;
    }
/*                           FSAVE ...  USED TO CHECK REPRODUCIBILITY   
STEPI115*/
L2010:
    fsave = cstep_1.FOBJ;
/*                                                                      
STEPI117*/
/* SET FIXED QUANTITIES ....                                            
STEPI118*/
/*                                                                      
STEPI119*/
/*                           MXSTP ...  LOG2(MAXIMUM NUMBER OF STEPS)   
STEPI120*/
    mxstp = 5;
/*                           FACUP ...  IF MORE THAN FACUP STEPS ARE    
STEPI122*/
/*                                TAKEN, THE STEP SIZE IS INCREASED     
STEPI123*/
    facup = (float)4.;
/*                           ACK ...  RATIO OF STEP SIZE INCREASE       
STEPI125*/
    ack = (float)2.;
/*                           STCUT ...  RATIO OF STEP SIZE DECREASE     
STEPI127*/
    stcut = (float)10.;
/*                           MOSQ ...  MAXIMUM DEPTH OF OSCILLATION     
STEPI129*/
/*                                SEARCH                                
STEPI130*/
    mosq = 5;
/*                           MNOSC ...  MINIMUM OSCILLATION PERIOD      
STEPI132*/
    mnosc = 2;
/*                                                                      
STEPI134*/
    rzero = (float)0.;
    rten = (float)10.;
/*                                                                      
STEPI137*/
/* NO REAL CONSTANTS ARE USED BEYOND THIS POINT.                        
STEPI138*/
/*                                                                      
STEPI139*/
    cstep_1.KERFL = 0;
/*                           JOCK ...  SWITCH USED IN SETTING JVARY     
STEPI141*/
    jock = 1;
/*                           JUMP ...  FLAG SET BY SUBROUTINE DATSW     
STEPI143*/
    jump = 2;
/*                           NOSC ...  CURRENT DEPTH OF THE OSCILLATION 
STEPI145*/
/*                                INFORMATION                           
STEPI146*/
    nosc = 0;
/*                           KWIT ...  TERMINATION SWITCH               
STEPI148*/
    kwit = 0;
/*                           FBEST ...  BEST PREVIOUS VALUE OF FOBJ     
STEPI150*/
    fbest = cstep_1.FOBJ;
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
/*                           DX(J) ...  CURRENT STEP SIZE FOR X(J)    
  STEPI153*/
/* L2020: */
	stork_1.dx[j - 1] = cstep_1.DELTX[j - 1];
    }
/*                                                                      
STEPI155*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STEPI156*/
/*                                                                      
STEPI157*/
/* VARY THE PARAMETERS ONE AT A TIME.                                   
STEPI158*/
/* THIS IS THE STARTING POINT USED EACH TIME THE STEP SIZE IS REDUCED   
STEPI159*/
/* OR A SUCCESSFUL GIANT STEP IS COMPLETED.                             
STEPI160*/
/*                                                                      
STEPI161*/
/*                           NCIRC ...  NUMBER OF CONSECUTIVE X(JX)     
STEPI162*/
/*                                WITHOUT SIZABLE CHANGES               
STEPI163*/
L2030:
    ncirc = 0;
/*                           NZIP ...  NUMBER OF CONSECUTIVE CYCLES     
STEPI165*/
/*                                WITHOUT A GIANT STEP                  
STEPI166*/
    nzip = 0;
/*                                                                      
STEPI168*/
/* MAIN DO LOOP FOR CYCLING THROUGH THE VARIABLES....                   
STEPI169*/
/* THE FIRST TRIAL STEP WITH EACH VARIABLE IS SEPARATE.                 
STEPI170*/
/*                                                                      
STEPI171*/
/*                           NACK ...  NUMBER OF ACTIVE X(JX) CYCLED    
STEPI172*/
/*                                THROUGH                               
STEPI173*/
L2040:
    nack = 0;
    i_1 = cstep_1.NV;
    for (jx = 1; jx <= i_1; ++jx) {
/*                           JFLAT(JX) ...  NONZERO IF CHANGING X(JX) 
  STEPI176*/
/*                                DID NOT CHANGE FOBJ                 
  STEPI177*/
	jflat[jx - 1] = 0;
/*                           VEC(J) ...  CURRENT VECTOR OF NUMBER OF  
  STEPI179*/
/*                                STEPS IN X(J)                       
  STEPI180*/
	vec[jx - 1] = rzero;
/*                           DLX(JX) ...  CHANGE IN X(JX)             
  STEPI182*/
	stork_1.dlx[jx - 1] = rzero;
	if (cstep_1.MASK[jx - 1] != 0) {
	    goto L2050;
	} else {
	    goto L2060;
	}
L2050:
	vec[jx - 1] = -(doublereal)rzero;
	jflat[jx - 1] = 1;
	goto L3190;
L2060:
	++nack;
/*                           ADX=ABS(DX(JX))                          
  STEPI189*/
	adx = stork_1.dx[jx - 1];
	if (adx >= (float)0.) {
	    goto L2080;
	} else {
	    goto L2070;
	}
L2070:
	adx = -(doublereal)adx;
/*                           CHECK THAT DX(JX) IS NOT NEGLIGIBLE.     
  STEPI193*/
L2080:
	xsave = cstep_1.X[jx - 1];
	xplus = xsave + stork_1.dx[jx - 1];
	if (xplus - xsave != (float)0.) {
	    goto L2090;
	} else {
	    goto L2100;
	}
L2090:
	xplus = xsave - stork_1.dx[jx - 1];
	if (xplus - xsave != (float)0.) {
	    goto L2110;
	} else {
	    goto L2100;
	}
L2100:
	jflat[jx - 1] = 2;
	goto L2300;
/*                           STEP X(JX).                              
  STEPI201*/
L2110:
	cstep_1.X[jx - 1] = xsave + stork_1.dx[jx - 1];
	cstep_1.JVARY = 0;
	if (jock <= 0) {
	    goto L2130;
	} else {
	    goto L2120;
	}
L2120:
	jock = 0;
	cstep_1.JVARY = jx;
/*                           NFLAG ...  COUNTER USED IN SETTING JFLAG(
J)STEPI207*/
L2130:
	nflag = 1;
	if (cstep_1.X[jx - 1] - cstep_1.XMIN[jx - 1] >= (float)0.) {
	    goto L2140;
	} else {
	    goto L2150;
	}
L2140:
	if (cstep_1.X[jx - 1] - cstep_1.XMAX[jx - 1] <= (float)0.) {
	    goto L2160;
	} else {
	    goto L2150;
	}
L2150:
	nflag += 3;
	goto L2180;
L2160:
	(*funk)();
	++stork_1.nf;
	cstep_1.JVARY = jx;
	fprev = cstep_1.FOBJ;
	if ((r_1 = cstep_1.FOBJ - fbest) < (float)0.) {
	    goto L2340;
	} else if (r_1 == 0) {
	    goto L2170;
	} else {
	    goto L2180;
	}
L2170:
	++nflag;
/*                           STEP X(JX) THE OTHER WAY.                
  STEPI219*/
L2180:
	xplus = cstep_1.X[jx - 1];
	cstep_1.X[jx - 1] = xsave - stork_1.dx[jx - 1];
	if (cstep_1.X[jx - 1] - cstep_1.XMIN[jx - 1] >= (float)0.) {
	    goto L2190;
	} else {
	    goto L2310;
	}
L2190:
	if (cstep_1.X[jx - 1] - cstep_1.XMAX[jx - 1] <= (float)0.) {
	    goto L2200;
	} else {
	    goto L2310;
	}
L2200:
	(*funk)();
	++stork_1.nf;
	cstep_1.JVARY = jx;
	if ((r_1 = cstep_1.FOBJ - fbest) < (float)0.) {
	    goto L2330;
	} else if (r_1 == 0) {
	    goto L2210;
	} else {
	    goto L2220;
	}
L2210:
	++nflag;
L2220:
	if ((i_2 = nflag - 3) < 0) {
	    goto L2230;
	} else if (i_2 == 0) {
	    goto L2290;
	} else {
	    goto L2310;
	}
/*                                                                    
  STEPI230*/
/*                           PERFORM PARABOLIC INTERPOLATION.         
  STEPI231*/
/*                                                                    
  STEPI232*/
L2230:
	denom = cstep_1.FOBJ - fbest - (fbest - fprev);
	if (denom != (float)0.) {
	    goto L2240;
	} else {
	    goto L2310;
	}
L2240:
	stork_1.dlx[jx - 1] = -(doublereal)stork_1.dx[jx - 1] * (cstep_1.FOBJ 
		- fprev) / (denom + denom);
	vec[jx - 1] = stork_1.dlx[jx - 1] / adx;
	cstep_1.X[jx - 1] = xsave + stork_1.dlx[jx - 1];
	if (cstep_1.X[jx - 1] - xsave != (float)0.) {
	    goto L2260;
	} else {
	    goto L2250;
	}
L2250:
	cstep_1.FOBJ = fbest;
	goto L2280;
L2260:
	(*funk)();
	++stork_1.nf;
	if (cstep_1.FOBJ - fbest >= (float)0.) {
	    goto L2280;
	} else {
	    goto L2270;
	}
L2270:
	fbest = cstep_1.FOBJ;
	jock = 1;
	goto L2320;
L2280:
	stork_1.dlx[jx - 1] = rzero;
	vec[jx - 1] = rzero;
	goto L2310;
L2290:
	jflat[jx - 1] = 1;
L2300:
	vec[jx - 1] = -(doublereal)rzero;
L2310:
	cstep_1.X[jx - 1] = xsave;
L2320:
	++ncirc;
	if (ncirc - stork_1.nactv >= 0) {
	    goto L3280;
	} else {
	    goto L2450;
	}
/*                                                                    
  STEPI255*/
/*                           FLIP DX(JX) FOR MORE EFFICIENT 
OPERATION.  STEPI256*/
L2330:
	stork_1.dx[jx - 1] = -(doublereal)stork_1.dx[jx - 1];
/*                                                                    
  STEPI258*/
/* A LOWER VALUE OF FOBJ HAS BEEN FOUND.  STEP, INCREASE THE STEP 
SIZE, STEPI259*/
/* AND REPEAT AS LONG AS FOBJ DECREASES, UP TO MXSTP TIMES.           
  STEPI260*/
/*                                                                    
  STEPI261*/
L2340:
	ncirc = 0;
	nstp = 0;
	del = stork_1.dx[jx - 1];
L2350:
	fprev = fbest;
	fbest = cstep_1.FOBJ;
	vec[jx - 1] += del / adx;
	stork_1.dlx[jx - 1] += del;
	++nstp;
	if (nstp - mxstp >= 0) {
	    goto L2430;
	} else {
	    goto L2360;
	}
L2360:
	del = ack * del;
	xplus = xsave;
	xsave = cstep_1.X[jx - 1];
	cstep_1.X[jx - 1] = xsave + del;
	if (cstep_1.X[jx - 1] - cstep_1.XMIN[jx - 1] >= (float)0.) {
	    goto L2370;
	} else {
	    goto L2440;
	}
L2370:
	if (cstep_1.X[jx - 1] - cstep_1.XMAX[jx - 1] <= (float)0.) {
	    goto L2380;
	} else {
	    goto L2440;
	}
L2380:
	(*funk)();
	++stork_1.nf;
	if (cstep_1.FOBJ - fbest >= (float)0.) {
	    goto L2390;
	} else {
	    goto L2350;
	}
/*                                                                    
  STEPI280*/
/*                           PERFORM PARABOLIC INTERPOLATION.         
  STEPI281*/
L2390:
	dxz = xsave - xplus;
	dxu = cstep_1.X[jx - 1] - xsave;
	dfz = fbest - fprev;
	dfu = cstep_1.FOBJ - fbest;
	denom = dfz * dxu - dfu * dxz;
	if (denom != (float)0.) {
	    goto L2400;
	} else {
	    goto L2440;
	}
L2400:
/* Computing 2nd power */
	r_1 = dxu;
/* Computing 2nd power */
	r_2 = dxz;
	del = (dfz * (r_1 * r_1) + dfu * (r_2 * r_2)) / (denom + denom);
	cstep_1.X[jx - 1] = xsave + del;
	if (cstep_1.X[jx - 1] - xsave != (float)0.) {
	    goto L2410;
	} else {
	    goto L2450;
	}
L2410:
	(*funk)();
	++stork_1.nf;
	if (cstep_1.FOBJ - fbest >= (float)0.) {
	    goto L2440;
	} else {
	    goto L2420;
	}
L2420:
	fbest = cstep_1.FOBJ;
	stork_1.dlx[jx - 1] += del;
	vec[jx - 1] += del / adx;
L2430:
	jock = 1;
	goto L2450;
L2440:
	cstep_1.X[jx - 1] = xsave;
/*                           SEE IF THE STEP SIZE SHOULD BE 
INCREASED.  STEPI300*/
L2450:
	if (nzip <= 0) {
	    goto L2460;
	} else {
	    goto L2470;
	}
L2460:
	if (nack - 1 <= 0) {
	    goto L3190;
	} else {
	    goto L2470;
	}
L2470:
	avec = vec[jx - 1];
	if (avec < (float)0.) {
	    goto L2480;
	} else if (avec == 0) {
	    goto L3190;
	} else {
	    goto L2490;
	}
L2480:
	avec = -(doublereal)avec;
L2490:
	if (avec - facup >= (float)0.) {
	    goto L2500;
	} else {
	    goto L2560;
	}
/*                                                                    
  STEPI307*/
/*                           INCREASE THE STEP SIZE.                  
  STEPI308*/
L2500:
	stork_1.dx[jx - 1] *= ack;
	vec[jx - 1] /= ack;
	if (nosc <= 0) {
	    goto L2530;
	} else {
	    goto L2510;
	}
L2510:
	i_2 = nosc;
	for (j = 1; j <= i_2; ++j) {
/* L2520: */
	    cstep_1.ERR[jx + j * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] /= ack;
	}
L2530:
	if (cstep_1.NTRAC <= 0) {
	    goto L2560;
	} else {
	    goto L2540;
	}
L2540:
	io__61.ciunit = cstep_1.KW;
	s_wsfe(&io__61);
	do_fio(&c__1, (char *)&jx, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&stork_1.dx[jx - 1], (ftnlen)sizeof(real));
	e_wsfe();
/*                                                                    
  STEPI318*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
* STEPI319*/
/*                                                                    
  STEPI320*/
/* STEP ALONG A RESULTANT DIRECTION, IF POSSIBLE.                     
  STEPI321*/
/*                                                                    
  STEPI322*/
L2560:
	if (nzip <= 0) {
	    goto L3190;
	} else {
	    goto L2570;
	}
L2570:
	nonzr = 0;
	sumv = rzero;
	i_2 = cstep_1.NV;
	for (j = 1; j <= i_2; ++j) {
	    if (vec[j - 1] != (float)0.) {
		goto L2580;
	    } else {
		goto L2590;
	    }
L2580:
	    ++nonzr;
L2590:
/* Computing 2nd power */
	    r_1 = vec[j - 1];
	    sumv += r_1 * r_1;
	}
	if (nonzr - 2 >= 0) {
	    goto L2600;
	} else {
	    goto L3190;
	}
L2600:
	if (sumv <= (float)0.) {
	    goto L2810;
	} else {
	    goto L2610;
	}
/*                                                                    
  STEPI332*/
/* GIANT STEPS WILL BE ATTEMPTED.  CHECK FOR POSSIBLE GIGANTIC STEPS. 
  STEPI333*/
/*                                                                    
  STEPI334*/
L2610:
	if (mosq <= 0) {
	    goto L2810;
	} else {
	    goto L2620;
	}
L2620:
/*                                                                    
  STEPI337*/
/*X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X 
X STEPI338*/
/*                                                                    
  STEPI339*/
/* OSCILLATION SEARCH SECTION......                                   
  STEPI340*/
/*                                                                    
  STEPI341*/
/*                           KL ...  POINTER FOR OSCILLATION CHECK    
  STEPI342*/
	kl = 1;
/*                           STORE OSCILLATION INFORMATION.           
  STEPI344*/
/*                                NOSC=MIN0(NOSC+1,MOSQ)              
  STEPI345*/
	++nosc;
	if (nosc - mosq <= 0) {
	    goto L2660;
	} else {
	    goto L2630;
	}
L2630:
	nosc = mosq;
	if ((i_2 = nosc - 1) < 0) {
	    goto L2810;
	} else if (i_2 == 0) {
	    goto L2660;
	} else {
	    goto L2640;
	}
/*                                                                    
  STEPI350*/
/*                           THE QUEUE OF OSCILLATION INFORMATION IS  
  STEPI351*/
/*                                FULL.  PUSH IT DOWN, THROWING AWAY  
  STEPI352*/
/*                                THE OLDEST ITEM.                    
  STEPI353*/
L2640:
	i_2 = nosc;
	for (k = 2; k <= i_2; ++k) {
	    fosc[k - 2] = fosc[k - 1];
	    i_3 = cstep_1.NV;
	    for (j = 1; j <= i_3; ++j) {
		xosc[j + (k - 1) * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = xosc[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1];
/* L2650: */
		cstep_1.ERR[j + (k - 1) * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = cstep_1.ERR[j + k * MAX_STEPIT_NVAR - 
			MAX_STEPIT_NVAR_PLUS1];
	    }
	}
/*                                                                    
  STEPI359*/
/*                           ADD THE NEW ITEM TO THE QUEUE.           
  STEPI360*/
L2660:
	sumv = sqrt(sumv);
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    xosc[j + nosc * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = cstep_1.X[j - 1];
/* L2670: */
	    cstep_1.ERR[j + nosc * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = vec[j - 1] / sumv;
	}
	fosc[nosc - 1] = fbest;
	if (nosc - 2 >= 0) {
	    goto L2680;
	} else {
	    goto L2810;
	}
/*                                                                    
  STEPI367*/
/* SEARCH FOR A PREVIOUS SUCCESSFUL GIANT STEP IN A DIRECTION MORE    
  STEPI368*/
/* NEARLY PARALLEL TO THE DIRECTION OF THE PROPOSED STEP THAN WAS THE 
  STEPI369*/
/* IMMEDIATELY PREVIOUS ONE.  THIS MAY MEAN THAT THE DIRECTIONS OF 
THE  STEPI370*/
/* GIANT STEPS OSCILLATE PERIODICALLY (ZIG-ZAG).  TRY GIGANTIC        
  STEPI371*/
/* (OSCILLATION) STEPS OF DECREASING PERIOD, THEN ORDINARY GIANT 
STEPS. STEPI372*/
/* SINCE THE DIRECTIONS ARE GIVEN AS NUMBERS OF STEPS, THIS           
  STEPI373*/
/* PROCEDURE IS SCALE INDEPENDENT.                                    
  STEPI374*/
/*                                                                    
  STEPI375*/
L2680:
	coxcm = rzero;
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
/* L2690: */
	    coxcm += cstep_1.ERR[j + nosc * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] * cstep_1.ERR[j + (nosc 
		    - 1) * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1];
	}
	nah = nosc - mnosc;
L2700:
	if (kl - nah <= 0) {
	    goto L2710;
	} else {
	    goto L2810;
	}
L2710:
	i_3 = nah;
	for (k = kl; k <= i_3; ++k) {
/*                           NRETR ...  NUMBER OF OSCILLATION 
PERIODS   STEPI382*/
/*                                YET TO BE TESTED                
      STEPI383*/
	    nretr = nah - k;
	    cosin = rzero;
	    i_2 = cstep_1.NV;
	    for (j = 1; j <= i_2; ++j) {
/* L2720: */
		cosin += cstep_1.ERR[j + nosc * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] * cstep_1.ERR[j + k *
			 MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1];
	    }
	    if (k - (nosc - 1) >= 0) {
		goto L2760;
	    } else {
		goto L2730;
	    }
L2730:
	    if (cosin <= (float)0.) {
		goto L2750;
	    } else {
		goto L2740;
	    }
L2740:
	    if (cosin - coxcm <= (float)0.) {
		goto L2750;
	    } else {
		goto L2760;
	    }
L2750:
	;}
	goto L2810;
/*                           ZIG-ZAGGING DETECTED.  ATTEMPT TO TAKE   
  STEPI393*/
/*                                GIGANTIC STEPS.                     
  STEPI394*/
L2760:
	kl = k + 1;
	if (cstep_1.NTRAC <= 0) {
	    goto L2790;
	} else {
	    goto L2770;
	}
L2770:
	nt = nosc - k;
	io__73.ciunit = cstep_1.KW;
	s_wsfe(&io__73);
	do_fio(&c__1, (char *)&nt, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&coxcm, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&cosin, (ftnlen)sizeof(real));
	e_wsfe();
L2790:
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
/*                           SALVO ...  SAVES DLX DURING GIGANTIC 
STEPS STEPI402*/
	    salvo[j - 1] = stork_1.dlx[j - 1];
/* L2800: */
	    stork_1.dlx[j - 1] = cstep_1.X[j - 1] - xosc[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1];
	}
	fprev = fosc[k - 1];
	goto L2820;
/*                                                                    
  STEPI407*/
/*X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X 
X STEPI408*/
/*                                                                    
  STEPI409*/
/* SIMON SAYS, TAKE AS MANY GIANT STEPS AS POSSIBLE.                  
  STEPI410*/
/*                                                                    
  STEPI411*/
L2810:
	fprev = fstor[jx - 1];
/*                           NRETR=-1 IF A GIANT STEP IS BEING TRIED. 
  STEPI413*/
	nretr = -1;
/*                           NGIAN...  NUMBER OF GIANT OR GIGANTIC    
  STEPI415*/
/*                                STEPS COMPLETED                     
  STEPI416*/
L2820:
	ngian = 0;
	nfsav = stork_1.nf;
L2830:
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    stork_1.xs[j - 1] = cstep_1.X[j - 1];
	    if (cstep_1.MASK[j - 1] != 0) {
		goto L2880;
	    } else {
		goto L2840;
	    }
L2840:
	    cstep_1.X[j - 1] += stork_1.dlx[j - 1];
/*                           X(J)=AMAX1(AMIN1(X(J),XMAX(J)),XMIN(
J))    STEPI423*/
	    if (cstep_1.X[j - 1] - cstep_1.XMAX[j - 1] <= (float)0.) {
		goto L2860;
	    } else {
		goto L2850;
	    }
L2850:
	    cstep_1.X[j - 1] = cstep_1.XMAX[j - 1];
L2860:
	    if (cstep_1.X[j - 1] - cstep_1.XMIN[j - 1] >= (float)0.) {
		goto L2880;
	    } else {
		goto L2870;
	    }
L2870:
	    cstep_1.X[j - 1] = cstep_1.XMIN[j - 1];
L2880:
	;}
	jock = 0;
	cstep_1.JVARY = 0;
	(*funk)();
	++stork_1.nf;
	if (cstep_1.FOBJ - fbest >= (float)0.) {
	    goto L2960;
	} else {
	    goto L2890;
	}
L2890:
	fprev = fbest;
	fbest = cstep_1.FOBJ;
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
/* L2900: */
	    stork_1.dlx[j - 1] *= ack;
	}
	++ngian;
	if (cstep_1.NTRAC <= 0) {
	    goto L2830;
	} else {
	    goto L2910;
	}
L2910:
	if (ngian - 1 <= 0) {
	    goto L2920;
	} else {
	    goto L2950;
	}
L2920:
	io__78.ciunit = cstep_1.KW;
	s_wsfe(&io__78);
	i_3 = jx;
	for (j = 1; j <= i_3; ++j) {
	    do_fio(&c__1, (char *)&vec[j - 1], (ftnlen)sizeof(real));
	}
	e_wsfe();
	io__79.ciunit = cstep_1.KW;
	s_wsfe(&io__79);
	do_fio(&c__1, (char *)&fprev, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&nfsav, (ftnlen)sizeof(integer));
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    do_fio(&c__1, (char *)&stork_1.xs[j - 1], (ftnlen)sizeof(real));
	}
	e_wsfe();
L2950:
	io__80.ciunit = cstep_1.KW;
	s_wsfe(&io__80);
	do_fio(&c__1, (char *)&cstep_1.FOBJ, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&stork_1.nf, (ftnlen)sizeof(integer));
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
	}
	e_wsfe();
	goto L2830;
L2960:
	if (ngian <= 0) {
	    goto L3040;
	} else {
	    goto L2970;
	}
/*                                                                    
  STEPI449*/
/*                           PERFORM PARABOLIC INTERPOLATION.         
  STEPI450*/
/*                                                                    
  STEPI451*/
L2970:
	denom = ack * (fprev - fbest) - (fbest - cstep_1.FOBJ);
	if (denom != (float)0.) {
	    goto L2980;
	} else {
	    goto L3040;
	}
L2980:
	cindr = ((fprev - fbest) * ack + (fbest - cstep_1.FOBJ) / ack) / (
		denom + denom);
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    if (cstep_1.MASK[j - 1] != 0) {
		goto L3030;
	    } else {
		goto L2990;
	    }
L2990:
	    cstep_1.X[j - 1] = stork_1.xs[j - 1] + cindr * stork_1.dlx[j - 1];

/*                                                                
      STEPI458*/
/*                           X(J)=AMAX1(AMIN1(X(J),XMAX(J)),XMIN(
J))    STEPI459*/
	    if (cstep_1.X[j - 1] - cstep_1.XMAX[j - 1] <= (float)0.) {
		goto L3010;
	    } else {
		goto L3000;
	    }
L3000:
	    cstep_1.X[j - 1] = cstep_1.XMAX[j - 1];
L3010:
	    if (cstep_1.X[j - 1] - cstep_1.XMIN[j - 1] >= (float)0.) {
		goto L3030;
	    } else {
		goto L3020;
	    }
L3020:
	    cstep_1.X[j - 1] = cstep_1.XMIN[j - 1];
L3030:
	;}
	jock = 0;
	cstep_1.JVARY = 0;
	(*funk)();
	++stork_1.nf;
	if (cstep_1.FOBJ - fbest >= (float)0.) {
	    goto L3040;
	} else {
	    goto L3120;
	}
L3040:
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    if (nretr >= 0) {
		goto L3050;
	    } else {
		goto L3060;
	    }
L3050:
	    stork_1.dlx[j - 1] = salvo[j - 1];
L3060:
	    cstep_1.X[j - 1] = stork_1.xs[j - 1];
	}
	if (cstep_1.NTRAC <= 0) {
	    goto L3090;
	} else {
	    goto L3070;
	}
L3070:
	io__82.ciunit = cstep_1.KW;
	s_wsfe(&io__82);
	do_fio(&c__1, (char *)&fbest, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&ngian, (ftnlen)sizeof(integer));
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
	}
	e_wsfe();
L3090:
	if (ngian <= 0) {
	    goto L3100;
	} else {
	    goto L3150;
	}
L3100:
/*                                                                    
  STEPI480*/
/*X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X 
X STEPI481*/
/*                                                                    
  STEPI482*/
/* STATEMENT USED IN THE OSCILLATION SEARCH....                       
  STEPI483*/
/*                                                                    
  STEPI484*/
	if (nretr < 0) {
	    goto L3170;
	} else if (nretr == 0) {
	    goto L3110;
	} else {
	    goto L2700;
	}
/*                                                                    
  STEPI486*/
/*X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X X 
X STEPI487*/
/*                                                                    
  STEPI488*/
/*                           IF ALL GIGANTIC STEPS WERE UNSUCCESSFUL, 
  STEPI489*/
/*                                TRY A GIANT STEP.                   
  STEPI490*/
L3110:
	if (nretr != 0) {
	    goto L3170;
	} else {
	    goto L2810;
	}
/*                                                                    
  STEPI492*/
L3120:
	fbest = cstep_1.FOBJ;
	jock = 1;
	if (cstep_1.NTRAC <= 0) {
	    goto L3150;
	} else {
	    goto L3130;
	}
L3130:
	steps = (real) ngian;
	steps += cindr;
	io__84.ciunit = cstep_1.KW;
	s_wsfe(&io__84);
	do_fio(&c__1, (char *)&fbest, (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&steps, (ftnlen)sizeof(real));
	i_3 = cstep_1.NV;
	for (j = 1; j <= i_3; ++j) {
	    do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
	}
	e_wsfe();
L3150:
	if (nretr >= 0) {
	    goto L3160;
	} else {
	    goto L2030;
	}
L3160:
/*                           A SUCCESSFUL GIGANTIC STEP HAS OCCURRED. 
  STEPI503*/
/*                           INSERT ADDITIONAL LOGIC HERE IF DESIRED. 
  STEPI504*/
	goto L2030;
/*                           AN UNSUCCESSFUL GIANT STEP HAS OCCURRED. 
  STEPI506*/
/*                                DELETE ITS OSCILLATION INFORMATION. 
  STEPI507*/
/*                                NOSC=MAX0(NOSC-1,0)                 
  STEPI508*/
L3170:
	--nosc;
	if (nosc >= 0) {
	    goto L3190;
	} else {
	    goto L3180;
	}
L3180:
	nosc = 0;
/*                           COMPLETE THE MAIN DO LOOP.               
  STEPI512*/
/*                           FSTOR(JX) ...  SAVES FBEST FOR           
  STEPI513*/
/*                                INTERPOLATION IN GIANT STEPS        
  STEPI514*/
L3190:
	fstor[jx - 1] = fbest;
/*                           RETURN IF THE SENSE SWITCH IS ON.        
  STEPI517*/
	datsw_(&stork_1.nssw, &jump);
	if (jump - 1 <= 0) {
	    goto L3550;
	} else {
	    goto L3200;
	}
/*                                                                    
  STEPI520*/
L3200:
	if (stork_1.nf - cstep_1.NFMAX <= 0) {
	    goto L3210;
	} else {
	    goto L3530;
	}
L3210:
    ;}
/*                           END OF THE MAIN DO LOOP.                   
STEPI523*/
/*                                                                      
STEPI524*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STEPI525*/
/*                                                                      
STEPI526*/
/* ANOTHER CYCLE THROUGH THE VARIABLES HAS BEEN COMPLETED.              
STEPI527*/
/* PRINT ANOTHER LINE OF TRACES.                                        
STEPI528*/
/*                                                                      
STEPI529*/
    if (cstep_1.NTRAC <= 0) {
	goto L3230;
    } else {
	goto L3220;
    }
L3220:
    io__85.ciunit = cstep_1.KW;
    s_wsfe(&io__85);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&vec[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
L3230:
    if (nzip != 0) {
	goto L3270;
    } else {
	goto L3240;
    }
L3240:
    if (cstep_1.NTRAC <= 0) {
	goto L3270;
    } else {
	goto L3250;
    }
L3250:
    io__86.ciunit = cstep_1.KW;
    s_wsfe(&io__86);
    do_fio(&c__1, (char *)&fbest, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&stork_1.nf, (ftnlen)sizeof(integer));
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io__87.ciunit = cstep_1.KW;
    s_wsfe(&io__87);
    e_wsfe();
L3270:
    ++nzip;
    goto L2040;
/*                                                                      
STEPI540*/
/* A NEW BASE POINT HAS BEEN FOUND.  PRINT THE REMAINING TRACES.        
STEPI541*/
/*                                                                      
STEPI542*/
L3280:
    fstor[jx - 1] = fbest;
    if (cstep_1.NTRAC <= 0) {
	goto L3300;
    } else {
	goto L3290;
    }
L3290:
    io__88.ciunit = cstep_1.KW;
    s_wsfe(&io__88);
    i_1 = jx;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&vec[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    io__89.ciunit = cstep_1.KW;
    s_wsfe(&io__89);
    do_fio(&c__1, (char *)&fbest, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&stork_1.nf, (ftnlen)sizeof(integer));
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
/*                                                                      
STEPI547*/
/* DECREASE THE SIZE OF THE STEPS FOR ALL VARIABLES.                    
STEPI548*/
/*                                                                      
STEPI549*/
L3300:
/*                           RETURN IF THE SENSE SWITCH IS ON.          
STEPI551*/
    datsw_(&stork_1.nssw, &jump);
    if (jump - 1 <= 0) {
	goto L3550;
    } else {
	goto L3310;
    }
/*                                                                      
STEPI554*/
L3310:
    if (stork_1.nf - cstep_1.NFMAX <= 0) {
	goto L3320;
    } else {
	goto L3530;
    }
/*                                                                      
STEPI556*/
/*                           CHECK WHETHER ALL ABS(DX(J)) .LE. DELMN(J)
.STEPI557*/
L3320:
    ngate = 1;
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	if (cstep_1.MASK[j - 1] != 0) {
	    goto L3370;
	} else {
	    goto L3330;
	}
/*                                                                    
  STEPI561*/
/*                           IF(ABS(DX(J))-DELMN(J))                  
  STEPI562*/
L3330:
	adx = stork_1.dx[j - 1];
	if (adx >= (float)0.) {
	    goto L3350;
	} else {
	    goto L3340;
	}
L3340:
	adx = -(doublereal)adx;
L3350:
	if (adx - cstep_1.DELMN[j - 1] <= (float)0.) {
	    goto L3370;
	} else {
	    goto L3360;
	}
L3360:
	ngate = 0;
L3370:
	stork_1.dx[j - 1] /= stcut;
    }
    if (ngate <= 0) {
	goto L3410;
    } else {
	goto L3380;
    }
L3380:
    cstep_1.KFLAG = 1;
    if (cstep_1.NTRAC >= 0) {
	goto L3390;
    } else {
	goto L3580;
    }
L3390:
    io__91.ciunit = cstep_1.KW;
    s_wsfe(&io__91);
    e_wsfe();
    goto L3580;
/*                           CHECK THE JFLAT(J).                        
STEPI576*/
L3410:
    if (cstep_1.NFLAT <= 0) {
	goto L3500;
    } else {
	goto L3420;
    }
L3420:
    jflmn = 5;
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	if (cstep_1.MASK[j - 1] != 0) {
	    goto L3450;
	} else {
	    goto L3430;
	}
L3430:
	if (jflat[j - 1] - jflmn >= 0) {
	    goto L3450;
	} else {
	    goto L3440;
	}
L3440:
	jflmn = jflat[j - 1];
L3450:
    ;}
    if (jflmn - 1 >= 0) {
	goto L3460;
    } else {
	goto L3500;
    }
L3460:
    cstep_1.KFLAG = 2;
    if (cstep_1.NTRAC >= 0) {
	goto L3470;
    } else {
	goto L3580;
    }
L3470:
    io__93.ciunit = cstep_1.KW;
    s_wsfe(&io__93);
    e_wsfe();
    io__94.ciunit = cstep_1.KW;
    s_wsfe(&io__94);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&stork_1.dx[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    goto L3580;
/*                           PRINT THE DX(J) AND SEARCH SOME MORE.      
STEPI593*/
L3500:
    if (cstep_1.NTRAC <= 0) {
	goto L2030;
    } else {
	goto L3510;
    }
L3510:
    io__95.ciunit = cstep_1.KW;
    s_wsfe(&io__95);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&stork_1.dx[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
    goto L2030;
/*                                                                      
STEPI599*/
L3530:
    cstep_1.KFLAG = -2;
    io__96.ciunit = cstep_1.KW;
    s_wsfe(&io__96);
    do_fio(&c__1, (char *)&cstep_1.NFMAX, (ftnlen)sizeof(integer));
    e_wsfe();
    goto L3570;
/*                                                                      
STEPI605*/
L3550:
    cstep_1.KFLAG = -3;
    io__97.ciunit = cstep_1.KW;
    s_wsfe(&io__97);
    do_fio(&c__1, (char *)&stork_1.nssw, (ftnlen)sizeof(integer));
    e_wsfe();
/*                                                                      
STEPI610*/
L3570:
    io__98.ciunit = cstep_1.KW;
    s_wsfe(&io__98);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&stork_1.dx[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
/*                                                                      
STEPI613*/
/*                           SET SWITCH FOR TERMINATION.                
STEPI614*/
    kwit = 1;
/*                           CALL FUNK WITH THE BEST SET OF X(J).       
STEPI616*/
L3580:
    cstep_1.JVARY = 0;
    (*funk)();
    if (fbest - fsave <= (float)0.) {
	goto L3590;
    } else {
	goto L3600;
    }
L3590:
    if (cstep_1.FOBJ - fbest != (float)0.) {
	goto L3600;
    } else {
	goto L3620;
    }
L3600:
    cstep_1.NOREP += 2;
    io__99.ciunit = cstep_1.KW;
    s_wsfe(&io__99);
    do_fio(&c__1, (char *)&stork_1.nf, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&fsave, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&fbest, (ftnlen)sizeof(real));
    do_fio(&c__1, (char *)&cstep_1.FOBJ, (ftnlen)sizeof(real));
    e_wsfe();
L3620:
    if (cstep_1.NTRAC >= 0) {
	goto L3630;
    } else {
	goto L3650;
    }
L3630:
    io__100.ciunit = cstep_1.KW;
    s_wsfe(&io__100);
    do_fio(&c__1, (char *)&stork_1.nf, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&cstep_1.FOBJ, (ftnlen)sizeof(real));
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
L3650:
    if (kwit != 0) {
	goto L3710;
    } else {
	goto L3660;
    }
/*                           IF(IABS(MATRX-100)-50)                     
STEPI632*/
L3660:
    matd = cstep_1.MATRX - 100;
    if (matd >= 0) {
	goto L3680;
    } else {
	goto L3670;
    }
L3670:
    matd = -matd;
L3680:
    if (matd - 50 <= 0) {
	goto L3690;
    } else {
	goto L3710;
    }
/*                                                                      
STEPI637*/
/*                           SET THE STEP SIZES FOR SUBROUTINE STERR.   
STEPI638*/
L3690:
    i_1 = cstep_1.MATRX - 100;
    fac = pow_ri(&rten, &i_1);
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
/* L3700: */
	stork_1.dx[j - 1] = fac * stork_1.dx[j - 1];
    }
/*                           CALL STERR TO COMPUTE AN APPROXIMATE       
STEPI642*/
/*                                ERROR MATRIX.                         
STEPI643*/
    sterr_(funk);
/*                           THIS IS THE ONLY RETURN STATEMENT....      
STEPI645*/
L3710:
    return 0;
/* END STEPIT.                                                          
STEPI647*/
} /* stept_ */

/* Subroutine */ int sterr_(funk)
/* Subroutine */ int (*funk) ();
{
    /* Format strings */
    static char fmt_5070[] = "(\0021COMPUTE AN APPROXIMATE ERROR MATRIX USIN\
G FINITE\002,\002 DIFFERENCES.\002////\002 INCREMENTS IN X(J) TO BE USED...\
.\002)";
    static char fmt_5080[] = "(/(9x8e13.5))";
    static char fmt_5230[] = "(//////\002 MATRIX OF THE SECOND PARTIAL DERIV\
ATIVES....\002,///,12x,\002 K ....\002,i5,7i13/(11x8i13))";
    static char fmt_5240[] = "(/,7x,\002 MASK(K)....\002,i5,7i13/(11x8i13))";
    static char fmt_5250[] = "(//3x,\002J\002,4x,\002MASK(J)\002)";
    static char fmt_5260[] = "(/1xi3,i8,5x8e13.5/(17x8e13.5))";
    static char fmt_5350[] = "(////\002 THE ABOVE MATRIX CONTAINS ONE OR MOR\
E\002,\002 UNEXPECTED ZEROES.\002/\002 PERHAPS A LARGER VALUE OF -MATRX-\002\
,\002 SHOULD BE TRIED, TO SEE IF THEY ARE LEGITIMATE.\002)";
    static char fmt_5380[] = "(////\002 A PIVOT ELEMENT OF THE MATRIX IS ZER\
O.\002,\002  PERHAPS -MATRX- SHOULD BE INCREASED.\002////\002 \002)";
    static char fmt_5510[] = "(////\002 THE ERROR MATRIX IS NOT POSITIVE DEF\
INITE. \002,\002 PERHAPS -MATRX- SHOULD BE DECREASED.\002)";
    static char fmt_5600[] = "(//////\002 APPROXIMATE STANDARD ERRORS....\
\002///,12x,\002J\002,6x,\002MASK(J)\002,9x,\002X(J)\002,14x,\002ERROR\002)";
    static char fmt_5670[] = "(///\002 NEGATIVE OR ZERO MEAN SQUARE\002,\002\
 ERROR ENCOUNTERED....\002,3xe16.8/,\002 PERHAPS -MATRX- SHOULD BE DECREASED\
.\002,///\002 \002)";
    static char fmt_5700[] = "(/10xi3,i10,6xe16.8,4xe13.5)";
    static char fmt_5740[] = "(//////\002 LOWER TRIANGLE OF THE CORRELATION \
MATRIX....\002,///,12x,\002 K ....\002,i5,7i13,/,(11x,8i13))";
    static char fmt_5820[] = "(/////1xi6,\002 FUNCTION COMPUTATIONS \002,///\
,\002 FINAL VALUE OF FOBJ = \002,e23.15///,9x,\002 FINAL VALUES OF X(J)...\
.\002,//(1x5e23.15))";

    /* System generated locals */
    integer i_1, i_2, i_3;
    real r_1;

    /* Builtin functions */
    integer s_wsfe(), e_wsfe(), do_fio();
    double sqrt();

    /* Local variables */
    static real aber;
    static integer jact, kact, jump;
    static real rtwo;
    static integer j, k, l, m;
    static real p, q, dxdef, secnd[4]	/* was [2][2] */, denom, fbest;
    extern /* Subroutine */ int datsw_();
    static integer notpd;
    static real rzero, runit;
    static integer jj, kk, ll, jmu;

    /* Fortran I/O blocks */
    static cilist io__109 = { 0, 0, 0, fmt_5070, 0 };
    static cilist io__110 = { 0, 0, 0, fmt_5080, 0 };
    static cilist io__117 = { 0, 0, 0, fmt_5230, 0 };
    static cilist io__118 = { 0, 0, 0, fmt_5240, 0 };
    static cilist io__119 = { 0, 0, 0, fmt_5250, 0 };
    static cilist io__120 = { 0, 0, 0, fmt_5260, 0 };
    static cilist io__122 = { 0, 0, 0, fmt_5350, 0 };
    static cilist io__126 = { 0, 0, 0, fmt_5380, 0 };
    static cilist io__128 = { 0, 0, 0, fmt_5510, 0 };
    static cilist io__132 = { 0, 0, 0, fmt_5600, 0 };
    static cilist io__134 = { 0, 0, 0, fmt_5670, 0 };
    static cilist io__135 = { 0, 0, 0, fmt_5700, 0 };
    static cilist io__136 = { 0, 0, 0, fmt_5740, 0 };
    static cilist io__137 = { 0, 0, 0, fmt_5240, 0 };
    static cilist io__138 = { 0, 0, 0, fmt_5250, 0 };
    static cilist io__140 = { 0, 0, 0, fmt_5260, 0 };
    static cilist io__141 = { 0, 0, 0, fmt_5820, 0 };


/*                                                                      
STERR  2*/
/* STERR 1.3       A.N.S.I. STANDARD FORTRAN       JUNE 1975            
STERR  3*/
/* COPYRIGHT (C) 1965, 1975 J. P. CHANDLER                              
STERR  4*/
/*                                                                      
STERR  5*/
/* STERR IS CALLED BY STEPIT TO COMPUTE AN APPROXIMATE ERROR MATRIX     
STERR  6*/
/* FOR A NONLINEAR FITTING PROBLEM.                                     
STERR  7*/
/* THE VALUES COMPUTED ARE OFTEN POOR APPROXIMATIONS.  FOR EACH CLASS   
STERR  8*/
/* OF PROBLEMS THEY SHOULD BE CHECKED USING SUBROUTINE FIDO.            
STERR  9*/
/*                                                                      
STERR 10*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STERR 11*/
/*                                                                      
STERR 12*/
/* INPUT QUANTITIES.....  FUNK,KW,NSSW,DX,NF,X,NTRAC,NV                 
STERR 13*/
/* OUTPUT QUANTITIES....  NF,ERR,KERFL, AND SOMETIMES DX                
STERR 14*/
/* SCRATCH STORAGE......  XS,DLX                                        
STERR 15*/
/*                                                                      
STERR 16*/
/* THE DX(J) ARE THE STEP SIZES USED IN APPROXIMATING THE SECOND        
STERR 17*/
/* PARTIAL DERIVATIVES OF FOBJ WITH RESPECT TO THE X(J) BY FINITE       
STERR 18*/
/* DIFFERENCES.                                                         
STERR 19*/
/* ERR RETURNS THE ERROR MATRIX.                                        
STERR 20*/
/* XMAX, XMIN, AND MASK ARE IGNORED IN STERR.                           
STERR 21*/
/* THE REAL FORMAT SPECIFICATIONS USED ARE E13.5, E16.8, AND E23.15 .   
STERR 22*/
/*                                                                      
STERR 23*/
/*    DOUBLE PRECISION X,XMAX,XMIN,DELTX,DELMN,ERR,FOBJ,DX,XS,DLX,      
STERR 24*/
/*   X   SECND,FBEST,RZERO,RUNIT,RTWO,ABER,DENOM                        
STERR 25*/
/*    DOUBLE PRECISION P,Q,QSQRT,DSQRT,DXDEF                            
STERR 26*/
/*                                                                      
STERR 27*/
/*                                                                      
STERR 29*/
/* USER COMMON.....                                                     
STERR 30*/
/*                                                                      
STERR 34*/
/* INTERNAL STEPIT COMMON.....                                          
STERR 35*/
/*                                                                      
STERR 37*/
/* XS AND DLX ARE IN COMMON ONLY TO CONSERVE STORAGE.                   
STERR 38*/
/*                                                                      
STERR 39*/
/*    QSQRT(Q)=DSQRT(Q)                                                 
STERR 41*/
/*                                                                      
STERR 42*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STERR 43*/
/*                                                                      
STERR 44*/
/*                           DXDEF ...  DEFAULT VALUE FOR DX            
STERR 45*/
    dxdef = (float).001;
    rzero = (float)0.;
    runit = (float)1.;
    rtwo = (float)2.;
/*                                                                      
STERR 50*/
/* NO REAL CONSTANTS ARE USED BEYOND THIS POINT.                        
STERR 51*/
/*                                                                      
STERR 52*/
    cstep_1.KERFL = 0;
    i_1 = cstep_1.NV;
    for (k = 1; k <= i_1; ++k) {
	if (cstep_1.MASK[k - 1] != 0) {
	    goto L5050;
	} else {
	    goto L5010;
	}
L5010:
	if ((r_1 = stork_1.dx[k - 1]) < (float)0.) {
	    goto L5040;
	} else if (r_1 == 0) {
	    goto L5020;
	} else {
	    goto L5050;
	}
L5020:
	stork_1.dx[k - 1] = dxdef * cstep_1.X[k - 1];
	if ((r_1 = stork_1.dx[k - 1]) < (float)0.) {
	    goto L5040;
	} else if (r_1 == 0) {
	    goto L5030;
	} else {
	    goto L5050;
	}
L5030:
	stork_1.dx[k - 1] = dxdef;
	goto L5050;
L5040:
	stork_1.dx[k - 1] = -(doublereal)stork_1.dx[k - 1];
L5050:
	stork_1.xs[k - 1] = cstep_1.X[k - 1];
    }
    (*funk)();
    ++stork_1.nf;
    fbest = cstep_1.FOBJ;
    if (cstep_1.NTRAC >= 0) {
	goto L5060;
    } else {
	goto L5090;
    }
L5060:
    io__109.ciunit = cstep_1.KW;
    s_wsfe(&io__109);
    e_wsfe();

    io__110.ciunit = cstep_1.KW;
    s_wsfe(&io__110);
    i_1 = cstep_1.NV;
    for (k = 1; k <= i_1; ++k) {
	do_fio(&c__1, (char *)&stork_1.dx[k - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();
/*                                                                      
STERR 72*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STERR 73*/
/*                                                                      
STERR 74*/
/* APPROXIMATE THE (SYMMETRIC) MATRIX OF SECOND PARTIAL DERIVATIVES     
STERR 75*/
/* OF FOBJ WITH RESPECT TO THE X(J), USING FINITE DIFFERENCES.          
STERR 76*/
/*                                                                      
STERR 77*/
/*                           COMPUTE THE DIAGONAL PARTIALS FIRST.       
STERR 78*/
L5090:
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	cstep_1.ERR[j + j * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = rzero;
	if (cstep_1.MASK[j - 1] != 0) {
	    goto L5120;
	} else {
	    goto L5100;
	}
L5100:
	cstep_1.JVARY = 0;
	for (k = 1; k <= 2; ++k) {
	    cstep_1.X[j - 1] = stork_1.xs[j - 1] + stork_1.dx[j - 1];
	    (*funk)();
	    ++stork_1.nf;
	    cstep_1.JVARY = j;
	    secnd[k - 1] = cstep_1.FOBJ;
/* L5110: */
	    stork_1.dx[j - 1] = -(doublereal)stork_1.dx[j - 1];
	}
	cstep_1.X[j - 1] = stork_1.xs[j - 1];
/* Computing 2nd power */
	r_1 = stork_1.dx[j - 1];
	cstep_1.ERR[j + j * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = (secnd[0] - fbest - (fbest - secnd[1]))
		 / (r_1 * r_1);
L5120:
    ;}
/*                           COMPUTE THE OFF-DIAGONAL PARTIALS.         
STERR 93*/
    if (cstep_1.NV - 2 >= 0) {
	goto L5130;
    } else {
	goto L5210;
    }
L5130:
    i_1 = cstep_1.NV;
    for (j = 2; j <= i_1; ++j) {
	jmu = j - 1;
	i_2 = jmu;
	for (k = 1; k <= i_2; ++k) {
	    cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = rzero;
	    if (cstep_1.MASK[j - 1] != 0) {
		goto L5190;
	    } else {
		goto L5140;
	    }
L5140:
	    if (cstep_1.MASK[k - 1] != 0) {
		goto L5190;
	    } else {
		goto L5150;
	    }
L5150:
	    for (l = 1; l <= 2; ++l) {
		cstep_1.X[j - 1] = stork_1.xs[j - 1] + stork_1.dx[j - 1];
		cstep_1.JVARY = 0;
		for (m = 1; m <= 2; ++m) {
		    cstep_1.X[k - 1] = stork_1.xs[k - 1] + stork_1.dx[k - 1];
		    (*funk)();
		    ++stork_1.nf;
		    cstep_1.JVARY = k;
		    secnd[l + (m << 1) - 3] = cstep_1.FOBJ;
		    cstep_1.X[k - 1] = stork_1.xs[k - 1];
/* L5160: */
		    stork_1.dx[k - 1] = -(doublereal)stork_1.dx[k - 1];
		}
		cstep_1.X[j - 1] = stork_1.xs[j - 1];
/*                           RETURN IF THE SENSE SWITCH IS 
ON.          STERR113*/
		jump = 2;
		datsw_(&stork_1.nssw, &jump);
		if (jump - 1 <= 0) {
		    goto L5170;
		} else {
		    goto L5180;
		}
L5170:
		cstep_1.KERFL = -1;
		goto L5800;
/*                                                            
          STERR119*/
L5180:
		stork_1.dx[j - 1] = -(doublereal)stork_1.dx[j - 1];
	    }
	    cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = (secnd[0] - secnd[2] - (secnd[1] - 
		    secnd[3])) / (rtwo * stork_1.dx[j - 1] * rtwo * 
		    stork_1.dx[k - 1]);
L5190:
	;}
/* L5200: */
    }
/*                           END OF THE DERIVATIVE COMPUTATION.         
STERR125*/
L5210:
    if (cstep_1.NTRAC >= 0) {
	goto L5220;
    } else {
	goto L5280;
    }
L5220:
    io__117.ciunit = cstep_1.KW;
    s_wsfe(&io__117);
    i_1 = cstep_1.NV;
    for (k = 1; k <= i_1; ++k) {
	do_fio(&c__1, (char *)&k, (ftnlen)sizeof(integer));
    }
    e_wsfe();

    io__118.ciunit = cstep_1.KW;
    s_wsfe(&io__118);
    i_1 = cstep_1.NV;
    for (k = 1; k <= i_1; ++k) {
	do_fio(&c__1, (char *)&cstep_1.MASK[k - 1], (ftnlen)sizeof(integer));
    }
    e_wsfe();
    io__119.ciunit = cstep_1.KW;
    s_wsfe(&io__119);
    e_wsfe();
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	io__120.ciunit = cstep_1.KW;
	s_wsfe(&io__120);
	do_fio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&cstep_1.MASK[j - 1], (ftnlen)sizeof(integer));
	i_2 = j;
	for (k = 1; k <= i_2; ++k) {
	    do_fio(&c__1, (char *)&cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1], (ftnlen)
		    sizeof(real));
	}
	e_wsfe();
/* L5270: */
    }
/*                           PACK THE MATRIX OF SECOND DERIVATIVES.     
STERR139*/
L5280:
    stork_1.nactv = 0;
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	if (cstep_1.MASK[j - 1] != 0) {
	    goto L5330;
	} else {
	    goto L5290;
	}
L5290:
	++stork_1.nactv;
	kact = 0;
	i_2 = j;
	for (k = 1; k <= i_2; ++k) {
	    if (cstep_1.MASK[k - 1] != 0) {
		goto L5320;
	    } else {
		goto L5300;
	    }
L5300:
	    ++kact;
	    cstep_1.ERR[stork_1.nactv + kact * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = cstep_1.ERR[j + k * 
		    MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1];
	    if (cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] != (float)0.) {
		goto L5320;
	    } else {
		goto L5310;
	    }
L5310:
	    cstep_1.KERFL = 1;
L5320:
	;}
L5330:
    ;}
    if (cstep_1.KERFL <= 0) {
	goto L5360;
    } else {
	goto L5340;
    }
L5340:
    io__122.ciunit = cstep_1.KW;
    s_wsfe(&io__122);
    e_wsfe();
/*                                                                      
STERR159*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STERR160*/
/*                                                                      
STERR161*/
/* INVERT THE MATRIX OF SECOND PARTIAL DERIVATIVES USING THE GAUSS-     
STERR162*/
/* JORDAN METHOD (F. L. BAUER AND C. REINSCH, P. 45 IN -LINEAR ALGEBRA- 
STERR163*/
/* BY J. H. WILKINSON AND C. REINSCH (SPRINGER-VERLAG, 1971)).          
STERR164*/
/* ONLY THE LOWER TRIANGLE OF ERR IS USED OR ALTERED.                   
STERR165*/
/*                                                                      
STERR166*/
/*                           NOTPD ...  =1 IF THE MATRIX IS NOT         
STERR167*/
/*                                POSITIVE DEFINITE                     
STERR168*/
L5360:
    notpd = 0;
    i_1 = stork_1.nactv;
    for (ll = 1; ll <= i_1; ++ll) {
	l = stork_1.nactv + 1 - ll;
	p = cstep_1.ERR[0];
	if (p < (float)0.) {
	    goto L5390;
	} else if (p == 0) {
	    goto L5370;
	} else {
	    goto L5400;
	}
L5370:
	cstep_1.KERFL = -2;
	io__126.ciunit = cstep_1.KW;
	s_wsfe(&io__126);
	e_wsfe();
	goto L5800;
L5390:
	notpd = 1;
L5400:
	if (stork_1.nactv - 2 >= 0) {
	    goto L5410;
	} else {
	    goto L5460;
	}
L5410:
	i_2 = stork_1.nactv;
	for (k = 2; k <= i_2; ++k) {
	    q = cstep_1.ERR[k - 1];
	    if (k - l <= 0) {
		goto L5430;
	    } else {
		goto L5420;
	    }
L5420:
	    stork_1.xs[k - 1] = q / p;
	    goto L5440;
L5430:
	    stork_1.xs[k - 1] = -(doublereal)q / p;
L5440:
	    i_3 = k;
	    for (m = 2; m <= i_3; ++m) {
/* L5450: */
		cstep_1.ERR[k - 1 + (m - 1) * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = cstep_1.ERR[k + m * 
			MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] + q * stork_1.xs[m - 1];
	    }
	}
L5460:
	cstep_1.ERR[stork_1.nactv + stork_1.nactv * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = runit / p;
	if (stork_1.nactv - 2 >= 0) {
	    goto L5470;
	} else {
	    goto L5490;
	}
L5470:
	i_3 = stork_1.nactv;
	for (k = 2; k <= i_3; ++k) {
/* L5480: */
	    cstep_1.ERR[stork_1.nactv + (k - 1) * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = stork_1.xs[k - 1]
		    ;
	}
L5490:
    ;}
/*                                                                      
STERR194*/
    if (notpd <= 0) {
	goto L5520;
    } else {
	goto L5500;
    }
L5500:
    cstep_1.KERFL = -3;
    io__128.ciunit = cstep_1.KW;
    s_wsfe(&io__128);
    e_wsfe();
/*                                                                      
STERR200*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STERR201*/
/*                                                                      
STERR202*/
/* UNPACK, DOUBLE, AND SYMMETRIZE THE INVERSE TO FORM THE ERROR MATRIX. 
STERR203*/
/*                                                                      
STERR204*/
L5520:
    jact = stork_1.nactv;
    i_1 = cstep_1.NV;
    for (jj = 1; jj <= i_1; ++jj) {
	j = cstep_1.NV + 1 - jj;
	kact = jact;
	i_3 = j;
	for (kk = 1; kk <= i_3; ++kk) {
	    k = j + 1 - kk;
	    if (cstep_1.MASK[j - 1] != 0) {
		goto L5540;
	    } else {
		goto L5530;
	    }
L5530:
	    if (cstep_1.MASK[k - 1] != 0) {
		goto L5540;
	    } else {
		goto L5550;
	    }
L5540:
	    cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = rzero;
	    goto L5560;
L5550:
	    cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = cstep_1.ERR[jact + kact * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] 
		    * rtwo;
	    --kact;
L5560:
	    cstep_1.ERR[k + j * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] = cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1];
	}
	if (cstep_1.MASK[j - 1] != 0) {
	    goto L5580;
	} else {
	    goto L5570;
	}
L5570:
	--jact;
L5580:
    ;}
/*                                                                      
STERR221*/
/** * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 
STERR222*/
/*                                                                      
STERR223*/
/* PRINT THE ERRORS AND CORRELATIONS, AND RETURN.                       
STERR224*/
/*                                                                      
STERR225*/
/*                           COMPUTE AND PRINT THE STANDARD ERRORS.     
STERR226*/
    if (cstep_1.NTRAC >= 0) {
	goto L5590;
    } else {
	goto L5610;
    }
L5590:
    io__132.ciunit = cstep_1.KW;
    s_wsfe(&io__132);
    e_wsfe();

L5610:
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	aber = cstep_1.ERR[j + j * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1];
	if (aber < (float)0.) {
	    goto L5620;
	} else if (aber == 0) {
	    goto L5680;
	} else {
	    goto L5630;
	}
L5620:
	aber = -(doublereal)aber;
L5630:
	aber = sqrt(aber);
	if (cstep_1.MASK[j - 1] != 0) {
	    goto L5680;
	} else {
	    goto L5640;
	}
L5640:
	if ((r_1 = cstep_1.ERR[j + j * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1]) < (float)0.) {
	    goto L5650;
	} else if (r_1 == 0) {
	    goto L5660;
	} else {
	    goto L5680;
	}
L5650:
	aber = -(doublereal)aber;
L5660:
	cstep_1.KERFL = -4;
	io__134.ciunit = cstep_1.KW;
	s_wsfe(&io__134);
	do_fio(&c__1, (char *)&cstep_1.ERR[j + j * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1], (ftnlen)sizeof(
		real));
	e_wsfe();

L5680:
	if (cstep_1.NTRAC >= 0) {
	    goto L5690;
	} else {
	    goto L5710;
	}
L5690:
	io__135.ciunit = cstep_1.KW;
	s_wsfe(&io__135);
	do_fio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&cstep_1.MASK[j - 1], (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
	do_fio(&c__1, (char *)&aber, (ftnlen)sizeof(real));
	e_wsfe();
L5710:
	stork_1.xs[j - 1] = aber;
    }
/*                           COMPUTE AND PRINT THE CORRELATIONS.        
STERR249*/
    if (cstep_1.NTRAC >= 0) {
	goto L5720;
    } else {
	goto L5800;
    }
L5720:
    if (cstep_1.NV - 2 >= 0) {
	goto L5730;
    } else {
	goto L5800;
    }
L5730:
    io__136.ciunit = cstep_1.KW;
    s_wsfe(&io__136);
    i_1 = cstep_1.NV;
    for (k = 1; k <= i_1; ++k) {
	do_fio(&c__1, (char *)&k, (ftnlen)sizeof(integer));
    }
    e_wsfe();
    io__137.ciunit = cstep_1.KW;
    s_wsfe(&io__137);
    i_1 = cstep_1.NV;
    for (k = 1; k <= i_1; ++k) {
	do_fio(&c__1, (char *)&cstep_1.MASK[k - 1], (ftnlen)sizeof(integer));
    }
    e_wsfe();
    io__138.ciunit = cstep_1.KW;
    s_wsfe(&io__138);
    e_wsfe();
    i_1 = cstep_1.NV;
    for (j = 1; j <= i_1; ++j) {
	i_3 = j;
	for (k = 1; k <= i_3; ++k) {
	    denom = stork_1.xs[j - 1] * stork_1.xs[k - 1];
	    if (denom < (float)0.) {
		goto L5760;
	    } else if (denom == 0) {
		goto L5750;
	    } else {
		goto L5770;
	    }
L5750:
	    stork_1.dlx[k - 1] = rzero;
	    goto L5780;
L5760:
	    denom = -(doublereal)denom;
L5770:
	    stork_1.dlx[k - 1] = cstep_1.ERR[j + k * MAX_STEPIT_NVAR - MAX_STEPIT_NVAR_PLUS1] / denom;
L5780:
	;}
/* L5790: */
	io__140.ciunit = cstep_1.KW;
	s_wsfe(&io__140);
	do_fio(&c__1, (char *)&j, (ftnlen)sizeof(integer));
	do_fio(&c__1, (char *)&cstep_1.MASK[j - 1], (ftnlen)sizeof(integer));
	i_3 = j;
	for (k = 1; k <= i_3; ++k) {
	    do_fio(&c__1, (char *)&stork_1.dlx[k - 1], (ftnlen)sizeof(real));
	}
	e_wsfe();
    }
/*                                                                      
STERR268*/
L5800:
    cstep_1.JVARY = 0;
    (*funk)();
    ++stork_1.nf;
    if (cstep_1.NTRAC >= 0) {
	goto L5810;
    } else {
	goto L5830;
    }
L5810:
    io__141.ciunit = cstep_1.KW;
    s_wsfe(&io__141);
    do_fio(&c__1, (char *)&stork_1.nf, (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&cstep_1.FOBJ, (ftnlen)sizeof(real));
    i_3 = cstep_1.NV;
    for (j = 1; j <= i_3; ++j) {
	do_fio(&c__1, (char *)&cstep_1.X[j - 1], (ftnlen)sizeof(real));
    }
    e_wsfe();

L5830:
    return 0;
/* END STERR.                                                           
STERR278*/
} /* sterr_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  SORTG */
/* SORTS ARRAY A INTO INCREASING ORDER, FROM A(1) TO A(N) */
/* THE ARRAY TAG IS PERMUTED THE SAME AS ARRAY A */
/* ----------------------------------------------------------------------- */

/* Subroutine */ int sortg_(a, n, tag)
real *a;
integer *n;
real *tag;
{
    static integer i, j, k, l, m;
    static real t;
    static integer ij, il[MAX_STEPIT_NVAR];
    static real tg;
    static integer iu[MAX_STEPIT_NVAR];
    static real tt;

    /* Parameter adjustments */
    --a;
    --tag;

    /* Function Body */

/* TO SORT N ELEMENTS STARTING WITH A(K), CALL WITH A(K) AND TAG(K). */
/* AN EARLIER VERSION OF THIS ALGORITHM, WITHOUT THE TAG ARRAY, WAS */
/* PUBLISHED BY R.C. SINGLETON AS ACM ALGORITHM 347, */
/* COMM. ACM 12 (MARCH 1969), 1865-1866.  THE CURRENT VERSION */
/* SOLVES A MACHINE-DEPENDENT PROBLEM PRESENT IN THE EARLIER */
/* VERSION AND ALMOST ALL OTHER SORT SUBROUTINES.  ON MANY */
/* COMPUTERS, COMPARING A VERY LARGE NEGATIVE NUMBER WITH A */
/* VERY LARGE POSITIVE NUMBER GIVES A WRONG RESULT AND A BAD SORT. */
/* THIS PROBLEM WAS NOTED BY R. GRIFFIN AND K.A. REDISH, "REMARK */
/* ON ALGORITHM 347,", COMM. ACM 13 (JANUARY 1970), 54. */
/* THE PROBLEM IS AVOIDED HERE BY AN INITIAL SPLIT ON ZERO. */
/* TIME IS PROPORTIONAL TO N*LOG(N) */
/* AS FAR AS THE AUTHOR IS AWARE, NO FASTER IN-PLACE SORT METHOD HAS */
/* BEEN PUBLISHED SINCE THE ORIGINAL APPEARANCE OF THIS ALGORITHM. */

/* WORKING STORAGE ARRAYS IL AND IU SHOULD HAVE DIMENSION */
/*      INT(ALOG(FLOAT(N))/ALOG(2.0)) */
/*      A DIMENSION OF 20 ALLOWS VALUES OF N UP TO 2**21-1 */

    m = 1;
    i = 1;
    j = *n;
    k = i;
    l = j;
    if (i >= j) {
	return 0;
    }
    t = (float)0.;
    if (a[i] <= (float)0.) {
	goto L30;
    } else {
	goto L10;
    }
L10:
    if (a[l] <= (float)0.) {
	goto L90;
    } else {
	goto L20;
    }
L20:
    --l;
    if (l - i <= 0) {
	goto L70;
    } else {
	goto L10;
    }
L30:
    if (a[j] >= (float)0.) {
	goto L110;
    } else {
	goto L40;
    }
L40:
    if (a[k] >= (float)0.) {
	goto L90;
    } else {
	goto L50;
    }
L50:
    ++k;
    if (j - k <= 0) {
	goto L70;
    } else {
	goto L40;
    }
L60:
    if (i >= j) {
	goto L140;
    }
L70:
    k = i;
    ij = (j + i) / 2;
    t = a[ij];
    if (a[i] <= t) {
	goto L80;
    }
    a[ij] = a[i];
    a[i] = t;
    t = a[ij];
    tg = tag[ij];
    tag[ij] = tag[i];
    tag[i] = tg;
L80:
    l = j;
    if (a[j] >= t) {
	goto L110;
    }
    a[ij] = a[j];
    a[j] = t;
    t = a[ij];
    tg = tag[ij];
    tag[ij] = tag[j];
    tag[j] = tg;
    if (a[i] <= t) {
	goto L110;
    }
    a[ij] = a[i];
    a[i] = t;
    t = a[ij];
    tg = tag[ij];
    tag[ij] = tag[i];
    tag[i] = tg;
    goto L110;
L90:
    tt = a[l];
L100:
    a[l] = a[k];
    a[k] = tt;
    tg = tag[l];
    tag[l] = tag[k];
    tag[k] = tg;
L110:
    --l;
    if (a[l] > t) {
	goto L110;
    }
    tt = a[l];
L120:
    ++k;
    if (a[k] < t) {
	goto L120;
    }
    if (k <= l) {
	goto L100;
    }
    if (l - i <= j - k) {
	goto L130;
    }
    il[m - 1] = i;
    iu[m - 1] = l;
    i = k;
    ++m;
    goto L150;
L130:
    il[m - 1] = k;
    iu[m - 1] = j;
    j = l;
    ++m;
    goto L150;
L140:
    --m;
    if (m == 0) {
	return 0;
    }
    i = il[m - 1];
    j = iu[m - 1];
L150:
    if (j - i > 10) {
	goto L70;
    }
    if (i == 1) {
	goto L60;
    }
    --i;
L160:
    ++i;
    if (i == j) {
	goto L140;
    }
    t = a[i + 1];
    if (a[i] <= t) {
	goto L160;
    }
    tg = tag[i + 1];
    k = i;
L170:
    a[k + 1] = a[k];
    tag[k + 1] = tag[k];
    --k;
    if (t < a[k]) {
	goto L170;
    }
    a[k + 1] = t;
    tag[k + 1] = tg;
    goto L160;
} /* sortg_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  NORMAL */
/* GENERATES AN INDEPENDENT PAIR OF RANDOM NORMAL DEVIATES */
/* METHOD DUE TO G. MARSAGLIA AND T.A. BRAY, */
/* SIAM REVIEW, VOL. 6, NO. 3, JULY 1964. 260-264 */
/* ----------------------------------------------------------------------- */

/* Subroutine */ int normal_(x, y)
real *x, *y;
{
    /* System generated locals */
    real r_1, r_2;

    /* Builtin functions */
    double log(), sqrt();

    /* Local variables */
    static real r, rx, ry;
    extern doublereal uni_();
    static integer nrm;


/* OUTPUT:  X,Y = INDEPENDENT PAIR OF RANDOM NORMAL DEVIATES */
/* FUNCTION UNI GENERATES PSEUDO-RANDOM NUMBER BETWEEN 0.0 AND 1.0 */

L10:
    rx = uni_(&nrm) * (float)2. - (float)1.;
    ry = uni_(&nrm) * (float)2. - (float)1.;
/* Computing 2nd power */
    r_1 = rx;
/* Computing 2nd power */
    r_2 = ry;
    r = r_1 * r_1 + r_2 * r_2;
    if (r >= (float)1.) {
	goto L10;
    }
    r = sqrt(log(r) * (float)-2. / r);
    *x = rx * r;
    *y = ry * r;
    return 0;
} /* normal_ */


/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  RMS */
/* COMPUTES RMS ERROR FOR TRANSFORM-INVERSE PAIR */
/* ----------------------------------------------------------------------- */

/* Subroutine */ int rms_(a, b, c, d, n, ea, eb)
real *a, *b, *c, *d;
integer *n;
real *ea, *eb;
{
    /* System generated locals */
    integer i_1;
    real r_1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static integer j;
    static real ssa, ssb;

    /* Parameter adjustments */
    --a;
    --b;
    --c;
    --d;

    /* Function Body */

/* ARRAYS:  A,B = TRANSFORM, INVERSE RESULTS */
/* C,D = ORIGINAL DATA */
/* INPUT:  N = DIMENSION OF ARRAYS A, B, C AND D */
/* OUTPUT:  EA,EB = RMS ERRORS FOR A AND B ARRAYS */

    ssa = (float)0.;
    ssb = (float)0.;
    i_1 = *n;
    for (j = 1; j <= i_1; ++j) {
/* Computing 2nd power */
	r_1 = a[j] - c[j];
	ssa = r_1 * r_1 + ssa;
/* Computing 2nd power */
	r_1 = b[j] - d[j];
	ssb = r_1 * r_1 + ssb;
/* L10: */
    }
    *ea = sqrt(ssa / (real) (*n));
    *eb = sqrt(ssb / (real) (*n));
    return 0;
} /* rms_ */


/* ----------------------------------------------------------------------- */
/* FUNCTION:  ISTKGT(NITEMS,ITYPE) */
/* ALLOCATES WORKING STORAGE FOR NITEMS OF ITYPE, AS FOLLOWS */

/* 1 - LOGICAL */
/* 2 - INTEGER */
/* 3 - REAL */
/* 4 - DOUBLE PRECISION */
/* 5 - COMPLEX */

/* ----------------------------------------------------------------------- */

integer istkgt_(nitems, itype)
integer *nitems, *itype;
{
    /* Format strings */
    static char fmt_9999[] = "(\002 \002,\002OVERFLOW OF COMMON ARRAY ISTAK \
--- NEED\002,i10)";
    static char fmt_9998[] = "(1x,i5,11i6)";

    /* System generated locals */
    integer ret_val;

    /* Builtin functions */
    integer s_wsfe(), do_fio(), e_wsfe();
    /* Subroutine */ int s_stop();

    /* Local variables */
#define lmax ((integer *)&cstak_1 + 3)
    static integer ierr;
#define lnow ((integer *)&cstak_1 + 1)
#define lout ((integer *)&cstak_1)
    static integer i, j;
#define lbook ((integer *)&cstak_1 + 4)
#define istak ((integer *)&cstak_1)
#define lused ((integer *)&cstak_1 + 2)
#define isize ((integer *)&cstak_1 + 5)
    extern integer i1mach_();

    /* Fortran I/O blocks */
    static cilist io__169 = { 0, 0, 0, fmt_9999, 0 };
    static cilist io__170 = { 0, 0, 0, fmt_9998, 0 };






    ret_val = (*lnow * isize[1] - 1) / isize[*itype - 1] + 2;
    i = ((ret_val - 1 + *nitems) * isize[*itype - 1] - 1) / isize[1] + 3;
    if (i > *lmax) {
	goto L10;
    }
    istak[i - 2] = *itype;
    istak[i - 1] = *lnow;
    ++(*lout);
    *lnow = i;
    *lused = max(*lused,*lnow);
    return ret_val;

L10:
    ierr = i1mach_(&c__4);
    io__169.ciunit = ierr;
    s_wsfe(&io__169);
    do_fio(&c__1, (char *)&i, (ftnlen)sizeof(integer));
    e_wsfe();
    io__170.ciunit = ierr;
    s_wsfe(&io__170);
    for (j = 1; j <= 10; ++j) {
	do_fio(&c__1, (char *)&istak[j - 1], (ftnlen)sizeof(integer));
    }
    do_fio(&c__1, (char *)&istak[*lnow - 2], (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&istak[*lnow - 1], (ftnlen)sizeof(integer));
    e_wsfe();
    s_stop("", 0L);
} /* istkgt_ */

#undef isize
#undef lused
#undef istak
#undef lbook
#undef lout
#undef lnow
#undef lmax



/* ----------------------------------------------------------------------- */
/* SUBROUTINE:  ISTKRL(K) */
/* DE-ALLOCATES THE LAST K WORKING STORAGE AREAS */
/* ----------------------------------------------------------------------- */

/* Subroutine */ int istkrl_(k)
integer *k;
{
    /* Format strings */
    static char fmt_9999[] = "(\002 WARNING...ISTAK(2),ISTAK(3),ISTAK(4) OR \
ISTAK(5) HIT\002)";
    static char fmt_9997[] = "(1x,i5,11i6)";
    static char fmt_9998[] = "(\002 WARNING...POINTER AT ISTAK(LNOW) OVERWRI\
TTEN\002/11x,\002DE-ALLOCATION NOT COMPLETED\002)";

    /* Builtin functions */
    integer s_wsfe(), e_wsfe(), do_fio();

    /* Local variables */
#define lmax ((integer *)&cstak_1 + 3)
    static integer ierr;
#define lnow ((integer *)&cstak_1 + 1)
#define lout ((integer *)&cstak_1)
    static integer j;
#define lbook ((integer *)&cstak_1 + 4)
#define istak ((integer *)&cstak_1)
#define lused ((integer *)&cstak_1 + 2)
    extern integer i1mach_();
    static integer in;

    /* Fortran I/O blocks */
    static cilist io__180 = { 0, 0, 0, fmt_9999, 0 };
    static cilist io__181 = { 0, 0, 0, fmt_9997, 0 };
    static cilist io__183 = { 0, 0, 0, fmt_9998, 0 };
    static cilist io__184 = { 0, 0, 0, fmt_9997, 0 };






    in = *k;

    if (*lbook <= *lnow && *lnow <= *lused && *lused <= *lmax) {
	goto L10;
    }
    ierr = i1mach_(&c__4);
    io__180.ciunit = ierr;
    s_wsfe(&io__180);
    e_wsfe();
    io__181.ciunit = ierr;
    s_wsfe(&io__181);
    for (j = 1; j <= 10; ++j) {
	do_fio(&c__1, (char *)&istak[j - 1], (ftnlen)sizeof(integer));
    }
    do_fio(&c__1, (char *)&istak[*lnow - 2], (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&istak[*lnow - 1], (ftnlen)sizeof(integer));
    e_wsfe();

L10:
    if (in <= 0) {
	return 0;
    }
    if (*lbook > istak[*lnow - 1] || istak[*lnow - 1] >= *lnow - 1) {
	goto L20;
    }
    --(*lout);
    *lnow = istak[*lnow - 1];
    --in;
    goto L10;

L20:
    ierr = i1mach_(&c__4);
    io__183.ciunit = ierr;
    s_wsfe(&io__183);
    e_wsfe();
    io__184.ciunit = ierr;
    s_wsfe(&io__184);
    for (j = 1; j <= 10; ++j) {
	do_fio(&c__1, (char *)&istak[j - 1], (ftnlen)sizeof(integer));
    }
    do_fio(&c__1, (char *)&istak[*lnow - 2], (ftnlen)sizeof(integer));
    do_fio(&c__1, (char *)&istak[*lnow - 1], (ftnlen)sizeof(integer));
    e_wsfe();
    return 0;

} /* istkrl_ */

#undef lused
#undef istak
#undef lbook
#undef lout
#undef lnow
#undef lmax


